/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http.util;

import java.security.SecureRandom;
import java.util.Date;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public abstract class HmacAuthHeader {
    private static final SecureRandom random = new SecureRandom();
    public static final HmacAuthHeader HmacSha256 = new HmacSha256AuthHeader();

    protected abstract String getHashAlgorithm();

    protected abstract String getAuthorizationScheme();

    protected abstract String getRequestVersion();

    protected abstract String getTextEncoding();

    protected abstract int getNonceSize();

    protected final String currentDateStamp() {
        return String.valueOf(new Date().getTime());
    }

    protected final byte[] newNonce(int size) {
        byte[] nonceBytes = new byte[size];
        random.nextBytes(nonceBytes);
        return nonceBytes;
    }

    protected final byte[] computeHash(byte[] data, byte[] key) throws Exception {
        Mac mac = Mac.getInstance(this.getHashAlgorithm());
        mac.init(new SecretKeySpec(key, this.getHashAlgorithm()));
        return mac.doFinal(data);
    }

    protected final byte[] calculateDataSignature(byte[] apiKeyBytes, byte[] nonceBytes, String dateStamp, String data) throws Exception {
        byte[] kNonce = this.computeHash(nonceBytes, apiKeyBytes);
        byte[] kDate = this.computeHash(dateStamp.getBytes(this.getTextEncoding()), kNonce);
        byte[] kSignature = this.computeHash(this.getRequestVersion().getBytes(this.getTextEncoding()), kDate);
        return this.computeHash(data.getBytes(this.getTextEncoding()), kSignature);
    }

    public final String calculateAuthorizationHeader(String apiID, String apiKey, String hostName, String uriString, String urlQueryParams, String httpMethod) {
        try {
            if (urlQueryParams != null) {
                uriString = uriString.concat(urlQueryParams);
            }
            String data = String.format("id=%s&host=%s&url=%s&method=%s", apiID, hostName, uriString, httpMethod);
            String dateStamp = this.currentDateStamp();
            byte[] nonceBytes = this.newNonce(this.getNonceSize());
            byte[] dataSignature = this.calculateDataSignature(HmacAuthHeader.fromHexBinary(apiKey), nonceBytes, dateStamp, data);
            String authorizationParam = String.format("id=%s,ts=%s,nonce=%s,sig=%s", apiID, dateStamp, HmacAuthHeader.toHexBinary(nonceBytes), HmacAuthHeader.toHexBinary(dataSignature));
            return this.getAuthorizationScheme() + " " + authorizationParam;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final String toHexBinary(byte[] bytes) {
        return DatatypeConverter.printHexBinary(bytes);
    }

    public static final byte[] fromHexBinary(String hexBinaryString) {
        return DatatypeConverter.parseHexBinary(hexBinaryString);
    }

    public static final boolean isValidHexBinary(String hexBinaryString) {
        if (hexBinaryString != null) {
            try {
                byte[] bytes = HmacAuthHeader.fromHexBinary(hexBinaryString);
                return bytes != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static final boolean isValidAuthHeaderToken(String authHeaderToken) {
        if (authHeaderToken != null) {
            boolean isMatch = Pattern.compile("^[\\x21\\x23-\\x27\\x2A-\\x2B\\x2D-\\x2E\\x30-\\x39\\x41-\\x5A\\x5E-\\x7A\\x7C\\x7E]+$").matcher(authHeaderToken).matches();
            return isMatch;
        }
        return false;
    }

    public static final boolean isValidId(String id) {
        if (null == id || id.length() != 32) {
            return false;
        }
        return HmacAuthHeader.isValidHexBinary(id);
    }

    private HmacAuthHeader() {
    }

    private static final class HmacSha256AuthHeader
    extends HmacAuthHeader {
        @Override
        protected String getHashAlgorithm() {
            return "HmacSHA256";
        }

        @Override
        protected String getAuthorizationScheme() {
            return "VERACODE-HMAC-SHA-256";
        }

        @Override
        protected String getRequestVersion() {
            return "vcode_request_version_1";
        }

        @Override
        protected String getTextEncoding() {
            return "UTF-8";
        }

        @Override
        protected int getNonceSize() {
            return 16;
        }

        private HmacSha256AuthHeader() {
        }
    }
}

