/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import com.google.gson.annotations.Expose;
import com.veracode.util.lang.StringUtility;

public class Region {
    @Expose
    private final String name;
    @Expose
    private final String idPrefix;
    @Expose
    private final String keyPrefix;
    @Expose
    private final String xmlApiHost;
    @Expose
    private final String restApiHost;
    @Expose(serialize=false)
    private final boolean isDefault;

    private Region() {
        this.name = "";
        this.idPrefix = "";
        this.keyPrefix = "";
        this.xmlApiHost = null;
        this.restApiHost = null;
        this.isDefault = false;
    }

    public Region(String name, String idPrefix, String keyPrefix, String xmlApiHost, String restApiHost, boolean isDefault) {
        if (!Region.isNameValid(name)) {
            throw new IllegalArgumentException("Region name must be a alphanumeric string.");
        }
        if (!Region.isCredentialsPrefixValid(idPrefix) || !Region.isCredentialsPrefixValid(keyPrefix)) {
            throw new IllegalArgumentException("Credentials prefix cannot be empty.");
        }
        if (!Region.isApiHostNameValid(xmlApiHost) || !Region.isApiHostNameValid(restApiHost)) {
            throw new IllegalArgumentException("The given API host(s) is invalid.");
        }
        this.name = name;
        this.idPrefix = idPrefix;
        this.keyPrefix = keyPrefix;
        this.xmlApiHost = xmlApiHost;
        this.restApiHost = restApiHost;
        this.isDefault = isDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public String getXmlApiHost() {
        return this.xmlApiHost;
    }

    public String getRestApiHost() {
        return this.restApiHost;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isValid() {
        return Region.isNameValid(this.name) && Region.isApiHostNameValid(this.xmlApiHost) && Region.isApiHostNameValid(this.restApiHost);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        return !(this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name));
    }

    private static boolean isNameValid(String name) {
        return null != name && name.matches("\\p{Alnum}+");
    }

    private static boolean isCredentialsPrefixValid(String prefix) {
        return !StringUtility.isNullOrEmpty(prefix);
    }

    private static boolean isApiHostNameValid(String hostName) {
        return StringUtility.isValidApiHostName(hostName);
    }
}

