/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.http;

import com.veracode.apiwrapper.services.CredentialsService;
import com.veracode.apiwrapper.services.RegionService;
import com.veracode.apiwrapper.services.ServiceManager;
import com.veracode.http.Region;
import com.veracode.http.util.HmacAuthHeader;
import com.veracode.util.lang.StringUtility;
import java.util.Optional;
import java.util.function.Function;

public class Credentials {
    public static final String INVALID_PREFIX_MESSAGE = "The credentials contain invalid prefix.";
    public static final String CONFLICTING_PREFIX_MESSAGE = "The credentials contain conflicting prefix.";
    public static final String INVALID_FORMAT_MESSAGE = "The credentials are not in the correct format.";
    public static final String INVALID_CREDS_MESSAGE = "The credentials are invalid.";
    private final String id;
    private final String key;
    private final Region region;

    public static final Credentials create(String id, String key) {
        return new Credentials(id, key);
    }

    private Credentials(String id, String key) {
        if (StringUtility.isNullOrEmpty(id) || StringUtility.isNullOrEmpty(key)) {
            throw new IllegalArgumentException(INVALID_CREDS_MESSAGE);
        }
        Optional<String> idPrefix = CredentialsService.getPrefix(id);
        Optional<String> keyPrefix = CredentialsService.getPrefix(key);
        RegionService regionSvc = ServiceManager.getRegionService();
        Optional<Region> idRegion = Credentials.getRegion(idPrefix.isPresent() ? idPrefix.get() : null, regionSvc::getRegionByIdPrefix);
        Optional<Region> keyRegion = Credentials.getRegion(keyPrefix.isPresent() ? keyPrefix.get() : null, regionSvc::getRegionByKeyPrefix);
        if (!idRegion.isPresent() || !keyRegion.isPresent()) {
            throw new IllegalArgumentException(INVALID_PREFIX_MESSAGE);
        }
        if (!idRegion.equals(keyRegion)) {
            throw new IllegalArgumentException(CONFLICTING_PREFIX_MESSAGE);
        }
        this.region = idRegion.get();
        String apiId = idPrefix.isPresent() ? id.substring(idPrefix.get().length() + "-".length()) : id;
        String apiKey = keyPrefix.isPresent() ? key.substring(keyPrefix.get().length() + "-".length()) : key;
        if (!HmacAuthHeader.isValidId(apiId) || !HmacAuthHeader.isValidHexBinary(apiKey)) {
            throw new IllegalArgumentException(INVALID_FORMAT_MESSAGE);
        }
        this.id = apiId;
        this.key = apiKey;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public Region getRegion() {
        return this.region;
    }

    private static final Optional<Region> getRegion(String prefix, Function<String, Optional<Region>> func) {
        Optional<Region> result = StringUtility.isNullOrEmpty(prefix) ? Optional.of(ServiceManager.getRegionService().getDefaultRegion()) : func.apply(prefix);
        return result;
    }

    private Credentials() {
        this.id = null;
        this.key = null;
        this.region = null;
    }
}

