/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.wrappers;

import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.http.util.HttpUtility;
import java.io.IOException;
import java.util.HashMap;

public final class ResultsAPIWrapper
extends AbstractAPIWrapper {
    public static final String DETAILED_REPORT_URI = "api/5.0/detailedreport.do";
    public static final String DETAILED_REPORT_PDF_URI = "api/4.0/detailedreportpdf.do";
    public static final String GET_APP_BUILDS_URI = "api/4.0/getappbuilds.do";
    public static final String GET_CALL_STACKS_URI = "api/5.0/getcallstacks.do";
    public static final String SUMMARY_REPORT_URI = "api/4.0/summaryreport.do";
    public static final String SUMMARY_REPORT_PDF_URI = "api/4.0/summaryreportpdf.do";
    public static final String THIRD_PARTY_REPORT_PDF_URI = "api/4.0/thirdpartyreportpdf.do";
    public static final String GET_ACC_CUSTOMFIELD_LIST_URI = "api/5.0/getaccountcustomfieldlist.do";

    public String detailedReport(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(DETAILED_REPORT_URI);
    }

    public byte[] detailedReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(DETAILED_REPORT_PDF_URI);
    }

    public String getAppBuilds() throws IOException {
        return this.getAppBuilds(null, null, null);
    }

    public String getAppBuilds(String report_changed_since, String only_latest, String include_in_progress) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (report_changed_since != null) {
            queryString.put("report_changed_since", HttpUtility.urlEncode(report_changed_since));
        }
        if (only_latest != null) {
            queryString.put("only_latest", HttpUtility.urlEncode(only_latest));
        }
        if (include_in_progress != null) {
            queryString.put("include_in_progress", HttpUtility.urlEncode(include_in_progress));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_APP_BUILDS_URI);
    }

    public String getCallStacks(String build_id, String flaw_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        if (flaw_id != null) {
            queryString.put("flaw_id", HttpUtility.urlEncode(flaw_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(GET_CALL_STACKS_URI);
    }

    public String summaryReport(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadString(SUMMARY_REPORT_URI);
    }

    public byte[] summaryReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(SUMMARY_REPORT_PDF_URI);
    }

    public byte[] thirdPartyReportPdf(String build_id) throws IOException {
        HashMap<String, Object> queryString = new HashMap<String, Object>();
        if (build_id != null) {
            queryString.put("build_id", HttpUtility.urlEncode(build_id));
        }
        this.webClient.queryString = queryString;
        return this.webClient.downloadData(THIRD_PARTY_REPORT_PDF_URI);
    }

    public String getAccountCustomFieldList() throws IOException {
        return this.webClient.downloadString(GET_ACC_CUSTOMFIELD_LIST_URI);
    }
}

