/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.services;

import com.veracode.apiwrapper.services.ArtifactApiService;
import com.veracode.apiwrapper.services.DynamicAnalysisAPIService;
import com.veracode.apiwrapper.services.IdentityAPIService;
import com.veracode.apiwrapper.services.impl.DefaultArtifactApiService;
import com.veracode.apiwrapper.services.impl.DefaultDynamicAnalysisAPIService;
import com.veracode.apiwrapper.services.impl.IdentityAPIServiceImpl;
import com.veracode.http.Credentials;
import com.veracode.parser.enums.CredentialTypes;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;

public class APIServiceManager {
    private final CredentialTypes type;
    private final Credentials creds;
    private final Proxy proxy;
    private DynamicAnalysisAPIService daAPIService = null;
    private IdentityAPIService identityAPIService = null;
    private ArtifactApiService artifactApiService = null;

    private APIServiceManager() {
        this(Credentials.create("", ""), Proxy.NO_PROXY);
    }

    @Deprecated
    private APIServiceManager(CredentialTypes type, String id, String key, Proxy proxy) {
        if (StringUtility.isNullOrEmpty(id) || StringUtility.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("Cannot initialize without credentials.");
        }
        this.type = type;
        this.creds = Credentials.create(id, key);
        this.proxy = proxy;
    }

    private APIServiceManager(Credentials creds, Proxy proxy) {
        this.creds = creds;
        this.proxy = proxy;
        this.type = CredentialTypes.API;
    }

    @Deprecated
    public static APIServiceManager createInstance(CredentialTypes type, String id, String key) {
        return APIServiceManager.createInstance(Credentials.create(id, key), Proxy.NO_PROXY);
    }

    @Deprecated
    public static APIServiceManager createInstance(CredentialTypes type, String id, String key, Proxy proxy) {
        return APIServiceManager.createInstance(Credentials.create(id, key), proxy);
    }

    public static APIServiceManager createInstance(Credentials creds) {
        return APIServiceManager.createInstance(creds, Proxy.NO_PROXY);
    }

    public static APIServiceManager createInstance(Credentials creds, Proxy proxy) {
        return new APIServiceManager(creds, proxy);
    }

    private synchronized void initDynamicAnalysisAPIService() {
        if (null == this.daAPIService) {
            if (this.type == CredentialTypes.USER) {
                throw new IllegalArgumentException("Incompatible credential type for Dynamic Analysis.");
            }
            this.daAPIService = new DefaultDynamicAnalysisAPIService(this.creds, this.proxy);
        }
    }

    private synchronized void initArtifactApiService() {
        if (null == this.artifactApiService) {
            if (this.type == CredentialTypes.USER) {
                throw new IllegalArgumentException("Incompatible credential type.");
            }
            this.artifactApiService = new DefaultArtifactApiService(this.creds, this.proxy);
        }
    }

    private synchronized void initIdentityAPIService() {
        if (null == this.identityAPIService) {
            if (this.type == CredentialTypes.USER) {
                throw new IllegalArgumentException("Incompatible credential type.");
            }
            this.identityAPIService = new IdentityAPIServiceImpl(this.creds, this.proxy);
        }
    }

    public DynamicAnalysisAPIService getDynamicAnalysisAPIService() {
        this.initDynamicAnalysisAPIService();
        return this.daAPIService;
    }

    public IdentityAPIService getIdentityAPIService() {
        this.initIdentityAPIService();
        return this.identityAPIService;
    }

    public ArtifactApiService getArtifactApiService() {
        this.initArtifactApiService();
        return this.artifactApiService;
    }
}

