/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.identity.model.api;

import com.veracode.util.lang.StringUtility;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class CredentialValidityDetails {
    private static final String ZONED_OFFSET_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String ABOUT_TO_EXPIRE_MESSAGE = "Your API credentials will expire in %s days. Generate new credentials for your account.";
    private static final String VALID_CREDS_MESSAGE = "Your API credentials are up-to-date.";
    private static final String NEAR_EXPIRE_STATUS = "Nearing Expiration";
    private static final String VALID_STATUS = "Valid";
    private static final int EXPIRATION_TIMESPAN_DAYS = 30;
    private String expirationDate = null;
    private String credentialStatus;
    private String message;

    public CredentialValidityDetails(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getMessage() {
        return this.message;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getCredentialStatus() {
        return this.credentialStatus;
    }

    public void checkValidity() {
        if (!StringUtility.isNullOrEmpty(this.expirationDate)) {
            try {
                LocalDate expireDate = new SimpleDateFormat(ZONED_OFFSET_FORMAT).parse(this.expirationDate).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                long remainingDays = ChronoUnit.DAYS.between(LocalDate.now(), expireDate);
                boolean credentialExpireStatus = remainingDays > 30L;
                this.credentialStatus = credentialExpireStatus ? VALID_STATUS : NEAR_EXPIRE_STATUS;
                this.message = credentialExpireStatus ? VALID_CREDS_MESSAGE : String.format(ABOUT_TO_EXPIRE_MESSAGE, remainingDays);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }
}

