/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Represents user agent details")
public class UserAgent {
    @SerializedName(value="custom_header")
    private String customHeader = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public UserAgent customHeader(String customHeader) {
        this.customHeader = customHeader;
        return this;
    }

    @ApiModelProperty(value="Custom header to use. Must be specified if User Agent Type is custom. Otherwise can override the default value for the type")
    public String getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(String customHeader) {
        this.customHeader = customHeader;
    }

    public UserAgent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="User agent type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgent userAgent = (UserAgent)o;
        return Objects.equals(this.customHeader, userAgent.customHeader) && Objects.equals((Object)this.type, (Object)userAgent.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customHeader, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAgent {\n");
        sb.append("    customHeader: ").append(this.toIndentedString(this.customHeader)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FIREFOX_21("FIREFOX_21"),
        CHROME("CHROME"),
        SAFARI("SAFARI"),
        INTERNET_EXPLORER_9("INTERNET_EXPLORER_9"),
        INTERNET_EXPLORER_7("INTERNET_EXPLORER_7"),
        INTERNET_EXPLORER_6("INTERNET_EXPLORER_6"),
        IPHONE("IPHONE"),
        BLACKBERRY("BLACKBERRY"),
        NOKIA_6600("NOKIA_6600"),
        SONY_ERICSSON_K700_I("SONY_ERICSSON_K700_I"),
        GENERIC_ANDROID_TABLET("GENERIC_ANDROID_TABLET"),
        CUSTOM("CUSTOM"),
        CHROME_55("CHROME_55"),
        SAFARI_10("SAFARI_10"),
        INTERNET_EXPLORER_11("INTERNET_EXPLORER_11"),
        MICROSOFT_EDGE("MICROSOFT_EDGE"),
        FIREFOX_50("FIREFOX_50"),
        CHROME_MOBILE("CHROME_MOBILE"),
        FIREFOX_MOBILE("FIREFOX_MOBILE"),
        MICROSOFT_EDGE_MOBILE("MICROSOFT_EDGE_MOBILE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

