/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScanVerification {
    @SerializedName(value="error_codes")
    private List<String> errorCodes = null;
    @SerializedName(value="success")
    private Boolean success = null;
    @SerializedName(value="verificationType")
    private VerificationTypeEnum verificationType = null;

    public ScanVerification errorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
        return this;
    }

    public ScanVerification addErrorCodesItem(String errorCodesItem) {
        if (this.errorCodes == null) {
            this.errorCodes = new ArrayList<String>();
        }
        this.errorCodes.add(errorCodesItem);
        return this;
    }

    @ApiModelProperty(value="List of error codes. Present only if verification was not successful")
    public List<String> getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public ScanVerification success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(example="false", value="If true, indicates verification was successful")
    public Boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public ScanVerification verificationType(VerificationTypeEnum verificationType) {
        this.verificationType = verificationType;
        return this;
    }

    @ApiModelProperty(value="")
    public VerificationTypeEnum getVerificationType() {
        return this.verificationType;
    }

    public void setVerificationType(VerificationTypeEnum verificationType) {
        this.verificationType = verificationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanVerification scanVerification = (ScanVerification)o;
        return Objects.equals(this.errorCodes, scanVerification.errorCodes) && Objects.equals(this.success, scanVerification.success) && Objects.equals((Object)this.verificationType, (Object)scanVerification.verificationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorCodes, this.success, this.verificationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanVerification {\n");
        sb.append("    errorCodes: ").append(this.toIndentedString(this.errorCodes)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    verificationType: ").append(this.toIndentedString((Object)this.verificationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationTypeEnum {
        CONNECTION("CONNECTION"),
        AUTHENTICATION("AUTHENTICATION");

        private String value;

        private VerificationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationTypeEnum fromValue(String text) {
            for (VerificationTypeEnum b : VerificationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerificationTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, VerificationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public VerificationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

