/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Representation of a custom host for scanning")
public class PresetCookie {
    @SerializedName(value="cookie_string")
    private String cookieString = null;
    @SerializedName(value="cookie_type")
    private CookieTypeEnum cookieType = null;

    public PresetCookie cookieString(String cookieString) {
        this.cookieString = cookieString;
        return this;
    }

    @ApiModelProperty(value="Cookie string as it would appear in a request")
    public String getCookieString() {
        return this.cookieString;
    }

    public void setCookieString(String cookieString) {
        this.cookieString = cookieString;
    }

    public PresetCookie cookieType(CookieTypeEnum cookieType) {
        this.cookieType = cookieType;
        return this;
    }

    @ApiModelProperty(value="Cookie type")
    public CookieTypeEnum getCookieType() {
        return this.cookieType;
    }

    public void setCookieType(CookieTypeEnum cookieType) {
        this.cookieType = cookieType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresetCookie presetCookie = (PresetCookie)o;
        return Objects.equals(this.cookieString, presetCookie.cookieString) && Objects.equals((Object)this.cookieType, (Object)presetCookie.cookieType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cookieString, this.cookieType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresetCookie {\n");
        sb.append("    cookieString: ").append(this.toIndentedString(this.cookieString)).append("\n");
        sb.append("    cookieType: ").append(this.toIndentedString((Object)this.cookieType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CookieTypeEnum {
        SESSION("SESSION"),
        FUTURE("FUTURE"),
        FIXED("FIXED");

        private String value;

        private CookieTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CookieTypeEnum fromValue(String text) {
            for (CookieTypeEnum b : CookieTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CookieTypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, CookieTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public CookieTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CookieTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

