/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Error information details")
public class ErrorInfo {
    @SerializedName(value="access_reference")
    private String accessReference = null;
    @SerializedName(value="error_message")
    private String errorMessage = null;
    @SerializedName(value="resolution")
    private String resolution = null;
    @SerializedName(value="url")
    private String url = null;

    public ErrorInfo accessReference(String accessReference) {
        this.accessReference = accessReference;
        return this;
    }

    @ApiModelProperty(value="A reference identifier for the error. May be used in troubleshooting")
    public String getAccessReference() {
        return this.accessReference;
    }

    public void setAccessReference(String accessReference) {
        this.accessReference = accessReference;
    }

    public ErrorInfo errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(value="Error message")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ErrorInfo resolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(value="Suggested resolution, may be absent")
    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public ErrorInfo url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Reference URL that was accessed")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorInfo errorInfo = (ErrorInfo)o;
        return Objects.equals(this.accessReference, errorInfo.accessReference) && Objects.equals(this.errorMessage, errorInfo.errorMessage) && Objects.equals(this.resolution, errorInfo.resolution) && Objects.equals(this.url, errorInfo.url);
    }

    public int hashCode() {
        return Objects.hash(this.accessReference, this.errorMessage, this.resolution, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorInfo {\n");
        sb.append("    accessReference: ").append(this.toIndentedString(this.accessReference)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

