/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ApplicationInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ContactInformation;
import com.veracode.apiwrapper.dynamicanalysis.model.api.InternalScanConfiguration;
import com.veracode.apiwrapper.dynamicanalysis.model.api.Link;
import com.veracode.apiwrapper.dynamicanalysis.model.api.LinkedAppInfo;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanOccurrenceRuntimeSummary;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanOccurrenceStatus;
import com.veracode.apiwrapper.dynamicanalysis.model.api.ScanVerification;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Detailed representation of a scan occurrence. A scan occurence is an instance of a Scan that is running or has run")
public class DetailedScanOccurrence {
    @SerializedName(value="scan_occurrence_id")
    private String scanOccurrenceId = null;
    @SerializedName(value="org")
    private String org = null;
    @SerializedName(value="analysis_id")
    private String analysisId = null;
    @SerializedName(value="analysis_name")
    private String analysisName = null;
    @SerializedName(value="analysis_occurrence_id")
    private String analysisOccurrenceId = null;
    @SerializedName(value="count_of_failed_verifications")
    private Integer countOfFailedVerifications = null;
    @SerializedName(value="count_of_high_sev_flaws")
    private Integer countOfHighSevFlaws = null;
    @SerializedName(value="count_of_low_sev_flaws")
    private Integer countOfLowSevFlaws = null;
    @SerializedName(value="count_of_medium_sev_flaws")
    private Integer countOfMediumSevFlaws = null;
    @SerializedName(value="count_of_very_high_sev_flaws")
    private Integer countOfVeryHighSevFlaws = null;
    @SerializedName(value="duration")
    private String duration = null;
    @SerializedName(value="expected_publish_date")
    private String expectedPublishDate = null;
    @SerializedName(value="has_custom_configuration")
    private Boolean hasCustomConfiguration = null;
    @SerializedName(value="internal_scan_configuration")
    private InternalScanConfiguration internalScanConfiguration = null;
    @SerializedName(value="extended_status")
    private ExtendedStatusEnum extendedStatus = null;
    @SerializedName(value="linked_platform_app_id")
    private String linkedPlatformAppId = null;
    @SerializedName(value="linked_platform_app_name")
    private String linkedPlatformAppName = null;
    @SerializedName(value="linked_platform_app_uuid")
    private String linkedPlatformAppUuid = null;
    @SerializedName(value="linked_app_info")
    private LinkedAppInfo linkedAppInfo = null;
    @SerializedName(value="result_import_status")
    private ResultImportStatusEnum resultImportStatus = null;
    @SerializedName(value="scan_contact_info")
    private ContactInformation scanContactInfo = null;
    @SerializedName(value="scan_id")
    private String scanId = null;
    @SerializedName(value="scan_locked")
    private Boolean scanLocked = null;
    @SerializedName(value="scan_locked_on")
    private String scanLockedOn = null;
    @SerializedName(value="scan_optional_info")
    private ApplicationInformation scanOptionalInfo = null;
    @SerializedName(value="scheduled_start_date")
    private String scheduledStartDate = null;
    @SerializedName(value="scheduled_end_date")
    private String scheduledEndDate = null;
    @SerializedName(value="start_date")
    private String startDate = null;
    @SerializedName(value="end_date")
    private String endDate = null;
    @SerializedName(value="status")
    private ScanOccurrenceStatus status = null;
    @SerializedName(value="summary")
    private ScanOccurrenceRuntimeSummary summary = null;
    @SerializedName(value="target_url")
    private String targetUrl = null;
    @SerializedName(value="total_flaw_count")
    private Integer totalFlawCount = null;
    @SerializedName(value="verification_only")
    private Boolean verificationOnly = null;
    @SerializedName(value="verifications")
    private List<ScanVerification> verifications = null;
    @SerializedName(value="created_on")
    private String createdOn = null;
    @SerializedName(value="last_modified_on")
    private String lastModifiedOn = null;
    @SerializedName(value="links")
    private List<Link> links = null;

    public DetailedScanOccurrence scanOccurrenceId(String scanOccurrenceId) {
        this.scanOccurrenceId = scanOccurrenceId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier and locator")
    public String getScanOccurrenceId() {
        return this.scanOccurrenceId;
    }

    public void setScanOccurrenceId(String scanOccurrenceId) {
        this.scanOccurrenceId = scanOccurrenceId;
    }

    public DetailedScanOccurrence org(String org) {
        this.org = org;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the account")
    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public DetailedScanOccurrence analysisId(String analysisId) {
        this.analysisId = analysisId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the Analysis containing the Scan the current Scan Occurrence is an instance of")
    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String analysisId) {
        this.analysisId = analysisId;
    }

    public DetailedScanOccurrence analysisName(String analysisName) {
        this.analysisName = analysisName;
        return this;
    }

    @ApiModelProperty(value="Name of the related Analysis")
    public String getAnalysisName() {
        return this.analysisName;
    }

    public void setAnalysisName(String analysisName) {
        this.analysisName = analysisName;
    }

    public DetailedScanOccurrence analysisOccurrenceId(String analysisOccurrenceId) {
        this.analysisOccurrenceId = analysisOccurrenceId;
        return this;
    }

    @ApiModelProperty(value="Identifer of the analysis occurence this Scan Occurrence is part of")
    public String getAnalysisOccurrenceId() {
        return this.analysisOccurrenceId;
    }

    public void setAnalysisOccurrenceId(String analysisOccurrenceId) {
        this.analysisOccurrenceId = analysisOccurrenceId;
    }

    public DetailedScanOccurrence countOfFailedVerifications(Integer countOfFailedVerifications) {
        this.countOfFailedVerifications = countOfFailedVerifications;
        return this;
    }

    @ApiModelProperty(value="Count of failed verifications")
    public Integer getCountOfFailedVerifications() {
        return this.countOfFailedVerifications;
    }

    public void setCountOfFailedVerifications(Integer countOfFailedVerifications) {
        this.countOfFailedVerifications = countOfFailedVerifications;
    }

    public DetailedScanOccurrence countOfHighSevFlaws(Integer countOfHighSevFlaws) {
        this.countOfHighSevFlaws = countOfHighSevFlaws;
        return this;
    }

    @ApiModelProperty(value="Count of high severity flaws")
    public Integer getCountOfHighSevFlaws() {
        return this.countOfHighSevFlaws;
    }

    public void setCountOfHighSevFlaws(Integer countOfHighSevFlaws) {
        this.countOfHighSevFlaws = countOfHighSevFlaws;
    }

    public DetailedScanOccurrence countOfLowSevFlaws(Integer countOfLowSevFlaws) {
        this.countOfLowSevFlaws = countOfLowSevFlaws;
        return this;
    }

    @ApiModelProperty(value="Count of low severity flaws")
    public Integer getCountOfLowSevFlaws() {
        return this.countOfLowSevFlaws;
    }

    public void setCountOfLowSevFlaws(Integer countOfLowSevFlaws) {
        this.countOfLowSevFlaws = countOfLowSevFlaws;
    }

    public DetailedScanOccurrence countOfMediumSevFlaws(Integer countOfMediumSevFlaws) {
        this.countOfMediumSevFlaws = countOfMediumSevFlaws;
        return this;
    }

    @ApiModelProperty(value="Count of medium severity flaws")
    public Integer getCountOfMediumSevFlaws() {
        return this.countOfMediumSevFlaws;
    }

    public void setCountOfMediumSevFlaws(Integer countOfMediumSevFlaws) {
        this.countOfMediumSevFlaws = countOfMediumSevFlaws;
    }

    public DetailedScanOccurrence countOfVeryHighSevFlaws(Integer countOfVeryHighSevFlaws) {
        this.countOfVeryHighSevFlaws = countOfVeryHighSevFlaws;
        return this;
    }

    @ApiModelProperty(value="Count of very high severity flaws")
    public Integer getCountOfVeryHighSevFlaws() {
        return this.countOfVeryHighSevFlaws;
    }

    public void setCountOfVeryHighSevFlaws(Integer countOfVeryHighSevFlaws) {
        this.countOfVeryHighSevFlaws = countOfVeryHighSevFlaws;
    }

    public DetailedScanOccurrence duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="The duration of the scan occurence. If null - means the occurrence is still not done")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public DetailedScanOccurrence expectedPublishDate(String expectedPublishDate) {
        this.expectedPublishDate = expectedPublishDate;
        return this;
    }

    @ApiModelProperty(value="Date the occurrence is expected to be published. In ISO-8601 format.")
    public String getExpectedPublishDate() {
        return this.expectedPublishDate;
    }

    public void setExpectedPublishDate(String expectedPublishDate) {
        this.expectedPublishDate = expectedPublishDate;
    }

    public DetailedScanOccurrence hasCustomConfiguration(Boolean hasCustomConfiguration) {
        this.hasCustomConfiguration = hasCustomConfiguration;
        return this;
    }

    @ApiModelProperty(value="If true, has custom scan configuration. Custom scan configuration - which can only be specified by internal operators - creates a complete override of the configuration of the scan.  ")
    public Boolean isHasCustomConfiguration() {
        return this.hasCustomConfiguration;
    }

    public void setHasCustomConfiguration(Boolean hasCustomConfiguration) {
        this.hasCustomConfiguration = hasCustomConfiguration;
    }

    public DetailedScanOccurrence internalScanConfiguration(InternalScanConfiguration internalScanConfiguration) {
        this.internalScanConfiguration = internalScanConfiguration;
        return this;
    }

    @ApiModelProperty(value="Internal scan configuration data, if the Scan is configured as an internal scan")
    public InternalScanConfiguration getInternalScanConfiguration() {
        return this.internalScanConfiguration;
    }

    public void setInternalScanConfiguration(InternalScanConfiguration internalScanConfiguration) {
        this.internalScanConfiguration = internalScanConfiguration;
    }

    public DetailedScanOccurrence extendedStatus(ExtendedStatusEnum extendedStatus) {
        this.extendedStatus = extendedStatus;
        return this;
    }

    @ApiModelProperty(value="Additional status information available for this occurrence.")
    public ExtendedStatusEnum getExtendedStatus() {
        return this.extendedStatus;
    }

    public void setExtendedStatus(ExtendedStatusEnum extendedStatus) {
        this.extendedStatus = extendedStatus;
    }

    public DetailedScanOccurrence linkedPlatformAppId(String linkedPlatformAppId) {
        this.linkedPlatformAppId = linkedPlatformAppId;
        return this;
    }

    @ApiModelProperty(value="Identifer of the platform application linked to the scan")
    public String getLinkedPlatformAppId() {
        return this.linkedPlatformAppId;
    }

    public void setLinkedPlatformAppId(String linkedPlatformAppId) {
        this.linkedPlatformAppId = linkedPlatformAppId;
    }

    public DetailedScanOccurrence linkedPlatformAppName(String linkedPlatformAppName) {
        this.linkedPlatformAppName = linkedPlatformAppName;
        return this;
    }

    @ApiModelProperty(value="Name of the platform application linked to the scan")
    public String getLinkedPlatformAppName() {
        return this.linkedPlatformAppName;
    }

    public void setLinkedPlatformAppName(String linkedPlatformAppName) {
        this.linkedPlatformAppName = linkedPlatformAppName;
    }

    public DetailedScanOccurrence linkedPlatformAppUuid(String linkedPlatformAppUuid) {
        this.linkedPlatformAppUuid = linkedPlatformAppUuid;
        return this;
    }

    @ApiModelProperty(value="Uuid of the platform application linked to the scan")
    public String getLinkedPlatformAppUuid() {
        return this.linkedPlatformAppUuid;
    }

    public void setLinkedPlatformAppUuid(String linkedPlatformAppUuid) {
        this.linkedPlatformAppUuid = linkedPlatformAppUuid;
    }

    public DetailedScanOccurrence linkedAppInfo(LinkedAppInfo linkedAppInfo) {
        this.linkedAppInfo = linkedAppInfo;
        return this;
    }

    @ApiModelProperty(value="Additional Application information including result import status.")
    public LinkedAppInfo getLinkedAppInfo() {
        return this.linkedAppInfo;
    }

    public void setLinkedAppInfo(LinkedAppInfo linkedAppInfo) {
        this.linkedAppInfo = linkedAppInfo;
    }

    public DetailedScanOccurrence resultImportStatus(ResultImportStatusEnum resultImportStatus) {
        this.resultImportStatus = resultImportStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the import task, if this occurrence results should be sent to an Application - e.g. in case the Scan is linked")
    public ResultImportStatusEnum getResultImportStatus() {
        return this.resultImportStatus;
    }

    public void setResultImportStatus(ResultImportStatusEnum resultImportStatus) {
        this.resultImportStatus = resultImportStatus;
    }

    public DetailedScanOccurrence scanContactInfo(ContactInformation scanContactInfo) {
        this.scanContactInfo = scanContactInfo;
        return this;
    }

    @ApiModelProperty(value="Contact information for the scan")
    public ContactInformation getScanContactInfo() {
        return this.scanContactInfo;
    }

    public void setScanContactInfo(ContactInformation scanContactInfo) {
        this.scanContactInfo = scanContactInfo;
    }

    public DetailedScanOccurrence scanId(String scanId) {
        this.scanId = scanId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the scan this occurrence is based on")
    public String getScanId() {
        return this.scanId;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public DetailedScanOccurrence scanLocked(Boolean scanLocked) {
        this.scanLocked = scanLocked;
        return this;
    }

    @ApiModelProperty(value="If true the scan of this scan occurrence is locked by the internal users and can be editted and resubmitted only by them")
    public Boolean isScanLocked() {
        return this.scanLocked;
    }

    public void setScanLocked(Boolean scanLocked) {
        this.scanLocked = scanLocked;
    }

    public DetailedScanOccurrence scanLockedOn(String scanLockedOn) {
        this.scanLockedOn = scanLockedOn;
        return this;
    }

    @ApiModelProperty(value="Time the scan of this scan occurrence was locked")
    public String getScanLockedOn() {
        return this.scanLockedOn;
    }

    public void setScanLockedOn(String scanLockedOn) {
        this.scanLockedOn = scanLockedOn;
    }

    public DetailedScanOccurrence scanOptionalInfo(ApplicationInformation scanOptionalInfo) {
        this.scanOptionalInfo = scanOptionalInfo;
        return this;
    }

    @ApiModelProperty(value="Optional scan information")
    public ApplicationInformation getScanOptionalInfo() {
        return this.scanOptionalInfo;
    }

    public void setScanOptionalInfo(ApplicationInformation scanOptionalInfo) {
        this.scanOptionalInfo = scanOptionalInfo;
    }

    public DetailedScanOccurrence scheduledStartDate(String scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    @ApiModelProperty(value="Date and time in ISO-8601 the occurrence is scheduled to start")
    public String getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public void setScheduledStartDate(String scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public DetailedScanOccurrence scheduledEndDate(String scheduledEndDate) {
        this.scheduledEndDate = scheduledEndDate;
        return this;
    }

    @ApiModelProperty(value="Date and time in ISO-8601 the occurrence is scheduled to end")
    public String getScheduledEndDate() {
        return this.scheduledEndDate;
    }

    public void setScheduledEndDate(String scheduledEndDate) {
        this.scheduledEndDate = scheduledEndDate;
    }

    public DetailedScanOccurrence startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Actual start date and time, in ISO-8601 format")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public DetailedScanOccurrence endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Actual end date and time, in ISO-8601 format")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public DetailedScanOccurrence status(ScanOccurrenceStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the scan occurrence. Cannot be null or empty")
    public ScanOccurrenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScanOccurrenceStatus status) {
        this.status = status;
    }

    public DetailedScanOccurrence summary(ScanOccurrenceRuntimeSummary summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="A summary of the current scan occurrence results")
    public ScanOccurrenceRuntimeSummary getSummary() {
        return this.summary;
    }

    public void setSummary(ScanOccurrenceRuntimeSummary summary) {
        this.summary = summary;
    }

    public DetailedScanOccurrence targetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    @ApiModelProperty(value="Target URL of the scan occurrence")
    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public DetailedScanOccurrence totalFlawCount(Integer totalFlawCount) {
        this.totalFlawCount = totalFlawCount;
        return this;
    }

    @ApiModelProperty(value="Total count of flaws")
    public Integer getTotalFlawCount() {
        return this.totalFlawCount;
    }

    public void setTotalFlawCount(Integer totalFlawCount) {
        this.totalFlawCount = totalFlawCount;
    }

    public DetailedScanOccurrence verificationOnly(Boolean verificationOnly) {
        this.verificationOnly = verificationOnly;
        return this;
    }

    @ApiModelProperty(value="If true, this is a verification-only or prescan occurrence")
    public Boolean isVerificationOnly() {
        return this.verificationOnly;
    }

    public void setVerificationOnly(Boolean verificationOnly) {
        this.verificationOnly = verificationOnly;
    }

    public DetailedScanOccurrence verifications(List<ScanVerification> verifications) {
        this.verifications = verifications;
        return this;
    }

    public DetailedScanOccurrence addVerificationsItem(ScanVerification verificationsItem) {
        if (this.verifications == null) {
            this.verifications = new ArrayList<ScanVerification>();
        }
        this.verifications.add(verificationsItem);
        return this;
    }

    @ApiModelProperty(value="List of verifications done on the scan")
    public List<ScanVerification> getVerifications() {
        return this.verifications;
    }

    public void setVerifications(List<ScanVerification> verifications) {
        this.verifications = verifications;
    }

    public DetailedScanOccurrence createdOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was created")
    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public DetailedScanOccurrence lastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
        return this;
    }

    @ApiModelProperty(value="UTC date time representation of the time the record was last modified")
    public String getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public DetailedScanOccurrence links(List<Link> links) {
        this.links = links;
        return this;
    }

    public DetailedScanOccurrence addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailedScanOccurrence detailedScanOccurrence = (DetailedScanOccurrence)o;
        return Objects.equals(this.scanOccurrenceId, detailedScanOccurrence.scanOccurrenceId) && Objects.equals(this.org, detailedScanOccurrence.org) && Objects.equals(this.analysisId, detailedScanOccurrence.analysisId) && Objects.equals(this.analysisName, detailedScanOccurrence.analysisName) && Objects.equals(this.analysisOccurrenceId, detailedScanOccurrence.analysisOccurrenceId) && Objects.equals(this.countOfFailedVerifications, detailedScanOccurrence.countOfFailedVerifications) && Objects.equals(this.countOfHighSevFlaws, detailedScanOccurrence.countOfHighSevFlaws) && Objects.equals(this.countOfLowSevFlaws, detailedScanOccurrence.countOfLowSevFlaws) && Objects.equals(this.countOfMediumSevFlaws, detailedScanOccurrence.countOfMediumSevFlaws) && Objects.equals(this.countOfVeryHighSevFlaws, detailedScanOccurrence.countOfVeryHighSevFlaws) && Objects.equals(this.duration, detailedScanOccurrence.duration) && Objects.equals(this.expectedPublishDate, detailedScanOccurrence.expectedPublishDate) && Objects.equals(this.hasCustomConfiguration, detailedScanOccurrence.hasCustomConfiguration) && Objects.equals(this.internalScanConfiguration, detailedScanOccurrence.internalScanConfiguration) && Objects.equals((Object)this.extendedStatus, (Object)detailedScanOccurrence.extendedStatus) && Objects.equals(this.linkedPlatformAppId, detailedScanOccurrence.linkedPlatformAppId) && Objects.equals(this.linkedPlatformAppName, detailedScanOccurrence.linkedPlatformAppName) && Objects.equals(this.linkedPlatformAppUuid, detailedScanOccurrence.linkedPlatformAppUuid) && Objects.equals(this.linkedAppInfo, detailedScanOccurrence.linkedAppInfo) && Objects.equals((Object)this.resultImportStatus, (Object)detailedScanOccurrence.resultImportStatus) && Objects.equals(this.scanContactInfo, detailedScanOccurrence.scanContactInfo) && Objects.equals(this.scanId, detailedScanOccurrence.scanId) && Objects.equals(this.scanLocked, detailedScanOccurrence.scanLocked) && Objects.equals(this.scanLockedOn, detailedScanOccurrence.scanLockedOn) && Objects.equals(this.scanOptionalInfo, detailedScanOccurrence.scanOptionalInfo) && Objects.equals(this.scheduledStartDate, detailedScanOccurrence.scheduledStartDate) && Objects.equals(this.scheduledEndDate, detailedScanOccurrence.scheduledEndDate) && Objects.equals(this.startDate, detailedScanOccurrence.startDate) && Objects.equals(this.endDate, detailedScanOccurrence.endDate) && Objects.equals(this.status, detailedScanOccurrence.status) && Objects.equals(this.summary, detailedScanOccurrence.summary) && Objects.equals(this.targetUrl, detailedScanOccurrence.targetUrl) && Objects.equals(this.totalFlawCount, detailedScanOccurrence.totalFlawCount) && Objects.equals(this.verificationOnly, detailedScanOccurrence.verificationOnly) && Objects.equals(this.verifications, detailedScanOccurrence.verifications) && Objects.equals(this.createdOn, detailedScanOccurrence.createdOn) && Objects.equals(this.lastModifiedOn, detailedScanOccurrence.lastModifiedOn) && Objects.equals(this.links, detailedScanOccurrence.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scanOccurrenceId, this.org, this.analysisId, this.analysisName, this.analysisOccurrenceId, this.countOfFailedVerifications, this.countOfHighSevFlaws, this.countOfLowSevFlaws, this.countOfMediumSevFlaws, this.countOfVeryHighSevFlaws, this.duration, this.expectedPublishDate, this.hasCustomConfiguration, this.internalScanConfiguration, this.extendedStatus, this.linkedPlatformAppId, this.linkedPlatformAppName, this.linkedPlatformAppUuid, this.linkedAppInfo, this.resultImportStatus, this.scanContactInfo, this.scanId, this.scanLocked, this.scanLockedOn, this.scanOptionalInfo, this.scheduledStartDate, this.scheduledEndDate, this.startDate, this.endDate, this.status, this.summary, this.targetUrl, this.totalFlawCount, this.verificationOnly, this.verifications, this.createdOn, this.lastModifiedOn, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailedScanOccurrence {\n");
        sb.append("    scanOccurrenceId: ").append(this.toIndentedString(this.scanOccurrenceId)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    analysisId: ").append(this.toIndentedString(this.analysisId)).append("\n");
        sb.append("    analysisName: ").append(this.toIndentedString(this.analysisName)).append("\n");
        sb.append("    analysisOccurrenceId: ").append(this.toIndentedString(this.analysisOccurrenceId)).append("\n");
        sb.append("    countOfFailedVerifications: ").append(this.toIndentedString(this.countOfFailedVerifications)).append("\n");
        sb.append("    countOfHighSevFlaws: ").append(this.toIndentedString(this.countOfHighSevFlaws)).append("\n");
        sb.append("    countOfLowSevFlaws: ").append(this.toIndentedString(this.countOfLowSevFlaws)).append("\n");
        sb.append("    countOfMediumSevFlaws: ").append(this.toIndentedString(this.countOfMediumSevFlaws)).append("\n");
        sb.append("    countOfVeryHighSevFlaws: ").append(this.toIndentedString(this.countOfVeryHighSevFlaws)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    expectedPublishDate: ").append(this.toIndentedString(this.expectedPublishDate)).append("\n");
        sb.append("    hasCustomConfiguration: ").append(this.toIndentedString(this.hasCustomConfiguration)).append("\n");
        sb.append("    internalScanConfiguration: ").append(this.toIndentedString(this.internalScanConfiguration)).append("\n");
        sb.append("    extendedStatus: ").append(this.toIndentedString((Object)this.extendedStatus)).append("\n");
        sb.append("    linkedPlatformAppId: ").append(this.toIndentedString(this.linkedPlatformAppId)).append("\n");
        sb.append("    linkedPlatformAppName: ").append(this.toIndentedString(this.linkedPlatformAppName)).append("\n");
        sb.append("    linkedPlatformAppUuid: ").append(this.toIndentedString(this.linkedPlatformAppUuid)).append("\n");
        sb.append("    linkedAppInfo: ").append(this.toIndentedString(this.linkedAppInfo)).append("\n");
        sb.append("    resultImportStatus: ").append(this.toIndentedString((Object)this.resultImportStatus)).append("\n");
        sb.append("    scanContactInfo: ").append(this.toIndentedString(this.scanContactInfo)).append("\n");
        sb.append("    scanId: ").append(this.toIndentedString(this.scanId)).append("\n");
        sb.append("    scanLocked: ").append(this.toIndentedString(this.scanLocked)).append("\n");
        sb.append("    scanLockedOn: ").append(this.toIndentedString(this.scanLockedOn)).append("\n");
        sb.append("    scanOptionalInfo: ").append(this.toIndentedString(this.scanOptionalInfo)).append("\n");
        sb.append("    scheduledStartDate: ").append(this.toIndentedString(this.scheduledStartDate)).append("\n");
        sb.append("    scheduledEndDate: ").append(this.toIndentedString(this.scheduledEndDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    targetUrl: ").append(this.toIndentedString(this.targetUrl)).append("\n");
        sb.append("    totalFlawCount: ").append(this.toIndentedString(this.totalFlawCount)).append("\n");
        sb.append("    verificationOnly: ").append(this.toIndentedString(this.verificationOnly)).append("\n");
        sb.append("    verifications: ").append(this.toIndentedString(this.verifications)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    lastModifiedOn: ").append(this.toIndentedString(this.lastModifiedOn)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultImportStatusEnum {
        REQUESTED("REQUESTED"),
        INPROGRESS("INPROGRESS"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        IGNORED("IGNORED"),
        INVALID("INVALID");

        private String value;

        private ResultImportStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultImportStatusEnum fromValue(String text) {
            for (ResultImportStatusEnum b : ResultImportStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResultImportStatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ResultImportStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ResultImportStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultImportStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExtendedStatusEnum {
        INTERNAL_SCAN_SETUP_ERROR("INTERNAL_SCAN_SETUP_ERROR"),
        CREATE_TUNNEL_FAILED_ENDPOINT_UNAVAILABLE("CREATE_TUNNEL_FAILED_ENDPOINT_UNAVAILABLE"),
        CREATE_TUNNEL_FAILED_ENDPOINT_ACCESS_DENIED("CREATE_TUNNEL_FAILED_ENDPOINT_ACCESS_DENIED"),
        GET_TUNNEL_INFO_FAILED_TIMEOUT("GET_TUNNEL_INFO_FAILED_TIMEOUT"),
        GET_TUNNEL_INFO_FAILED_TUNNEL_NOT_READY("GET_TUNNEL_INFO_FAILED_TUNNEL_NOT_READY"),
        CREATE_TUNNEL_FAILED_GATEWAY_OFFLINE("CREATE_TUNNEL_FAILED_GATEWAY_OFFLINE"),
        CREATE_TUNNEL_FAILED_ENDPOINT_OFFLINE("CREATE_TUNNEL_FAILED_ENDPOINT_OFFLINE");

        private String value;

        private ExtendedStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExtendedStatusEnum fromValue(String text) {
            for (ExtendedStatusEnum b : ExtendedStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExtendedStatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, ExtendedStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ExtendedStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExtendedStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

