/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.dynamicanalysis.model.api;

import com.google.gson.annotations.SerializedName;
import com.veracode.apiwrapper.dynamicanalysis.model.api.CrawlScript;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Representation of a crawl script configuration for a scan")
public class CrawlConfiguration {
    @SerializedName(value="disabled")
    private Boolean disabled = null;
    @SerializedName(value="scripts")
    private List<CrawlScript> scripts = null;

    public CrawlConfiguration disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(example="false", value="If true, the automated crawler is disabled")
    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public CrawlConfiguration scripts(List<CrawlScript> scripts) {
        this.scripts = scripts;
        return this;
    }

    public CrawlConfiguration addScriptsItem(CrawlScript scriptsItem) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<CrawlScript>();
        }
        this.scripts.add(scriptsItem);
        return this;
    }

    @ApiModelProperty(value="List of script identifiers. Is not mandatory, but if specified must be valid identifers.")
    public List<CrawlScript> getScripts() {
        return this.scripts;
    }

    public void setScripts(List<CrawlScript> scripts) {
        this.scripts = scripts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlConfiguration crawlConfiguration = (CrawlConfiguration)o;
        return Objects.equals(this.disabled, crawlConfiguration.disabled) && Objects.equals(this.scripts, crawlConfiguration.scripts);
    }

    public int hashCode() {
        return Objects.hash(this.disabled, this.scripts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlConfiguration {\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    scripts: ").append(this.toIndentedString(this.scripts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

