/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.veracode.apiwrapper.AbstractAPIWrapper;
import com.veracode.apiwrapper.identity.model.api.CredentialValidityDetails;
import com.veracode.apiwrapper.identity.model.client.Feature;
import com.veracode.apiwrapper.services.APIServiceManager;
import com.veracode.apiwrapper.services.ServiceManager;
import com.veracode.apiwrapper.wrappers.AdminAPIWrapper;
import com.veracode.apiwrapper.wrappers.ArcherAPIWrapper;
import com.veracode.apiwrapper.wrappers.MitigationAPIWrapper;
import com.veracode.apiwrapper.wrappers.ResultsAPIWrapper;
import com.veracode.apiwrapper.wrappers.SandboxAPIWrapper;
import com.veracode.apiwrapper.wrappers.UploadAPIWrapper;
import com.veracode.apiwrapper.wrappers.VastAPIWrapper;
import com.veracode.http.Credentials;
import com.veracode.http.Region;
import com.veracode.http.proxy.ProxyData;
import com.veracode.http.util.ProxyAuthenticator;
import com.veracode.parser.CommandLineParser;
import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.annotations.Option;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.exceptions.UnableToProceedException;
import com.veracode.parser.exceptions.UnknownStatusException;
import com.veracode.parser.exceptions.XmlApiException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.util.StringUtility;
import com.veracode.parser.util.XmlUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class VeracodeCommand {
    private static String USER_AGENT_NAME = "";
    private static String USER_AGENT_VERSION = "";
    private static String JRE_VERSION = "";
    private static String USER_AGENT_TOOL = "";
    private static Date BUILT_DATE = null;
    private static final String DEFAULT_VAULE = "Unknown";
    private static final String NEWLINE = System.lineSeparator();
    private static final short MIN_ALLOWED_CONSECUTIVE_API_EXCEPTIONS = 0;
    private static final short MAX_ALLOWED_CONSECUTIVE_API_EXCEPTIONS = 5;
    private static final short DEFAULT_MAX_SCAN_POLL_INTERVAL_SECONDS = 120;
    private static final short DEFAULT_MIN_SCAN_POLL_INTERVAL_SECONDS = 30;
    private static boolean isDebugEnabled = false;
    private static final String SCANTIMEOUT_USERINPUT_INDEFINITE = "indefinite";
    private static final String ERROR_MSG_REGEX = "<error>(.*?)</error>";
    private static final int SCANTIMEOUT_INDEFINITE_INT = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initUserAgent() {
        block11: {
            try {
                ClassLoader loader = VeracodeCommand.class.getClassLoader();
                InputStream is = loader.getResourceAsStream("version.properties");
                if (is == null) break block11;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    String title = properties.getProperty("title");
                    String string = USER_AGENT_NAME = !StringUtility.isNullOrEmpty(title) ? title : "VeracodeJavaAPI";
                    if (!StringUtility.isNullOrEmpty(title)) {
                        String version = properties.getProperty("version");
                        USER_AGENT_VERSION = !StringUtility.isNullOrEmpty(version) ? version : DEFAULT_VAULE;
                        try {
                            String rawDate = properties.getProperty("date");
                            String datePattern = properties.getProperty("datepattern");
                            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
                            BUILT_DATE = sdf.parse(rawDate);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Throwable loader) {
                // empty catch block
            }
        }
        if ("".equals(JRE_VERSION)) {
            try {
                String sysJreVersion = System.getProperty("java.version");
                JRE_VERSION = !StringUtility.isNullOrEmpty(sysJreVersion) && sysJreVersion.matches("^[1-9][0-9]?(\\.[0-9]\\.[0-9](_\\d{1,4}(-\\S{0,20})?)?)?") ? sysJreVersion : DEFAULT_VAULE;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String getUserAgentName() {
        return USER_AGENT_NAME;
    }

    public static String getUserAgentVersion() {
        return USER_AGENT_VERSION;
    }

    public static String getJreVersion() {
        return JRE_VERSION;
    }

    public static String getUserAgentTool() {
        return USER_AGENT_TOOL;
    }

    private static String getBuiltDate() {
        String date = null;
        if (BUILT_DATE != null) {
            date = new SimpleDateFormat("yyyyMMddHHmm").format(BUILT_DATE);
        }
        return !StringUtility.isNullOrEmpty(date) ? date : "";
    }

    public static String getVersionString() {
        String heading = String.format("%s v%s c%s", VeracodeCommand.getUserAgentName(), VeracodeCommand.getUserAgentVersion(), VeracodeCommand.getJreVersion());
        return !StringUtility.isNullOrEmpty(heading) ? heading : "";
    }

    public static boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static void main(String[] args) {
        VeracodeParser parser = new VeracodeParser();
        System.exit(parser.parse(args));
    }

    static /* synthetic */ boolean access$1002(boolean x0) {
        isDebugEnabled = x0;
        return isDebugEnabled;
    }

    static {
        VeracodeCommand.initUserAgent();
    }

    public static class VeracodeParser {
        private PrintStream outputWriter = this.getPrintStream(System.out);
        private PrintStream errorWriter = System.err;
        private PrintStream logWriter;
        private boolean canThrowExceptions;
        private boolean isValidXml = true;
        private boolean failedPolicy = false;
        private short pollInterval = (short)2;
        private int pollIntervalSeconds = 120;
        private int scanCompleteTimeout = -2;

        private PrintStream getPrintStream(OutputStream ioOutput) {
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(ioOutput, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                this.printException(e);
                printStream = System.out;
            }
            return printStream;
        }

        private String beginPreScan(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.beginPreScan(options._app_id, options._sandbox_id, APICallText.Reader.toString(options._auto_scan), APICallText.Reader.toString(options._scan_all_nonfatal_top_level_modules));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String beginPreScan(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.beginPreScan(options._app_id, options._sandbox_id, APICallText.Reader.toString(options._auto_scan), APICallText.Reader.toString(options._scan_all_nonfatal_top_level_modules));
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to start pre-scan. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to start pre-scan. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to start pre-scan. Error: " + errorMsg);
            }
            return result;
        }

        private String beginScan(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.beginScan(options._app_id, options._modules, APICallText.Reader.toString(options._scan_all_top_level_modules), APICallText.Reader.toString(options._scan_selected_modules), APICallText.Reader.toString(options._scan_previously_selected_modules), options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String beginScan(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.beginScan(options._app_id, options._modules, APICallText.Reader.toString(options._scan_all_top_level_modules), APICallText.Reader.toString(options._scan_selected_modules), APICallText.Reader.toString(options._scan_previously_selected_modules), options._sandbox_id);
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to start scan. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to start scan. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to start a scan. Error: " + errorMsg);
            }
            return result;
        }

        private String rescanDynamicScan(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            this.infoWriteLine("Dynamic Rescan flaw only enabled - " + (Object)((Object)options._flaw_only), new Object[0]);
            if (StringUtility.compare(options._version, "timestamp", true) == 0) {
                options._version = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date());
            }
            String result = uploadAPIWrapper.dynamicRescan(options._app_id, APICallText.Reader.toString(options._flaw_only), options._version);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String submitDynamicRescan(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.submitDynamicRescan(options._app_id, options._start_time, options._end_time);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            this.infoWriteLine("Dynamic Rescan request submitted for application ID - " + options._app_id, new Object[0]);
            return isValidXML ? result : null;
        }

        private void createAndSubmitDynamicScan(Options options) throws Exception {
            String result = this.getAppList(options, false);
            if (result != null) {
                String app_id = this.parseAppId(options, result);
                if (app_id != null) {
                    this.infoWriteLine("\r\nApplication profile \"%s\" (appid=%s) was located.", options._app_name, app_id);
                    options._app_id = app_id;
                    result = this.rescanDynamicScan(options, false);
                    if (result != null) {
                        this.infoWriteLine("Dynamic Rescan request created for application - " + options._app_name, new Object[0]);
                        this.submitDynamicRescan(options, false);
                    } else {
                        this.infoWriteLine("Dynamic Rescan request NOT created for application - " + options._app_name, new Object[0]);
                    }
                } else {
                    this.infoWriteLine("Application not found......" + options._app_name, new Object[0]);
                }
            }
        }

        private String createApp(Options options, boolean printReport) throws Exception {
            if (options._business_criticality == null) {
                options._business_criticality = Business_Criticality.VeryHigh;
            }
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.createApp(options._app_name, options._description, options._vendor_id, APICallText.Reader.toString(options._business_criticality), options._policy, options._business_unit, options._business_owner, options._business_owner_email, options._teams, APICallText.Reader.toString(options._origin), APICallText.Reader.toString(options._industry), APICallText.Reader.toString(options._app_type), APICallText.Reader.toString(options._deployment_type), APICallText.Reader.toString(options._web_application), options._archer_app_name, options._tags, APICallText.Reader.toString(options._next_day_scheduling_enabled));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String createBuild(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.createBuild(options._app_id, options._version, APICallText.Reader.toString(options._platform), options._platform_id, APICallText.Reader.toString(options._lifecycle_stage), options._lifecycle_stage_id, options._launch_date, options._sandbox_id, APICallText.Reader.toString(options._legacy_scan_engine));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String createBuild(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.createBuild(options._app_id, options._version, APICallText.Reader.toString(options._platform), options._platform_id, APICallText.Reader.toString(options._lifecycle_stage), options._lifecycle_stage_id, options._launch_date, options._sandbox_id, APICallText.Reader.toString(options._legacy_scan_engine));
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to create an analysis. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to create an analysis. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to create analysis. Error: " + errorMsg);
            }
            return result;
        }

        private String deleteApp(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.deleteApp(options._app_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String deleteBuild(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.deleteBuild(options._app_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String deleteBuild(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.deleteBuild(options._app_id, options._sandbox_id);
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to delete the analysis. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to delete the analysis. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to delete the latest analysis of application " + options._app_name + ". Error: " + errorMsg);
            }
            return result;
        }

        private void deleteBuildIgnoreError(Options options) {
            try {
                this.errorWriteLine("Deleting analysis " + options._version, new Object[0]);
                this.deleteBuild(options);
                this.errorWriteLine("Deleted analysis " + options._version, new Object[0]);
            }
            catch (XmlApiException xae) {
                this.errorWriteLine(xae.getMessage(), new Object[0]);
            }
            catch (Exception e) {
                this.errorWriteLine("Unable to delete the analysis. Error: %s", e.getMessage());
            }
        }

        private String getAppInfo(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getAppInfo(options._app_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getAppList(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getAppList(APICallText.Reader.toString(options._include_user_info));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getBuildInfo(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getBuildInfo(options._app_id, options._build_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getBuildInfo(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.getBuildInfo(options._app_id, options._build_id, options._sandbox_id);
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to get analysis info. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to get analysis info. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to get analysis info. Error: " + errorMsg);
            }
            return result;
        }

        private String getBuildList(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getBuildList(options._app_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getFileList(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getFileList(options._app_id, options._build_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getPolicyList(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getPolicyList();
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getPreScanResults(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getPreScanResults(options._app_id, options._build_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getPreScanResults(Options options) throws XmlApiException {
            UploadAPIWrapper uploadAPIWrapper = this.getWrapper(UploadAPIWrapper.class, options);
            String result = "";
            try {
                result = uploadAPIWrapper.getPreScanResults(options._app_id, options._build_id, options._sandbox_id);
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to get pre-scan result. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to get pre-scan result. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to get pre-scan result. Error: " + errorMsg);
            }
            return result;
        }

        private String getVendorList(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.getVendorList();
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String removeFile(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.removeFile(options._app_id, options._file_id, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateApp(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.updateApp(options._app_id, options._app_name, options._description, APICallText.Reader.toString(options._business_criticality), options._policy, options._business_unit, options._business_owner, options._business_owner_email, options._teams, APICallText.Reader.toString(options._origin), APICallText.Reader.toString(options._industry), APICallText.Reader.toString(options._app_type), APICallText.Reader.toString(options._deployment_type), options._archer_app_name, options._tags, options._custom_field_name, options._custom_field_value, APICallText.Reader.toString(options._next_day_scheduling_enabled));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateBuild(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.updateBuild(options._app_id, options._build_id, options._version, APICallText.Reader.toString(options._lifecycle_stage), options._launch_date, options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String uploadFile(Options options, boolean printReport) throws Exception {
            UploadAPIWrapper uploadAPIWrapper = this.getUploadAPIWrapper(options);
            String result = uploadAPIWrapper.uploadFile(options._app_id, options._file[0].toString(), options._sandbox_id, options._save_as);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String createSandbox(Options options, boolean printReport) throws Exception {
            SandboxAPIWrapper sandboxAPIWrapper = this.getSandboxAPIWrapper(options);
            String result = sandboxAPIWrapper.createSandbox(options._app_id, options._sandbox_name, null == options.autoRecreate ? null : Boolean.valueOf(TrueOrFalse.True == options.autoRecreate));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getSandboxList(Options options, boolean printReport) throws Exception {
            SandboxAPIWrapper sandboxAPIWrapper = this.getSandboxAPIWrapper(options);
            String result = sandboxAPIWrapper.getSandboxList(options._app_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String promoteSandbox(Options options, boolean printReport) throws Exception {
            SandboxAPIWrapper sandboxAPIWrapper = this.getSandboxAPIWrapper(options);
            String result = sandboxAPIWrapper.promoteSandbox(options._build_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateSandbox(Options options, boolean printReport) throws Exception {
            SandboxAPIWrapper sandboxAPIWrapper = this.getSandboxAPIWrapper(options);
            String result = sandboxAPIWrapper.updateSandbox(options._sandbox_id, options._custom_field_name, options._custom_field_value, null == options.autoRecreate ? null : Boolean.valueOf(TrueOrFalse.True == options.autoRecreate));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String deleteSandbox(Options options, boolean printReport) throws Exception {
            SandboxAPIWrapper sandboxAPIWrapper = this.getSandboxAPIWrapper(options);
            String result = sandboxAPIWrapper.deleteSandbox(options._sandbox_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String detailedReport(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            String result = resultsAPIWrapper.detailedReport(options._build_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private Boolean isFeatureEnabled(Options options, boolean printReport) throws Exception {
            String featureName = options._feature;
            ProxyData proxyData = this.createProxyData(options);
            Credentials credentials = this.createCredentials(options._vid, options._vkey, options.credprofile);
            Proxy proxy = proxyData != null ? ProxyAuthenticator.newProxy(proxyData) : Proxy.NO_PROXY;
            APIServiceManager apiServiceManager = APIServiceManager.createInstance(credentials, proxy);
            boolean isFeatureEnabled = apiServiceManager.getIdentityAPIService().isFeatureEnabled(featureName);
            if (printReport) {
                Feature feature = new Feature();
                feature.setName(featureName);
                feature.setEnabled(isFeatureEnabled);
                Gson gson = new GsonBuilder().create();
                String result = gson.toJson(feature);
                this.consoleWriteLine(false, result);
            }
            return isFeatureEnabled;
        }

        private CredentialValidityDetails getApiCredentialDetails(Options options, boolean printReport) throws Exception {
            ProxyData proxyData = this.createProxyData(options);
            Credentials credentials = this.createCredentials(options._vid, options._vkey, options.credprofile);
            Proxy proxy = proxyData != null ? ProxyAuthenticator.newProxy(proxyData) : Proxy.NO_PROXY;
            APIServiceManager apiServiceManager = APIServiceManager.createInstance(credentials, proxy);
            CredentialValidityDetails credentialValidity = apiServiceManager.getIdentityAPIService().getApiCredentialDetails();
            if (printReport) {
                Gson gson = new GsonBuilder().create();
                String result = gson.toJson(credentialValidity);
                this.consoleWriteLine(false, result);
            }
            return credentialValidity;
        }

        private byte[] detailedReportPdf(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            byte[] result = resultsAPIWrapper.detailedReportPdf(options._build_id);
            if (printReport) {
                this.printReport(result, options);
            }
            return result;
        }

        private String getAppBuilds(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            String result = resultsAPIWrapper.getAppBuilds(options._report_changed_since, APICallText.Reader.toString(options._only_latest), APICallText.Reader.toString(options._include_in_progress));
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getCallStacks(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            String result = resultsAPIWrapper.getCallStacks(options._build_id, options._flaw_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String summaryReport(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            String result = resultsAPIWrapper.summaryReport(options._build_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String summaryReport(Options options) throws XmlApiException {
            ResultsAPIWrapper resultAPIWrapper = this.getWrapper(ResultsAPIWrapper.class, options);
            String result = "";
            try {
                result = resultAPIWrapper.summaryReport(options._build_id);
            }
            catch (IOException ioe) {
                throw new XmlApiException("Unable to get the summary report. Error: " + ioe.getMessage(), ioe);
            }
            if (StringUtility.isNullOrEmpty(result)) {
                throw new XmlApiException("Unable to get the summary report. The API call returns empty result.");
            }
            String errorMsg = this.getErrorString(result);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new XmlApiException("Unable to get the summary report. Error: " + errorMsg);
            }
            return result;
        }

        private byte[] summaryReportPdf(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            byte[] result = resultsAPIWrapper.summaryReportPdf(options._build_id);
            if (printReport) {
                this.printReport(result, options);
            }
            return result;
        }

        private byte[] thirdPartyReportPdf(Options options, boolean printReport) throws Exception {
            ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
            byte[] result = resultsAPIWrapper.thirdPartyReportPdf(options._build_id);
            if (printReport) {
                this.printReport(result, options);
            }
            return result;
        }

        private String createTeam(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.createTeam(options._team_name, options._members);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String createUser(Options options, boolean printReport) throws Exception {
            if (options._is_saml_user == TrueOrFalse.True && StringUtility.isNullOrEmpty(options._custom_id)) {
                this.errorWriteLine("\r\nSAML users must enter the custom_id parameter.", options._first_name);
                return null;
            }
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.createUser(options._first_name, options._last_name, options._email_address, options._roles, options._teams, APICallText.Reader.toString(options._is_saml_user), options._custom_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String deleteTeam(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.deleteTeam(options._team_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String deleteUser(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.deleteUser(options._username, options._custom_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getCurriculumList(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getCurriculumList();
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getTeamList(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getTeamList();
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getTeamInfo(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getTeamInfo(options._team_id, options._include_users, options._include_applications);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getTrackList(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getTrackList();
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getUserInfo(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getUserInfo(options._username, options._custom_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getUserList(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.getUserList(options._first_name, options._last_name, options._custom_id, options._email_address, options._login_account_type, options._phone, options._teams, options._roles, APICallText.Reader.toString(options._is_saml_user), APICallText.Reader.toString(options._login_enabled), APICallText.Reader.toString(options._requires_token), APICallText.Reader.toString(options._is_elearning_manager), options._elearning_manager, options._elearning_track, options._elearning_curriculum, APICallText.Reader.toString(options._keep_elearning_active), options._custom_one, options._custom_two, options._custom_three, options._custom_four, options._custom_five, options._position);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateTeam(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.updateTeam(options._members, options._team_id, options._team_name);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateUser(Options options, boolean printReport) throws Exception {
            AdminAPIWrapper adminAPIWrapper = this.getAdminAPIWrapper(options);
            String result = adminAPIWrapper.updateUser(options._username, options._custom_id, options._first_name, options._last_name, options._email_address, options._new_custom_id, options._login_account_type, options._phone, options._teams, options._roles, APICallText.Reader.toString(options._is_saml_user), APICallText.Reader.toString(options._login_enabled), APICallText.Reader.toString(options._requires_token), APICallText.Reader.toString(options._is_elearning_manager), options._elearning_manager, options._elearning_track, options._elearning_curriculum, APICallText.Reader.toString(options._keep_elearning_active), options._custom_one, options._custom_two, options._custom_three, options._custom_four, options._custom_five);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String archer(Options options, boolean printReport) throws Exception {
            ArcherAPIWrapper archerAPIWrapper = this.getArcherAPIWrapper(options);
            String result = archerAPIWrapper.archer(options._app_id, options._period, options._from_date, options._to_date, options._scan_type);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String generateArcherReport(Options options, boolean printReport) throws Exception {
            ArcherAPIWrapper archerAPIWrapper = this.getArcherAPIWrapper(options);
            String result = archerAPIWrapper.generateArcherReport(options._app_id, options._period, options._from_date, options._to_date, options._scan_type);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String downloadArcherReport(Options options, boolean printReport) throws Exception {
            ArcherAPIWrapper archerAPIWrapper = this.getArcherAPIWrapper(options);
            String result = archerAPIWrapper.downloadArcherReport(options._token);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String generateFlawReport(Options options, boolean printReport) throws Exception {
            ArcherAPIWrapper archerAPIWrapper = this.getArcherAPIWrapper(options);
            String result = archerAPIWrapper.generateFlawReport(options._app_id_list, options._scan_type);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String downloadFlawReport(Options options, boolean printReport) throws Exception {
            ArcherAPIWrapper archerAPIWrapper = this.getArcherAPIWrapper(options);
            String result = archerAPIWrapper.downloadFlawReport(options._token);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getMitigationInfo(Options options, boolean printReport) throws Exception {
            MitigationAPIWrapper mitigationAPIWrapper = this.getMitigationAPIWrapper(options);
            String result = mitigationAPIWrapper.getMitigationInfo(options._build_id, options._flaw_id_list);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String updateMitigationInfo(Options options, boolean printReport) throws Exception {
            MitigationAPIWrapper mitigationAPIWrapper = this.getMitigationAPIWrapper(options);
            String result = mitigationAPIWrapper.updateMitigationInfo(options._build_id, APICallText.Reader.toString(options._mitigation_action), options._comment, options._flaw_id_list);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getSharedReportInfo(Options options, boolean printReport) throws Exception {
            VastAPIWrapper vastAPIWrapper = this.getVastAPIWrapper(options);
            String result = vastAPIWrapper.getSharedReportInfo(options._app_id, options._shared_report_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String getSharedReportList(Options options, boolean printReport) throws Exception {
            VastAPIWrapper vastAPIWrapper = this.getVastAPIWrapper(options);
            String result = vastAPIWrapper.getSharedReportList(options._app_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private String sharedReport(Options options, boolean printReport) throws Exception {
            VastAPIWrapper vastAPIWrapper = this.getVastAPIWrapper(options);
            String result = vastAPIWrapper.sharedReport(options._app_id, options._shared_report_id);
            boolean isValidXML = this.isValidXML(result, options);
            if (printReport && isValidXML) {
                this.printReport(result, options);
            }
            return isValidXML ? result : null;
        }

        private byte[] sharedReportPdf(Options options, boolean printReport) throws Exception {
            VastAPIWrapper vastAPIWrapper = this.getVastAPIWrapper(options);
            byte[] result = vastAPIWrapper.sharedReportPdf(options._app_id, options._shared_report_id);
            if (printReport) {
                this.printReport(result, options);
            }
            return result;
        }

        private void allDetailedReports(Options options) throws Exception {
            NodeList nodeList;
            String result = this.getAppBuilds(options, false);
            if (result != null && (nodeList = XmlUtils.getXmlNodeList(result, "/*/*[local-name()='application'][@cots='false']/*[local-name()='build'][@results_ready='true']")).getLength() > 0) {
                ResultsAPIWrapper resultsAPIWrapper = this.getResultsAPIWrapper(options);
                File folderPath = new File(options._output_folderpath);
                if (!folderPath.exists()) {
                    folderPath.mkdirs();
                }
                block3: for (int x = 0; x < nodeList.getLength(); ++x) {
                    Node node = nodeList.item(x);
                    String app_id = node.getParentNode().getAttributes().getNamedItem("app_id").getNodeValue();
                    String build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
                    File filePath = new File(folderPath, String.format("%s.%s.%s", Integer.parseInt(app_id), Integer.parseInt(build_id), options._format.toString()));
                    switch (options._format) {
                        case pdf: {
                            this.printReport(resultsAPIWrapper.detailedReportPdf(build_id), options, filePath.getPath());
                            continue block3;
                        }
                        default: {
                            this.printReport(resultsAPIWrapper.detailedReport(build_id), options, false, filePath.getPath());
                        }
                    }
                }
            }
        }

        private void passFail(Options options) throws Exception {
            String result = this.getAppList(options, false);
            if (result != null) {
                String app_id = this.parseAppId(options, result);
                if (app_id != null) {
                    options._app_id = app_id;
                    if (options._sandbox_name != null && (result = this.getSandboxList(options, false)) != null) {
                        String sandbox_id = this.parseSandboxId(options, result);
                        if (sandbox_id != null) {
                            options._sandbox_id = sandbox_id;
                        } else {
                            this.errorWriteLine("\r\nA sandbox_id could not be located for sandbox \"%s\".", options._sandbox_name);
                            return;
                        }
                    }
                    if ((result = this.getBuildInfo(options, false)) != null) {
                        String build_id;
                        Node node = XmlUtils.getXmlNode(result, "/*/*[local-name()='build'][@build_id]");
                        options._build_id = build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
                        result = this.detailedReport(options, false);
                        if (result != null) {
                            node = XmlUtils.getXmlNode(result, "/*[local-name()='detailedreport']");
                            String formatString = "%s,%s,%s,%s";
                            String submitter = null;
                            String app_name = null;
                            String version = null;
                            String policy_compliance_status = null;
                            String sandbox_name = null;
                            if (node.hasChildNodes()) {
                                Node attribute = node.getAttributes().getNamedItem("submitter");
                                if (attribute != null) {
                                    submitter = String.format("\"%s\"", attribute.getNodeValue());
                                }
                                if ((attribute = node.getAttributes().getNamedItem("app_name")) != null) {
                                    app_name = String.format("\"%s\"", attribute.getNodeValue());
                                }
                                if ((attribute = node.getAttributes().getNamedItem("sandbox_name")) != null) {
                                    sandbox_name = String.format("\"%s\"", attribute.getNodeValue());
                                }
                                if ((attribute = node.getAttributes().getNamedItem("version")) != null) {
                                    version = String.format("\"%s\"", attribute.getNodeValue());
                                }
                                if ((attribute = node.getAttributes().getNamedItem("policy_compliance_status")) != null) {
                                    policy_compliance_status = String.format("\"%s\"", attribute.getNodeValue());
                                }
                            }
                            this.infoWriteLine(formatString, "SUBMITTER", sandbox_name != null ? "APPLICATION,SANDBOX" : "APPLICATION", "VERSION", "PASSFAIL");
                            this.infoWriteLine(formatString, submitter, sandbox_name != null ? app_name + ", " + sandbox_name : app_name, version, policy_compliance_status);
                        }
                    }
                } else {
                    this.infoWriteLine("Application profile \"%s\" could not be located.", options._app_name);
                    this.throwException(options);
                }
            }
        }

        private void switchToSaml(Options options) throws Exception {
            String result = this.getUserList(options, false);
            if (result != null) {
                this.infoWriteLine("Attempting to switch user(s) to SAML.", new Object[0]);
                NodeList nodeList = XmlUtils.getXmlNodeList(result, "/*/*[local-name()='users'][@usernames]");
                if (nodeList.getLength() > 0) {
                    String suppliedUser = options._username;
                    for (int x = 0; x < nodeList.getLength(); ++x) {
                        Node node = nodeList.item(x);
                        List<String> users = Arrays.asList(node.getAttributes().getNamedItem("usernames").getNodeValue().split(String.valueOf(','), -1));
                        if (suppliedUser == null && users.size() > 0) {
                            Iterator<String> iterator = users.iterator();
                            while (iterator.hasNext()) {
                                String user;
                                options._username = user = iterator.next();
                                this.infoWriteLine("\r\nAttempting to switch user \"%s\" to SAML.", options._username);
                                String responseMessage = this.switchUserToSAML(options, false);
                                this.infoWriteLine(responseMessage, new Object[0]);
                            }
                            continue;
                        }
                        if (users.contains(suppliedUser)) {
                            this.infoWriteLine("\r\nAttempting to switch user \"%s\" to SAML.", options._username);
                            String responseMessage = this.switchUserToSAML(options, false);
                            this.infoWriteLine(responseMessage, new Object[0]);
                            continue;
                        }
                        this.infoWriteLine("\r\nUser list does not contain user \"%s\".", suppliedUser);
                    }
                } else {
                    this.infoWriteLine("\r\nUser list could not be located.", new Object[0]);
                }
            }
        }

        private String getAppId(Options options) throws Exception {
            if (options._business_criticality == null) {
                options._business_criticality = Business_Criticality.VeryHigh;
            }
            String result = this.getAppList(options, false);
            String appId = null;
            if (result != null) {
                appId = this.parseAppId(options, result);
                if (null != appId) {
                    this.infoWriteLine("\r\nApplication profile \"%s\" (appid=%s) was located.", options._app_name, appId);
                } else if (options._create_profile == TrueOrFalse.True) {
                    Node node;
                    this.infoWriteLine("\r\nAttempting to create a new application profile with name \"%s\" and criticality \"%s\".", options._app_name, APICallText.Reader.toString(options._business_criticality));
                    result = this.createApp(options, false);
                    if (result != null && null != (appId = (node = XmlUtils.getXmlNode(result, "/*/*[local-name()='application'][@app_id]")).getAttributes().getNamedItem("app_id").getNodeValue())) {
                        byte seconds = 5;
                        this.infoWriteLine("\r\nThe app_id of the new application profile is \"%s\".\r\nWaiting %s seconds before attempting to continue.", appId, seconds);
                        Thread.sleep(seconds * 1000);
                    }
                }
            }
            return appId;
        }

        private boolean fillInSandboxId(Options options) throws Exception {
            boolean ok = true;
            if (null != options._sandbox_id || null != options._sandbox_name) {
                ok = false;
                String result = this.getSandboxList(options, false);
                if (null != result) {
                    if (null != options._sandbox_id) {
                        String sandbox_name = this.parseSandboxName(options, result);
                        if (null != sandbox_name) {
                            this.infoWriteLine("\r\nSandbox \"%s\" (sandboxid=%s) was located.", sandbox_name, options._sandbox_id);
                            options._sandbox_name = sandbox_name;
                            ok = true;
                        } else {
                            this.errorWriteLine("\r\nA sandbox could not be located for sandboxid=\"%s\".", options._sandbox_id);
                        }
                    } else {
                        String sandbox_id = this.parseSandboxId(options, result);
                        if (null != sandbox_id) {
                            this.infoWriteLine("\r\nSandbox \"%s\" (sandboxid=%s) was located.", options._sandbox_name, sandbox_id);
                        } else if (options._create_sandbox == TrueOrFalse.True) {
                            Node node;
                            this.infoWriteLine("\r\nAttempting to create a new sandbox with name \"%s\".", options._sandbox_name);
                            result = this.createSandbox(options, false);
                            if (null != result && null != (sandbox_id = (node = XmlUtils.getXmlNode(result, "/*/*[local-name()='sandbox'][@sandbox_id]")).getAttributes().getNamedItem("sandbox_id").getNodeValue())) {
                                byte seconds = 5;
                                this.infoWriteLine("\r\nThe sandbox_id of the new sandbox is \"%s\".\r\nWaiting %s seconds before attempting to continue.", sandbox_id, seconds);
                                Thread.sleep(seconds * 1000);
                            }
                        }
                        if (null != sandbox_id) {
                            options._sandbox_id = sandbox_id;
                            ok = true;
                        } else {
                            this.errorWriteLine("\r\nA sandbox_id could not be located for sandbox \"%s\".", options._sandbox_name);
                        }
                    }
                }
            }
            return ok;
        }

        private String waitForPrescanComplete(Options options) throws Exception {
            String result = null;
            short minutes = this.pollInterval;
            long timeToQuit = 0L;
            try {
                int userTimeout = Integer.parseInt(options._scantime_out);
                if (0 > userTimeout) {
                    throw new IllegalArgumentException("Invalid scan time out value: " + options._scantime_out);
                }
                if (0 < userTimeout) {
                    timeToQuit = (long)(userTimeout * 60) * 1000L + System.currentTimeMillis();
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid scan time out value: " + options._scantime_out, nfe);
            }
            boolean timedOut = false;
            while (!timedOut && (result = this.getBuildInfo(options, false)) != null) {
                String version = this.parseBuildVersion(result);
                String status = this.parseBuildStatus(result);
                if (!Build.isPreScanSubmitted(status)) {
                    if (Build.isPreScanSucess(status)) {
                        this.infoWriteLine("%sThe status of \"%s\" is \"%s\".", System.lineSeparator(), version, status);
                        break;
                    }
                    if (Build.isScanInProgress(status) || Build.isResultReady(status)) {
                        this.infoWriteLine("%sThe status of the \"%s\" is \"%s\".", System.lineSeparator(), version, status);
                        break;
                    }
                    this.errorWriteLine("%sThe status of \"%s\" is \"%s\". Unable to continue.", System.lineSeparator(), version, status);
                    result = null;
                    break;
                }
                this.infoWriteLine("%sThe status of \"%s\" is \"%s\". Requesting analysis info again in %s minute(s).", System.lineSeparator(), version, status, minutes);
                Thread.sleep(minutes * 1000 * 60);
                timedOut = timeToQuit > 0L ? System.currentTimeMillis() >= timeToQuit : false;
            }
            if (timedOut) {
                throw new TimeoutException("maxWaitTime (" + options._scantime_out + " minutes) exceeded waiting for prescan to complete.");
            }
            return result;
        }

        private String getBuildStatus(Options options) throws Exception {
            String buildInfo = this.getBuildInfo(options, false);
            String errorMsg = this.getErrorString(buildInfo);
            if (!StringUtility.isNullOrEmpty(errorMsg)) {
                throw new RuntimeException("Unable to determine current analysis status. Error: " + errorMsg);
            }
            return this.parseBuildStatus(buildInfo);
        }

        private String beginScanAndWaitForPrescanComplete(Options options, boolean deleteBuildAfterTimeout) throws TimeoutException {
            if ("timestamp".equalsIgnoreCase(options._version)) {
                options._version = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date());
            }
            this.infoWriteLine("\r\nAttempting to create a new analysis with name \"%s\".", options._version);
            String result = "";
            try {
                result = this.createBuild(options);
            }
            catch (Exception e) {
                if (e instanceof XmlApiException) {
                    this.errorWriteLine(e.getMessage(), new Object[0]);
                } else {
                    this.errorWriteLine("Unable to create a new analysis with name \"%s\". Error: %s", options._version, e.getMessage());
                }
                String status = "";
                try {
                    status = this.getBuildStatus(options);
                    if (Build.isInProgess(status) || Build.isInComplete(status)) {
                        this.errorWriteLine("\r\n* A scan is in progress or has failed to complete successfully. ".concat("Wait for the current scan to complete or delete the failed scan from the Veracode Platform and try again."), new Object[0]);
                    }
                }
                catch (Exception e1) {
                    this.errorWriteLine(e1.getMessage(), new Object[0]);
                }
                throw new RuntimeException("Unable to start a new analysis.", e);
            }
            long buildId = 0L;
            try {
                buildId = XmlUtils.parseBuildId(result);
            }
            catch (Exception e) {
                this.infoWriteLine("Unable to determine the ID of the new analysis. This is not an error.", new Object[0]);
            }
            options._build_id = String.valueOf(buildId);
            options._save_as = null;
            try {
                this.uploadFiles(options, false, options._file);
            }
            catch (Exception e) {
                this.deleteBuildIgnoreError(options);
                throw new RuntimeException("Unable to upload file to the new analysis.", e);
            }
            this.infoWriteLine("\r\nStarting pre-scan verification for application \"%s\" %sanalysis \"%s\".", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
            if (null == options._auto_scan) {
                options._auto_scan = options._include == null && options._exclude == null ? TrueOrFalse.True : TrueOrFalse.False;
            }
            try {
                this.beginPreScan(options);
            }
            catch (Exception e) {
                if (e instanceof XmlApiException) {
                    this.errorWriteLine(e.getMessage(), new Object[0]);
                } else {
                    this.errorWriteLine("Unable to start prescan. Error: %s", e.getMessage());
                }
                throw new RuntimeException("Unable to start prescan.", e);
            }
            String buildInfo = "";
            try {
                buildInfo = this.waitForPrescanComplete(options);
            }
            catch (TimeoutException toe) {
                this.errorWriteLine(toe.getMessage(), new Object[0]);
                if (deleteBuildAfterTimeout) {
                    this.deleteBuildIgnoreError(options);
                }
                throw toe;
            }
            catch (Exception e) {
                this.errorWriteLine("Encountered error when waiting for prescan to complete. Error: " + e.getMessage(), new Object[0]);
                this.deleteBuildIgnoreError(options);
                throw new RuntimeException("Encountered error when waiting for prescan to complete.", e);
            }
            if (options._auto_scan != TrueOrFalse.True) {
                this.infoWriteLine("\r\nPre-scan verification for application \"%s\" %sanalysis \"%s\" was successful.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                try {
                    result = this.getPreScanResults(options);
                }
                catch (Exception e) {
                    if (e instanceof XmlApiException) {
                        this.errorWriteLine(e.getMessage(), new Object[0]);
                    } else {
                        this.errorWriteLine("Encountered error when getting prescan result. Error: %s", e.getMessage());
                    }
                    this.deleteBuildIgnoreError(options);
                    throw new RuntimeException("Encountered error when getting prescan result.", e);
                }
                try {
                    NodeList nodeList = XmlUtils.getXmlNodeList(result, "/*/*[local-name()='module'][@id][@name][@status][@has_fatal_errors='true']");
                    int count = nodeList.getLength();
                    this.infoWriteLine("\r\nThere %s %s module%s with fatal errors%s", count != 1 ? "are" : "is", count, count != 1 ? "s" : "", count > 0 ? ":" : ".");
                    for (int x = 0; x < count; ++x) {
                        this.infoWriteLine("\r\nModule ID: %s", nodeList.item(x).getAttributes().getNamedItem("id").getNodeValue());
                        this.infoWriteLine("Module Name: %s", nodeList.item(x).getAttributes().getNamedItem("name").getNodeValue());
                    }
                    this.infoWriteLine("\r\nThe following modules will be selected to be individually scanned:", new Object[0]);
                    options._modules = this.selectUploadAndScanModuleList(options, result);
                    options._scan_all_top_level_modules = options._modules != null ? TrueOrFalse.False : TrueOrFalse.True;
                    options._scan_selected_modules = options._modules == null && options._scan_all_top_level_modules == TrueOrFalse.False ? TrueOrFalse.True : TrueOrFalse.False;
                    TrueOrFalse trueOrFalse = options._scan_previously_selected_modules = options._modules == null && options._scan_selected_modules == TrueOrFalse.False && options._scan_all_top_level_modules == TrueOrFalse.False ? TrueOrFalse.True : TrueOrFalse.False;
                    if (null == options._modules) {
                        this.infoWriteLine("\r\nAll the top level modules.", new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.errorWriteLine("Unable to select and update modules. Error: %s", e.getMessage());
                    this.deleteBuildIgnoreError(options);
                    throw new RuntimeException("Unable to select and update modules.", e);
                }
                this.infoWriteLine("\r\nSubmitting application \"%s\" %sanalysis \"%s\" for scanning.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                try {
                    this.beginScan(options);
                }
                catch (Exception e) {
                    if (e instanceof XmlApiException) {
                        this.errorWriteLine(e.getMessage(), new Object[0]);
                    } else {
                        this.errorWriteLine("Encountered error when starting a scan. Error: %s", e.getMessage());
                    }
                    this.deleteBuildIgnoreError(options);
                    throw new RuntimeException("Encountered error when starting a scan.", e);
                }
                this.infoWriteLine("\r\nApplication \"%s\" (appid=%s) %sanalysis \"%s\" (analysis id=%s) successfully submitted for scanning.", options._app_name, options._app_id, options._sandbox_name != null ? String.format("sandbox \"%s\" (sandboxid=%s) ", options._sandbox_name, options._sandbox_id) : "", options._version, options._build_id);
            } else {
                this.infoWriteLine("\r\nApplication \"%s\" %sanalysis \"%s\" will be automatically submitted for scanning if the pre-scan verification is successful.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
            }
            return buildInfo;
        }

        public String scanAndWaitForPrescanComplete(Options options, boolean deleteBuildAfterTimeout) throws Exception {
            this.setUserAgentTool(options);
            String appId = this.getAppId(options);
            if (null == appId) {
                throw new RuntimeException("Cannot locate the ID of the application '" + options._app_name + "'");
            }
            options._app_id = appId;
            if (!this.fillInSandboxId(options)) {
                throw new RuntimeException("Cannot fill in sandbox ID and name of application '" + options._app_name + "'");
            }
            return this.beginScanAndWaitForPrescanComplete(options, deleteBuildAfterTimeout);
        }

        public boolean waitForScanCompleteWithDelete(Options options, boolean deleteBuildAfterTimeout) throws Exception {
            this.setUserAgentTool(options);
            try {
                return this.waitForScanComplete(options);
            }
            catch (TimeoutException e) {
                this.errorWriteLine(e.getMessage(), new Object[0]);
                if (deleteBuildAfterTimeout) {
                    this.deleteBuildIgnoreError(options);
                }
                throw e;
            }
            catch (UnableToProceedException | UnknownStatusException e) {
                this.errorWriteLine(e.getMessage(), new Object[0]);
                this.deleteBuildIgnoreError(options);
                throw e;
            }
        }

        private boolean waitForScanComplete(Options options) throws Exception {
            String result = null;
            short minutes = this.pollInterval;
            long timeToQuit = 0L;
            try {
                int userTimeout = Integer.parseInt(options._scantime_out);
                if (0 > userTimeout) {
                    throw new IllegalArgumentException("Invalid scan time out value: " + options._scantime_out);
                }
                if (0 < userTimeout) {
                    timeToQuit = (long)(userTimeout * 60) * 1000L + System.currentTimeMillis();
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid scan time out value: " + options._scantime_out, nfe);
            }
            boolean timedOut = false;
            while (!timedOut) {
                block14: {
                    try {
                        result = this.getBuildInfo(options);
                    }
                    catch (XmlApiException xae) {
                        this.errorWriteLine("Encountered error when determining the analysis status [error: %s].", xae.getMessage());
                        boolean bl = timeToQuit > 0L ? System.currentTimeMillis() >= timeToQuit : (timedOut = false);
                        if (timedOut) break block14;
                        this.infoWriteLine("Requesting analysis info again in %d minutes.", minutes);
                        Thread.sleep(minutes * 1000 * 60);
                    }
                }
                String status = this.parseBuildStatus(result);
                boolean bl = timeToQuit > 0L ? System.currentTimeMillis() >= timeToQuit : (timedOut = false);
                if (Build.isInProgess(status) && !timedOut) {
                    if (options._auto_scan == TrueOrFalse.True && Build.isPreScanSucess(status) && XmlUtils.getXmlNodeList(result = this.getPreScanResults(options), "/*/*[local-name()='module'][@id][@name][@status][@has_fatal_errors='false'][@is_dependency='false']").getLength() == 0) {
                        throw new UnableToProceedException(String.format("The status of the new analysis is \"%s\". Unable to continue since scan did not start.", status));
                    }
                    this.infoWriteLine("The status of the new analysis is \"%s\". Requesting analysis info again in %d minute(s).", status, minutes);
                    Thread.sleep(minutes * 1000 * 60);
                    continue;
                }
                if (!Build.isResultReady(status)) continue;
                this.infoWriteLine("The status of the new analysis is \"%s\".", status);
                break;
            }
            if (timedOut) {
                throw new TimeoutException("maxWaitTime (" + options._scantime_out + " minutes) exceeded waiting for scan to complete.");
            }
            result = this.summaryReport(options);
            String policyStatus = XmlUtils.getAttributeAsString(result, "/*[local-name()='summaryreport']/@policy_compliance_status");
            this.infoWriteLine("The scan finished with policy status '%s'.", policyStatus);
            boolean passedPolicy = false;
            if (Build.isPolicyCompliancePass(policyStatus) || Build.isPolicyComplianceConditionalPass(policyStatus)) {
                passedPolicy = true;
            } else if (Build.isPolicyComplianceDidNotPass(policyStatus)) {
                passedPolicy = false;
            } else {
                throw new UnknownStatusException(String.format("Cannot tell if the scan passed or did not pass policy from status %s.", policyStatus));
            }
            return passedPolicy;
        }

        private void uploadAndScan(Options options) throws Exception {
            String appId = this.getAppId(options);
            if (null != appId) {
                options._app_id = appId;
                this.commonUploadAndScan(options);
                return;
            }
            this.errorWriteLine("\r\nAn app_id could not be located for application profile \"%s\".", options._app_name);
            this.throwException(options);
        }

        private void uploadAndScanByAppId(Options options) throws Exception {
            String result = this.getAppList(options, false);
            if (result != null) {
                String app_name = this.parseAppName(options, result);
                if (app_name != null) {
                    this.infoWriteLine("\r\nApplication profile \"%s\" (appid=%s) was located.", app_name, options._app_id);
                    options._app_name = app_name;
                    this.commonUploadAndScan(options);
                    return;
                }
                this.errorWriteLine("\r\nAn application profile could not be located for appid=\"%s\".", options._app_id);
            }
            this.throwException(options);
        }

        private void commonUploadAndScan(Options options) throws Exception {
            if (this.fillInSandboxId(options)) {
                this.commonUploadAndScan2(options);
            } else {
                this.throwException(options);
            }
        }

        private void commonUploadAndScan2(Options options) throws Exception {
            if (StringUtility.compare(options._version, "timestamp", true) == 0) {
                options._version = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date());
            }
            this.infoWriteLine("\r\nCreating a new analysis with name \"%s\".", options._version);
            String result = this.createBuild(options, false);
            if (result == null) {
                String buildInfo = null;
                buildInfo = this.getBuildInfo(options, false);
                if (!StringUtility.isNullOrEmpty(buildInfo)) {
                    String status = this.parseBuildStatus(buildInfo);
                    String version = this.parseBuildVersion(buildInfo);
                    if (Build.isInProgess(status) || Build.isInComplete(status)) {
                        this.errorWriteLine("\r\n* A scan is in progress or has failed to complete successfully. ".concat("Wait for the current scan to complete or delete the failed scan from the Veracode Platform and try again."), new Object[0]);
                    }
                }
            } else {
                Node node = XmlUtils.getXmlNode(result, "/*/*[local-name()='build'][@build_id]");
                String build_id = node.getAttributes().getNamedItem("build_id").getNodeValue();
                if (build_id != null) {
                    this.infoWriteLine("\r\nThe analysis id of the new analysis is \"%s\".", build_id);
                }
                options._build_id = build_id;
                options._save_as = null;
                this.uploadFiles(options, false, options._file);
                this.infoWriteLine("\r\nStarting pre-scan verification for application \"%s\" %sanalysis \"%s\".", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                if (options._auto_scan == null) {
                    TrueOrFalse trueOrFalse = options._auto_scan = options._include == null && options._exclude == null ? TrueOrFalse.True : TrueOrFalse.False;
                }
                if ((result = this.beginPreScan(options, false)) != null) {
                    this.setScanPollInterval(options.scanPollingInterval);
                    if (options._auto_scan != TrueOrFalse.True) {
                        result = this.tryGetBuildInfoXML(options);
                        if (result != null) {
                            this.infoWriteLine("\r\nPre-scan verification for application \"%s\" %sanalysis \"%s\" was successful.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                            result = this.getPreScanResults(options, false);
                            if (result != null) {
                                NodeList nodeList = XmlUtils.getXmlNodeList(result, "/*/*[local-name()='module'][@id][@name][@status][@has_fatal_errors='true']");
                                int count = nodeList.getLength();
                                this.infoWriteLine("\r\nThere %s %s module%s with fatal errors%s", count != 1 ? "are" : "is", count, count != 1 ? "s" : "", count > 0 ? ":" : ".");
                                for (int x = 0; x < count; ++x) {
                                    this.infoWriteLine("\r\nModule ID: %s", nodeList.item(x).getAttributes().getNamedItem("id").getNodeValue());
                                    this.infoWriteLine("Module Name: %s", nodeList.item(x).getAttributes().getNamedItem("name").getNodeValue());
                                }
                                this.infoWriteLine("\r\nThe following modules will be selected to be individually scanned:", new Object[0]);
                                options._modules = this.selectUploadAndScanModuleList(options, result);
                                options._scan_all_top_level_modules = options._modules != null ? TrueOrFalse.False : TrueOrFalse.True;
                                options._scan_selected_modules = options._modules == null && options._scan_all_top_level_modules == TrueOrFalse.False ? TrueOrFalse.True : TrueOrFalse.False;
                                TrueOrFalse trueOrFalse = options._scan_previously_selected_modules = options._modules == null && options._scan_selected_modules == TrueOrFalse.False && options._scan_all_top_level_modules == TrueOrFalse.False ? TrueOrFalse.True : TrueOrFalse.False;
                                if (options._modules == null) {
                                    this.infoWriteLine("\r\nAll the top level modules.", new Object[0]);
                                }
                                this.infoWriteLine("\r\nSubmitting application \"%s\" %sanalysis \"%s\" for scanning.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                                result = this.beginScan(options, false);
                                if (result != null) {
                                    this.infoWriteLine("\r\nApplication \"%s\" (appid=%s) %sanalysis \"%s\" (analysis id=%s) successfully submitted for scanning.", options._app_name, options._app_id, options._sandbox_name != null ? String.format("sandbox \"%s\" (sandboxid=%s) ", options._sandbox_name, options._sandbox_id) : "", options._version, options._build_id);
                                }
                            }
                        }
                    } else {
                        this.infoWriteLine("\r\nApplication \"%s\" %sanalysis \"%s\" will be automatically submitted for scanning if the pre-scan verification is successful.", options._app_name, options._sandbox_name != null ? String.format("sandbox \"%s\" ", options._sandbox_name) : "", options._version);
                    }
                    if (result != null) {
                        if (!StringUtility.isNullOrEmpty(options._scantime_out)) {
                            if (options._scantime_out.equalsIgnoreCase(VeracodeCommand.SCANTIMEOUT_USERINPUT_INDEFINITE)) {
                                options._scantime_out = String.valueOf(-1);
                            }
                            try {
                                int scanTimeOut = Integer.valueOf(options._scantime_out);
                                if (scanTimeOut == -1 || scanTimeOut > 0) {
                                    this.setScanCompleteTimeout(options._scantime_out);
                                }
                            }
                            catch (NumberFormatException nfe) {
                                this.infoWriteLine("Invalid format for scantimeout. %s.", nfe.getMessage());
                                this.throwException(nfe);
                            }
                        }
                        if (this.scanCompleteTimeout == -1 || this.scanCompleteTimeout > 0) {
                            String status = this.waitForScanComplete(options, false);
                            if (status != null) {
                                if (!Build.isPolicyComplianceDidNotPass(status)) {
                                    return;
                                }
                                this.setFailedPolicy(true);
                            }
                        } else {
                            return;
                        }
                    }
                }
            }
            this.throwException(options);
        }

        private String selectUploadAndScanModuleList(Options options, String xmlPreScanResult) throws Exception {
            NodeList nodeList;
            int count;
            String excludePattern;
            String includePattern = !StringUtility.isNullOrEmpty(options._include) ? this.escapeIncludeExcludePattern(options._include) : null;
            String string = excludePattern = !StringUtility.isNullOrEmpty(options._exclude) ? this.escapeIncludeExcludePattern(options._exclude) : null;
            if ((includePattern != null || excludePattern != null) && (count = (nodeList = XmlUtils.getXmlNodeList(xmlPreScanResult, "/*/*[local-name()='module'][@id][@name]")).getLength()) > 0) {
                ArrayList<String> moduleIdList = new ArrayList<String>();
                for (int x = 0; x < count; ++x) {
                    String name = nodeList.item(x).getAttributes().getNamedItem("name").getNodeValue();
                    if (includePattern != null && !Pattern.matches(includePattern, name) || excludePattern != null && Pattern.matches(excludePattern, name)) continue;
                    String id = nodeList.item(x).getAttributes().getNamedItem("id").getNodeValue();
                    moduleIdList.add(id);
                    this.infoWriteLine("\r\nModule ID: %s", id);
                    this.infoWriteLine("Module Name: %s", name);
                    Node statusAttribute = nodeList.item(x).getAttributes().getNamedItem("status");
                    if (statusAttribute == null) continue;
                    this.infoWriteLine("Module Status: %s", statusAttribute.getNodeValue());
                }
                if (moduleIdList.size() > 0) {
                    return StringUtility.join(",", moduleIdList.toArray(new String[0]));
                }
            }
            return null;
        }

        private String escapeIncludeExcludePattern(String regexLikePattern) {
            regexLikePattern = regexLikePattern.replaceAll("^\"|\"$|^'|'$", "");
            regexLikePattern = StringUtility.join(",", StringUtility.split(regexLikePattern, "\\s*,\\s*", true));
            return Pattern.quote(regexLikePattern).replace("*", "\\E.*\\Q").replace(",", "\\E|\\Q").replace("?", "\\E.\\Q");
        }

        private String parseAppId(Options options, String xmlAppListResult) throws Exception {
            NodeList nodeList = XmlUtils.getXmlNodeList(xmlAppListResult, "/*/*[local-name()='app'][@app_id][@app_name]");
            String app_id = null;
            for (int x = 0; x < nodeList.getLength(); ++x) {
                Node node = nodeList.item(x);
                if (StringUtility.compare(node.getAttributes().getNamedItem("app_name").getNodeValue(), options._app_name, true) != 0) continue;
                app_id = node.getAttributes().getNamedItem("app_id").getNodeValue();
                break;
            }
            return app_id;
        }

        private String parseAppName(Options options, String xmlAppListResult) throws Exception {
            NodeList nodeList = XmlUtils.getXmlNodeList(xmlAppListResult, "/*/*[local-name()='app'][@app_id][@app_name]");
            String app_name = null;
            for (int x = 0; x < nodeList.getLength(); ++x) {
                Node node = nodeList.item(x);
                if (StringUtility.compare(node.getAttributes().getNamedItem("app_id").getNodeValue(), options._app_id, true) != 0) continue;
                app_name = node.getAttributes().getNamedItem("app_name").getNodeValue();
                break;
            }
            return app_name;
        }

        private String parseBuildStatus(String xmlBuildInfoResult) throws Exception {
            String status = XmlUtils.getAttributeAsString(xmlBuildInfoResult, "/*/*/*[local-name()='analysis_unit']/@status");
            return !StringUtility.isNullOrEmpty(status) ? status.replaceAll("\\r?\\n", " ") : "";
        }

        private String parseBuildVersion(String xmlBuildInfoResult) throws Exception {
            String version = XmlUtils.getAttributeAsString(xmlBuildInfoResult, "/*/*[local-name()='build']/@version");
            return !StringUtility.isNullOrEmpty(version) ? version.replaceAll("\\r?\\n", " ") : "";
        }

        private String parseSandboxId(Options options, String xmlSandboxListResult) throws Exception {
            NodeList nodeList = XmlUtils.getXmlNodeList(xmlSandboxListResult, "/*/*[local-name()='sandbox'][@sandbox_id][@sandbox_name]");
            String sandbox_id = null;
            for (int x = 0; x < nodeList.getLength(); ++x) {
                Node node = nodeList.item(x);
                if (StringUtility.compare(node.getAttributes().getNamedItem("sandbox_name").getNodeValue(), options._sandbox_name, true) != 0) continue;
                sandbox_id = node.getAttributes().getNamedItem("sandbox_id").getNodeValue();
                break;
            }
            return sandbox_id;
        }

        private String parseSandboxName(Options options, String xmlSandboxListResult) throws Exception {
            NodeList nodeList = XmlUtils.getXmlNodeList(xmlSandboxListResult, "/*/*[local-name()='sandbox'][@sandbox_id][@sandbox_name]");
            String sandbox_name = null;
            for (int x = 0; x < nodeList.getLength(); ++x) {
                Node node = nodeList.item(x);
                if (StringUtility.compare(node.getAttributes().getNamedItem("sandbox_id").getNodeValue(), options._sandbox_id, true) != 0) continue;
                sandbox_name = node.getAttributes().getNamedItem("sandbox_name").getNodeValue();
                break;
            }
            return sandbox_name;
        }

        private void uploadFiles(Options options, boolean printReports, String ... path) throws Exception {
            for (String p : path) {
                File pFile = new File(p);
                if (pFile.isFile()) {
                    String saveAsFileName;
                    String originalFileName;
                    options._save_as = null;
                    if (options._pattern != null && options._replacement != null && StringUtility.compare(originalFileName = pFile.getName(), saveAsFileName = this.replaceFileName(originalFileName, options._pattern, options._replacement), false) != 0) {
                        options._save_as = saveAsFileName;
                    }
                    this.displayPreFileUploadMessage(p);
                    options._file[0] = p;
                    String result = this.uploadFile(options, printReports);
                    if (result == null || options._save_as == null) continue;
                    this.infoWriteLine("\"%s\" will be saved as \"%s\".", pFile.getName(), options._save_as);
                    continue;
                }
                if (pFile.isDirectory()) {
                    for (File cFile : pFile.listFiles()) {
                        this.uploadFiles(options, printReports, cFile.getPath());
                    }
                    continue;
                }
                throw new IllegalArgumentException(String.format("Could not find file \"%s\".", pFile.getCanonicalPath()));
            }
        }

        private String replaceFileName(String fileName, String pattern, String replacement) {
            if (!(StringUtility.isNullOrEmpty(fileName) || StringUtility.isNullOrEmpty(pattern) || StringUtility.isNullOrEmpty(replacement))) {
                try {
                    Matcher matcher = Pattern.compile(this.escapeFileNamePattern(pattern)).matcher(fileName);
                    if (matcher.matches()) {
                        return matcher.replaceAll(this.escapeReplacementPattern(replacement, matcher.groupCount()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return fileName;
        }

        private String escapeFileNamePattern(String pattern) {
            return "^" + Pattern.quote(pattern).replace("?", "\\E(.)\\Q").replace("*", "\\E(.*?)\\Q") + "$";
        }

        private String escapeReplacementPattern(String replacement, int groupCount) {
            String[] tokens = replacement.split("\\\\", -1);
            for (int x = 0; x < tokens.length; ++x) {
                tokens[x] = this.escapeReplacementToken(tokens[x], groupCount);
            }
            return StringUtility.join("\\\\", tokens);
        }

        private String escapeReplacementToken(String replacementToken, int groupCount) {
            Matcher m = Pattern.compile("(?<!\\\\)\\$((\\{|\\$|\\d+|.)(([^\\$\\{\\}]+)\\}([^\\$])?)?)?").matcher(replacementToken);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String firstCapture = m.group(1);
                if (!StringUtility.isNullOrEmpty(firstCapture)) {
                    String secondCapture = m.group(2);
                    String thirdCapture = m.group(3);
                    if ("{".equals(secondCapture)) {
                        if (!StringUtility.isNullOrEmpty(thirdCapture)) {
                            String indexString = m.group(4);
                            String nextCharString = m.group(5);
                            boolean validIndex = false;
                            try {
                                int index = Integer.parseInt(indexString);
                                validIndex = index <= groupCount && indexString.charAt(0) != '-';
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (validIndex) {
                                if (!StringUtility.isNullOrEmpty(nextCharString) && Character.isDigit(nextCharString.charAt(0))) {
                                    m.appendReplacement(sb, Matcher.quoteReplacement("$" + indexString + "\\" + nextCharString));
                                    continue;
                                }
                                m.appendReplacement(sb, Matcher.quoteReplacement("$" + indexString + StringUtility.getEmptyIfNull(nextCharString)));
                                continue;
                            }
                            m.appendReplacement(sb, Matcher.quoteReplacement("\\${" + indexString + "}" + StringUtility.getEmptyIfNull(nextCharString)));
                            continue;
                        }
                        m.appendReplacement(sb, Matcher.quoteReplacement("\\${"));
                        continue;
                    }
                    if ("$".equals(secondCapture)) {
                        m.appendReplacement(sb, Matcher.quoteReplacement("\\$" + StringUtility.getEmptyIfNull(thirdCapture)));
                        continue;
                    }
                    boolean validIndex = false;
                    try {
                        int index = Integer.parseInt(secondCapture);
                        validIndex = index <= groupCount && secondCapture.charAt(0) != '-';
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (validIndex) {
                        m.appendReplacement(sb, Matcher.quoteReplacement("$" + StringUtility.getEmptyIfNull(secondCapture) + StringUtility.getEmptyIfNull(thirdCapture)));
                        continue;
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement("\\$" + StringUtility.getEmptyIfNull(secondCapture) + StringUtility.getEmptyIfNull(thirdCapture)));
                    continue;
                }
                m.appendReplacement(sb, Matcher.quoteReplacement("\\$"));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        private String tryGetBuildInfoXML(Options options) throws Exception {
            String result;
            block6: {
                result = null;
                int seconds = this.pollIntervalSeconds;
                while ((result = this.retryGetBuildInfo(options, false, -1L)) != null) {
                    String version = this.parseBuildVersion(result);
                    String status = this.parseBuildStatus(result);
                    if (Build.isPreScanSubmitted(status)) {
                        this.infoWriteLine("\r\nThe status of \"%s\" is \"%s\".\r\nRequesting analysis info again in %s seconds.", version, status, seconds);
                        Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
                        continue;
                    }
                    if (Build.isPreScanSucess(status)) {
                        this.infoWriteLine("\r\nThe status of \"%s\" is \"%s\".", version, status);
                    } else if (Build.isScanInProgress(status) || Build.isResultReady(status)) {
                        this.infoWriteLine("\r\nThe status of the \"%s\" is \"%s\".", version, status);
                    } else {
                        this.errorWriteLine("\r\nThe status of \"%s\" is \"%s\".", version, status);
                        result = null;
                    }
                    break block6;
                }
                this.errorWriteLine(NEWLINE + "Analysis info is null. Unable to continue.", new Object[0]);
            }
            return result;
        }

        public void setScanPollInterval(String scanPollIntervalTime) {
            if (StringUtility.isNullOrEmpty(scanPollIntervalTime)) {
                this.pollIntervalSeconds = 120;
                this.infoWriteLine("\r\nScan polling interval is set to the default of %s seconds.", (short)120);
                return;
            }
            int scanPollInterval = 0;
            try {
                scanPollInterval = Integer.parseInt(scanPollIntervalTime);
            }
            catch (NumberFormatException nfe) {
                this.pollIntervalSeconds = 120;
                this.infoWriteLine("\r\nScan polling interval has invalid value and has defaulted to %s seconds.", (short)120);
                return;
            }
            if (scanPollInterval < 30) {
                this.pollIntervalSeconds = 30;
                this.infoWriteLine("\r\nScan polling interval is less than the %s-second minimum and has defaulted to %s seconds.", (short)30, (short)30);
            } else if (scanPollInterval > 120) {
                this.pollIntervalSeconds = 120;
                this.infoWriteLine("\r\nScan polling interval is greater than the %s-second maximum and has defaulted to %s seconds.", (short)120, (short)120);
            } else {
                this.pollIntervalSeconds = scanPollInterval;
            }
        }

        private String waitForScanComplete(Options options, boolean printReports) throws Exception {
            String result = null;
            int seconds = this.pollIntervalSeconds;
            int user_timeout = -1;
            try {
                user_timeout = Integer.parseInt(options._scantime_out);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.scanCompleteTimeout = this.scanCompleteTimeout <= 0 && user_timeout > 0 ? user_timeout : this.scanCompleteTimeout;
            long timeout_millis = (long)(this.scanCompleteTimeout * 60) * 1000L + System.currentTimeMillis();
            while ((result = this.retryGetBuildInfo(options, false, timeout_millis)) != null) {
                String status = this.parseBuildStatus(result);
                if (Build.isInProgess(status)) {
                    if (user_timeout != -1 && timeout_millis != 0L && System.currentTimeMillis() > timeout_millis) {
                        this.errorWriteLine("\r\nTimeout waiting for scan to complete.  The status of the new analysis is \"%s\".", status);
                        return null;
                    }
                    if (options._auto_scan == TrueOrFalse.True && Build.isPreScanSucess(status) && ((result = this.getPreScanResults(options, false)) == null || XmlUtils.getXmlNodeList(result, "/*/*[local-name()='module'][@id][@name][@status][@has_fatal_errors='false'][@is_dependency='false']").getLength() == 0)) {
                        this.errorWriteLine("\r\nThe status of the new analysis is \"%s\".\r\nUnable to continue since scan did not start.", status);
                        return null;
                    }
                    this.infoWriteLine("\r\nThe status of the new analysis is \"%s\".\r\nRequesting analysis info again in %s seconds.", status, seconds);
                    Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
                    continue;
                }
                if (Build.isResultReady(status)) {
                    this.infoWriteLine("\r\nThe status of the new analysis is \"%s\".", status);
                    result = this.summaryReport(options, printReports);
                    if (result != null) {
                        Node node = XmlUtils.getXmlNode(result, "/*[local-name()='summaryreport']");
                        status = node.getAttributes().getNamedItem("policy_compliance_status").getNodeValue();
                        if (Build.isPolicyCompliancePass(status) || Build.isPolicyComplianceConditionalPass(status)) {
                            this.infoWriteLine("\r\nThe scan finished with policy status '%s'.", status);
                            return status;
                        }
                        this.errorWriteLine("\r\nThe policy status '%s' is not passing.", status);
                        return Build.isPolicyComplianceDidNotPass(status) ? status : null;
                    }
                    return null;
                }
                this.errorWriteLine("\r\nThe status of the new analysis is \"%s\". Unable to continue.", status);
                return null;
            }
            this.errorWriteLine(NEWLINE + "Analysis info is null. Unable to continue.", new Object[0]);
            return null;
        }

        private String retryGetBuildInfo(Options options, boolean printReport, long timeOutMillis) throws Exception {
            String result = null;
            int seconds = this.pollIntervalSeconds;
            boolean isResultsFound = false;
            int exceptionCount = 0;
            options._max_retry_count = Math.max(Math.min(options._max_retry_count, 5), 0);
            while (!isResultsFound) {
                try {
                    result = this.getBuildInfo(options, printReport);
                    exceptionCount = 0;
                    isResultsFound = true;
                }
                catch (IOException ioe) {
                    this.errorWriteLine(NEWLINE + "Exception retrieving analysis info: " + ioe.toString(), new Object[0]);
                    if (exceptionCount >= options._max_retry_count) {
                        throw new TimeoutException("Maximum number of retries exceeded.");
                    }
                    if (timeOutMillis > -1L && System.currentTimeMillis() > timeOutMillis) {
                        throw new TimeoutException("Maximum wait time exceeded waiting for scan to complete.");
                    }
                    ++exceptionCount;
                    this.infoWriteLine(NEWLINE + "Requesting analysis info again in %s seconds.", seconds);
                    Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
                }
            }
            return result;
        }

        private String switchUserToSAML(Options options, boolean printReports) throws Exception {
            String responseMessage = null;
            String result = this.getUserInfo(options, printReports);
            if (result != null) {
                String login_account_type = null;
                String email_address = null;
                String is_saml_user = null;
                Node loginNode = XmlUtils.getXmlNode(result, "/*/*[local-name()='login_account']");
                Node attribute = loginNode.getAttributes().getNamedItem("login_account_type");
                if (attribute != null) {
                    login_account_type = attribute.getNodeValue();
                }
                if ((attribute = loginNode.getAttributes().getNamedItem("email_address")) != null) {
                    email_address = attribute.getNodeValue();
                }
                if ((attribute = loginNode.getAttributes().getNamedItem("is_saml_user")) != null) {
                    is_saml_user = attribute.getNodeValue();
                }
                if (StringUtility.compare(login_account_type, "api", true) == 0) {
                    responseMessage = String.format("API user \"%s\" cannot use SAML.", options._username);
                } else if (StringUtility.compare(is_saml_user, "true", true) == 0) {
                    responseMessage = String.format("User \"%s\" already uses SAML.", options._username);
                } else {
                    options._email_address = email_address;
                    options._is_saml_user = TrueOrFalse.True;
                    result = this.updateUser(options, printReports);
                    responseMessage = result != null ? String.format("User \"%s\" switched to SAML.", options._username) : String.format("User \"%s\" could not be switched to SAML.", options._username);
                }
            }
            return responseMessage;
        }

        private void getRegion(String vid, String vkey, String credprofile) throws Exception {
            Credentials credentials = !StringUtility.isNullOrEmpty(vid) && !StringUtility.isNullOrEmpty(vkey) ? Credentials.create(vid, vkey) : (!StringUtility.isNullOrEmpty(credprofile) ? ServiceManager.getCredentialsService().getCredentials(credprofile).get() : ServiceManager.getCredentialsService().getCredentials().get());
            Region region = credentials.getRegion();
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            String result = gson.toJson(region);
            this.consoleWriteLine(false, result);
        }

        private boolean printReport(byte[] bytesResult, Options options) throws Exception {
            return this.printReport(bytesResult, options, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean printReport(byte[] bytesResult, Options options, String altFilePath) throws Exception {
            byte[] pdfResult = null;
            switch (options._format) {
                case pdf: {
                    pdfResult = bytesResult;
                    break;
                }
                default: {
                    this.errorWriteLine("Format \"%s\" not supported for Action \"%s\".", new Object[]{options._format, options._action});
                }
            }
            boolean printStatus = false;
            if (pdfResult != null) {
                String filePath;
                String string = filePath = altFilePath != null ? altFilePath : options._output_filepath;
                if (!StringUtility.isNullOrEmpty(filePath)) {
                    try (PrintStream writer = null;
                         BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(pdfResult)));){
                        Pattern pattern = Pattern.compile(VeracodeCommand.ERROR_MSG_REGEX);
                        if (br.lines().anyMatch(pattern.asPredicate())) {
                            this.errorWriteLine("\r\n* Action \"%s\" returned the following message:\r\n* %s\r\n", new Object[]{options._action, "No PDF report available."});
                        } else {
                            writer = this.getPrintStream(new FileOutputStream(filePath));
                            writer.write(pdfResult, 0, pdfResult.length);
                            this.displayFileDownloadedMessage(filePath);
                        }
                    }
                    printStatus = true;
                } else {
                    this.errorWriteLine("Action \"%s\" resulted in the following error(s):\r\nOutput filepath is missing.", new Object[]{options._action});
                }
            } else {
                this.errorWriteLine("Unable to retrieve data in \"%s\" format.", new Object[]{options._format});
            }
            return printStatus;
        }

        private boolean printReport(String xmlResult, Options options) throws Exception {
            return this.printReport(xmlResult, options, true);
        }

        private boolean printReport(String xmlResult, Options options, boolean indentXml) throws Exception {
            return this.printReport(xmlResult, options, indentXml, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean printReport(String xmlResult, Options options, boolean indentXml, String altFilePath) throws Exception {
            String textResult = null;
            switch (options._format) {
                case xml: {
                    textResult = XmlUtils.getDecodedXmlResponse(xmlResult, indentXml);
                    break;
                }
                case csv: {
                    textResult = this.getCsvString(xmlResult);
                    break;
                }
                default: {
                    this.errorWriteLine("Format \"%s\" not supported for Action \"%s\".", new Object[]{options._format, options._action});
                }
            }
            boolean printStatus = false;
            if (!StringUtility.isNullOrEmpty(textResult)) {
                String filePath;
                String string = filePath = altFilePath != null ? altFilePath : options._output_filepath;
                if (!StringUtility.isNullOrEmpty(filePath)) {
                    try (PrintStream writer = null;){
                        writer = this.getPrintStream(new FileOutputStream(filePath));
                        writer.print(textResult);
                        this.displayFileDownloadedMessage(filePath);
                    }
                } else {
                    this.consoleWriteLine(false, textResult);
                }
                printStatus = true;
            } else {
                this.errorWriteLine("Unable to retrieve data in \"%s\" format.", new Object[]{options._format});
                this.setIsValidXml(false);
            }
            return printStatus;
        }

        private void displayFileDownloadedMessage(String filePath) {
            if (!StringUtility.isNullOrEmpty(filePath)) {
                this.infoWriteLine("Output filepath: %s", filePath);
            }
        }

        private void displayPreFileUploadMessage(String filePath) {
            if (filePath != null) {
                this.infoWriteLine("\r\nUploading: %s", filePath);
            }
        }

        private void displayProgressChangedMessage(int percentage, long bytesSent, long totalBytesToSend, boolean isSignificant) {
            if (percentage >= 0 && percentage <= 100 && isSignificant) {
                this.infoWriteLine("Uploaded: %3d%%", percentage);
            }
        }

        public final void infoWriteLine(String format, Object ... args) {
            String text = this.addTimeStamp(this.formatText(format, args));
            this.consoleWriteLine(false, text);
            this.logWriteLine(text);
        }

        public final void debugWriteLine(String format, Object ... args) {
            if (isDebugEnabled) {
                String text = this.addTimeStamp(this.formatText(format, args));
                this.consoleWriteLine(false, text);
                this.logWriteLine(text);
            }
        }

        public final void errorWriteLine(String format, Object ... args) {
            String text = this.addTimeStamp(this.formatText(format, args));
            this.consoleWriteLine(true, text);
            this.logWriteLine(text);
        }

        private void consoleWriteLine(boolean isErrorMessage, String text) {
            if (!isErrorMessage) {
                if (this.outputWriter != null) {
                    this.outputWriter.println(text);
                }
            } else if (this.errorWriter != null) {
                this.errorWriter.println(text);
            }
        }

        private void logWriteLine(String text) {
            if (this.logWriter != null && !StringUtility.isNullOrEmpty(text)) {
                this.logWriter.println(text);
                this.logWriter.flush();
            }
        }

        private String formatText(String format, Object ... args) {
            return args != null && args.length != 0 ? String.format(format, args) : format;
        }

        private String addTimeStamp(String text) {
            String timestamp = String.format("[%s] ", new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS").format(new Date()));
            return timestamp + (text != null ? text.replace("\r\n", System.lineSeparator()).replace(System.lineSeparator(), System.lineSeparator() + timestamp) : "");
        }

        private boolean isValidXML(String xmlResult, Options options) {
            xmlResult = XmlUtils.getDecodedXmlResponse(xmlResult, true);
            boolean isValidXML = false;
            String errorString = this.getErrorString(xmlResult);
            if (StringUtility.isNullOrEmpty(errorString)) {
                isValidXML = true;
            } else {
                this.setIsValidXml(isValidXML);
                this.errorWriteLine("\r\n* Action \"%s\" returned the following message:\r\n* %s\r\n", new Object[]{options._action, errorString.replace("\r\n", " ")});
            }
            return isValidXML;
        }

        private String getErrorString(String xmlString) {
            String errorString = "";
            StringBuilder builder = new StringBuilder();
            Pattern pattern = Pattern.compile(VeracodeCommand.ERROR_MSG_REGEX);
            Matcher matcher = pattern.matcher(xmlString);
            while (matcher.find()) {
                builder.append(matcher.group(1) + "\r\n");
            }
            errorString = builder.toString();
            if (errorString.contains("\r\n")) {
                errorString = errorString.substring(0, builder.lastIndexOf("\r\n"));
            }
            return errorString;
        }

        private String getCsvString(String xmlString) throws Exception {
            StringBuilder builder = new StringBuilder();
            NodeList nodeList = XmlUtils.getXmlNodeList(xmlString, "/*/*");
            if (nodeList != null) {
                ArrayList<String> nodeNames = new ArrayList<String>();
                String[] headers = null;
                String[] values = null;
                for (int x = 0; x < nodeList.getLength(); ++x) {
                    boolean newNodeName;
                    Node node = nodeList.item(x);
                    if (node == null) continue;
                    values = new String[node.getAttributes().getLength()];
                    boolean bl = newNodeName = !nodeNames.contains(node.getNodeName());
                    if (newNodeName) {
                        nodeNames.add(node.getNodeName());
                        headers = new String[node.getAttributes().getLength()];
                        if (x > 0) {
                            builder.append("\r\n");
                        }
                    }
                    for (int y = 0; y < node.getAttributes().getLength(); ++y) {
                        String value;
                        if (newNodeName) {
                            headers[y] = node.getAttributes().item(y).getNodeName().toUpperCase();
                        }
                        String formatString = (value = node.getAttributes().item(y).getNodeValue().replace("\"", "\"\"")).contains(" ") ? "\"%s\"" : "%s";
                        values[y] = String.format(formatString, value);
                    }
                    if (newNodeName) {
                        builder.append(StringUtility.join(",", headers) + "\r\n");
                    }
                    builder.append(StringUtility.join(",", values) + "\r\n");
                }
            }
            return builder.toString();
        }

        private <T extends AbstractAPIWrapper> T getWrapper(Class<T> wrapperClass, Options options) throws XmlApiException {
            if (null == wrapperClass || null == options) {
                throw new IllegalArgumentException("Cannot create wrapper with the given parameters.");
            }
            AbstractAPIWrapper wrapper = null;
            try {
                wrapper = (AbstractAPIWrapper)wrapperClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                String msg = String.format("Unable to get an instance of %s. Error: %s", wrapperClass.getName(), e.getMessage());
                throw new XmlApiException(msg, e);
            }
            this.setUpWrapper(wrapper, options);
            return (T)wrapper;
        }

        private UploadAPIWrapper getUploadAPIWrapper(Options options) {
            UploadAPIWrapper wrapper = new UploadAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private SandboxAPIWrapper getSandboxAPIWrapper(Options options) {
            SandboxAPIWrapper wrapper = new SandboxAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private ResultsAPIWrapper getResultsAPIWrapper(Options options) {
            ResultsAPIWrapper wrapper = new ResultsAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private AdminAPIWrapper getAdminAPIWrapper(Options options) {
            AdminAPIWrapper wrapper = new AdminAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private ArcherAPIWrapper getArcherAPIWrapper(Options options) {
            ArcherAPIWrapper wrapper = new ArcherAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private MitigationAPIWrapper getMitigationAPIWrapper(Options options) {
            MitigationAPIWrapper wrapper = new MitigationAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private VastAPIWrapper getVastAPIWrapper(Options options) {
            VastAPIWrapper wrapper = new VastAPIWrapper();
            this.setUpWrapper(wrapper, options);
            return wrapper;
        }

        private void setUpWrapper(AbstractAPIWrapper wrapper, Options options) {
            this.setUpCredentials(wrapper, options);
            this.setUpProxyCredentials(wrapper, options);
        }

        private void setUpCredentials(AbstractAPIWrapper wrapper, Options options) {
            if (!StringUtility.isNullOrEmpty(options._vid) && !StringUtility.isNullOrEmpty(options._vkey)) {
                wrapper.setUpApiCredentials(Credentials.create(options._vid, options._vkey));
            } else {
                wrapper.setUpApiCredentials(options.credprofile);
            }
        }

        private void setUpProxyCredentials(AbstractAPIWrapper wrapper, Options options) {
            if (options._phost != null) {
                String user = options._puser;
                String pcode = options._ppcode;
                if (StringUtility.isNullOrEmpty(user) && !StringUtility.isNullOrEmpty(options._api3)) {
                    user = this.decodeB64(options._api3);
                }
                if (StringUtility.isNullOrEmpty(pcode) && !StringUtility.isNullOrEmpty(options._api4)) {
                    pcode = this.decodeB64(options._api4);
                }
                wrapper.setUpProxy(options._phost, options._pport, user, pcode);
            }
        }

        private String decodeB64(String b64EncodedString) {
            try {
                return new String(DatatypeConverter.parseBase64Binary(b64EncodedString), "UTF-8");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid base64-encoded String.");
            }
        }

        private ProxyData createProxyData(Options options) {
            ProxyData proxyData = null;
            if (options._phost != null) {
                String user = options._puser;
                String pcode = options._ppcode;
                if (StringUtility.isNullOrEmpty(user) && !StringUtility.isNullOrEmpty(options._api3)) {
                    user = this.decodeB64(options._api3);
                }
                if (StringUtility.isNullOrEmpty(pcode) && !StringUtility.isNullOrEmpty(options._api4)) {
                    pcode = this.decodeB64(options._api4);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(options._phost, Integer.parseInt(options._pport)));
                proxyData = new ProxyData(proxy, user, pcode != null ? pcode.toCharArray() : null);
            }
            return proxyData;
        }

        private Credentials createCredentials(String vid, String vkey, String credprofile) throws Exception {
            Credentials credentials = !StringUtility.isNullOrEmpty(vid) && !StringUtility.isNullOrEmpty(vkey) ? Credentials.create(vid, vkey) : (!StringUtility.isNullOrEmpty(credprofile) ? ServiceManager.getCredentialsService().getCredentials(credprofile).get() : ServiceManager.getCredentialsService().getCredentials().get());
            return credentials;
        }

        private void throwException(Options options) {
            if (this.canThrowExceptions) {
                this.errorWriteLine(String.format("%s failure.", new Object[]{options._action}), new Object[0]);
            }
            this.setIsValidXml(false);
        }

        private void throwException(String message) {
            if (this.canThrowExceptions) {
                this.errorWriteLine(String.format("%s", message), new Object[0]);
            }
            this.setIsValidXml(false);
        }

        private void throwException(Throwable e) {
            if (this.canThrowExceptions) {
                if (e instanceof RuntimeException) {
                    this.printException((RuntimeException)e);
                } else {
                    this.errorWriteLine(e.getMessage(), new Object[0]);
                }
            }
            this.setIsValidXml(false);
        }

        private void printException(Throwable e) {
            if (e instanceof ParseException) {
                this.errorWriteLine("\r\nParsing error: %s", e.getMessage() != null ? e.getMessage() : e.getClass().getName());
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    this.errorWriteLine(e.getCause().getMessage(), new Object[0]);
                }
            } else if (e instanceof UnsupportedEncodingException) {
                this.errorWriteLine("\r\nUnsupportedEncodingException: %s", e.getMessage() != null ? e.getMessage() : e.getClass().getName());
            } else if (e instanceof UnknownHostException && e.getMessage() != null) {
                this.errorWriteLine("\r\nUnknownHostException: %s", e.getMessage());
                this.errorWriteLine("Note: Do not include the web protocol, such as HTTP or HTTPS, in the host. Including the protocol can cause an error.", new Object[0]);
            } else if (e instanceof IOException) {
                if (e.getMessage() != null) {
                    this.errorWriteLine("\r\n%s", e.getMessage());
                    if (isDebugEnabled) {
                        e.printStackTrace();
                    }
                    if (e.getMessage().contains("Server returned HTTP response code: 401")) {
                        this.errorWriteLine("Please make sure that all of the following are true:", new Object[0]);
                        this.errorWriteLine("1. The login credentials are valid.", new Object[0]);
                        this.errorWriteLine("2. The account is an API account with sufficient privilege.", new Object[0]);
                        this.errorWriteLine("3. The account is not locked.", new Object[0]);
                        this.errorWriteLine("4. This machine's internet-facing IP address is not restricted.", new Object[0]);
                    }
                } else {
                    this.errorWriteLine("\r\n%s", e.getClass().getName());
                }
            } else {
                this.errorWriteLine("\r\n%s", e.getMessage() != null ? e.getMessage() : e.getClass().getName());
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    this.errorWriteLine(e.getCause().getMessage(), new Object[0]);
                }
            }
        }

        private void createLogWriter(Options options) throws Exception {
            this.logWriter = new PrintStream(new FileOutputStream(options._log_filepath, true));
            this.logWriteLine(StringUtility.repeatChar('-', 80));
            this.logWriteLine(VeracodeCommand.getVersionString());
            this.logWriteLine(options._action != null ? String.format("Action: %s", options._action.toString()) : "");
            this.logWriteLine(StringUtility.repeatChar('-', 80));
        }

        private void disposeLogWriter() {
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
        }

        private void setUserAgentTool(Options options) {
            if (USER_AGENT_TOOL.equals("")) {
                USER_AGENT_TOOL = options._useragent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String[]> parseCsvFileArgsList(String filePath) throws IOException {
            ArrayList<String[]> recordsList = new ArrayList<String[]>();
            Pattern pattern = Pattern.compile("((?:\"(?:\"\"|[^\"])*\")|(?:[^,]*)),?");
            boolean firstPass = true;
            String[] parameters = null;
            String[] arguments = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String current = null;
                while ((current = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(current);
                    if (firstPass) {
                        int columnCount = 0;
                        while (matcher.find()) {
                            ++columnCount;
                        }
                        if (columnCount <= 0) break;
                        parameters = new String[columnCount - 1];
                        matcher.reset();
                    } else {
                        arguments = new String[parameters.length * 2];
                    }
                    for (int x = 0; x < parameters.length; ++x) {
                        String item = null;
                        if (matcher.find()) {
                            item = matcher.group(1);
                            if (Pattern.matches("\".*\"", item)) {
                                item = item.substring(1, item.length() - 1);
                            }
                            String string = item = !StringUtility.isNullOrEmpty(item) ? item.replace("\"\"", "\"") : null;
                        }
                        if (firstPass) {
                            parameters[x] = item;
                            continue;
                        }
                        if (parameters[x] == null || item == null) continue;
                        arguments[x * 2] = "-" + parameters[x];
                        arguments[x * 2 + 1] = item;
                    }
                    if (firstPass) {
                        firstPass = false;
                        continue;
                    }
                    recordsList.add(arguments);
                }
            }
            return recordsList;
        }

        private void parseCsvFile(Options options, CommandLineParser parser) throws IOException {
            List<String[]> argsList = this.parseCsvFileArgsList(options._input_filepath);
            if (argsList != null && argsList.size() > 0) {
                int x = 0;
                parser.setSettings(new CommandLineParserSettings(null));
                for (String[] _args : argsList) {
                    try {
                        this.infoWriteLine(StringUtility.repeatChar('*', 40), new Object[0]);
                        this.infoWriteLine("Command:\t%s/%s", ++x, argsList.size());
                        this.infoWriteLine(StringUtility.repeatChar('*', 40), new Object[0]);
                        parser.parse(options, _args);
                        this.switchOptions(options);
                    }
                    catch (Throwable e) {
                        this.printException(e);
                        throw new ParseException(e.getMessage());
                    }
                }
            } else {
                throw new ParseException(String.format("Invalid Input File: %s.", options._input_filepath));
            }
        }

        private void switchOptions(Options options) throws Exception {
            this.debugWriteLine(VeracodeCommand.getVersionString(), new Object[0]);
            this.debugWriteLine("Wrapper action: " + options._action.toString(), new Object[0]);
            switch (options._action) {
                case BeginPreScan: {
                    this.beginPreScan(options, true);
                    break;
                }
                case BeginScan: {
                    this.beginScan(options, true);
                    break;
                }
                case CreateApp: {
                    this.createApp(options, true);
                    break;
                }
                case CreateBuild: {
                    this.createBuild(options, true);
                    break;
                }
                case DeleteApp: {
                    this.deleteApp(options, true);
                    break;
                }
                case DeleteBuild: {
                    this.deleteBuild(options, true);
                    break;
                }
                case GetAppInfo: {
                    this.getAppInfo(options, true);
                    break;
                }
                case GetAppList: {
                    this.getAppList(options, true);
                    break;
                }
                case GetBuildInfo: {
                    this.getBuildInfo(options, true);
                    break;
                }
                case GetBuildList: {
                    this.getBuildList(options, true);
                    break;
                }
                case GetFileList: {
                    this.getFileList(options, true);
                    break;
                }
                case GetPolicyList: {
                    this.getPolicyList(options, true);
                    break;
                }
                case GetPreScanResults: {
                    this.getPreScanResults(options, true);
                    break;
                }
                case GetVendorList: {
                    this.getVendorList(options, true);
                    break;
                }
                case RemoveFile: {
                    this.removeFile(options, true);
                    break;
                }
                case UpdateApp: {
                    this.updateApp(options, true);
                    break;
                }
                case UpdateBuild: {
                    this.updateBuild(options, true);
                    break;
                }
                case UploadFile: {
                    this.uploadFile(options, true);
                    break;
                }
                case CreateSandbox: {
                    this.createSandbox(options, true);
                    break;
                }
                case PromoteSandbox: {
                    this.promoteSandbox(options, true);
                    break;
                }
                case GetSandboxList: {
                    this.getSandboxList(options, true);
                    break;
                }
                case UpdateSandbox: {
                    this.updateSandbox(options, true);
                    break;
                }
                case DeleteSandbox: {
                    this.deleteSandbox(options, true);
                    break;
                }
                case DetailedReport: {
                    if (options._format.equals((Object)Format.pdf)) {
                        this.detailedReportPdf(options, true);
                        break;
                    }
                    this.detailedReport(options, true);
                    break;
                }
                case GetAppBuilds: {
                    this.getAppBuilds(options, true);
                    break;
                }
                case GetCallStacks: {
                    this.getCallStacks(options, true);
                    break;
                }
                case SummaryReport: {
                    if (options._format.equals((Object)Format.pdf)) {
                        this.summaryReportPdf(options, true);
                        break;
                    }
                    this.summaryReport(options, true);
                    break;
                }
                case ThirdPartyReport: {
                    this.thirdPartyReportPdf(options, true);
                    break;
                }
                case CreateTeam: {
                    this.createTeam(options, true);
                    break;
                }
                case CreateUser: {
                    this.createUser(options, true);
                    break;
                }
                case DeleteTeam: {
                    this.deleteTeam(options, true);
                    break;
                }
                case DeleteUser: {
                    this.deleteUser(options, true);
                    break;
                }
                case GetCurriculumList: {
                    this.getCurriculumList(options, true);
                    break;
                }
                case GetTeamList: {
                    this.getTeamList(options, true);
                    break;
                }
                case GetTeamInfo: {
                    this.getTeamInfo(options, true);
                    break;
                }
                case GetTrackList: {
                    this.getTrackList(options, true);
                    break;
                }
                case GetUserInfo: {
                    this.getUserInfo(options, true);
                    break;
                }
                case GetUserList: {
                    this.getUserList(options, true);
                    break;
                }
                case UpdateTeam: {
                    this.updateTeam(options, true);
                    break;
                }
                case UpdateUser: {
                    this.updateUser(options, true);
                    break;
                }
                case Archer: {
                    this.archer(options, true);
                    break;
                }
                case GenerateArcherReport: {
                    this.generateArcherReport(options, true);
                    break;
                }
                case DownloadArcherReport: {
                    this.downloadArcherReport(options, true);
                    break;
                }
                case GenerateFlawReport: {
                    this.generateFlawReport(options, true);
                    break;
                }
                case DownloadFlawReport: {
                    this.downloadFlawReport(options, true);
                    break;
                }
                case GetMitigationInfo: {
                    this.getMitigationInfo(options, true);
                    break;
                }
                case UpdateMitigationInfo: {
                    this.updateMitigationInfo(options, true);
                    break;
                }
                case GetSharedReportInfo: {
                    this.getSharedReportInfo(options, true);
                    break;
                }
                case GetSharedReportList: {
                    this.getSharedReportList(options, true);
                    break;
                }
                case SharedReport: {
                    if (options._format.equals((Object)Format.pdf)) {
                        this.sharedReportPdf(options, true);
                        break;
                    }
                    this.sharedReport(options, true);
                    break;
                }
                case AllDetailedReports: {
                    this.allDetailedReports(options);
                    break;
                }
                case PassFail: {
                    this.passFail(options);
                    break;
                }
                case SwitchToSaml: {
                    this.switchToSaml(options);
                    break;
                }
                case UploadAndScan: {
                    this.uploadAndScan(options);
                    break;
                }
                case UploadAndScanByAppId: {
                    this.uploadAndScanByAppId(options);
                    break;
                }
                case RescanDynamicScan: {
                    this.rescanDynamicScan(options, false);
                    break;
                }
                case SubmitDynamicScan: {
                    this.submitDynamicRescan(options, false);
                    break;
                }
                case CreateAndSubmitDynamicRescan: {
                    this.createAndSubmitDynamicScan(options);
                    break;
                }
                case GetRegion: {
                    this.getRegion(options._vid, options._vkey, options.credprofile);
                    break;
                }
                case IsFeatureEnabled: {
                    this.isFeatureEnabled(options, true);
                    break;
                }
                case IsExpiring: {
                    this.getApiCredentialDetails(options, true);
                    break;
                }
                default: {
                    throw new ParseException(String.format("Invalid Action: %s.", new Object[]{options._action}));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScanCompleteTimeout(String timeoutMinutes) {
            VeracodeParser veracodeParser = this;
            synchronized (veracodeParser) {
                if (!StringUtility.isNullOrEmpty(timeoutMinutes)) {
                    try {
                        this.scanCompleteTimeout = Integer.parseInt(timeoutMinutes);
                    }
                    catch (NumberFormatException nfe) {
                        this.errorWriteLine("Invalid value for timeout: %s", timeoutMinutes);
                        this.throwException(nfe);
                        this.scanCompleteTimeout = -2;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPollInterval(short minutes) {
            VeracodeParser veracodeParser = this;
            synchronized (veracodeParser) {
                this.pollInterval = (short)(minutes > 2 ? minutes : 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOutputWriter(PrintStream outputWriter) {
            VeracodeParser veracodeParser = this;
            synchronized (veracodeParser) {
                this.outputWriter = outputWriter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setErrorWriter(PrintStream errorWriter) {
            VeracodeParser veracodeParser = this;
            synchronized (veracodeParser) {
                this.errorWriter = errorWriter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void throwExceptions(boolean canThrowExceptions) {
            VeracodeParser veracodeParser = this;
            synchronized (veracodeParser) {
                this.canThrowExceptions = canThrowExceptions;
            }
        }

        public void setIsValidXml(boolean isValidXml) {
            this.isValidXml = isValidXml;
        }

        public boolean getIsValidXml() {
            return this.isValidXml;
        }

        public void setFailedPolicy(boolean failedPolicy) {
            this.failedPolicy = failedPolicy;
        }

        public boolean getFailedPolicy() {
            return this.failedPolicy;
        }

        /*
         * Exception decompiling
         */
        public int parse(String[] args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static final class Options
    extends CommandLineOptionsBase {
        private static final String ACTION = "action";
        @Option(longName="action", parseOnce=true, displayEnumOptions=true, required=true)
        public Action _action = null;
        private static final String API1 = "api1";
        @Option(longName="api1", parseOnce=true, helpText="API one", mutuallyExclusiveSet="vuser_set, ssoid_set1, ssokey_set1")
        public String _api1 = null;
        private static final String API2 = "api2";
        @Option(longName="api2", parseOnce=true, helpText="API two", mutuallyExclusiveSet="vpassword_set, ssoid_set2, ssokey_set2")
        public String _api2 = null;
        private static final String API3 = "api3";
        @Option(longName="api3", parseOnce=true, helpText="API three", mutuallyExclusiveSet="puser_set")
        public String _api3 = null;
        private static final String API4 = "api4";
        @Option(longName="api4", parseOnce=true, helpText="API four", mutuallyExclusiveSet="ppassword_set")
        public String _api4 = null;
        private static final String APP_ID = "appid";
        @Option(longName="appid", helpText="Application ID", requiredBy={"action", "UploadAndScanByAppId", "BeginPreScan", "BeginScan", "CreateBuild", "CreateSandbox", "DeleteApp", "DeleteBuild", "GetAppInfo", "GetBuildInfo", "GetBuildList", "GetFileList", "GetPreScanResults", "GetSandboxList", "RemoveFile", "UpdateApp", "UpdateBuild", "UploadFile", "GetSharedReportInfo", "GetSharedReportList", "SharedReport", "RescanDynamicScan", "SubmitDynamicScan"}, optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _app_id = null;
        private static final String APP_ID_LIST = "appidlist";
        @Option(longName="appidlist", helpText="Application ID list (csv)", optionalBy={"action", "GenerateFlawReport"})
        public String _app_id_list = null;
        private static final String APP_NAME = "appname";
        @Option(longName="appname", helpText="Application Name", requiredBy={"action", "PassFail", "UploadAndScan", "CreateApp", "CreateAndSubmitDynamicRescan"}, optionalBy={"action", "UpdateApp"})
        public String _app_name = null;
        private static final String APP_TYPE = "apptype";
        @Option(longName="apptype", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public App_Type _app_type = null;
        private static final String ARCHER_APP_NAME = "archerappname";
        @Option(longName="archerappname", helpText="Archer Application Name", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _archer_app_name = null;
        private static final String AUTO_SCAN = "autoscan";
        @Option(longName="autoscan", helpText="True if you want to automatically submit a full scan of the application following a successful prescan", mutuallyExclusiveSet="include_set, exclude_set", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId", "BeginPreScan"})
        public TrueOrFalse _auto_scan = null;
        private static final String BUILD_ID = "buildid";
        @Option(longName="buildid", helpText="Build ID", requiredBy={"action", "DetailedReport", "GetCallStacks", "SummaryReport", "ThirdPartyReport", "GetMitigationInfo", "UpdateMitigationInfo", "PromoteSandbox"}, optionalBy={"action", "GetBuildInfo", "GetFileList", "GetPreScanResults", "UpdateBuild"})
        public String _build_id = null;
        private static final String BUSINESS_CRITICALITY = "criticality";
        @Option(longName="criticality", displayEnumOptions=true, requiredBy={"action", "CreateApp"}, optionalBy={"action", "UploadAndScan", "UpdateApp"})
        public Business_Criticality _business_criticality = null;
        private static final String BUSINESS_OWNER = "businessowner";
        @Option(longName="businessowner", helpText="Business Owner", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_owner = null;
        private static final String BUSINESS_OWNER_EMAIL = "businessowneremail";
        @Option(longName="businessowneremail", helpText="Business Owner's e-mail address", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_owner_email = null;
        private static final String BUSINESS_UNIT = "businessunit";
        @Option(longName="businessunit", helpText="Business Unit", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _business_unit = null;
        private static final String COMMENT = "comment";
        @Option(longName="comment", helpText="Comment", requiredBy={"action", "UpdateMitigationInfo"})
        public String _comment = null;
        private static final String CREATE_PROFILE = "createprofile";
        @Option(longName="createprofile", helpText="True to create a new application profile", requiredBy={"action", "UploadAndScan"})
        public TrueOrFalse _create_profile = null;
        private static final String CREATE_SANDBOX = "createsandbox";
        @Option(longName="createsandbox", helpText="True to create a new sandbox", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public TrueOrFalse _create_sandbox = null;
        private static final String SCAN_POLLING_INTERVAL = "scanpollinginterval";
        @Option(longName="scanpollinginterval", helpText="Scan polling interval (in seconds)", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String scanPollingInterval = null;
        private static final String CUSTOM_FIELD_NAME = "customfieldname";
        @Option(longName="customfieldname", helpText="Custom field name", requiredBy={"action", "UpdateSandbox"}, optionalBy={"action", "UpdateApp"})
        public String _custom_field_name = null;
        private static final String CUSTOM_FIELD_VALUE = "customfieldvalue";
        @Option(longName="customfieldvalue", helpText="Custom field value", requiredBy={"action", "UpdateSandbox"}, optionalBy={"action", "UpdateApp"})
        public String _custom_field_value = null;
        private static final String CUSTOM_FIVE = "custom5";
        @Option(longName="custom5", helpText="Custom five", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_five = null;
        private static final String CUSTOM_FOUR = "custom4";
        @Option(longName="custom4", helpText="Custom four", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_four = null;
        private static final String CUSTOM_ID = "customid";
        @Option(longName="customid", helpText="Custom ID", mutuallyExclusiveSet="user_set", requiredBy={"action", "DeleteUser", "GetUserInfo", "UpdateUser"}, optionalBy={"action", "GetUserList", "CreateUser"})
        public String _custom_id = null;
        private static final String CUSTOM_ONE = "custom1";
        @Option(longName="custom1", helpText="Custom one", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_one = null;
        private static final String CUSTOM_THREE = "custom3";
        @Option(longName="custom3", helpText="Custom three", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_three = null;
        private static final String CUSTOM_TWO = "custom2";
        @Option(longName="custom2", helpText="Custom two", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _custom_two = null;
        private static final String DEBUG = "debug";
        @Option(longName="debug", parseOnce=true, helpText="Turn on debug messages")
        public boolean _debug = false;
        private static final String DEPLOYMENT_TYPE = "deploymenttype";
        @Option(longName="deploymenttype", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Deployment_Type _deployment_type = null;
        private static final String DESCRIPTION = "description";
        @Option(longName="description", helpText="Description", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _description = null;
        private static final String ELEARNING_CURRICULUM = "elearningcurriculum";
        @Option(longName="elearningcurriculum", helpText="eLearning Curriculum", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_curriculum = null;
        private static final String ELEARNING_MANAGER = "elearningmanager";
        @Option(longName="elearningmanager", helpText="eLearning Manager", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_manager = null;
        private static final String ELEARNING_TRACK = "elearningtrack";
        @Option(longName="elearningtrack", helpText="eLearning Track", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _elearning_track = null;
        private static final String EMAIL_ADDRESS = "emailaddress";
        @Option(longName="emailaddress", helpText="E-mail address", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _email_address = null;
        private static final String END_TIME = "endtime";
        @Option(longName="endtime", helpText="Dynamic scan end time", optionalBy={"action", "SubmitDynamicScan", "CreateAndSubmitDynamicRescan"})
        public String _end_time = null;
        private static final String EXCLUDE = "exclude";
        @Option(longName="exclude", helpText="Case-sensitive comma-separated list of module name patterns that represent the names of modules that should not be scanned as top level modules. The '*' wildcard matches 0 or more characters. The '?' wildcard matches exactly 1 character.", mutuallyExclusiveSet="exclude_set", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String _exclude = null;
        private static final String FILE = "filepath";
        @Option(longName="filepath", inputPath=true, helpText="Filepath or folderpath of the file or directory to upload. (If the last character is a backslash it needs to be escaped: \\\\)", requiredBy={"action", "UploadAndScan", "UploadAndScanByAppId", "UploadFile"})
        public String[] _file = null;
        private static final String FILE_ID = "fileid";
        @Option(longName="fileid", helpText="File ID", requiredBy={"action", "RemoveFile"})
        public String _file_id = null;
        private static final String FIRST_NAME = "firstname";
        @Option(longName="firstname", helpText="First Name", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _first_name = null;
        private static final String FLAW_ID = "flawid";
        @Option(longName="flawid", helpText="Flaw ID", requiredBy={"action", "GetCallStacks"})
        public String _flaw_id = null;
        private static final String FLAW_ID_LIST = "flawidlist";
        @Option(longName="flawidlist", helpText="Comma-separated list of module flaw IDs", requiredBy={"action", "GetMitigationInfo", "UpdateMitigationInfo"})
        public String _flaw_id_list = null;
        private static final String FLAW_ONLY = "flawonly";
        @Option(longName="flawonly", helpText="Turn on DVR (Dynamic Vulnerability Rescan) functionality", optionalBy={"action", "RescanDynamicScan"})
        public TrueOrFalse _flaw_only = null;
        private static final String FORMAT = "format";
        @Option(longName="format", customDefaultValue="xml", displayEnumOptions=true, requiredBy={"action", "ThirdPartyReport"}, optionalBy={"~action", "ThirdPartyReport"})
        public Format _format = null;
        private static final String FROM_DATE = "fromdate";
        @Option(longName="fromdate", helpText="From Date", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _from_date = null;
        private static final String HELP = "help";
        @Option(longName="help", parseOnce=true, helpText="Display this message")
        public boolean _help = false;
        private static final String INCLUDE = "include";
        @Option(longName="include", helpText="Case-sensitive comma-separated list of module name patterns that represent the names of modules that should be scanned as top level modules. The '*' wildcard matches 0 or more characters. The '?' wildcard matches exactly 1 character.", mutuallyExclusiveSet="include_set", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String _include = null;
        private static final String INCLUDE_IN_PROGRESS = "includeinprogress";
        @Option(longName="includeinprogress", helpText="True to include build data for builds with unpublished scan reports", optionalBy={"action", "AllDetailedReports", "GetAppBuilds"})
        public TrueOrFalse _include_in_progress = null;
        private static final String INCLUDE_USER_INFO = "includeuserinfo";
        @Option(longName="includeuserinfo", helpText="True to include permission information for the current user", optionalBy={"action", "GetAppList"})
        public TrueOrFalse _include_user_info = null;
        private static final String INCLUDE_USERS = "includeusers";
        @Option(longName="includeusers", helpText="Enter Yes to view applications assigned to the team. The default is No.", optionalBy={"action", "GetTeamInfo"})
        public String _include_users = null;
        private static final String INCLUDE_APPLICATIONS = "includeapplications";
        @Option(longName="includeapplications", helpText="Enter Yes to view the members of the team. The default is No.", optionalBy={"action", "GetTeamInfo"})
        public String _include_applications = null;
        private static final String INDUSTRY = "industry";
        @Option(longName="industry", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Industry _industry = null;
        private static final String INPUT_FILEPATH = "inputfilepath";
        @Option(longName="inputfilepath", parseOnce=true, inputPath=true, overridesRules=true, helpText="The filepath of the csv file from which to read additional command-line arguments (The first row should contain the parameter names, subsequent rows should contain the corresponding values of those parameters).", optionalBy={"~action", "GetAppList", "GetPolicyList", "GetVendorList", "GetAppBuilds", "GetCurriculumList", "GetTeamList", "GetTrackList", "GetUserList"})
        public String _input_filepath = null;
        private static final String IS_ELEARNING_MANAGER = "iselearningmanager";
        @Option(longName="iselearningmanager", helpText="True if eLearning manager", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _is_elearning_manager = null;
        private static final String IS_SAML_USER = "issamluser";
        @Option(longName="issamluser", helpText="True if SAML user", optionalBy={"action", "GetUserList", "UpdateUser", "CreateUser"})
        public TrueOrFalse _is_saml_user = null;
        private static final String KEEP_ELEARNING_ACTIVE = "keepelearningactive";
        @Option(longName="keepelearningactive", helpText="True to keep eLearning Active", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _keep_elearning_active = null;
        private static final String LAST_NAME = "lastname";
        @Option(longName="lastname", helpText="Last Name", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _last_name = null;
        private static final String LAUNCH_DATE = "launchdate";
        @Option(longName="launchdate", helpText="Launch date", optionalBy={"action", "CreateBuild", "UpdateBuild"})
        public String _launch_date = null;
        private static final String LEGACY_SCAN_ENGINE = "legacyscanengine";
        @Option(longName="legacyscanengine", helpText="True to use legacy scan engine", optionalBy={"action", "CreateBuild"})
        public TrueOrFalse _legacy_scan_engine = null;
        private static final String LIFECYCLE_STAGE = "lifecyclestage";
        @Option(longName="lifecyclestage", displayEnumOptions=true, optionalBy={"action", "CreateBuild", "UpdateBuild"})
        public Lifecycle_Stage _lifecycle_stage = null;
        private static final String LIFECYCLE_STAGE_ID = "lifecyclestageid";
        @Option(longName="lifecyclestageid", helpText="Lifecycle stage id", optionalBy={"action", "CreateBuild"})
        public String _lifecycle_stage_id = null;
        private static final String LOG_FILEPATH = "logfilepath";
        @Option(longName="logfilepath", parseOnce=true, outputPath=true, helpText="The filepath of the file where informational and error messages will be logged. If the file already exists new data will be appended.", optionalBy={"action"})
        public String _log_filepath = null;
        private static final String LOGIN_ACCOUNT_TYPE = "loginaccounttype";
        @Option(longName="loginaccounttype", helpText="Login Account Type", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _login_account_type = null;
        private static final String LOGIN_ENABLED = "loginenabled";
        @Option(longName="loginenabled", helpText="True if Login is enabled.", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _login_enabled = null;
        private static final String MAX_RETRY_COUNT = "maxretrycount";
        @Option(longName="maxretrycount", helpText="Maximum retry count in the case of connectivity failure", optionalBy={"action", "UploadAndScan"})
        public Integer _max_retry_count = new Integer(0);
        private static final String MEMBERS = "members";
        @Option(longName="members", helpText="Members", optionalBy={"action", "CreateTeam", "UpdateTeam"})
        public String _members = null;
        private static final String MITIGATION_ACTION = "mitigationaction";
        @Option(longName="mitigationaction", displayEnumOptions=true, requiredBy={"action", "UpdateMitigationInfo"})
        public Mitigation_Action _mitigation_action = null;
        private static final String MODULES = "modules";
        @Option(longName="modules", helpText="Comma-separated list of module IDs", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"})
        public String _modules = null;
        private static final String NEW_CUSTOM_ID = "newcustomid";
        @Option(longName="newcustomid", helpText="New Custom ID", optionalBy={"action", "UpdateUser"})
        public String _new_custom_id = null;
        private static final String NEXT_DAY_SCHEDULING_ENABLED = "nextdayschedulingenabled";
        @Option(longName="nextdayschedulingenabled", helpText="Next-day scheduling enabled. Boolean, defaults to false. Specifies if a user can schedule next-day consultations. Only available to Veracode human user accounts with the Security Lead or Administrator roles and to non-human API accounts with the Upload API role", optionalBy={"action", "CreateApp", "UpdateApp"})
        public TrueOrFalse _next_day_scheduling_enabled = null;
        private static final String ONLY_LATEST = "onlylatest";
        @Option(longName="onlylatest", helpText="False to include build data for previous builds with published scan reports", optionalBy={"action", "AllDetailedReports", "GetAppBuilds"})
        public TrueOrFalse _only_latest = null;
        private static final String ORIGIN = "origin";
        @Option(longName="origin", displayEnumOptions=true, optionalBy={"action", "CreateApp", "UpdateApp"})
        public Origin _origin = null;
        private static final String OUTPUT_FILEPATH = "outputfilepath";
        @Option(longName="outputfilepath", outputPath=true, helpText="Output filepath", requiredBy={"action", "DetailedReport", "SummaryReport", "ThirdPartyReport", "SharedReport"})
        public String _output_filepath = null;
        private static final String OUTPUT_FOLDERPATH = "outputfolderpath";
        @Option(longName="outputfolderpath", outputPath=true, helpText="Output folderpath. (If the last character is a backslash it needs to be escaped: \\\\)", requiredBy={"action", "AllDetailedReports"})
        public String _output_folderpath = null;
        private static final String PATTERN = "pattern";
        @Option(longName="pattern", helpText="Case-sensitive filename pattern that represents the names of uploaded files that should be saved with a different name. The '*' wildcard matches 0 or more characters. The '?' wildcard matches exactly 1 character. Each wildcard corresponds to a numbered group that can be referenced in the replacement pattern.", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String _pattern = null;
        private static final String PERIOD = "period";
        @Option(longName="period", helpText="Period", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _period = null;
        private static final String PHONE = "phone";
        @Option(longName="phone", helpText="Phone", optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _phone = null;
        private static final String PHOST = "phost";
        @Option(longName="phost", parseOnce=true, helpText="Proxy host", optionalBy={"action"})
        public String _phost = null;
        private static final String PLATFORM = "platform";
        @Option(longName="platform", displayEnumOptions=true, optionalBy={"action", "CreateBuild"})
        public Platform _platform = null;
        private static final String PLATFORM_ID = "platformid";
        @Option(longName="platformid", helpText="Platform ID", optionalBy={"action", "CreateBuild"})
        public String _platform_id = null;
        private static final String POLICY = "policy";
        @Option(longName="policy", helpText="Policy", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _policy = null;
        private static final String POSITION = "position";
        @Option(longName="position", helpText="Job title of the user", optionalBy={"action", "GetUserList"})
        public String _position = null;
        private static final String PPASSWORD = "ppassword";
        @Option(longName="ppassword", parseOnce=true, helpText="Proxy password", mutuallyExclusiveSet="ppassword_set", optionalBy={"action"})
        public String _ppcode = null;
        private static final String PPORT = "pport";
        @Option(longName="pport", parseOnce=true, helpText="Proxy port", optionalBy={"action"})
        public String _pport = null;
        private static final String PUSER = "puser";
        @Option(longName="puser", parseOnce=true, helpText="Proxy user", mutuallyExclusiveSet="puser_set", optionalBy={"action"})
        public String _puser = null;
        private static final String REPLACEMENT = "replacement";
        @Option(longName="replacement", helpText="A replacement pattern that references groups captured by the filename pattern. For example, if the filename pattern is '*-*-SNAPSHOT.war' and the replacement pattern '$1-master-SNAPSHOT.war', an uploaded file named 'app-branch-SNAPSHOT.war' would be saved as 'app-master-SNAPSHOT.war'", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String _replacement = null;
        private static final String REPORT_CHANGED_SINCE = "reportchangedsince";
        @Option(longName="reportchangedsince", helpText="Build data is included only for builds with scan reports that have been published or scan reports that have changed since the specified date.", optionalBy={"action", "AllDetailedReports", "GetAppBuilds"})
        public String _report_changed_since = null;
        private static final String REQUIRES_TOKEN = "requirestoken";
        @Option(longName="requirestoken", helpText="True if the user requires token", optionalBy={"action", "GetUserList", "UpdateUser"})
        public TrueOrFalse _requires_token = null;
        private static final String ROLES = "roles";
        @Option(longName="roles", helpText="Comma-delimited list. Case-sensitive. You can filter on theses human user roles: Administrator, Creator, Executive, Mitigation Approver, Policy Administrator, Reviewer, Security Lead, Submitter, Security Insights, eLearning.", requiredBy={"action", "CreateUser"}, optionalBy={"action", "GetUserList", "UpdateUser"})
        public String _roles = null;
        private static final String SANDBOX_ID = "sandboxid";
        @Option(longName="sandboxid", helpText="Sandbox ID", mutuallyExclusiveSet="sandbox_set", requiredBy={"action", "UpdateSandbox", "DeleteSandbox"}, optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId", "BeginPreScan", "BeginScan", "CreateBuild", "DeleteBuild", "GetBuildInfo", "GetBuildList", "GetFileList", "GetPreScanResults", "RemoveFile", "UpdateBuild", "UploadFile", "PassFail"})
        public String _sandbox_id = null;
        private static final String SANDBOX_NAME = "sandboxname";
        @Option(longName="sandboxname", helpText="The name of the sandbox", mutuallyExclusiveSet="sandbox_set", requiredBy={"action", "CreateSandbox"}, optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId", "PassFail"})
        public String _sandbox_name = null;
        private static final String SAVE_AS = "saveas";
        @Option(longName="saveas", helpText="New filename for the uploaded file.", optionalBy={"action", "UploadFile"})
        public String _save_as = null;
        private static final String SCAN_ALL_TOP_LEVEL_MODULES = "toplevel";
        @Option(longName="toplevel", helpText="True if you want to ensure that the scan completes even though there are non-fatal errors, such as unsupported frameworks.", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"}, optionalBy={"action", "UploadAndScan"})
        public TrueOrFalse _scan_all_top_level_modules = null;
        private static final String SCAN_ALL_NONFATAL_TOP_LEVEL_MODULES = "scanallnonfataltoplevelmodules";
        @Option(longName="scanallnonfataltoplevelmodules", helpText="True if you want to automatically scan all top level modules of the application following a successful prescan", optionalBy={"action", "BeginPreScan", "UploadAndScan"})
        public TrueOrFalse _scan_all_nonfatal_top_level_modules = null;
        private static final String SCAN_SELECTED_MODULES = "selected";
        @Option(longName="selected", helpText="True if you want to scan all modules which are currently selected", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"}, optionalBy={"action", "UploadAndScan"})
        public TrueOrFalse _scan_selected_modules = null;
        private static final String SCAN_PREVIOUSLY_SELECTED_MODULES = "selectedpreviously";
        @Option(longName="selectedpreviously", helpText="True if you want to scan all modules which are previously selected", mutuallyExclusiveSet="modules_set", requiredBy={"action", "BeginScan"}, optionalBy={"action", "UploadAndScan"})
        public TrueOrFalse _scan_previously_selected_modules = null;
        private static final String SCAN_TIMEOUT = "scantimeout";
        @Option(longName="scantimeout", helpText="Scan timeout in minutes.", optionalBy={"action", "UploadAndScan", "UploadAndScanByAppId"})
        public String _scantime_out = null;
        private static final String SCAN_TYPE = "scantype";
        @Option(longName="scantype", helpText="Scan Type", optionalBy={"action", "Archer", "GenerateArcherReport", "GenerateFlawReport"})
        public String _scan_type = null;
        private static final String SHARED_REPORT_ID = "sharedreportid";
        @Option(longName="sharedreportid", helpText="Shared report id", requiredBy={"action", "SharedReport"}, optionalBy={"action", "GetSharedReportInfo"})
        public String _shared_report_id = null;
        private static final String START_TIME = "starttime";
        @Option(longName="starttime", helpText="Dynamic scan start time", optionalBy={"action", "SubmitDynamicScan", "CreateAndSubmitDynamicRescan"})
        public String _start_time = null;
        private static final String TAGS = "tags";
        @Option(longName="tags", helpText="Tags", optionalBy={"action", "CreateApp", "UpdateApp"})
        public String _tags = null;
        private static final String TEAM_ID = "teamid";
        @Option(longName="teamid", helpText="Team ID", requiredBy={"action", "DeleteTeam", "UpdateTeam", "GetTeamInfo"})
        public String _team_id = null;
        private static final String TEAM_NAME = "teamname";
        @Option(longName="teamname", helpText="Team Name", requiredBy={"action", "CreateTeam"}, optionalBy={"action", "UpdateTeam"})
        public String _team_name = null;
        private static final String TEAMS = "teams";
        @Option(longName="teams", helpText="Comma-separated list of team names. Case-sensitive", optionalBy={"action", "CreateApp", "UploadAndScan", "UpdateApp", "CreateUser", "GetUserList", "UpdateUser"})
        public String _teams = null;
        private static final String TO_DATE = "todate";
        @Option(longName="todate", helpText="To date", optionalBy={"action", "Archer", "GenerateArcherReport"})
        public String _to_date = null;
        private static final String TOKEN = "token";
        @Option(longName="token", helpText="Token associated with the archer report", optionalBy={"action", "DownloadArcherReport", "DownloadFlawReport"})
        public String _token = null;
        private static final String USERAGENT = "useragent";
        @Option(longName="useragent", helpText="The user agent request header value, used by Veracode integrations to invoke the wrapper (For internal use only).", displayOnCLI=false)
        public String _useragent = null;
        private static final String USERNAME = "username";
        @Option(longName="username", helpText="User name", mutuallyExclusiveSet="user_set", requiredBy={"action", "DeleteUser", "GetUserInfo", "UpdateUser"})
        public String _username = null;
        private static final String VENDOR_ID = "vendorid";
        @Option(longName="vendorid", helpText="Vendor ID", optionalBy={"action", "CreateApp"})
        public String _vendor_id = null;
        private static final String VERSION = "version";
        @Option(longName="version", helpText="The name or version number of the new or updated build", requiredBy={"action", "UploadAndScan", "UploadAndScanByAppId", "CreateBuild"}, optionalBy={"action", "UpdateBuild", "CreateAndSubmitDynamicRescan"})
        public String _version = null;
        private static final String VID = "vid";
        @Option(longName="vid", parseOnce=true, helpText="Veracode API ID", mutuallyExclusiveSet="ssoid_set1, ssoid_set2", mutuallyInclusiveSet="sso_set", required=false)
        public String _vid = null;
        private static final String VKEY = "vkey";
        @Option(longName="vkey", parseOnce=true, helpText="Veracode API key", mutuallyExclusiveSet="ssokey_set1, ssokey_set2", mutuallyInclusiveSet="sso_set", required=false)
        public String _vkey = null;
        private static final String VPASSWORD = "vpassword";
        @Option(longName="vpassword", parseOnce=true, helpText="Veracode password", mutuallyExclusiveSet="vpassword_set, ssoid_set2, ssokey_set2", notSupported=true)
        public String _vpcode = null;
        private static final String VUSER = "vuser";
        @Option(longName="vuser", parseOnce=true, helpText="Veracode username", mutuallyExclusiveSet="vuser_set, ssoid_set1, ssokey_set1", notSupported=true)
        public String _vuser = null;
        private static final String WEB_APPLICATION = "webapplication";
        @Option(longName="webapplication", helpText="True if the application is a web application.", optionalBy={"action", "CreateApp"})
        public TrueOrFalse _web_application = null;
        private static final String WRAPPER_VERSION = "wrapperversion";
        @Option(longName="wrapperversion", parseOnce=true, helpText="Display the version of this wrapper.")
        public boolean _wrapper_version = false;
        private static final String CREDPROFILE = "credprofile";
        @Option(longName="credprofile", parseOnce=true, helpText="Credentials Profile", mutuallyExclusiveSet="ssoid_set1, ssoid_set2", required=false)
        public String credprofile = null;
        private static final String AUTORECREATE = "autorecreate";
        @Option(longName="autorecreate", parseOnce=true, helpText="If true, the sandbox will be automatically re-created when the 7-day expiration period starts.", optionalBy={"action", "UploadAndScan", "CreateSandbox", "UpdateSandbox", "UploadAndScanByAppId"}, required=false)
        public TrueOrFalse autoRecreate = null;
        private static final String FEATURE = "feature";
        @Option(longName="feature", parseOnce=true, helpText="Feature Name", required=false)
        public String _feature = null;

        @Override
        public String createHeading() {
            String heading = VeracodeCommand.getVersionString();
            return !StringUtility.isNullOrEmpty(heading) ? heading + "\r\n" : "";
        }

        @Override
        public List<String> optionsWithIncompatibleArguments() {
            ArrayList<String> list = new ArrayList<String>();
            if (this._action != null) {
                switch (this._action) {
                    case AllDetailedReports: {
                        if (this._format.equals((Object)Format.pdf) || this._format.equals((Object)Format.xml)) break;
                        list.add(FORMAT);
                        break;
                    }
                    case ThirdPartyReport: {
                        if (this._format.equals((Object)Format.pdf)) break;
                        list.add(FORMAT);
                        break;
                    }
                    case DetailedReport: 
                    case SummaryReport: 
                    case SharedReport: {
                        break;
                    }
                    default: {
                        if (!this._format.equals((Object)Format.pdf)) break;
                        list.add(FORMAT);
                    }
                }
            }
            return list;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface APICallText {
        public String value();

        public static final class Reader {
            public static String toString(Enum<?> enumElement) {
                String result = null;
                if (enumElement != null) {
                    String enumElementName = enumElement.name();
                    APICallText attribute = null;
                    try {
                        attribute = enumElement.getClass().getField(enumElementName).getAnnotation(APICallText.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result = attribute != null ? attribute.value() : enumElementName;
                }
                return result;
            }

            private Reader() {
            }
        }
    }

    private static final class Build {
        private static final String INCOMPLETE = "Incomplete";
        private static final String NOT_SUBMITTED_TO_ENGINE = "Not Submitted to Engine";
        private static final String SUBMITTED_TO_ENGINE = "Submitted to Engine";
        private static final String SCAN_ERRORS = "Scan Errors";
        private static final String SCAN_IN_PROCESS = "Scan In Process";
        private static final String RESULTS_READY = "Results Ready";
        private static final String PRESCAN_SUBMITTED = "Pre-Scan Submitted";
        private static final String PREFLIGHT_SUBMITTED = "Preflight Submitted";
        private static final String PRESCAN_FAILED = "Pre-Scan Failed";
        private static final String PRESCAN_SUCESS = "Pre-Scan Success";
        private static final String PREFLIGHT_SUCESS = "Preflight Success";
        private static final String NO_MODULES_DEFINED = "No Modules Defined";
        private static final String PRESCAN_CANCELLED = "Pre-Scan Cancelled";
        private static final String DID_NOT_PASS = "Did Not Pass";
        private static final String CONDITIONAL_PASS = "Conditional Pass";
        private static final String SUCCESS = "Pass";

        private Build() {
        }

        private static final boolean isInProgess(String status) {
            return Build.isPreScanSubmitted(status) || Build.isPreScanSucess(status) || Build.isScanInProgress(status);
        }

        private static final boolean isScanInProgress(String status) {
            return StringUtility.compare(status, SCAN_IN_PROCESS, true) == 0 || StringUtility.compare(status, SUBMITTED_TO_ENGINE, true) == 0;
        }

        private static final boolean isResultReady(String status) {
            return StringUtility.compare(status, RESULTS_READY, true) == 0;
        }

        private static final boolean isPreScanSubmitted(String status) {
            return StringUtility.compare(status, PRESCAN_SUBMITTED, true) == 0 || StringUtility.compare(status, PREFLIGHT_SUBMITTED, true) == 0;
        }

        private static final boolean isPreScanSucess(String status) {
            return StringUtility.compare(status, PRESCAN_SUCESS, true) == 0 || StringUtility.compare(status, PREFLIGHT_SUCESS, true) == 0;
        }

        private static final boolean isPolicyCompliancePass(String status) {
            return StringUtility.compare(status, SUCCESS, true) == 0;
        }

        private static final boolean isPolicyComplianceConditionalPass(String status) {
            return StringUtility.compare(status, CONDITIONAL_PASS, true) == 0;
        }

        private static final boolean isPolicyComplianceDidNotPass(String status) {
            return StringUtility.compare(status, DID_NOT_PASS, true) == 0;
        }

        public static final boolean isPreScanIncomplete(String status) {
            return StringUtility.compare(status, PRESCAN_CANCELLED, true) == 0 || StringUtility.compare(status, PRESCAN_FAILED, true) == 0;
        }

        public static boolean isInComplete(String status) {
            return StringUtility.compare(status, INCOMPLETE, true) == 0 || StringUtility.compare(status, NO_MODULES_DEFINED, true) == 0 || Build.isPreScanIncomplete(status);
        }
    }

    private static enum ReturnCode {
        SUCCESS(0, "Success"),
        ARGUMENT_INPUT_ERROR(1, "Argument Input Error"),
        API_ERROR(2, "API Error"),
        CSV_FILE_INPUT_ERROR(3, "CSV File Input Error"),
        DID_NOT_PASS_POLICY(4, "Did Not Pass Policy");

        private final int value;
        private final String displayValue;

        private ReturnCode(int value, String displayValue) {
            this.value = value;
            this.displayValue = displayValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }
    }

    private static enum Platform {
        NotSpecified,
        Windows,
        Solaris,
        Linux,
        Java,
        WindowsMobile,
        J2ME,
        ColdFusion,
        PHP,
        Android,
        iOS,
        Ruby;

    }

    private static enum Origin {
        NotSpecified,
        ThirdPartyLibrary,
        PurchasedApplication,
        Contractor,
        InternallyDeveloped,
        OpenSource,
        OutsourcedTeam;

    }

    private static enum Lifecycle_Stage {
        NotSpecified,
        InDevelopmentPreAlpha,
        InternalOrAlphaTesting,
        ExternalOrBetaTesting,
        DeployedInProductionAndActivelyDeveloped,
        MaintenanceOnlyBugFixes,
        CannotDisclose;

    }

    private static enum Industry {
        agmine,
        busiserv,
        compelec,
        conserv,
        edu,
        enerutil,
        fed,
        finserv,
        gvmt,
        hpb,
        local,
        manu,
        mediaent,
        nonprofit{

            public String toString() {
                return "non-profit";
            }
        }
        ,
        notspec,
        prtnr,
        realconst,
        retail,
        softint,
        telcom,
        transerv,
        travel,
        wholedist;

    }

    private static enum Deployment_Type {
        NotSpecified,
        WebBased,
        EnterpriseApplicationEnhancement,
        ClientServer,
        Mobile,
        StandAlone;

    }

    private static enum Business_Criticality {
        VeryHigh,
        High,
        Medium,
        Low,
        VeryLow;

    }

    private static enum App_Type {
        NotSpecified,
        ApplicationDesignConstructionIDEAnalysis,
        ApplicationLifeCycleManagement,
        ApplicationServerIntegrationServer,
        BackOfficeEnterprise,
        CRM,
        CollaborationGroupwareMessaging,
        Consumer,
        ContentManagementAuthoring,
        Engineering,
        EnterpriseResourcePlanning,
        InformationAccessDeliveryMiningPortal,
        InformationDataManagementDatabase,
        MiddlewareMessageOrientedTransaction,
        NetworkManagement,
        Networking,
        Other,
        OtherDevelopmentTools,
        Security,
        ServerWareClusteringWebVM,
        Storage,
        SystemLevelSoftware,
        SystemsManagement,
        TestingTools;

    }

    private static enum Mitigation_Action {
        comment,
        fp,
        appdesign,
        osenv,
        netenv,
        rejected,
        accepted,
        remediated,
        acceptrisk;

    }

    private static enum Format {
        xml,
        pdf,
        csv,
        text;

    }

    private static enum TrueOrFalse {
        True,
        False;

    }

    private static enum Action {
        BeginPreScan,
        BeginScan,
        CreateApp,
        CreateBuild,
        DeleteApp,
        DeleteBuild,
        GetAppInfo,
        GetAppList,
        GetBuildInfo,
        GetBuildList,
        GetFileList,
        GetPolicyList,
        GetPreScanResults,
        GetVendorList,
        RemoveFile,
        UpdateApp,
        UpdateBuild,
        UploadFile,
        CreateSandbox,
        GetSandboxList,
        PromoteSandbox,
        UpdateSandbox,
        DeleteSandbox,
        RescanDynamicScan,
        SubmitDynamicScan,
        DetailedReport,
        GetAppBuilds,
        GetCallStacks,
        SummaryReport,
        ThirdPartyReport,
        CreateTeam,
        CreateUser,
        DeleteTeam,
        DeleteUser,
        GetCurriculumList,
        GetTeamList,
        GetTeamInfo,
        GetTrackList,
        GetUserInfo,
        GetUserList,
        UpdateTeam,
        UpdateUser,
        Archer,
        GenerateArcherReport,
        DownloadArcherReport,
        GenerateFlawReport,
        DownloadFlawReport,
        GetMitigationInfo,
        UpdateMitigationInfo,
        GetSharedReportInfo,
        GetSharedReportList,
        SharedReport,
        AllDetailedReports,
        PassFail,
        SwitchToSaml,
        UploadAndScan,
        UploadAndScanByAppId,
        CreateAndSubmitDynamicRescan,
        GetRegion,
        IsFeatureEnabled,
        IsExpiring;

    }
}

