/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper.adapters.impl;

import com.google.gson.reflect.TypeToken;
import com.veracode.apiwrapper.adapters.DynamicAnalysisAdapter;
import com.veracode.apiwrapper.adapters.impl.BaseAdapter;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisOccurrence;
import com.veracode.apiwrapper.dynamicanalysis.model.api.AnalysisRequest;
import com.veracode.apiwrapper.dynamicanalysis.model.api.PagedAnalysisSummary;
import com.veracode.apiwrapper.dynamicanalysis.model.api.PagedDetailedScanOccurrence;
import com.veracode.apiwrapper.exceptions.ApiException;
import com.veracode.apiwrapper.exceptions.InvocationException;
import com.veracode.apiwrapper.rest.ApiEndpoint;
import com.veracode.http.Credentials;
import com.veracode.util.lang.StringUtility;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DefaultDynamicAnalysisAdapter
extends BaseAdapter
implements DynamicAnalysisAdapter {
    private static final ApiEndpoint ANALYSES_GET = new ApiEndpoint.Builder("/analyses").allowsParameters(new HashSet<String>(Arrays.asList("org", "page", "size", "sort", "name", "status"))).build();
    private static final ApiEndpoint ANALYSES_UPDATE = new ApiEndpoint.Builder("/analyses/{analysis_id}").withArguments(new HashSet<String>(Arrays.asList("analysis_id"))).allowsParameters(new HashSet<String>(Arrays.asList("org", "page", "size", "sort", "name", "status", "method"))).build();
    private static final ApiEndpoint ANALYSIS_OCCURRENCE_LATEST = new ApiEndpoint.Builder("/analyses").withArguments(new HashSet<String>(Arrays.asList("analysis_occurrence_id"))).allowsParameters(new HashSet<String>(Arrays.asList("verification_only"))).build();
    private static final ApiEndpoint SCAN_OCCURRENCES = new ApiEndpoint.Builder("/analysis_occurrences/{analysis_occurrence_id}/scan_occurrences").withArguments(new HashSet<String>(Arrays.asList("analysis_occurrence_id"))).allowsParameters(new HashSet<String>(Arrays.asList("page", "size", "sort", "scan_name", "linked_platform_app_name", "scan_locked"))).build();

    public DefaultDynamicAnalysisAdapter(Credentials creds, Proxy proxy) {
        super(creds, proxy);
    }

    @Override
    public PagedAnalysisSummary getAnalysisSummary(Map<String, String> query) throws ApiException, InvocationException {
        String response = this.getRequest(ANALYSES_GET, null, query);
        Type returnType = new TypeToken<PagedAnalysisSummary>(){}.getType();
        return (PagedAnalysisSummary)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public void updateAnalysis(String analysisId, AnalysisRequest request, Map<String, String> query) throws ApiException, InvocationException {
        if (!StringUtility.validateGUID(analysisId) || null == request) {
            throw new IllegalArgumentException("Cannot update an Analysis with the given arguments: [" + analysisId + ", " + request + "]");
        }
        HashMap<String, String> uriArgs = new HashMap<String, String>();
        uriArgs.put("analysis_id", analysisId);
        this.updateRequest(ANALYSES_UPDATE, uriArgs, this.getJSON().serialize(request), query);
    }

    @Override
    public AnalysisOccurrence getLatestAnalysisOccurrence(String analysisOccurrenceId, Map<String, String> query) throws ApiException, InvocationException {
        HashMap<String, String> uriArgs = new HashMap<String, String>();
        uriArgs.put("analysis_occurrence_id", analysisOccurrenceId);
        String response = this.getRequest(ANALYSIS_OCCURRENCE_LATEST, uriArgs, query);
        Type returnType = new TypeToken<AnalysisOccurrence>(){}.getType();
        return (AnalysisOccurrence)this.getJSON().deserialize(response, returnType);
    }

    @Override
    public PagedDetailedScanOccurrence getScanOccurrences(String analysisOccurrenceId, Map<String, String> query) throws ApiException, InvocationException {
        if (!StringUtility.validateGUID(analysisOccurrenceId)) {
            throw new IllegalArgumentException("Cannot get Scan Occurrences with the given argument: [" + analysisOccurrenceId + "]");
        }
        HashMap<String, String> uriArgs = new HashMap<String, String>();
        uriArgs.put("analysis_occurrence_id", analysisOccurrenceId);
        String response = this.getRequest(SCAN_OCCURRENCES, uriArgs, query);
        Type returnType = new TypeToken<PagedDetailedScanOccurrence>(){}.getType();
        return (PagedDetailedScanOccurrence)this.getJSON().deserialize(response, returnType);
    }
}

