/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.apiwrapper;

import com.veracode.apiwrapper.services.ServiceManager;
import com.veracode.http.Credentials;
import com.veracode.http.WebClient;
import com.veracode.http.events.PreMakeRequestEventArgs;
import com.veracode.http.events.PreMakeRequestListener;
import com.veracode.http.proxy.ProxyData;
import com.veracode.http.util.HmacAuthHeader;
import com.veracode.parser.text.TextBuilder;
import com.veracode.util.lang.StringUtility;
import java.net.Proxy;
import java.util.NoSuchElementException;
import java.util.Optional;

public abstract class AbstractAPIWrapper {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String XML_API_HOST_ENV_VAR = "VERACODE_XML_API_HOST";
    private static final String BASE_ADDRESS_FORMAT = "https://%s/";
    public static final String BASE_ADDRESS;
    public static final String ENV_ADDRESS;
    private PreMakeRequestListener preMakeRequest;
    protected WebClient webClient = new WebClient();

    public void setUpProxy(Proxy proxy) {
        this.webClient.proxyData = new ProxyData(proxy, null, null);
    }

    public void setUpProxy(String host, String port) {
        this.setUpProxy(host, port, null, null);
    }

    public void setUpProxy(String host, String port, String username, String password) {
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webClient.proxyData = new ProxyData(host, portNumber, username, password != null ? password.toCharArray() : null);
    }

    @Deprecated
    public void setUpCredentials(String username, String password) {
        throw new UnsupportedOperationException(TextBuilder.getDeprecatedUserPassText());
    }

    public void setUpApiCredentials(String profile) {
        Optional<Credentials> creds = null;
        creds = !StringUtility.isNullOrEmpty(profile) ? ServiceManager.getCredentialsService().getCredentials(profile) : ServiceManager.getCredentialsService().getCredentials();
        if (!creds.isPresent()) {
            throw new NoSuchElementException(String.format("The profile '%s' does not exist.", StringUtility.isNullOrEmpty(profile) ? "default" : profile));
        }
        this.setUpApiCredentials(creds.get());
    }

    public void setUpApiCredentials(final Credentials credentials) {
        if (null == credentials) {
            throw new IllegalArgumentException("Credentials is missing.");
        }
        this.clearCredentials();
        String xmlApiHost = null != ENV_ADDRESS ? ENV_ADDRESS : String.format(BASE_ADDRESS_FORMAT, credentials.getRegion().getXmlApiHost());
        this.webClient.baseAddress = xmlApiHost;
        this.preMakeRequest = new PreMakeRequestListener(){

            @Override
            public void preMakeRequest(PreMakeRequestEventArgs e) {
                String authorization = HmacAuthHeader.HmacSha256.calculateAuthorizationHeader(credentials.getId(), credentials.getKey(), e.getHostName(), e.getUriString(), e.getUrlQueryParams(), e.getHttpMethod());
                AbstractAPIWrapper.this.webClient.headers.put(AbstractAPIWrapper.AUTHORIZATION_HEADER, authorization);
            }
        };
        this.webClient.addPreMakeRequestListener(this.preMakeRequest);
    }

    @Deprecated
    public void setUpApiCredentials(String apiID, String apiKey) {
        this.setUpApiCredentials(Credentials.create(apiID, apiKey));
    }

    private void clearCredentials() {
        if (this.webClient.headers.containsKey(AUTHORIZATION_HEADER)) {
            this.webClient.headers.remove(AUTHORIZATION_HEADER);
        }
        if (this.preMakeRequest != null) {
            this.webClient.removePreMakeRequestListener(this.preMakeRequest);
            this.preMakeRequest = null;
        }
        this.webClient.baseAddress = null;
    }

    protected AbstractAPIWrapper() {
        this.webClient.baseAddress = BASE_ADDRESS;
    }

    static {
        String xmlApiHost = System.getenv(XML_API_HOST_ENV_VAR);
        if (!StringUtility.isValidApiHostName(xmlApiHost)) {
            xmlApiHost = ServiceManager.getRegionService().getDefaultRegion().getXmlApiHost();
            ENV_ADDRESS = null;
        } else {
            ENV_ADDRESS = String.format(BASE_ADDRESS_FORMAT, xmlApiHost);
        }
        BASE_ADDRESS = String.format(BASE_ADDRESS_FORMAT, xmlApiHost);
    }
}

