/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.jgit.AgentProxyAwareJschConfigSessionFactory;
import com.vackosar.gitflowincrementalbuild.control.jgit.GitProvider;
import com.vackosar.gitflowincrementalbuild.control.jgit.HttpDelegatingCredentialsProvider;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DifferentFiles {
    private static final String HEAD = "HEAD";
    private static final String REFS_REMOTES = "refs/remotes/";
    private static final String REFS_HEADS = "refs/heads/";
    private static final String REFS_TAGS = "refs/tags/";
    private Logger logger = LoggerFactory.getLogger(DifferentFiles.class);
    @Inject
    private GitProvider gitProvider;
    private final Map<String, String> additionalNativeGitEnvironment = new HashMap<String, String>();

    public Set<Path> get(Configuration config) {
        HashSet<Path> paths = new HashSet<Path>();
        Worker worker = null;
        try {
            worker = new Worker(this.gitProvider.get(config), config);
            worker.fetch();
            worker.checkout();
            if (!config.disableBranchComparison) {
                paths.addAll(worker.getBranchDiff());
            }
            if (config.uncommitted || config.untracked) {
                paths.addAll(worker.getChangesFromStatus());
            }
            if (worker != null) {
                worker.credentialsProvider.resetAll();
            }
        }
        catch (IOException | GitAPIException e) {
            try {
                throw new RuntimeException("Failed to get file differences", e);
            }
            catch (Throwable throwable) {
                if (worker != null) {
                    worker.credentialsProvider.resetAll();
                }
                throw throwable;
            }
        }
        return paths;
    }

    void putAdditionalNativeGitEnvironment(String key, String value) {
        this.additionalNativeGitEnvironment.put(key, value);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Won't fix for 3.x; actual attack vector very unlikely")
    private class Worker {
        private final Git git;
        private final Path workTree;
        private final Configuration configuration;
        private final HttpDelegatingCredentialsProvider credentialsProvider;

        public Worker(Git git, Configuration configuration) {
            this.git = git;
            this.workTree = git.getRepository().getWorkTree().toPath().normalize().toAbsolutePath();
            this.configuration = configuration;
            this.credentialsProvider = new HttpDelegatingCredentialsProvider(this.workTree, DifferentFiles.this.additionalNativeGitEnvironment);
        }

        private Set<Path> getBranchDiff() throws IOException {
            RevCommit base = this.getBranchCommit(this.configuration.baseBranch, false);
            try (TreeWalk treeWalk = new TreeWalk(this.git.getRepository());){
                treeWalk.addTree((AnyObjectId)base.getTree());
                treeWalk.addTree((AnyObjectId)this.resolveReference(base).getTree());
                treeWalk.setFilter(TreeFilter.ANY_DIFF);
                treeWalk.setRecursive(true);
                Set<Path> set = this.getDiff(treeWalk, this.workTree);
                return set;
            }
        }

        private void checkout() throws IOException, GitAPIException {
            if (!(DifferentFiles.HEAD.equals(this.configuration.baseBranch) || this.configuration.baseBranch.startsWith("worktrees/") || this.git.getRepository().getFullBranch().equals(this.configuration.baseBranch))) {
                DifferentFiles.this.logger.info("Checking out base branch " + this.configuration.baseBranch);
                this.git.checkout().setName(this.configuration.baseBranch).call();
            }
        }

        private void fetch() throws GitAPIException {
            if (!this.configuration.disableBranchComparison && this.configuration.fetchReferenceBranch) {
                this.fetch(this.configuration.referenceBranch, true);
            }
            if (this.configuration.fetchBaseBranch) {
                this.fetch(this.configuration.baseBranch, false);
            }
        }

        private void fetch(String branchName, boolean reference) throws GitAPIException {
            String spec;
            String remoteName;
            DifferentFiles.this.logger.info("Fetching " + branchName);
            if (branchName.startsWith(DifferentFiles.REFS_TAGS)) {
                remoteName = this.getSingleRemoteName();
                spec = branchName + ":" + branchName;
            } else {
                if (!branchName.startsWith(DifferentFiles.REFS_REMOTES)) {
                    throw new IllegalArgumentException("Cannot fetch local " + (reference ? "reference" : "base") + " branch '" + branchName + "'. Only remote tracking branches can be fetched, meaning branches starting with '" + DifferentFiles.REFS_REMOTES + "'. Make sure to not confuse remote tracking branches with local branches, 'git branch -a' is your friend!");
                }
                remoteName = this.extractRemoteName(branchName);
                spec = DifferentFiles.REFS_HEADS + this.extractShortName(remoteName, branchName) + ":" + branchName;
            }
            FetchCommand fetchCommand = ((FetchCommand)this.git.fetch().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(spec)});
            if (this.configuration.useJschAgentProxy) {
                fetchCommand.setTransportConfigCallback(transport -> {
                    if (transport instanceof SshTransport) {
                        ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)new AgentProxyAwareJschConfigSessionFactory());
                    }
                });
            }
            fetchCommand.call();
        }

        private String getSingleRemoteName() {
            Set remoteNames = this.git.getRepository().getRemoteNames();
            return remoteNames.size() == 1 ? (String)remoteNames.iterator().next() : "origin";
        }

        private String extractRemoteName(String branchName) {
            return branchName.split("/")[2];
        }

        private String extractShortName(String remoteName, String branchName) {
            return branchName.replaceFirst(DifferentFiles.REFS_REMOTES + remoteName + "/", "");
        }

        private RevCommit getMergeBase(RevCommit baseCommit, RevCommit referenceHeadCommit) throws IOException {
            try (RevWalk walk = new RevWalk(this.git.getRepository());){
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(walk.lookupCommit((AnyObjectId)baseCommit));
                walk.markStart(walk.lookupCommit((AnyObjectId)referenceHeadCommit));
                RevCommit commit = walk.next();
                if (commit == null) {
                    throw new IllegalStateException(String.format("Cannot find merge base, try fetching more history.%n\tbase: %s%n\treference: %s", baseCommit, referenceHeadCommit));
                }
                DifferentFiles.this.logger.info("Using merge base of id: " + commit.getId());
                RevCommit revCommit = commit;
                return revCommit;
            }
        }

        private Set<Path> getDiff(TreeWalk treeWalk, Path gitDir) throws IOException {
            HashSet<Path> paths = new HashSet<Path>();
            while (treeWalk.next()) {
                Path path = Paths.get(treeWalk.getPathString(), new String[0]).normalize();
                if (!this.pathIncluded(path)) continue;
                paths.add(gitDir.resolve(path));
            }
            return paths;
        }

        private RevCommit getBranchCommit(String branchName, boolean reference) throws IOException {
            Repository repository = this.git.getRepository();
            ObjectId objectId = repository.resolve(branchName);
            boolean isRemoteTrackingBranch = branchName.startsWith(DifferentFiles.REFS_REMOTES);
            String branchDesc = String.format("%s %s branch '%s'", isRemoteTrackingBranch ? "remote tracking" : "local", reference ? "reference" : "base", branchName);
            if (objectId == null) {
                if (repository.simplify(branchName) != null) {
                    throw new SkipExecutionException("Could not get Git ObjectId for " + branchDesc + ". Is this repository empty (no commits yet)?");
                }
                if (isRemoteTrackingBranch && repository.getRemoteNames().isEmpty()) {
                    throw new SkipExecutionException("Could not get Git ObjectId for " + branchDesc + ". No remotes found at all, push still pending?");
                }
                throw new IllegalArgumentException("Git " + branchDesc + " not found. Make sure it exists by creating it explicitly via 'git branch/checkout/switch ...' or by fetching it from the remote repository via 'git fetch <remote> <branch>:<branch>' (or just 'git fetch <branch>'). Also make sure to not confuse remote tracking branches (refs/remotes/...) with local branches, 'git branch -a' is your friend!");
            }
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
                DifferentFiles.this.logger.info("Reference commit of " + branchDesc + " has id: " + commit.getId());
                RevCommit revCommit = commit;
                return revCommit;
            }
        }

        private Set<Path> getChangesFromStatus() throws GitAPIException {
            HashSet changes = new HashSet();
            Status status = this.git.status().call();
            if (this.configuration.uncommitted) {
                changes.addAll(status.getUncommittedChanges());
            }
            if (this.configuration.untracked) {
                changes.addAll(status.getUntracked());
            }
            return changes.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::normalize).filter(this::pathIncluded).map(this.workTree::resolve).collect(Collectors.toSet());
        }

        private RevCommit resolveReference(RevCommit base) throws IOException {
            RevCommit refHead = this.getBranchCommit(this.configuration.referenceBranch, true);
            if (this.configuration.compareToMergeBase) {
                return this.getMergeBase(base, refHead);
            }
            return refHead;
        }

        private boolean pathIncluded(Path path) {
            String pathString = path.toString();
            if (this.configuration.skipIfPathMatches.map(pred -> pred.test(pathString)).orElse(false).booleanValue()) {
                throw new SkipExecutionException("Changed path matches regex defined by skipIfPathMatches: " + pathString);
            }
            boolean excluded = this.configuration.excludePathsMatching.map(pred -> pred.test(pathString)).orElse(false);
            boolean included = !excluded && this.configuration.includePathsMatching.map(pred -> pred.test(pathString)).orElse(true) != false;
            DifferentFiles.this.logger.debug("included {}: {}", (Object)included, (Object)pathString);
            return included;
        }
    }
}

