/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.DifferentFiles;
import com.vackosar.gitflowincrementalbuild.control.Modules;
import com.vackosar.gitflowincrementalbuild.control.jgit.GitProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class ChangedProjects {
    public static final String CTX_TEST_ONLY = ChangedProjects.class.getName() + "#TEST-ONLY";
    private Logger logger = LoggerFactory.getLogger(ChangedProjects.class);
    @Inject
    private DifferentFiles differentFiles;
    @Inject
    private Modules modules;
    @Inject
    private GitProvider gitProvider;

    public Set<MavenProject> get(Configuration config) throws GitAPIException, IOException {
        Map<Path, List<MavenProject>> modulesPathMap = this.modules.createPathMap(config.mavenSession);
        Path projectRoot = this.gitProvider.getProjectRoot(config);
        return this.differentFiles.get(config).stream().flatMap(path -> this.findProject((Path)path, modulesPathMap, projectRoot).stream()).collect(Collectors.toSet());
    }

    private List<MavenProject> findProject(Path diffPath, Map<Path, List<MavenProject>> modulesPathMap, Path projectRoot) {
        Path path;
        for (path = this.stripSrcSubpath(diffPath, projectRoot); path != null && !modulesPathMap.containsKey(path) && !Files.exists(path.resolve("pom.xml"), new LinkOption[0]); path = path.getParent()) {
        }
        if (path == null) {
            this.logger.warn("Ignoring changed file outside build project: {}", (Object)diffPath);
            return Collections.emptyList();
        }
        List<MavenProject> changedReactorProjects = modulesPathMap.get(path);
        if (changedReactorProjects == null) {
            this.logger.warn("Ignoring changed file in non-reactor module: {}", (Object)diffPath);
            return Collections.emptyList();
        }
        this.logger.debug("Changed file: {}", (Object)diffPath);
        for (MavenProject changedReactorProject : changedReactorProjects) {
            Boolean testOnlyFlag = (Boolean)changedReactorProject.getContextValue(CTX_TEST_ONLY);
            if (Boolean.FALSE.equals(testOnlyFlag)) continue;
            changedReactorProject.setContextValue(CTX_TEST_ONLY, (Object)diffPath.startsWith(path.resolve("src").resolve("test")));
        }
        return changedReactorProjects;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Extremely unlikely that getFileName() or getRoot() will return null here.")
    private Path stripSrcSubpath(Path path, Path projectRoot) {
        int elementIndex = 0;
        Path relativePath = projectRoot.relativize(path);
        for (Path element : relativePath) {
            if (element.getFileName().toString().equals("src")) {
                return projectRoot.resolve(relativePath.subpath(0, elementIndex));
            }
            ++elementIndex;
        }
        return path;
    }
}

