/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.DifferentFiles;
import com.vackosar.gitflowincrementalbuild.control.Modules;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class ChangedProjects {
    public static final String CTX_TEST_ONLY = ChangedProjects.class.getName() + "#TEST-ONLY";
    private Logger logger = LoggerFactory.getLogger(ChangedProjects.class);
    @Inject
    private DifferentFiles differentFiles;
    @Inject
    private Modules modules;

    public Set<MavenProject> get(Configuration config) throws GitAPIException, IOException {
        Map<Path, MavenProject> modulesPathMap = this.modules.createPathMap(config.mavenSession);
        return this.differentFiles.get(config).stream().map(path -> this.findProject((Path)path, modulesPathMap)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private MavenProject findProject(Path diffPath, Map<Path, MavenProject> modulesPathMap) {
        Path path;
        for (path = diffPath; path != null && !modulesPathMap.containsKey(path) && !Files.exists(path.resolve("pom.xml"), new LinkOption[0]); path = path.getParent()) {
        }
        if (path == null) {
            this.logger.warn("Ignoring changed file outside build project: {}", (Object)diffPath);
            return null;
        }
        MavenProject changedReactorProject = modulesPathMap.get(path);
        if (changedReactorProject == null) {
            this.logger.warn("Ignoring changed file in non-reactor module: {}", (Object)diffPath);
            return null;
        }
        this.logger.debug("Changed file: {}", (Object)diffPath);
        Boolean testOnlyFlag = (Boolean)changedReactorProject.getContextValue(CTX_TEST_ONLY);
        if (!Boolean.FALSE.equals(testOnlyFlag)) {
            changedReactorProject.setContextValue(CTX_TEST_ONLY, (Object)diffPath.startsWith(path.resolve("src").resolve("test")));
        }
        return changedReactorProject;
    }
}

