/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.ChangedProjects;
import com.vackosar.gitflowincrementalbuild.control.jgit.GitProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.ModelBase;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
class UnchangedProjectsRemover {
    private static final String MAVEN_TEST_SKIP = "maven.test.skip";
    private static final String MAVEN_TEST_SKIP_EXEC = "skipTests";
    private static final String TEST_JAR_DETECTED = "Dependency with test-jar goal detected. Will compile test sources.";
    private static final String GOAL_TEST_JAR = "test-jar";
    private static final String PCKG_POM = "pom";
    private Logger logger = LoggerFactory.getLogger(UnchangedProjectsRemover.class);
    @Inject
    private ChangedProjects changedProjects;
    @Inject
    private GitProvider gitProvider;
    private final Map<String, Set<MavenProject>> downstreamCache = new HashMap<String, Set<MavenProject>>();

    UnchangedProjectsRemover() {
    }

    void act(Configuration config) throws GitAPIException, IOException {
        try {
            this.doAct(config);
        }
        finally {
            this.downstreamCache.clear();
        }
    }

    private void doAct(Configuration config) throws GitAPIException, IOException {
        Set<MavenProject> selected;
        LazyMavenProjectComparator projectComparator = new LazyMavenProjectComparator(config.mavenSession);
        config.logImpactedTo.ifPresent(logFilePath -> this.writeImpactedLogFile(Collections.emptySet(), (Path)logFilePath, projectComparator, config));
        if (config.disableSelectedProjectsHandling) {
            selected = Collections.emptySet();
        } else {
            selected = ProjectSelectionUtil.gatherSelectedProjects(config.mavenSession);
            if (this.onlySelectedModulesPresent(selected, config.mavenSession)) {
                this.printDelimiter();
                this.logger.info("Building explicitly selected projects (without any adjustment): {}", (Object)config.mavenSession.getProjects().stream().map(MavenProject::getArtifactId).collect(Collectors.joining(", ")));
                return;
            }
            if (!config.mavenSession.getRequest().isRecursive() || this.onlySingleLeafModulePresent(config)) {
                this.printDelimiter();
                this.logger.info("Building single project (without any adjustment): {}", (Object)config.currentProject.getArtifactId());
                return;
            }
        }
        Set<MavenProject> changed = this.changedProjects.get(config);
        this.printDelimiter();
        if (changed.isEmpty()) {
            this.handleNoChangesDetected(selected, projectComparator, config);
            return;
        }
        this.logProjects(changed, "Changed Artifacts:", projectComparator, config.mavenSession);
        Set<MavenProject> impacted = this.calculateImpactedProjects(selected, changed, config);
        config.logImpactedTo.ifPresent(logFilePath -> this.writeImpactedLogFile(impacted, (Path)logFilePath, projectComparator, config));
        if (!config.buildAll) {
            this.modifyProjectList(selected, changed, impacted, projectComparator, config);
        } else {
            config.mavenSession.getProjects().stream().filter(proj -> !impacted.contains(proj)).forEach(proj -> this.applyUpstreamModuleArgs((MavenProject)proj, config));
        }
    }

    private boolean onlySelectedModulesPresent(Set<MavenProject> selected, MavenSession mavenSession) {
        return !selected.isEmpty() && mavenSession.getProjects().equals(new ArrayList<MavenProject>(selected));
    }

    private boolean onlySingleLeafModulePresent(Configuration config) {
        return config.mavenSession.getProjects().size() == 1 && config.currentProject.getModel().getModules().isEmpty();
    }

    private void handleNoChangesDetected(Set<MavenProject> selected, LazyMavenProjectComparator projectComparator, Configuration config) {
        if (!selected.isEmpty()) {
            this.logger.info("No changed artifacts detected: Building just explicitly selected projects (and their upstream and/or downstream, if requested).");
            Set selectedAndDownstream = selected.stream().flatMap(proj -> this.streamProjectWithDownstreamProjects((MavenProject)proj, config)).collect(Collectors.toSet());
            if (Configuration.isMakeBehaviourActive("make-upstream", config.mavenSession)) {
                if (config.buildUpstreamMode == Configuration.BuildUpstreamMode.NONE) {
                    config.mavenSession.setProjects(selectedAndDownstream.stream().sorted(projectComparator).collect(Collectors.toList()));
                } else {
                    config.mavenSession.getProjects().stream().filter(proj -> !selectedAndDownstream.contains(proj)).forEach(proj -> this.applyUpstreamModuleArgs((MavenProject)proj, config));
                }
            }
            if (Configuration.isMakeBehaviourActive("make-downstream", config.mavenSession) && !config.buildDownstream) {
                config.mavenSession.setProjects(config.mavenSession.getProjects().stream().filter(proj -> selected.contains(proj) || !selectedAndDownstream.contains(proj)).collect(Collectors.toList()));
            }
        } else if (config.buildAllIfNoChanges) {
            this.logger.info("No changed artifacts detected: Building all modules in buildAll mode.");
            this.logger.info("- skip tests: {}", (Object)config.skipTestsForUpstreamModules);
            this.logger.info("- additional args: {}", config.argsForUpstreamModules);
            config.mavenSession.getProjects().stream().forEach(proj -> this.applyUpstreamModuleArgs((MavenProject)proj, config));
        } else {
            this.logger.info("No changed artifacts detected: Executing validate goal on current project only, skipping all submodules.");
            config.mavenSession.setProjects(Collections.singletonList(this.applyUpstreamModuleArgs(config.currentProject, config)));
            config.mavenSession.getGoals().clear();
            config.mavenSession.getGoals().add("validate");
        }
    }

    private Set<MavenProject> calculateImpactedProjects(Set<MavenProject> selected, Set<MavenProject> changed, Configuration config) {
        Stream<Object> impacted;
        Stream stream = impacted = selected.isEmpty() ? changed.stream() : selected.stream();
        if (config.buildAll || config.buildDownstream) {
            impacted = impacted.flatMap(proj -> this.streamProjectWithDownstreamProjects((MavenProject)proj, config));
        }
        return impacted.filter(config.mavenSession.getProjects()::contains).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void writeImpactedLogFile(Set<MavenProject> impacted, Path logFilePath, LazyMavenProjectComparator projectComparator, Configuration config) {
        List projectsToLog;
        if (impacted.isEmpty()) {
            projectsToLog = Collections.emptyList();
        } else {
            Path projectRootDir = this.gitProvider.get(config).getRepository().getDirectory().toPath().getParent();
            projectsToLog = impacted.stream().sorted(projectComparator).map(proj -> projectRootDir.relativize(proj.getBasedir().toPath()).toString()).collect(Collectors.toList());
        }
        this.logger.debug("Writing impacted projects to {}: {}", (Object)logFilePath, projectsToLog);
        try {
            Files.write(logFilePath, projectsToLog, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write impacted projects to " + logFilePath + ": " + impacted, e);
        }
    }

    private void modifyProjectList(Set<MavenProject> selected, Set<MavenProject> changed, Set<MavenProject> impacted, LazyMavenProjectComparator projectComparator, Configuration config) {
        Set<MavenProject> rebuild = this.calculateRebuildProjects(selected, changed, impacted, config);
        if (rebuild.isEmpty()) {
            this.handleNoChangesDetected(selected, projectComparator, config);
        } else {
            if (!config.forceBuildModules.isEmpty()) {
                Set forceBuildModules = config.mavenSession.getProjects().stream().filter(proj -> !rebuild.contains(proj)).filter(proj -> this.matchesAny(proj.getArtifactId(), config.forceBuildModules)).map(proj -> this.applyUpstreamModuleArgs((MavenProject)proj, config)).collect(Collectors.toCollection(LinkedHashSet::new));
                rebuild.addAll(forceBuildModules);
            }
            config.mavenSession.setProjects(rebuild.stream().sorted(projectComparator).collect(Collectors.toList()));
        }
    }

    private Set<MavenProject> calculateRebuildProjects(Set<MavenProject> selected, Set<MavenProject> changed, Set<MavenProject> impacted, Configuration config) {
        Set<MavenProject> upstreamRequiringProjects;
        Configuration.BuildUpstreamMode buildUpstreamMode = config.buildUpstreamMode;
        switch (buildUpstreamMode) {
            case NONE: {
                return impacted;
            }
            case CHANGED: {
                upstreamRequiringProjects = selected.isEmpty() ? changed : selected;
                break;
            }
            case IMPACTED: {
                upstreamRequiringProjects = impacted;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported BuildUpstreamMode: " + (Object)((Object)buildUpstreamMode));
            }
        }
        Set upstreamProjects = upstreamRequiringProjects.stream().flatMap(proj -> this.streamUpstreamProjects((MavenProject)proj, config.mavenSession)).filter(proj -> !impacted.contains(proj)).peek(proj -> this.applyUpstreamModuleArgs((MavenProject)proj, config)).collect(Collectors.toCollection(LinkedHashSet::new));
        return config.mavenSession.getProjects().stream().filter(proj -> impacted.contains(proj) || upstreamProjects.contains(proj)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private MavenProject applyUpstreamModuleArgs(MavenProject mavenProject, Configuration config) {
        Properties projectProperties = mavenProject.getProperties();
        if (config.skipTestsForUpstreamModules) {
            if (this.projectDeclaresTestJarGoal(mavenProject)) {
                this.logger.debug("{}: {}", (Object)mavenProject.getArtifactId(), (Object)TEST_JAR_DETECTED);
                projectProperties.setProperty(MAVEN_TEST_SKIP_EXEC, Boolean.TRUE.toString());
            } else {
                projectProperties.setProperty(MAVEN_TEST_SKIP, Boolean.TRUE.toString());
            }
        }
        config.argsForUpstreamModules.forEach(projectProperties::setProperty);
        return mavenProject;
    }

    private boolean projectDeclaresTestJarGoal(MavenProject project) {
        return project.getBuildPlugins().stream().flatMap(proj -> proj.getExecutions().stream()).flatMap(e -> e.getGoals().stream()).anyMatch(GOAL_TEST_JAR::equals);
    }

    private void logProjects(Set<MavenProject> projects, String title, LazyMavenProjectComparator projectComparator, MavenSession mavenSession) {
        this.logger.info(title);
        this.logger.info("");
        projects.stream().sorted(projectComparator).map(proj -> {
            String entry = proj.getArtifactId();
            if (!mavenSession.getProjects().contains(proj)) {
                entry = entry + " (but deselected)";
            }
            return entry;
        }).forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
        this.logger.info("");
    }

    private void printDelimiter() {
        this.logger.info("------------------------------------------------------------------------");
    }

    private Stream<MavenProject> streamProjectWithDownstreamProjects(MavenProject project, Configuration config) {
        return this.streamProjectWithDownstreamProjects(project, false, config);
    }

    private Stream<MavenProject> streamProjectWithDownstreamProjects(MavenProject project, boolean testJarOnly, Configuration config) {
        String cacheKey = project.hashCode() + "_" + testJarOnly;
        Set<MavenProject> downstream = this.downstreamCache.get(cacheKey);
        if (downstream == null) {
            downstream = new LinkedHashSet<MavenProject>();
            downstream.add(project);
            if (testJarOnly || Boolean.TRUE.equals(project.getContextValue(ChangedProjects.CTX_TEST_ONLY))) {
                if (this.projectDeclaresTestJarGoal(project)) {
                    config.mavenSession.getProjectDependencyGraph().getDownstreamProjects(project, false).stream().flatMap(downstreamProj -> this.getTestJarDependencyScope((MavenProject)downstreamProj, project).map(depScope -> this.streamProjectWithDownstreamProjects((MavenProject)downstreamProj, depScope.equals("test"), config)).orElseGet(Stream::empty)).filter(downstreamProj -> this.isDownstreamModuleNotExcluded((MavenProject)downstreamProj, config)).forEach(downstream::add);
                }
            } else {
                config.mavenSession.getProjectDependencyGraph().getDownstreamProjects(project, true).stream().filter(downstreamProj -> this.isDownstreamModuleNotExcluded((MavenProject)downstreamProj, config)).forEach(downstream::add);
            }
            if (PCKG_POM.equals(project.getPackaging())) {
                downstream.addAll(this.findBOMDownstreamProjects(project, downstream, config));
            }
            this.downstreamCache.put(cacheKey, downstream);
        }
        return downstream.stream();
    }

    private Optional<String> getTestJarDependencyScope(MavenProject project, MavenProject testJarProvidingProject) {
        return project.getDependencies().stream().filter(dep -> dep.getType().equals(GOAL_TEST_JAR) && dep.getArtifactId().equals(testJarProvidingProject.getArtifactId()) && dep.getGroupId().equals(testJarProvidingProject.getGroupId()) && dep.getVersion().equals(testJarProvidingProject.getVersion())).findFirst().map(dep -> Optional.of(dep.getScope()).orElse("compile"));
    }

    private boolean isDownstreamModuleNotExcluded(MavenProject proj, Configuration config) {
        return !config.excludeDownstreamModulesPackagedAs.contains(proj.getPackaging());
    }

    private Set<MavenProject> findBOMDownstreamProjects(MavenProject potentialBOMProject, Set<MavenProject> downstream, Configuration config) {
        return config.mavenSession.getAllProjects().stream().filter(proj -> !downstream.contains(proj)).filter(proj -> this.isDownstreamModuleNotExcluded((MavenProject)proj, config)).filter(proj -> this.importsBOM((MavenProject)proj, potentialBOMProject, config)).flatMap(proj -> this.streamProjectWithDownstreamProjects((MavenProject)proj, config)).filter(config.mavenSession.getProjects()::contains).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Boolean importsBOM(MavenProject project, MavenProject potentialBOMProject, Configuration config) {
        return Optional.ofNullable(project.getOriginalModel()).map(ModelBase::getDependencyManagement).map(depMgtm -> depMgtm.getDependencies().stream().anyMatch(dep -> this.isBOMImport((Dependency)dep, potentialBOMProject, project, config))).orElse(false);
    }

    private boolean isBOMImport(Dependency dependency, MavenProject potentialBOMProject, MavenProject depDefiningProject, Configuration config) {
        LazyExpressionEvaluator evaluator = new LazyExpressionEvaluator(config.mavenSession, depDefiningProject);
        return Objects.equals(evaluator.evaluate(dependency.getType()), PCKG_POM) && Objects.equals(evaluator.evaluate(dependency.getScope()), "import") && Objects.equals(evaluator.evaluate(dependency.getArtifactId()), potentialBOMProject.getArtifactId()) && Objects.equals(evaluator.evaluate(dependency.getGroupId()), potentialBOMProject.getGroupId()) && Objects.equals(evaluator.evaluate(dependency.getVersion()), potentialBOMProject.getVersion());
    }

    private Stream<MavenProject> streamUpstreamProjects(MavenProject project, MavenSession mavenSession) {
        return mavenSession.getProjectDependencyGraph().getUpstreamProjects(project, true).stream();
    }

    private boolean matchesAny(String str, Collection<Pattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matcher(str).matches());
    }

    private static class LazyExpressionEvaluator {
        private static final Logger LOGGER = LoggerFactory.getLogger(LazyExpressionEvaluator.class);
        private final MavenSession session;
        private final MavenProject project;
        private TypeAwareExpressionEvaluator evaluator;

        public LazyExpressionEvaluator(MavenSession session, MavenProject project) {
            this.session = session;
            this.project = project;
        }

        public String evaluate(String expression) {
            if (expression == null || !expression.contains("${")) {
                return expression;
            }
            if (this.evaluator == null) {
                MavenSession clonedSession = this.session.clone();
                clonedSession.setCurrentProject(this.project);
                this.evaluator = new PluginParameterExpressionEvaluator(clonedSession, new MojoExecution(new MojoDescriptor()));
            }
            try {
                return this.evaluator.evaluate(expression, String.class).toString();
            }
            catch (ExpressionEvaluationException e) {
                LOGGER.warn("Failed to evaluate: " + expression, (Throwable)e);
                return expression;
            }
        }
    }

    static class LazyMavenProjectComparator
    implements Comparator<MavenProject> {
        private final MavenSession mavenSession;
        private Map<MavenProject, Integer> indexMap;

        public LazyMavenProjectComparator(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
        }

        @Override
        public int compare(MavenProject proj1, MavenProject proj2) {
            if (this.indexMap == null) {
                List projects = this.mavenSession.getProjects();
                this.indexMap = IntStream.range(0, projects.size()).boxed().collect(Collectors.toMap(projects::get, i -> i));
                List allProjects = this.mavenSession.getAllProjects();
                if (allProjects.size() > projects.size()) {
                    for (int i2 = 0; i2 < allProjects.size(); ++i2) {
                        MavenProject proj = (MavenProject)allProjects.get(i2);
                        if (this.indexMap.containsKey(proj)) continue;
                        this.indexMap.put(proj, i2 + 100000);
                    }
                }
            }
            return this.indexMap.getOrDefault(proj1, Integer.MAX_VALUE).compareTo(this.indexMap.getOrDefault(proj2, Integer.MAX_VALUE));
        }
    }

    private static class ProjectSelectionUtil {
        private ProjectSelectionUtil() {
        }

        static Set<MavenProject> gatherSelectedProjects(MavenSession mavenSession) {
            List selectors = mavenSession.getRequest().getSelectedProjects();
            if (selectors.isEmpty()) {
                return Collections.emptySet();
            }
            File reactorDirectory = Optional.ofNullable(mavenSession.getRequest().getBaseDirectory()).map(File::new).orElse(null);
            return mavenSession.getProjects().stream().filter(proj -> selectors.stream().anyMatch(sel -> ProjectSelectionUtil.matchesSelector(proj, sel, reactorDirectory))).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        private static boolean matchesSelector(MavenProject project, String selector, File reactorDirectory) {
            if (selector.contains(":")) {
                String id = ':' + project.getArtifactId();
                if (id.equals(selector)) {
                    return true;
                }
                id = project.getGroupId() + id;
                if (id.equals(selector)) {
                    return true;
                }
            } else if (reactorDirectory != null) {
                File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
                if (selectedProject.isFile()) {
                    return selectedProject.equals(project.getFile());
                }
                if (selectedProject.isDirectory()) {
                    return selectedProject.equals(project.getBasedir());
                }
            }
            return false;
        }
    }
}

