/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.boundary.UnchangedProjectsRemover;
import com.vackosar.gitflowincrementalbuild.control.Property;
import com.vackosar.gitflowincrementalbuild.control.jgit.GitProvider;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private Logger logger = LoggerFactory.getLogger(MavenLifecycleParticipant.class);
    @Inject
    private UnchangedProjectsRemover unchangedProjectsRemover;
    @Inject
    private GitProvider gitProvider;
    private final String implVersion;

    public MavenLifecycleParticipant() {
        this.implVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
    }

    MavenLifecycleParticipant(String implVersion) {
        this.implVersion = implVersion;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Configuration config = new Configuration(session);
        if (config.help) {
            this.logHelp();
        }
        if (config.disable) {
            this.logger.info("gitflow-incremental-builder is disabled.");
            return;
        }
        if (session.getProjectDependencyGraph() == null) {
            this.logger.warn("Execution of gitflow-incremental-builder is not supported in this environment: Current MavenSession does not provide a ProjectDependencyGraph. Consider disabling gitflow-incremental-builder via property '" + Property.disable.name() + "'.");
            return;
        }
        try {
            this.perform(config);
        }
        finally {
            this.gitProvider.close();
        }
    }

    private void logHelp() {
        this.logger.info("gitflow-incremental-builder {} help:\n{}\nFor more help see: {}/tree/version/{}#configuration\n", new Object[]{this.implVersion, Property.exemplifyAll(), "https://github.com/gitflow-incremental-builder/gitflow-incremental-builder", this.implVersion});
    }

    private void perform(Configuration config) throws MavenExecutionException {
        try {
            if (this.isDisabledForReferenceBranch(config) || this.isDisabledForCurrentBranch(config)) {
                return;
            }
            this.logger.info("gitflow-incremental-builder {} starting...", (Object)this.implVersion);
            this.warnIfBuggyOrUnsupportedMavenVersion(MavenSession.class.getPackage().getImplementationVersion(), config);
            this.unchangedProjectsRemover.act(config);
        }
        catch (Exception e) {
            boolean isSkipExecException = e instanceof SkipExecutionException;
            if (!config.failOnError || isSkipExecException) {
                this.logger.info("gitflow-incremental-builder execution skipped: {}", (Object)(isSkipExecException ? e.getMessage() : e.toString()));
                this.logger.debug("Full exception:", (Throwable)e);
            }
            throw new MavenExecutionException("Exception during gitflow-incremental-builder execution occurred.", (Throwable)e);
        }
        this.logger.info("gitflow-incremental-builder exiting...");
    }

    private boolean isDisabledForReferenceBranch(Configuration config) {
        boolean matches = config.disableIfReferenceBranchMatches.map(predicate -> predicate.test(config.referenceBranch)).orElse(false);
        if (matches) {
            this.logger.info("gitflow-incremental-builder is disabled for reference branch: {}", (Object)config.referenceBranch);
        }
        return matches;
    }

    private boolean isDisabledForCurrentBranch(Configuration config) {
        return config.disableIfBranchMatches.map(predicate -> {
            try {
                String branch = this.gitProvider.get(config).getRepository().getBranch();
                boolean matches = predicate.test(branch);
                if (matches) {
                    this.logger.info("gitflow-incremental-builder is disabled for the current branch: {}", (Object)branch);
                }
                return matches;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(false);
    }

    void warnIfBuggyOrUnsupportedMavenVersion(String mavenVersion, Configuration config) {
        if (mavenVersion == null) {
            this.logger.warn("Could not get Maven version.");
        } else if (!(mavenVersion.startsWith("3.8.") || mavenVersion.startsWith("3.6.") || mavenVersion.startsWith("3.5."))) {
            if (mavenVersion.startsWith("3.3.")) {
                if (!(mavenVersion.equals("3.3.0") || !config.disableSelectedProjectsHandling && config.mavenSession.getRequest().getSelectedProjects().isEmpty())) {
                    this.logger.warn("Detected Maven {} is affected by https://issues.apache.org/jira/browse/MNG-6173.", (Object)mavenVersion);
                    this.logger.warn("More details: https://github.com/gitflow-incremental-builder/gitflow-incremental-builder/issues/324");
                }
            } else {
                this.logger.warn("Detected Maven {} was not tested with gitflow-incremental-builder.", (Object)mavenVersion);
            }
        }
    }
}

