/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class VaadinHintsRegistrar
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints ref = hints.reflection();
        LookupInitializer.getDefaultImplementations().forEach(cls -> ref.registerType(cls, MemberCategory.values()));
        hints.resources().registerPattern("META-INF/VAADIN/*");
        hints.resources().registerPattern("vaadin-i18n/*");
        for (String cls2 : this.getClasses()) {
            hints.reflection().registerType(TypeReference.of((String)cls2), MemberCategory.values());
        }
        for (String componentClass : this.getCommonComponentClasses()) {
            hints.reflection().registerType(TypeReference.of((String)componentClass), MemberCategory.values());
        }
        this.registerResourceIfPresent(hints, "com/vaadin/flow/component/login/i18n.json");
        this.registerResourceIfPresent(hints, "com/vaadin/flow/component/crud/i18n.json");
        hints.resources().registerPattern("com/vaadin/flow/server/*");
        hints.resources().registerPattern("com/vaadin/flow/router/*");
    }

    private void registerResourceIfPresent(RuntimeHints hints, String path) {
        ClassPathResource res = new ClassPathResource(path);
        if (res.exists()) {
            hints.resources().registerResource((Resource)res);
        }
    }

    private Set<String> getCommonComponentClasses() {
        HashSet<String> classes = new HashSet<String>(List.of("com.vaadin.flow.component.messages.MessageListItem"));
        Predicate<String> i18nClasses = className -> className.matches(".*I18[nN]($|\\$.*$)");
        Predicate<String> componentsFilter = i18nClasses.or(className -> className.startsWith("com.vaadin.flow.component.charts.model.") || className.startsWith("com.vaadin.flow.component.map.configuration."));
        classes.addAll(VaadinHintsRegistrar.classesFromPackage("com.vaadin.flow.component", componentsFilter));
        return classes;
    }

    private static Set<String> classesFromPackage(String packageName, Predicate<String> filter) {
        return new Reflections((Configuration)new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).setScanners(new Scanner[]{Scanners.SubTypes})).getAll((Scanner)Scanners.SubTypes).stream().filter(cl -> cl.startsWith(packageName)).filter(filter).collect(Collectors.toSet());
    }

    private String[] getClasses() {
        return new String[]{"org.apache.catalina.core.ApplicationContextFacade", "org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler$SupplierCsrfToken", "org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter", "org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", DefaultErrorHandler.class.getName()};
    }
}

