/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar;

import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarItem;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;

class MenuBarRootItem
extends MenuBarItem {
    private MenuBar menuBar;

    MenuBarRootItem(MenuBar menuBar, SerializableRunnable contentReset) {
        super(null, contentReset);
        this.menuBar = menuBar;
    }

    public void setCheckable(boolean checkable) {
        if (checkable) {
            throw new UnsupportedOperationException("A root level item in a MenuBar can not be checkable");
        }
    }

    public void addThemeNames(String ... themeNames) {
        super.addThemeNames(themeNames);
        this.menuBar.updateButtons();
    }

    public void removeThemeNames(String ... themeNames) {
        super.removeThemeNames(themeNames);
        this.menuBar.updateButtons();
    }

    @Override
    public void addClassName(String className) {
        super.addClassName(className);
        this.updateClassName();
    }

    @Override
    public void addClassNames(String ... classNames) {
        super.addClassNames(classNames);
        this.updateClassName();
    }

    @Override
    public void setClassName(String className) {
        super.setClassName(className);
        this.updateClassName();
    }

    @Override
    public void setClassName(String className, boolean set) {
        super.setClassName(className, set);
        this.updateClassName();
    }

    @Override
    public boolean removeClassName(String className) {
        boolean result = super.removeClassName(className);
        this.updateClassName();
        return result;
    }

    @Override
    public void removeClassNames(String ... classNames) {
        super.removeClassNames(classNames);
        this.updateClassName();
    }

    private void updateClassName() {
        this.getElement().executeJs("window.Vaadin.Flow.menubarConnector.setClassName(this)", new Serializable[0]);
        this.menuBar.updateButtons();
    }
}

