/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.open.OSUtils;
import com.vaadin.open.Open;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenInCurrentIde {
    private OpenInCurrentIde() {
    }

    public static boolean openFile(File file, int lineNumber) {
        String absolutePath = file.getAbsolutePath();
        Optional<ProcessHandle.Info> maybeIdeCommand = OpenInCurrentIde.findIdeCommandInfo();
        if (!maybeIdeCommand.isPresent()) {
            OpenInCurrentIde.getLogger().debug("Unable to detect IDE from process tree");
            OpenInCurrentIde.printProcessTree(msg -> OpenInCurrentIde.getLogger().debug(msg));
            return false;
        }
        ProcessHandle.Info processInfo = maybeIdeCommand.get();
        if (OpenInCurrentIde.isVSCode(processInfo)) {
            return Open.open((String)("vscode://file" + absolutePath + ":" + lineNumber));
        }
        if (OpenInCurrentIde.isIdea(processInfo)) {
            try {
                OpenInCurrentIde.run(OpenInCurrentIde.getBinary(processInfo), "--line", "" + lineNumber, absolutePath);
                return true;
            }
            catch (Exception e) {
                OpenInCurrentIde.getLogger().error("Unable to launch IntelliJ IDEA", (Throwable)e);
            }
        } else if (OpenInCurrentIde.isEclipse(processInfo)) {
            if (OSUtils.isMac()) {
                try {
                    OpenInCurrentIde.run("open", "-a", OpenInCurrentIde.getBinary(processInfo), absolutePath);
                    return true;
                }
                catch (Exception e) {
                    OpenInCurrentIde.getLogger().error("Unable to launch Eclipse", (Throwable)e);
                }
            } else {
                try {
                    OpenInCurrentIde.run(OpenInCurrentIde.getBinary(processInfo), absolutePath + ":" + lineNumber);
                    return true;
                }
                catch (Exception e) {
                    OpenInCurrentIde.getLogger().error("Unable to launch Eclipse", (Throwable)e);
                }
            }
        }
        return false;
    }

    static String getBinary(ProcessHandle.Info info) {
        String cmd = info.command().get();
        if (OpenInCurrentIde.isIdea(info)) {
            return OpenInCurrentIde.getIdeaBinary(info);
        }
        if (OpenInCurrentIde.isEclipse(info)) {
            return cmd.replaceFirst("/Contents/MacOS/eclipse$", "");
        }
        return cmd;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(OpenInCurrentIde.class);
    }

    public static void main(String[] args) {
        OpenInCurrentIde.printProcessTree(System.out::println);
    }

    private static void printProcessTree(Consumer<String> printer) {
        for (ProcessHandle.Info info : OpenInCurrentIde.getProcessTree()) {
            printer.accept("Process tree:");
            info.command().ifPresent(value -> printer.accept("Command: " + value));
            info.commandLine().ifPresent(value -> printer.accept("Command line: " + value));
            info.arguments().ifPresent(values -> {
                for (int i = 0; i < ((String[])values).length; ++i) {
                    printer.accept("Arguments[" + i + "]: " + values[i]);
                }
            });
            printer.accept("");
        }
    }

    static void run(String command, String ... arguments) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(command);
        cmd.addAll(Arrays.asList(arguments));
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
            throw new IOException("Command " + cmd + " terminated with exit code " + exitCode + ".\nOutput:\n" + output);
        }
    }

    private static List<ProcessHandle.Info> getProcessTree() {
        return OpenInCurrentIde.getParentProcesses().stream().map(p -> p.info()).collect(Collectors.toList());
    }

    private static Optional<ProcessHandle.Info> findIdeCommandInfo() {
        return OpenInCurrentIde.findIdeCommand(OpenInCurrentIde.getProcessTree());
    }

    static Optional<ProcessHandle.Info> findIdeCommand(List<ProcessHandle.Info> processes) {
        for (ProcessHandle.Info info : processes) {
            if (!OpenInCurrentIde.isIdea(info) && !OpenInCurrentIde.isVSCode(info) && !OpenInCurrentIde.isEclipse(info)) continue;
            return Optional.of(info);
        }
        return Optional.empty();
    }

    private static String getCommandAndArguments(ProcessHandle.Info info) {
        return info.commandLine().orElse(null);
    }

    private static List<ProcessHandle> getParentProcesses() {
        ArrayList<ProcessHandle> proceses = new ArrayList<ProcessHandle>();
        ProcessHandle p = ProcessHandle.current();
        while (p != null) {
            proceses.add(p);
            p = p.parent().orElse(null);
        }
        return proceses;
    }

    static boolean isEclipse(ProcessHandle.Info info) {
        Optional<String> cmd = info.command();
        if (cmd.isPresent()) {
            String lowerCmd = cmd.get().toLowerCase(Locale.ENGLISH);
            return lowerCmd.endsWith("eclipse") || lowerCmd.endsWith("eclipse.exe");
        }
        return false;
    }

    static boolean isIdea(ProcessHandle.Info info) {
        return OpenInCurrentIde.getIdeaBinary(info) != null;
    }

    private static String getIdeaBinary(ProcessHandle.Info info) {
        String replaced;
        String commandAndArguments = OpenInCurrentIde.getCommandAndArguments(info);
        if (commandAndArguments != null && commandAndArguments.contains("idea_rt.jar") && !(replaced = commandAndArguments.replaceFirst(".*[:;]([^:;]*)(idea_rt.jar).*", "$1$2")).equals(commandAndArguments)) {
            File binFolder = new File(new File(replaced).getParentFile().getParentFile(), "bin");
            Optional<File> bin = Stream.of("idea", "idea.sh", "idea.bat").map(binName -> new File(binFolder, (String)binName)).filter(binaryFile -> binaryFile.exists()).findFirst();
            if (bin.isPresent()) {
                return bin.get().getAbsolutePath();
            }
        }
        return info.command().filter(cmd -> cmd.contains("idea")).orElse(null);
    }

    static boolean isVSCode(ProcessHandle.Info info) {
        String cmdLower;
        String termProgram = System.getenv("TERM_PROGRAM");
        if ("vscode".equalsIgnoreCase(termProgram)) {
            return true;
        }
        String cmd = OpenInCurrentIde.getCommandAndArguments(info);
        return cmd != null && ((cmdLower = cmd.toLowerCase(Locale.ENGLISH)).contains("vscode") || cmdLower.contains("vs code") || cmdLower.contains("code helper") || cmdLower.contains("visual studio code"));
    }
}

