/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.base.devserver.MavenUtils;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ExternalDependencyWatcher
implements Closeable {
    private static final Set<FileWatcher> watchers = new HashSet<FileWatcher>();

    public ExternalDependencyWatcher(VaadinContext context, File jarFrontendResourcesFolder) {
        ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
        String hotdeployDependenciesProperty = config.getStringProperty("frontend.hotdeploy.dependencies", null);
        List<String> hotdeployDependencyFolders = new ArrayList<String>();
        File projectFolder = config.getProjectFolder();
        if (hotdeployDependenciesProperty != null) {
            for (String folder2 : hotdeployDependenciesProperty.split(",")) {
                if (folder2.isBlank()) continue;
                hotdeployDependencyFolders.add(folder2.trim());
            }
        } else {
            Document parentPom;
            File pomFile = new File(projectFolder, "pom.xml");
            File parentPomFile = MavenUtils.getParentPomOfMultiModuleProject(pomFile);
            if (parentPomFile != null && (parentPom = MavenUtils.parsePomFile(parentPomFile)) != null) {
                Path currentPomToParentPomPath = pomFile.getParentFile().toPath().relativize(parentPomFile.getParentFile().toPath());
                hotdeployDependencyFolders = MavenUtils.getModuleFolders(parentPom).stream().map(folder -> currentPomToParentPomPath + File.separator + folder).toList();
            }
        }
        for (String hotdeployDependencyFolder : hotdeployDependencyFolders) {
            Path metaInf;
            Path moduleFolder = projectFolder.toPath().resolve(hotdeployDependencyFolder).normalize();
            if (moduleFolder.equals(projectFolder.toPath()) || this.watchDependencyFolder((metaInf = moduleFolder.resolve(Path.of("src", "main", "resources", "META-INF"))).toFile(), jarFrontendResourcesFolder) || hotdeployDependenciesProperty == null) continue;
            this.getLogger().warn("No folders to watch were found in " + metaInf.normalize().toAbsolutePath() + ". This should be the META-INF folder that contains either frontend or resources/frontend");
        }
    }

    private boolean watchDependencyFolder(File metaInfFolder, File jarFrontendResourcesFolder) {
        File metaInfFrontend = new File(metaInfFolder, "frontend");
        File metaInfResourcesFrontend = new File(new File(metaInfFolder, "resources"), "frontend");
        File metaInfResourcesThemes = new File(new File(metaInfFolder, "resources"), "themes");
        boolean watching1 = this.watchAndCopy(metaInfFrontend, jarFrontendResourcesFolder);
        boolean watching2 = this.watchAndCopy(metaInfResourcesFrontend, jarFrontendResourcesFolder);
        boolean watching3 = this.watchAndCopy(metaInfResourcesThemes, new File(jarFrontendResourcesFolder, "themes"));
        return watching1 || watching2 || watching3;
    }

    private boolean watchAndCopy(File watchFolder, File targetFolder) {
        if (!watchFolder.exists()) {
            return false;
        }
        try {
            FileWatcher watcher = new FileWatcher((SerializableConsumer<File>)(SerializableConsumer & Serializable)updatedFile -> {
                if (FileIOUtils.isProbablyTemporaryFile((File)updatedFile)) {
                    return;
                }
                Path pathInsideWatchFolder = watchFolder.toPath().relativize(updatedFile.toPath());
                Path target = targetFolder.toPath().resolve(pathInsideWatchFolder);
                try {
                    Files.copy(updatedFile.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to copy modified file from " + updatedFile + " to " + target, (Throwable)e);
                }
            }, watchFolder);
            watcher.start();
            watchers.add(watcher);
            this.getLogger().debug("Watching {} for frontend file changes", (Object)watchFolder);
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to start file watcher for " + watchFolder, (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        for (FileWatcher watcher : watchers) {
            try {
                watcher.stop();
            }
            catch (IOException e) {
                this.getLogger().error("Unable to stop file watcher", (Throwable)e);
            }
        }
        watchers.clear();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

