package com.vaadin.uitest.common;

import org.junit.jupiter.api.BeforeEach;

import com.vaadin.testbench.BrowserTestBase;
import com.vaadin.testbench.ElementQuery;
import com.vaadin.testbench.TestBenchElement;

public class BaseTestBenchIT extends BrowserTestBase implements HasTestView {

    @BeforeEach
    protected void setup() {
        getDriver().get(getUrl() + getView());
    }

    protected boolean hasContent(String content, TestBenchElement e) {
        return e.getText().toLowerCase().contains(content.toLowerCase());
    }

    protected boolean hasContent(String content, ElementQuery<?> query) {
        for (TestBenchElement e : query.all()) {
            if (e.getText().toLowerCase().contains(content.toLowerCase())) {
                return true;
            }
        }
        return false;
    }

}
