/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.vaadin.pro.licensechecker.BuildType;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineKey {
    private String jwtData;
    private JWT jwt;

    public OfflineKey(String jwtData) throws ParseException {
        this.jwtData = jwtData;
        this.jwt = JWTParser.parse((String)jwtData);
    }

    public String getJwtData() {
        return this.jwtData;
    }

    public String getSubscription() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("subscription");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("name");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public String getAccount() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("account");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public long getExpires() {
        try {
            return this.jwt.getJWTClaimsSet().getExpirationTime().getTime();
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return 0L;
        }
    }

    public String getSubscriptionKey() {
        try {
            return this.jwt.getJWTClaimsSet().getStringClaim("subscriptionKey");
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public boolean isProductionBuildAllowed() {
        return this.hasBuildType(BuildType.PRODUCTION.getKey());
    }

    public boolean isDevelopmentBuildAllowed() {
        return this.hasBuildType(BuildType.DEVELOPMENT.getKey());
    }

    private boolean hasBuildType(String key) {
        try {
            List buildType = this.jwt.getJWTClaimsSet().getStringListClaim("build_types");
            if (buildType != null) {
                return buildType.contains(key);
            }
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
        }
        return true;
    }

    public String getMachineId() {
        try {
            String machineId = this.jwt.getJWTClaimsSet().getStringClaim("machine_id");
            if (machineId == null || machineId.isEmpty()) {
                return null;
            }
            return machineId;
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
            return null;
        }
    }

    public List<String> getAllowedProducts() {
        try {
            List list = this.jwt.getJWTClaimsSet().getStringListClaim("allowedProducts");
            if (list != null) {
                return list;
            }
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<String> getAllowedFeatures() {
        try {
            List list = this.jwt.getJWTClaimsSet().getStringListClaim("allowedFeatures");
            if (list != null) {
                return list;
            }
        }
        catch (ParseException e) {
            this.getLogger().debug("Unable to parse claim from JWT. Should not happen", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

