/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.EnvironmentVariables;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class LocalOfflineKey {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OfflineKey read(File offlineKeyLocation) throws IOException {
        if (!offlineKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(offlineKeyLocation);){
            OfflineKey key;
            OfflineKey offlineKey = key = new OfflineKey(Util.toString(is));
            return offlineKey;
        }
        catch (ParseException e) {
            LocalOfflineKey.getLogger().error("Unable to read offline license from file", (Throwable)e);
            return null;
        }
    }

    public static File[] getLocations() {
        return (File[])Stream.of("offlineKey", "offlineKey.txt", "serverKey", "serverKey.txt").map(name -> new File(LocalProKey.getVaadinFolder(), (String)name)).toArray(File[]::new);
    }

    public static OfflineKey get() {
        OfflineKey offlineKey = LocalOfflineKey.getSystemProperty();
        if (offlineKey != null) {
            LocalOfflineKey.getLogger().debug("Using offlineKey from system property");
            return offlineKey;
        }
        offlineKey = LocalOfflineKey.getEnvironmentVariable();
        if (offlineKey != null) {
            LocalOfflineKey.getLogger().debug("Using offlineKey from environment variable");
            return offlineKey;
        }
        try {
            File keyLocation = null;
            for (File location : LocalOfflineKey.getLocations()) {
                offlineKey = LocalOfflineKey.read(location);
                if (offlineKey == null) continue;
                keyLocation = location;
                break;
            }
            if (offlineKey != null) {
                LocalOfflineKey.getLogger().debug("Found offline key in " + keyLocation);
            }
            return offlineKey;
        }
        catch (IOException e) {
            LocalOfflineKey.getLogger().debug("Unable to read offline key", (Throwable)e);
            return null;
        }
    }

    public static Optional<OfflineKey> fromString(String key) {
        if (key != null) {
            return Optional.ofNullable(LocalOfflineKey.parseOfflineKey(key, null));
        }
        return Optional.empty();
    }

    private static OfflineKey getSystemProperty() {
        String jwtData = System.getProperty("vaadin.offlineKey");
        if (jwtData == null && (jwtData = System.getProperty("vaadin.key")) == null) {
            return null;
        }
        return LocalOfflineKey.parseOfflineKey(jwtData, "system property");
    }

    private static OfflineKey getEnvironmentVariable() {
        String value = EnvironmentVariables.get("VAADIN_OFFLINE_KEY");
        if (value == null && (value = EnvironmentVariables.get("VAADIN_KEY")) == null) {
            return null;
        }
        return LocalOfflineKey.parseOfflineKey(value, "environment variable");
    }

    private static OfflineKey parseOfflineKey(String jwtData, String source) {
        try {
            return new OfflineKey(jwtData);
        }
        catch (ParseException e) {
            if (source != null) {
                LocalOfflineKey.getLogger().error("Unable to read offline license from {}", (Object)source, (Object)e);
            }
            return null;
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

