/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.internal.AbstractTaskEndpointGenerator;
import java.io.File;
import java.net.URL;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGenerateEndpointImpl
extends AbstractTaskEndpointGenerator
implements TaskGenerateEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGenerateEndpointImpl.class);
    private final String nodeCommand;
    private final boolean productionMode;

    TaskGenerateEndpointImpl(File projectDirectory, String buildDirectoryName, File outputDirectory, Function<String, URL> resourceFinder, boolean productionMode, String nodeCommand) {
        super(projectDirectory, buildDirectoryName, outputDirectory, resourceFinder);
        this.productionMode = productionMode;
        this.nodeCommand = nodeCommand;
    }

    public void execute() throws ExecutionFailedException {
        try {
            EngineConfiguration engineConfiguration = this.getEngineConfiguration();
            GeneratorProcessor processor = new GeneratorProcessor(engineConfiguration, this.nodeCommand, this.productionMode);
            processor.process();
        }
        catch (GeneratorException e) {
            LOGGER.error("Failed to run TypeScript endpoint generator", (Throwable)e);
            throw new ExecutionFailedException("Failed to run TypeScript endpoint generator");
        }
    }
}

