/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtils {
    private FileIOUtils() {
    }

    public static boolean writeIfChanged(File file, List<String> content) throws IOException {
        return FileIOUtils.writeIfChanged(file, content.stream().collect(Collectors.joining("\n")));
    }

    public static boolean writeIfChanged(File file, String content) throws IOException {
        String existingFileContent = FileIOUtils.getExistingFileContent(file);
        if (content.equals(existingFileContent)) {
            FileIOUtils.log().debug("skipping writing to file '{}' because content matches", (Object)file);
            return false;
        }
        FileIOUtils.log().debug("writing to file '{}' because content does not match", (Object)file);
        FileUtils.forceMkdirParent((File)file);
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        return true;
    }

    private static Logger log() {
        return LoggerFactory.getLogger(FileIOUtils.class);
    }

    private static String getExistingFileContent(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static File getProjectFolderFromClasspath() {
        try {
            URL url = FileIOUtils.class.getClassLoader().getResource(".");
            if (url != null && url.getProtocol().equals("file")) {
                return FileIOUtils.getProjectFolderFromClasspath(url);
            }
        }
        catch (Exception e) {
            FileIOUtils.log().warn("Unable to determine project folder using classpath", (Throwable)e);
        }
        return null;
    }

    static File getProjectFolderFromClasspath(URL rootFolder) throws URISyntaxException {
        Path path = Path.of(rootFolder.toURI());
        if (path.endsWith(Path.of("target", "classes"))) {
            return path.getParent().getParent().toFile();
        }
        return null;
    }

    public static boolean isProbablyTemporaryFile(File file) {
        return file.getName().endsWith("~");
    }

    public static List<Path> getFilesByPattern(Path baseDir, String pattern) throws IOException {
        if (baseDir == null || !baseDir.toFile().exists()) {
            throw new IllegalArgumentException("Base directory is empty or doesn't exist: " + baseDir);
        }
        if (pattern == null || pattern.isBlank()) {
            pattern = "*";
        }
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        final ArrayList<Path> matchingPaths = new ArrayList<Path>();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (matcher.matches(file)) {
                    matchingPaths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return matchingPaths;
    }

    public static boolean compareIgnoringIndentationAndEOL(String content1, String content2, BiPredicate<String, String> compareFn) {
        return compareFn.test(FileIOUtils.replaceIndentationAndEOL(content1), FileIOUtils.replaceIndentationAndEOL(content2));
    }

    public static boolean compareIgnoringIndentationEOLAndWhiteSpace(String content1, String content2, BiPredicate<String, String> compareFn) {
        return compareFn.test(FileIOUtils.replaceWhiteSpace(FileIOUtils.replaceIndentationAndEOL(content1)), FileIOUtils.replaceWhiteSpace(FileIOUtils.replaceIndentationAndEOL(content2)));
    }

    private static String replaceIndentationAndEOL(String text) {
        return text.replace("\r\n", "\n").replaceFirst("\n$", "").replaceAll("(?m)^(\\s)+", "");
    }

    private static String replaceWhiteSpace(String text) {
        for (String character : Stream.of("{", "}", ":", "'", "[", "]").toList()) {
            text = FileIOUtils.replaceWhiteSpaceAround(text, character);
        }
        return text;
    }

    private static String replaceWhiteSpaceAround(String text, String character) {
        return text.replaceAll(String.format("(\\s)*\\%s", character), character).replaceAll(String.format("\\%s(\\s)*", character), character);
    }
}

