/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckDecisionResolver;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.NavigationContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessCheckDecisionResolver
implements AccessCheckDecisionResolver {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultAccessCheckDecisionResolver.class);

    @Override
    public AccessCheckResult resolve(List<AccessCheckResult> results, NavigationContext context) {
        Class<?> navigationTarget = context.getNavigationTarget();
        String path = context.getLocation().getPath();
        Map<AccessCheckDecision, List<AccessCheckResult>> resultsByDecision = results.stream().collect(Collectors.groupingBy(AccessCheckResult::decision));
        int neutralVotes = Optional.ofNullable(resultsByDecision.remove((Object)AccessCheckDecision.NEUTRAL)).map(Collection::size).orElse(0);
        String denyReasons = resultsByDecision.getOrDefault((Object)AccessCheckDecision.DENY, List.of()).stream().map(AccessCheckResult::reason).filter(Objects::nonNull).collect(Collectors.joining(System.lineSeparator()));
        if (resultsByDecision.size() == 1) {
            AccessCheckDecision decision = resultsByDecision.keySet().iterator().next();
            int votes = resultsByDecision.get((Object)decision).size();
            if (decision == AccessCheckDecision.ALLOW) {
                LOGGER.debug("Access to view '{}' with path '{}' allowed by {} out of {} navigation checkers  ({} neutral).", new Object[]{navigationTarget.getName(), path, votes, results.size(), neutralVotes});
                return context.allow();
            }
            LOGGER.debug("Access to view '{}' with path '{}' denied by {} out of {} navigation checkers  ({} neutral).", new Object[]{navigationTarget.getName(), path, votes, results.size(), neutralVotes});
        } else if (resultsByDecision.isEmpty()) {
            if (context.isErrorHandling()) {
                return context.allow();
            }
            denyReasons = "Access denied because navigation checkers did not take any decision.";
            LOGGER.debug("Access to view '{}' with path '{}' denied because {} out of {} navigation checkers are neutral.", new Object[]{navigationTarget.getName(), path, results.size(), results.size()});
        } else {
            Object summary = resultsByDecision.entrySet().stream().map(e -> e.getKey() + " = " + ((List)e.getValue()).size()).collect(Collectors.joining(", ", "Votes: ", ""));
            if (neutralVotes > 0) {
                summary = (String)summary + ", " + AccessCheckDecision.NEUTRAL + " = " + neutralVotes;
            }
            LOGGER.warn("Access to view '{}' with path '{}' blocked because there is no unanimous consensus from the navigation checkers. {}.", new Object[]{navigationTarget.getName(), path, summary});
            return context.reject(String.format("Mixed consensus from navigation checkers for view '%s' with path '%s'. %s. Deny reasons: [%s]", navigationTarget.getName(), path, summary, denyReasons));
        }
        return context.deny(denyReasons);
    }
}

