/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.internal.PathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class RouteParameters
implements Serializable {
    private static final RouteParameters EMPTY = new RouteParameters();
    private Map<String, String> params;

    private RouteParameters() {
        this.params = Collections.emptyMap();
    }

    public RouteParameters(Map<String, String> params) {
        this.params = params != null ? Collections.unmodifiableMap(params) : Collections.emptyMap();
    }

    public RouteParameters(RouteParam ... params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(params.length);
        for (RouteParam param : params) {
            String existingValue = paramsMap.put(param.getName(), param.getValue());
            if (existingValue == null) continue;
            throw new IllegalArgumentException("Parameter " + param.getName() + " is given more than once.");
        }
        this.params = Collections.unmodifiableMap(paramsMap);
    }

    public RouteParameters(String name, String value) {
        this.params = Collections.singletonMap(name, value);
    }

    public static RouteParameters empty() {
        return EMPTY;
    }

    public Set<String> getParameterNames() {
        return this.params.keySet();
    }

    public Optional<String> get(String parameterName) {
        return Optional.ofNullable(this.getValue(parameterName));
    }

    public Optional<Integer> getInteger(String parameterName) {
        String value = this.getValue(parameterName);
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Couldn't parse '%s' parameter value '%s' as integer", parameterName, value), e);
        }
    }

    public Optional<Long> getLong(String parameterName) {
        String value = this.getValue(parameterName);
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Couldn't parse '%s' parameter value '%s' as long", parameterName, value), e);
        }
    }

    public List<String> getWildcard(String parameterName) {
        String value = this.getValue(parameterName);
        if (value == null) {
            return Collections.emptyList();
        }
        return PathUtil.getSegmentsList(value);
    }

    public String toString() {
        return this.params.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouteParameters) {
            RouteParameters parameters = (RouteParameters)obj;
            return this.params.equals(parameters.params);
        }
        return false;
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    private String getValue(String parameterName) {
        return this.params.get(parameterName);
    }
}

