/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.dom.impl.BasicTextElementStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.LoggerFactory;

public class ElementUtil {
    private static Pattern tagNamePattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9-_\\.]*$");

    private ElementUtil() {
    }

    public static boolean isValidTagName(String tag) {
        return tag != null && tagNamePattern.matcher(tag).matches();
    }

    public static boolean isValidAttributeName(String attribute) {
        char[] illegalCharacters;
        if (attribute == null || attribute.isEmpty()) {
            return false;
        }
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        for (char c : illegalCharacters = new char[]{'\u0000', ' ', '\"', '\'', '>', '/', '='}) {
            if (attribute.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static void validateStylePropertyName(String name) {
        String reason = ElementUtil.getInvalidStylePropertyNameError(name);
        if (reason != null) {
            throw new IllegalArgumentException(reason);
        }
    }

    private static String getInvalidStylePropertyNameError(String name) {
        if (name == null || name.trim().isEmpty()) {
            return "A style property name cannot be null or empty";
        }
        if (name.startsWith(" ") || name.endsWith(" ")) {
            return String.format("Invalid style property name '%s': a style property name cannot start or end in whitespace", name);
        }
        if (name.contains(":")) {
            return String.format("Invalid style property name '%s': a style property name cannot contain colons", name);
        }
        return null;
    }

    public static boolean isValidStylePropertyName(String name) {
        return ElementUtil.getInvalidStylePropertyNameError(name) == null;
    }

    public static boolean isValidStylePropertyValue(String value) {
        return ElementUtil.getInvalidStylePropertyValueError(value) == null;
    }

    public static void validateStylePropertyValue(String value) {
        String reason = ElementUtil.getInvalidStylePropertyValueError(value);
        if (reason != null) {
            throw new IllegalArgumentException(reason);
        }
    }

    private static String getInvalidStylePropertyValueError(String value) {
        if (value.endsWith(";")) {
            return "A style value cannot end in semicolon";
        }
        return null;
    }

    public static void setComponent(Element element, Component component) {
        if (element == null) {
            throw new IllegalArgumentException("Element must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        Optional<Component> currentComponent = element.getComponent();
        if (currentComponent.isPresent()) {
            boolean isCompositeReplacingItsContent;
            boolean bl = isCompositeReplacingItsContent = component instanceof Composite && component.getChildren().findFirst().get() == currentComponent.get();
            if (!isCompositeReplacingItsContent) {
                throw new IllegalStateException("A component of type " + currentComponent.get().getClass().getName() + " is already attached to this element");
            }
        }
        element.getStateProvider().setComponent(element.getNode(), component);
    }

    public static Node toJsoup(Document document, Element element) {
        if (element.isTextNode()) {
            return new TextNode(element.getText());
        }
        org.jsoup.nodes.Element target = document.createElement(element.getTag());
        if (element.hasProperty("innerHTML")) {
            target.html((String)((Object)element.getPropertyRaw("innerHTML")));
        }
        element.getAttributeNames().forEach(name -> {
            String attributeValue = element.getAttribute((String)name);
            if ("".equals(attributeValue)) {
                target.attr(name, true);
            } else {
                target.attr(name, attributeValue);
            }
        });
        element.getChildren().forEach(child -> target.appendChild(ElementUtil.toJsoup(document, child)));
        return target;
    }

    public static Optional<Element> fromJsoup(Node node) {
        if (node instanceof TextNode) {
            return Optional.of(Element.createText(((TextNode)node).text()));
        }
        if (node instanceof DataNode) {
            return Optional.of(Element.createText(((DataNode)node).getWholeData()));
        }
        if (!(node instanceof org.jsoup.nodes.Element)) {
            LoggerFactory.getLogger(ElementUtil.class).error("Could not convert a {}, '{}' into {}!", new Object[]{Node.class.getName(), node, Element.class.getName()});
            return Optional.empty();
        }
        Element ret = new Element(((org.jsoup.nodes.Element)node).tagName());
        node.attributes().asList().forEach(attribute -> ret.setAttribute(attribute.getKey(), attribute.getValue()));
        List childNodes = node.childNodes();
        if (!childNodes.isEmpty()) {
            childNodes.forEach(child -> ElementUtil.fromJsoup(child).ifPresent(xva$0 -> {
                Element cfr_ignored_0 = (Element)ret.appendChild((Element)xva$0);
            }));
        }
        return Optional.of(ret);
    }

    public static boolean isCustomElement(Element element) {
        return !element.isTextNode() && element.getTag().contains("-");
    }

    public static boolean isScript(Element element) {
        return !element.isTextNode() && "script".equalsIgnoreCase(element.getTag());
    }

    public static void setIgnoreParentInert(Element element, boolean ignoreParentInert) {
        Optional<InertData> optionalInertData = element.getNode().getFeatureIfInitialized(InertData.class);
        if (ignoreParentInert) {
            optionalInertData.orElse(element.getNode().getFeature(InertData.class)).setIgnoreParentInert(true);
        } else {
            optionalInertData.ifPresent(inertData -> inertData.setIgnoreParentInert(false));
        }
    }

    public static void setInert(Element element, boolean inert) {
        Optional<InertData> optionalInertData = element.getNode().getFeatureIfInitialized(InertData.class);
        if (inert) {
            optionalInertData.orElse(element.getNode().getFeature(InertData.class)).setInertSelf(true);
        } else {
            optionalInertData.ifPresent(inertData -> inertData.setInertSelf(false));
        }
    }

    public static Optional<Element> from(StateNode node) {
        assert (node != null);
        if (node.hasFeature(TextNodeMap.class)) {
            return Optional.of(Element.get(node, BasicTextElementStateProvider.get()));
        }
        if (node.hasFeature(ElementData.class)) {
            return Optional.of(Element.get(node, BasicElementStateProvider.get()));
        }
        return Optional.empty();
    }
}

