/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class CvdlProducts {
    private static final String CVDL_PACKAGE_KEY = "cvdlName";

    public static Product getProductIfCvdl(File nodeModules, String npmModule) {
        File packageJsonFile = new File(new File(nodeModules, npmModule), "package.json");
        if (!packageJsonFile.exists()) {
            return null;
        }
        try {
            JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
            if (packageJson.hasKey(CVDL_PACKAGE_KEY)) {
                return new Product(packageJson.getString(CVDL_PACKAGE_KEY), packageJson.getString("version"));
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read package.json file " + packageJsonFile, e);
        }
    }
}

