/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeChange;
import java.io.Serializable;
import java.util.function.Consumer;

public abstract class NodeFeature
implements Serializable {
    private final StateNode node;

    public NodeFeature(StateNode node) {
        this.node = node;
    }

    public StateNode getNode() {
        return this.node;
    }

    public abstract void collectChanges(Consumer<NodeChange> var1);

    public abstract void generateChangesFromEmpty();

    protected void attachPotentialChild(Object child) {
        if (child instanceof StateNode) {
            StateNode childNode = (StateNode)child;
            childNode.setParent(this.getNode());
        }
    }

    protected void detatchPotentialChild(Object child) {
        if (child instanceof StateNode) {
            StateNode childNode = (StateNode)child;
            assert (childNode.getParent() == this.getNode());
            childNode.setParent(null);
        }
    }

    public abstract void forEachChild(Consumer<StateNode> var1);

    public void onAttach(boolean initialAttach) {
    }

    public void onDetach() {
    }

    public boolean allowsChanges() {
        return true;
    }
}

