/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.GenerateMainImports;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.ThemeValidationUtil;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleValidationUtil {
    public static boolean needsBuild(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder, Mode mode) {
        BundleValidationUtil.getLogger().info("Checking if a {} mode bundle build is needed", (Object)mode);
        try {
            boolean needsBuild;
            if (mode.isProduction()) {
                if (options.isForceProductionBuild() || EndpointRequestUtil.isHillaAvailable()) {
                    if (options.isForceProductionBuild()) {
                        UsageStatistics.markAsUsed("flow/prod-build-requested", null);
                    }
                    BundleValidationUtil.getLogger().info("Frontend build requested.");
                    BundleValidationUtil.saveResultInFile(true, options);
                    return true;
                }
                needsBuild = BundleValidationUtil.needsBuildProdBundle(options, frontendDependencies, finder);
                BundleValidationUtil.saveResultInFile(needsBuild, options);
            } else if (Mode.DEVELOPMENT_BUNDLE == mode) {
                needsBuild = BundleValidationUtil.needsBuildDevBundle(options, frontendDependencies, finder);
            } else {
                if (Mode.DEVELOPMENT_FRONTEND_LIVERELOAD == mode) {
                    return false;
                }
                throw new IllegalArgumentException("Unexpected mode");
            }
            if (needsBuild) {
                BundleValidationUtil.getLogger().info("A {} mode bundle build is needed", (Object)mode);
            } else {
                BundleValidationUtil.getLogger().info("A {} mode bundle build is not needed", (Object)mode);
            }
            return needsBuild;
        }
        catch (Exception e) {
            BundleValidationUtil.getLogger().error(String.format("Error when checking if a %s bundle build is needed", new Object[]{mode}), (Throwable)e);
            return true;
        }
    }

    private static boolean needsBuildDevBundle(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) throws IOException {
        File npmFolder = options.getNpmFolder();
        File compressedDevBundle = new File(npmFolder, "src/main/bundles/dev.bundle");
        if (!(DevBundleUtils.getDevBundleFolder(npmFolder, options.getBuildDirectoryName()).exists() || compressedDevBundle.exists() || BundleValidationUtil.hasJarBundle("vaadin-dev-bundle/", finder))) {
            BundleValidationUtil.getLogger().info("No dev-bundle found.");
            return true;
        }
        if (!DevBundleUtils.getDevBundleFolder(npmFolder, options.getBuildDirectoryName()).exists() && compressedDevBundle.exists()) {
            DevBundleUtils.unpackBundle(npmFolder, new File(new File(npmFolder, options.getBuildDirectoryName()), "dev-bundle"));
        }
        if (options.isSkipDevBundle()) {
            BundleValidationUtil.getLogger().info("Skip dev bundle requested. Using existing bundle.");
            return false;
        }
        String statsJsonContent = DevBundleUtils.findBundleStatsJson(npmFolder, options.getBuildDirectoryName());
        if (statsJsonContent == null) {
            BundleValidationUtil.getLogger().info("No bundle's stats.json found for dev-bundle validation.");
            return true;
        }
        return BundleValidationUtil.needsBuildInternal(options, frontendDependencies, finder, statsJsonContent);
    }

    private static boolean needsBuildProdBundle(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) throws IOException {
        String statsJsonContent = ProdBundleUtils.findBundleStatsJson(options.getNpmFolder(), finder);
        if (!finder.getAnnotatedClasses(LoadDependenciesOnStartup.class).isEmpty()) {
            BundleValidationUtil.getLogger().info("Custom eager routes defined. Require bundle build.");
            UsageStatistics.markAsUsed("flow/rebundle-reason-bundle-custom-loading", null);
            return true;
        }
        if (statsJsonContent == null) {
            BundleValidationUtil.getLogger().info("No bundle's stats.json found for production-bundle validation.");
            return true;
        }
        return BundleValidationUtil.needsBuildInternal(options, frontendDependencies, finder, statsJsonContent);
    }

    private static boolean needsBuildInternal(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder, String statsJsonContent) throws IOException {
        Map<String, String> npmPackages;
        JsonObject packageJson = BundleValidationUtil.getPackageJson(options, frontendDependencies, finder);
        JsonObject statsJson = Json.parse((String)statsJsonContent);
        if (!BundleValidationUtil.hashAndBundleModulesEqual(statsJson, packageJson, npmPackages = frontendDependencies.getPackages())) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-missing-package", null);
            return true;
        }
        if (!BundleValidationUtil.frontendImportsFound(statsJson, options, finder, frontendDependencies)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-missing-frontend-import", null);
            return true;
        }
        if (ThemeValidationUtil.themeConfigurationChanged(options, statsJson, frontendDependencies, finder)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-changed-theme-config", null);
            return true;
        }
        if (ThemeValidationUtil.themeShadowDOMStylesheetsChanged(options, statsJson, frontendDependencies)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-changed-shadow-DOM-stylesheets", null);
            return true;
        }
        if (BundleValidationUtil.exportedWebComponents(statsJson, finder)) {
            UsageStatistics.markAsUsed("flow/rebundle-reason-added-exported-component", null);
            return true;
        }
        return false;
    }

    public static boolean hasJarBundle(String jarPath, ClassFinder finder) {
        URL resource = finder.getResource(jarPath + "config/stats.json");
        return resource != null;
    }

    public static JsonObject getPackageJson(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder) {
        File packageJsonFile = new File(options.getNpmFolder(), "package.json");
        if (packageJsonFile.exists()) {
            try {
                JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
                BundleValidationUtil.cleanOldPlatformDependencies(packageJson);
                return BundleValidationUtil.getDefaultPackageJson(options, frontendDependencies, finder, packageJson);
            }
            catch (IOException e) {
                BundleValidationUtil.getLogger().warn("Failed to read package.json", (Throwable)e);
            }
        } else {
            return BundleValidationUtil.getDefaultPackageJson(options, frontendDependencies, finder, null);
        }
        return null;
    }

    public static JsonObject getDefaultPackageJson(Options options, FrontendDependenciesScanner frontendDependencies, ClassFinder finder, JsonObject packageJson) {
        NodeUpdater nodeUpdater = new NodeUpdater(finder, frontendDependencies, options){

            @Override
            public void execute() {
            }
        };
        try {
            if (packageJson == null) {
                packageJson = nodeUpdater.getPackageJson();
            }
            nodeUpdater.addVaadinDefaultsToJson(packageJson);
            nodeUpdater.updateDefaultDependencies(packageJson);
            Map<String, String> applicationDependencies = frontendDependencies.getPackages();
            for (Map.Entry<String, String> dep : applicationDependencies.entrySet()) {
                nodeUpdater.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
            }
            String hash = TaskUpdatePackages.generatePackageJsonHash(packageJson);
            packageJson.getObject("vaadin").put("hash", hash);
            JsonObject platformPinnedDependencies = nodeUpdater.getPlatformPinnedDependencies();
            for (String key : platformPinnedDependencies.keys()) {
                if (applicationDependencies.containsKey(key)) continue;
                TaskUpdatePackages.pinPlatformDependency(packageJson, platformPinnedDependencies, key);
            }
            return packageJson;
        }
        catch (IOException e) {
            BundleValidationUtil.getLogger().warn("Failed to generate package.json", (Throwable)e);
            return null;
        }
    }

    private static void cleanOldPlatformDependencies(JsonObject packageJson) {
        if (packageJson == null || !BundleValidationUtil.hasFrameworkDependencyObjects(packageJson)) {
            return;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        JsonObject vaadinDependencies = packageJson.getObject("vaadin").getObject("dependencies");
        for (String vaadinDependency : vaadinDependencies.keys()) {
            String version = vaadinDependencies.getString(vaadinDependency);
            if (!dependencies.hasKey(vaadinDependency) || !version.equals(dependencies.getString(vaadinDependency))) continue;
            dependencies.remove(vaadinDependency);
            BundleValidationUtil.getLogger().debug("Old Vaadin provided dependency '{}':'{}' has been removed from package.json", (Object)vaadinDependency, (Object)version);
        }
    }

    public static boolean hashAndBundleModulesEqual(JsonObject statsJson, JsonObject packageJson, Map<String, String> npmPackages) {
        String packageJsonHash = BundleValidationUtil.getPackageJsonHash(packageJson);
        String bundlePackageJsonHash = BundleValidationUtil.getStatsHash(statsJson);
        if (packageJsonHash == null || packageJsonHash.isEmpty()) {
            BundleValidationUtil.getLogger().error("No hash found for 'package.json' even though one should always be generated!");
            return false;
        }
        JsonObject bundleModules = statsJson.getObject("packageJsonDependencies");
        if (bundleModules == null) {
            BundleValidationUtil.getLogger().error("Bundle did not contain package json dependencies to validate.\nRebuild of bundle needed.");
            return false;
        }
        if (packageJsonHash.equals(bundlePackageJsonHash) && !BundleValidationUtil.dependenciesContainsAllPackages(npmPackages, bundleModules)) {
            return false;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        List dependenciesList = Arrays.stream(dependencies.keys()).filter(pkg -> !"@vaadin/flow-frontend".equals(pkg)).collect(Collectors.toList());
        List missingFromBundle = dependenciesList.stream().filter(pkg -> !bundleModules.hasKey(pkg)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Dependency " + dependency + " is missing from the bundle");
            }
            return false;
        }
        missingFromBundle = dependenciesList.stream().filter(pkg -> !BundleValidationUtil.versionAccepted(dependencies.getString(pkg), bundleModules.getString(pkg))).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String pkg2 : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Dependency {}:{} has the wrong version {} in the bundle", new Object[]{pkg2, dependencies.getString(pkg2), bundleModules.getString(pkg2)});
            }
            return false;
        }
        return true;
    }

    private static boolean versionAccepted(String expected, String actual) {
        FrontendVersion expectedVersion = new FrontendVersion(expected);
        FrontendVersion actualVersion = new FrontendVersion(actual);
        if (expected.startsWith("~")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion() && expectedVersion.getMinorVersion() == actualVersion.getMinorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        if (expected.startsWith("^")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        return expectedVersion.isEqualTo(actualVersion);
    }

    private static boolean dependenciesContainsAllPackages(Map<String, String> npmPackages, JsonObject dependencies) {
        List<String> collect = npmPackages.keySet().stream().filter(pkg -> !dependencies.hasKey(pkg) || !BundleValidationUtil.versionAccepted(dependencies.getString(pkg), (String)npmPackages.get(pkg))).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            collect.forEach(dependency -> BundleValidationUtil.getLogger().info("Dependency " + dependency + " is missing from the bundle"));
            return false;
        }
        return true;
    }

    public static boolean exportedWebComponents(JsonObject statsJson, ClassFinder finder) {
        try {
            HashSet exporterRelatedClasses = new HashSet();
            finder.getSubTypesOf(WebComponentExporter.class.getName()).forEach(exporterRelatedClasses::add);
            finder.getSubTypesOf(WebComponentExporterFactory.class.getName()).forEach(exporterRelatedClasses::add);
            Set webComponents = WebComponentExporterUtils.getFactories(exporterRelatedClasses).stream().map(BundleValidationUtil::getTag).collect(Collectors.toSet());
            JsonArray webComponentsInStats = statsJson.getArray("webComponents");
            if (webComponentsInStats == null) {
                if (!webComponents.isEmpty()) {
                    BundleValidationUtil.getLogger().info("Found embedded web components not yet included into the bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                    return true;
                }
                return false;
            }
            for (int index = 0; index < webComponentsInStats.length(); ++index) {
                String webComponentInStats = webComponentsInStats.getString(index);
                webComponents.remove(webComponentInStats);
            }
            if (!webComponents.isEmpty()) {
                BundleValidationUtil.getLogger().info("Found newly added embedded web components not yet included into the bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            BundleValidationUtil.getLogger().error("Unable to locate embedded web component classes.");
            return false;
        }
    }

    private static String getTag(WebComponentExporterFactory<? extends Component> factory) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(factory);
    }

    public static boolean frontendImportsFound(JsonObject statsJson, Options options, ClassFinder finder, FrontendDependenciesScanner frontendDependencies) throws IOException {
        GenerateMainImports generateMainImports = new GenerateMainImports(finder, frontendDependencies, options, statsJson);
        generateMainImports.run();
        List imports = generateMainImports.getLines().stream().filter(line -> line.startsWith("import")).map(line -> line.substring(line.indexOf(39) + 1, line.lastIndexOf(39))).map(importString -> importString.contains("?") ? importString.substring(0, importString.lastIndexOf("?")) : importString).collect(Collectors.toList());
        LinkedHashSet uniqueImports = new LinkedHashSet(imports);
        JsonArray statsBundle = statsJson.hasKey("bundleImports") ? statsJson.getArray("bundleImports") : Json.createArray();
        List missingFromBundle = uniqueImports.stream().filter(importString -> !BundleValidationUtil.arrayContainsString(statsBundle, importString)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Frontend import " + dependency + " is missing from the bundle");
            }
            return false;
        }
        String resourcePath = "generated/jar-resources/";
        List<String> jarImports = uniqueImports.stream().filter(importString -> importString.contains(resourcePath)).map(importString -> importString.substring(importString.indexOf(resourcePath) + resourcePath.length())).collect(Collectors.toList());
        List<String> projectImports = uniqueImports.stream().filter(importString -> importString.startsWith("Frontend/") && !importString.contains(resourcePath)).map(importString -> importString.substring("Frontend/".length())).collect(Collectors.toList());
        JsonObject frontendHashes = statsJson.getObject("frontendHashes");
        ArrayList<String> faultyContent = new ArrayList<String>();
        for (String jarImport : jarImports) {
            String jarResourceString = FrontendUtils.getJarResourceString(jarImport, finder);
            if (jarResourceString == null) {
                BundleValidationUtil.getLogger().info("No file found for '{}'", (Object)jarImport);
                return false;
            }
            BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, jarImport, jarResourceString);
        }
        for (String projectImport : projectImports) {
            File frontendFile = new File(options.getFrontendDirectory(), projectImport);
            if (!frontendFile.exists()) {
                BundleValidationUtil.getLogger().info("No file found for '{}'", (Object)projectImport);
                return false;
            }
            String frontendFileContent = FileUtils.readFileToString((File)frontendFile, (Charset)StandardCharsets.UTF_8);
            BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, projectImport, frontendFileContent);
        }
        if (!faultyContent.isEmpty()) {
            BundleValidationUtil.logChangedFiles(faultyContent, "Detected changed content for frontend files:");
            return false;
        }
        if (BundleValidationUtil.indexFileAddedOrDeleted(options, frontendHashes)) {
            return false;
        }
        Map<String, String> remainingImports = BundleValidationUtil.getRemainingImports(jarImports, projectImports, frontendHashes);
        return !BundleValidationUtil.importedFrontendFilesChanged(options.getFrontendDirectory(), remainingImports);
    }

    private static boolean indexFileAddedOrDeleted(Options options, JsonObject frontendHashes) {
        List<String> indexFiles = Arrays.asList("index.ts", "index.js", "index.tsx");
        for (String indexFile : indexFiles) {
            File file = new File(options.getFrontendDirectory(), indexFile);
            if (file.exists() && !frontendHashes.hasKey(indexFile)) {
                BundleValidationUtil.getLogger().info("Detected added {} file", (Object)indexFile);
                return true;
            }
            if (file.exists() || !frontendHashes.hasKey(indexFile)) continue;
            BundleValidationUtil.getLogger().info("Detected deleted {} file", (Object)indexFile);
            return true;
        }
        return false;
    }

    private static Map<String, String> getRemainingImports(List<String> jarImports, List<String> projectImports, JsonObject frontendHashes) {
        HashMap<String, String> remainingImportEntries = new HashMap<String, String>();
        ArrayList<String> remainingKeys = new ArrayList<String>(Arrays.asList(frontendHashes.keys()));
        remainingKeys.removeAll(jarImports);
        remainingKeys.removeAll(projectImports);
        if (!remainingKeys.isEmpty()) {
            for (String key : remainingKeys) {
                remainingImportEntries.put(key, frontendHashes.getString(key));
            }
            return remainingImportEntries;
        }
        return Collections.emptyMap();
    }

    private static boolean importedFrontendFilesChanged(File frontendDirectory, Map<String, String> remainingImports) throws IOException {
        if (!remainingImports.isEmpty()) {
            ArrayList<String> changed = new ArrayList<String>();
            for (Map.Entry<String, String> importEntry : remainingImports.entrySet()) {
                String hash;
                String filePath = importEntry.getKey();
                String expectedHash = importEntry.getValue();
                File frontendFile = new File(frontendDirectory, filePath);
                if (!frontendFile.exists() || expectedHash.equals(hash = BundleValidationUtil.calculateHash(FileUtils.readFileToString((File)frontendFile, (Charset)StandardCharsets.UTF_8)))) continue;
                changed.add(filePath);
            }
            if (!changed.isEmpty()) {
                BundleValidationUtil.logChangedFiles(changed, "Detected changed frontend files:");
                return true;
            }
        }
        return false;
    }

    private static void compareFrontendHashes(JsonObject frontendHashes, List<String> faultyContent, String frontendFilePath, String frontendFileContent) {
        String contentHash = BundleValidationUtil.calculateHash(frontendFileContent);
        if (frontendHashes.hasKey(frontendFilePath) && !frontendHashes.getString(frontendFilePath).equals(contentHash)) {
            faultyContent.add(frontendFilePath);
        } else if (!frontendHashes.hasKey(frontendFilePath)) {
            BundleValidationUtil.getLogger().info("No hash info for '{}'", (Object)frontendFilePath);
            faultyContent.add(frontendFilePath);
        }
    }

    public static String calculateHash(String fileContent) {
        String content = fileContent.replaceAll("\\r\\n", "\n");
        return StringUtil.getHash(content, StandardCharsets.UTF_8);
    }

    private static boolean arrayContainsString(JsonArray array, String string) {
        string = string.replace("Frontend/", "./");
        for (int i = 0; i < array.length(); ++i) {
            if (!string.equals(array.getString(i).replace("Frontend/", "./"))) continue;
            return true;
        }
        return false;
    }

    public static String getStatsHash(JsonObject statsJson) {
        if (statsJson.hasKey("packageJsonHash")) {
            return statsJson.getString("packageJsonHash");
        }
        return null;
    }

    public static String getPackageJsonHash(JsonObject packageJson) {
        if (packageJson != null && packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey("hash")) {
            return packageJson.getObject("vaadin").getString("hash");
        }
        return null;
    }

    private static boolean hasFrameworkDependencyObjects(JsonObject packageJson) {
        return packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey("dependencies") && packageJson.hasKey("dependencies");
    }

    public static void logChangedFiles(List<String> frontendFiles, String message) {
        if (message == null || ((String)message).isEmpty()) {
            throw new IllegalArgumentException("Changed files message cannot be empty");
        }
        if (((String)message).contains("{}")) {
            throw new IllegalArgumentException("Changed files message shouldn't include '{}' placeholder");
        }
        message = (String)message + "\n{}";
        StringBuilder handledFiles = new StringBuilder();
        for (String file : frontendFiles) {
            handledFiles.append(" - ").append(file).append("\n");
        }
        BundleValidationUtil.getLogger().info((String)message, (Object)handledFiles);
    }

    public static URL getProdBundleResource(String filename, ClassFinder finder) {
        return finder.getResource("vaadin-prod-bundle/" + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needsBundleBuild(File resourceOutputFolder) {
        File needsBuildFile = new File(resourceOutputFolder, "config/needs-build");
        if (!needsBuildFile.exists()) {
            BundleValidationUtil.getLogger().error("Require bundle build due to missing '{}' file.", (Object)"config/needs-build");
            return true;
        }
        try {
            String content = FileUtils.readFileToString((File)needsBuildFile, (String)StandardCharsets.UTF_8.name());
            boolean bl = Boolean.parseBoolean(content);
            return bl;
        }
        catch (IOException e) {
            BundleValidationUtil.getLogger().error("Failed to read re-bundle checker result from file", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)needsBuildFile);
        }
    }

    private static void saveResultInFile(boolean needsBundle, Options options) throws IOException {
        File needsBuildFile = new File(options.getResourceOutputDirectory(), "config/needs-build");
        File targetDir = needsBuildFile.getParentFile();
        if (!targetDir.exists()) {
            FileUtils.forceMkdir((File)targetDir);
        }
        FileUtils.write((File)needsBuildFile, (CharSequence)Boolean.toString(needsBundle), (String)StandardCharsets.UTF_8.name());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleValidationUtil.class);
    }
}

