/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeFeatureChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;

public class MapPutChange
extends NodeFeatureChange {
    private final String key;
    private final Object value;

    public MapPutChange(NodeFeature map, String key, Object value) {
        super(map);
        assert (key != null);
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected void populateJson(JsonObject json, ConstantPool constantPool) {
        json.put("type", "put");
        json.put("key", this.key);
        super.populateJson(json, constantPool);
        if (this.value instanceof StateNode) {
            StateNode node = (StateNode)this.value;
            json.put("nodeValue", (JsonValue)Json.create((double)node.getId()));
        } else {
            json.put("value", JsonCodec.encodeWithConstantPool(this.value, constantPool));
        }
    }
}

