/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class I18NUtil {
    public static final String PROPERTIES_SUFFIX = ".properties";

    public static boolean containsDefaultTranslation() {
        URL resource = I18NUtil.getClassLoader().getResource("vaadin-i18n/translations.properties");
        return resource != null;
    }

    public static List<Locale> getDefaultTranslationLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        URL resource = I18NUtil.getClassLoader().getResource("vaadin-i18n");
        if (resource == null) {
            return locales;
        }
        List<File> listedFiles = I18NUtil.getTranslationFiles(resource).stream().filter(file -> file.getName().startsWith("translations") && file.getName().endsWith(PROPERTIES_SUFFIX)).collect(Collectors.toList());
        return I18NUtil.collectLocalesFromFiles(listedFiles);
    }

    public static List<Locale> collectLocalesFromFileNames(List<String> fileNames) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String name : fileNames) {
            if (!name.contains("_")) continue;
            String langCode = name.substring("translations".length() + 1, name.lastIndexOf(46));
            String[] langParts = langCode.split("_");
            if (langParts.length == 1) {
                locales.add(new Locale(langParts[0]));
                continue;
            }
            if (langParts.length == 2) {
                locales.add(new Locale(langParts[0], langParts[1]));
                continue;
            }
            if (langParts.length != 3) continue;
            locales.add(new Locale(langParts[0], langParts[1], langParts[2]));
        }
        return locales;
    }

    private static List<Locale> collectLocalesFromFiles(List<File> files) {
        return I18NUtil.collectLocalesFromFileNames(files.stream().map(File::getName).collect(Collectors.toList()));
    }

    protected static List<File> getTranslationFiles(URL resource) {
        ArrayList<File> files = new ArrayList<File>();
        File bundleFolder = new File(resource.getFile());
        if ("jar".equals(resource.getProtocol())) {
            String file = resource.getFile().substring("file:".length(), resource.getFile().indexOf(33));
            try {
                Enumeration<JarEntry> entries = new JarFile(file).entries();
                entries.asIterator().forEachRemaining(entry -> {
                    String fileName = entry.getName();
                    if (fileName.contains("vaadin-i18n") && fileName.endsWith(PROPERTIES_SUFFIX)) {
                        files.add(new File(fileName));
                    }
                });
            }
            catch (IOException ioe) {
                I18NUtil.getLogger().debug("failed to read jar file '" + file + "' contents", (Throwable)ioe);
            }
        } else if (bundleFolder.exists() && bundleFolder.isDirectory()) {
            Arrays.stream(bundleFolder.listFiles()).filter(File::isFile).forEach(files::add);
        }
        return files;
    }

    protected static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(I18NUtil.class);
    }
}

