/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.ReflectionCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ComponentEventBusUtil {
    private static final String EVENT_CONSTRUCTOR_DEFINITION = "A DOM event constructor should take (Component, boolean) as the two first parameters, followed by any number of optional parameters marked with @" + EventData.class.getSimpleName();
    private static final String NO_SUITABLE_CONSTRUCTOR = "No suitable DOM event constructor found for %s. " + EVENT_CONSTRUCTOR_DEFINITION;
    static ReflectionCache<ComponentEvent<?>, EventTypeInfo> cache = new ReflectionCache(EventTypeInfo::new);

    private ComponentEventBusUtil() {
    }

    public static LinkedHashMap<String, Class<?>> getEventDataExpressions(Class<? extends ComponentEvent<?>> eventType) {
        return ComponentEventBusUtil.cache.get(eventType).dataExpressions;
    }

    private static LinkedHashMap<String, Class<?>> findEventDataExpressions(Constructor<? extends ComponentEvent<?>> eventConstructor) {
        LinkedHashMap eventDataExpressions = new LinkedHashMap();
        for (int i = 2; i < eventConstructor.getParameterCount(); ++i) {
            Parameter p = eventConstructor.getParameters()[i];
            EventData eventData = p.getAnnotation(EventData.class);
            if (eventData == null || eventData.value().isEmpty()) {
                throw new IllegalArgumentException(String.format("The parameter %s of the constructor %s has no @%s, or the annotation value is empty", p.getName(), eventConstructor.toString(), EventData.class.getSimpleName()));
            }
            eventDataExpressions.put(eventData.value(), p.getType());
        }
        return eventDataExpressions;
    }

    public static <T extends ComponentEvent<?>> Constructor<T> getEventConstructor(Class<T> eventType) {
        return ComponentEventBusUtil.cache.get(eventType).eventConstructor;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends ComponentEvent<?>> Constructor<T> findEventConstructor(Class<T> eventType) {
        void var4_6;
        ReflectTools.checkClassAccessibility(eventType);
        ArrayList constructors = new ArrayList();
        Constructor<?>[] constructorArray = eventType.getConstructors();
        int n = constructorArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            Constructor<?> c = constructorArray[var4_6];
            if (ComponentEventBusUtil.isDomEventConstructor(c)) {
                constructors.add(c);
            }
            ++var4_6;
        }
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException(String.format(NO_SUITABLE_CONSTRUCTOR, eventType.getName()));
        }
        if (constructors.size() == 1) {
            return (Constructor)constructors.get(0);
        }
        Constructor eventDataConstructor = null;
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() <= 2) continue;
            if (eventDataConstructor == null) {
                eventDataConstructor = constructor;
                continue;
            }
            throw new IllegalArgumentException("More than one DOM event constructors annotated with @" + EventData.class.getSimpleName() + " found for " + eventType.getName() + ". There can be only one constructor with @" + EventData.class.getSimpleName() + " annotations present.");
        }
        if (eventDataConstructor != null) {
            return eventDataConstructor;
        }
        throw new IllegalArgumentException(String.format(NO_SUITABLE_CONSTRUCTOR, eventType.getName()));
    }

    public static boolean isDomEventConstructor(Constructor<?> constructor) {
        if (constructor.getParameterCount() < 2) {
            return false;
        }
        if (!Component.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
            return false;
        }
        if (constructor.getParameterTypes()[1] != Boolean.TYPE) {
            return false;
        }
        for (int param = 2; param < constructor.getParameterCount(); ++param) {
            Parameter p = constructor.getParameters()[param];
            if (p.getAnnotation(EventData.class) != null) continue;
            return false;
        }
        return true;
    }

    private static class EventTypeInfo {
        private final LinkedHashMap<String, Class<?>> dataExpressions;
        private final Constructor<? extends ComponentEvent<?>> eventConstructor;

        public EventTypeInfo(Class<? extends ComponentEvent<?>> type) {
            this.eventConstructor = ComponentEventBusUtil.findEventConstructor(type);
            this.dataExpressions = ComponentEventBusUtil.findEventDataExpressions(this.eventConstructor);
        }
    }
}

