/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.react;

import com.fasterxml.jackson.core.type.TypeReference;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;

public abstract class ReactAdapterComponent
extends Component {
    protected <T> DomListenerRegistration addStateChangeListener(String stateName, Class<T> typeClass, SerializableConsumer<T> listener) {
        return this.addJsonReaderStateChangeListener(stateName, (SerializableFunction & Serializable)jsonValue -> ReactAdapterComponent.readFromJson(jsonValue, typeClass), listener);
    }

    protected <T> DomListenerRegistration addStateChangeListener(String stateName, TypeReference<T> typeReference, SerializableConsumer<T> listener) {
        return this.addJsonReaderStateChangeListener(stateName, (SerializableFunction & Serializable)jsonValue -> ReactAdapterComponent.readFromJson(jsonValue, typeReference), listener);
    }

    protected void setState(String stateName, Object value) {
        this.getElement().setPropertyJson(stateName, ReactAdapterComponent.writeAsJson(value));
    }

    protected <T> T getState(String stateName, Class<T> typeClass) {
        return ReactAdapterComponent.readFromJson(this.getPropertyJson(stateName), typeClass);
    }

    protected <T> T getState(String stateName, TypeReference<T> typeReference) {
        return ReactAdapterComponent.readFromJson(this.getPropertyJson(stateName), typeReference);
    }

    protected static <T> T readFromJson(JsonValue jsonValue, Class<T> typeClass) {
        return (T)JsonUtils.readValue((JsonValue)jsonValue, typeClass);
    }

    protected static <T> T readFromJson(JsonValue jsonValue, TypeReference<T> typeReference) {
        return (T)JsonUtils.readValue((JsonValue)jsonValue, typeReference);
    }

    protected static JsonValue writeAsJson(Object object) {
        return JsonUtils.writeValue((Object)object);
    }

    private JsonValue getPropertyJson(String propertyName) {
        Serializable rawValue = this.getElement().getPropertyRaw(propertyName);
        if (rawValue == null) {
            return Json.createNull();
        }
        if (rawValue instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)rawValue;
            return jsonValue;
        }
        if (rawValue instanceof String) {
            String stringValue = (String)((Object)rawValue);
            return Json.create((String)stringValue);
        }
        if (rawValue instanceof Double) {
            Double doubleValue = (Double)rawValue;
            return Json.create((double)doubleValue);
        }
        if (rawValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)rawValue;
            return Json.create((boolean)booleanValue);
        }
        return Json.create((String)rawValue.toString());
    }

    private <T> DomListenerRegistration addJsonReaderStateChangeListener(String stateName, SerializableFunction<JsonValue, T> jsonReader, SerializableConsumer<T> listener) {
        return this.getElement().addPropertyChangeListener(stateName, stateName + "-changed", (PropertyChangeListener & Serializable)event -> {
            JsonValue newStateJson = JsonCodec.encodeWithoutTypeInfo((Object)event.getValue());
            Object newState = jsonReader.apply((Object)newStateJson);
            listener.accept(newState);
        });
    }
}

