/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.annotation.Processor;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.DefaultBroadcasterCache;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AsyncSupportListenerAdapter;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFrameworkListener;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceListener;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.DefaultAtmosphereResourceFactory;
import org.atmosphere.cpr.DefaultAtmosphereResourceSessionFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultMetaBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.cpr.Universe;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.interceptor.AndroidAtmosphereInterceptor;
import org.atmosphere.interceptor.CacheHeadersInterceptor;
import org.atmosphere.interceptor.CorsInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.interceptor.JSONPAtmosphereInterceptor;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.atmosphere.interceptor.OnDisconnectInterceptor;
import org.atmosphere.interceptor.PaddingAtmosphereInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.interceptor.WebSocketMessageSuspendInterceptor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.DefaultUUIDProvider;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.ServletContextFactory;
import org.atmosphere.util.UUIDProvider;
import org.atmosphere.util.Utils;
import org.atmosphere.util.Version;
import org.atmosphere.util.VoidServletConfig;
import org.atmosphere.util.analytics.FocusPoint;
import org.atmosphere.util.analytics.JGoogleAnalyticsTracker;
import org.atmosphere.util.analytics.ModuleDetection;
import org.atmosphere.websocket.DefaultWebSocketFactory;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketFactory;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFramework {
    public static final String DEFAULT_ATMOSPHERE_CONFIG_PATH = "/META-INF/atmosphere.xml";
    public static final String DEFAULT_LIB_PATH = "/WEB-INF/lib/";
    public static final String DEFAULT_HANDLER_PATH = "/WEB-INF/classes/";
    public static final String META_SERVICE = "META-INF/services/";
    public static final String MAPPING_REGEX = "[a-zA-Z0-9-&.*_~=@;\\?]+";
    public static final String ASYNC_IO = "io.async";
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    protected final List<String> broadcasterFilters = new ArrayList<String>();
    protected final List<AsyncSupportListener> asyncSupportListeners = new ArrayList<AsyncSupportListener>();
    protected final List<AtmosphereResourceListener> atmosphereResourceListeners = new ArrayList<AtmosphereResourceListener>();
    protected final ArrayList<String> possibleComponentsCandidate = new ArrayList();
    protected final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config;
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    protected final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    protected final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<String> objectFactoryType = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<BroadcasterCacheInspector> inspectors = new ConcurrentLinkedQueue();
    protected String mappingRegex = "[a-zA-Z0-9-&.*_~=@;\\?]+";
    protected boolean useNativeImplementation;
    protected boolean useBlockingImplementation;
    protected boolean useStreamForFlushingComments = true;
    protected boolean useServlet30 = true;
    protected AsyncSupport asyncSupport;
    protected String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified;
    protected boolean isBroadcasterSpecified;
    protected boolean isSessionSupportSpecified;
    protected boolean isThrowExceptionOnClonedRequestSpecified;
    protected BroadcasterFactory broadcasterFactory;
    protected String broadcasterFactoryClassName;
    protected String broadcasterCacheClassName;
    protected boolean webSocketEnabled = true;
    protected String broadcasterLifeCyclePolicy = "NEVER";
    protected String webSocketProtocolClassName = SimpleHttpProtocol.class.getName();
    protected WebSocketProtocol webSocketProtocol;
    protected String handlersPath = "/WEB-INF/classes/";
    protected ServletConfig servletConfig;
    protected boolean autoDetectHandlers = true;
    private boolean hasNewWebSocketProtocol;
    protected String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
    protected String metaServicePath = "META-INF/services/";
    protected final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
    protected boolean scanDone;
    protected String annotationProcessorClassName = "org.atmosphere.cpr.DefaultAnnotationProcessor";
    protected final List<BroadcasterListener> broadcasterListeners = Collections.synchronizedList(new ArrayList());
    protected String webSocketProcessorClassName = DefaultWebSocketProcessor.class.getName();
    protected boolean webSocketProtocolInitialized;
    protected EndpointMapper<AtmosphereHandlerWrapper> endpointMapper = new DefaultEndpointMapper<AtmosphereHandlerWrapper>();
    protected String libPath = "/WEB-INF/lib/";
    protected boolean isInit;
    protected boolean sharedThreadPools = true;
    protected final List<String> packages = new ArrayList<String>();
    protected final LinkedList<String> annotationPackages = new LinkedList();
    protected boolean allowAllClassesScan = true;
    protected boolean annotationFound;
    protected boolean executeFirstSet;
    protected AtmosphereObjectFactory<?> objectFactory = new DefaultAtmosphereObjectFactory();
    protected final AtomicBoolean isDestroyed = new AtomicBoolean();
    protected boolean externalizeDestroy;
    protected AnnotationProcessor annotationProcessor;
    protected final List<String> excludedInterceptors = new ArrayList<String>();
    protected final LinkedList<BroadcasterCacheListener> broadcasterCacheListeners = new LinkedList();
    protected final List<BroadcasterConfig.FilterManipulator> filterManipulators = new ArrayList<BroadcasterConfig.FilterManipulator>();
    protected AtmosphereResourceFactory arFactory;
    protected MetaBroadcaster metaBroadcaster;
    protected AtmosphereResourceSessionFactory sessionFactory;
    protected String defaultSerializerClassName;
    protected Class<Serializer> defaultSerializerClass;
    protected final List<AtmosphereFrameworkListener> frameworkListeners = new LinkedList<AtmosphereFrameworkListener>();
    private UUIDProvider uuidProvider = new DefaultUUIDProvider();
    protected Thread shutdownHook;
    public static final List<Class<? extends AtmosphereInterceptor>> DEFAULT_ATMOSPHERE_INTERCEPTORS = new LinkedList<Class<? extends AtmosphereInterceptor>>(){
        {
            this.add(CorsInterceptor.class);
            this.add(CacheHeadersInterceptor.class);
            this.add(PaddingAtmosphereInterceptor.class);
            this.add(AndroidAtmosphereInterceptor.class);
            this.add(HeartbeatInterceptor.class);
            this.add(SSEAtmosphereInterceptor.class);
            this.add(JSONPAtmosphereInterceptor.class);
            this.add(JavaScriptProtocol.class);
            this.add(WebSocketMessageSuspendInterceptor.class);
            this.add(OnDisconnectInterceptor.class);
            this.add(IdleResourceInterceptor.class);
        }
    };
    private WebSocketFactory webSocketFactory;
    private IllegalStateException initializationError;
    public static final AtmosphereHandler REFLECTOR_ATMOSPHEREHANDLER = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) {
            logger.trace("VoidHandler {}", (Object)resource.uuid());
        }

        @Override
        public void destroy() {
            logger.trace("VoidHandler");
        }
    };

    public void setAndConfigureAtmosphereResourceFactory(AtmosphereResourceFactory arFactory) {
        this.arFactory = arFactory;
        this.arFactory.configure(this.config);
    }

    public AtmosphereFramework() {
        this(false, true);
    }

    public AtmosphereFramework(ServletConfig sc) throws ServletException {
        this(false, true);
        this.init(sc);
    }

    public AtmosphereFramework(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
        this.config = this.newAtmosphereConfig();
    }

    protected AtmosphereConfig newAtmosphereConfig() {
        return new AtmosphereConfig(this);
    }

    private void populateBroadcasterType() {
        this.broadcasterTypes.add("org.atmosphere.kafka.KafkaBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.hazelcast.HazelcastBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.xmpp.XMPPBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.redis.RedisBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jgroups.JGroupsBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jms.JMSBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.rmi.RMIBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.rabbitmq.RabbitMQBroadcaster");
    }

    private void populateObjectFactoryType() {
        this.objectFactoryType.add("org.atmosphere.cdi.CDIObjectFactory");
        this.objectFactoryType.add("org.atmosphere.spring.SpringWebObjectFactory");
        this.objectFactoryType.add("org.atmosphere.guice.GuiceObjectFactory");
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        this.createWrapperAndConfigureHandler(h, mapping, l);
        if (!this.isInit) {
            logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
            logger.info("Installed the following AtmosphereInterceptor mapped to AtmosphereHandler {}", (Object)h.getClass().getName());
            if (!l.isEmpty()) {
                for (AtmosphereInterceptor s : l) {
                    logger.info("\t{} : {}", (Object)s.getClass().getName(), (Object)s);
                }
            }
        }
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        this.createWrapperAndConfigureHandler((AtmosphereHandler)h, (String)mapping, l).broadcaster = broadcaster;
        if (!this.isInit) {
            logger.info("Installed AtmosphereHandler {} mapped to context-path {} and Broadcaster Class {}", new Object[]{h.getClass().getName(), mapping, broadcaster.getClass().getName()});
        } else {
            logger.debug("Installed AtmosphereHandler {} mapped to context-path {} and Broadcaster Class {}", new Object[]{h.getClass().getName(), mapping, broadcaster.getClass().getName()});
        }
        if (!l.isEmpty()) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        this.createWrapperAndConfigureHandler((AtmosphereHandler)h, (String)mapping, l).broadcaster.setID(broadcasterId);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        if (!l.isEmpty()) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
        return this;
    }

    protected AtmosphereHandlerWrapper createWrapperAndConfigureHandler(AtmosphereHandler h, String mapping, List<AtmosphereInterceptor> l) {
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(this.broadcasterFactory, h, mapping, this.config);
        this.addMapping(mapping, w);
        this.addInterceptorToWrapper(w, l);
        this.initServletProcessor(h);
        return w;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        this.addAtmosphereHandler(mapping, h, Collections.emptyList());
        return this;
    }

    private AtmosphereFramework addMapping(String path, AtmosphereHandlerWrapper w) {
        this.atmosphereHandlers.put(this.normalizePath(path), w);
        return this;
    }

    public String normalizePath(String path) {
        if (path.contains("*")) {
            path = path.replace("*", this.mappingRegex);
        }
        if (path.endsWith("/")) {
            path = path + this.mappingRegex;
        }
        return path;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        this.addAtmosphereHandler(mapping, h, broadcasterId, Collections.emptyList());
        return this;
    }

    private void initServletProcessor(AtmosphereHandler h) {
        if (!this.isInit) {
            return;
        }
        try {
            if (h instanceof AtmosphereServletProcessor) {
                ((AtmosphereServletProcessor)h).init(this.config);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        this.addAtmosphereHandler(mapping, h, broadcaster, Collections.emptyList());
        return this;
    }

    public AtmosphereFramework removeAtmosphereHandler(String mapping) {
        if (mapping.endsWith("/")) {
            mapping = mapping + this.mappingRegex;
        }
        this.atmosphereHandlers.remove(mapping);
        return this;
    }

    public AtmosphereFramework removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
        return this;
    }

    public AtmosphereFramework removeAllInitParams() {
        this.initParams.clear();
        return this;
    }

    public AtmosphereFramework addInitParameter(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    protected void readSystemProperties() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.useBlocking") != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useBlocking"));
            this.isCometSupportSpecified = true;
        }
        this.atmosphereDotXmlPath = System.getProperty("org.atmosphere.atmosphereDotXml", this.atmosphereDotXmlPath);
        if (System.getProperty("org.atmosphere.disableOnStateEvent") != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", System.getProperty("org.atmosphere.disableOnStateEvent"));
        }
    }

    public void patchContainer() {
        System.setProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false");
    }

    public AtmosphereFramework init() {
        try {
            this.init(this.servletConfig == null ? new VoidServletConfig(this.initParams) : this.servletConfig, false);
        }
        catch (ServletException e) {
            logger.error("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereFramework init(ServletConfig sc) throws ServletException {
        return this.init(sc, true);
    }

    protected void preventOOM() {
        String s = this.config.getInitParameter("org.atmosphere.cpr.scanClassPath");
        if (s != null) {
            this.allowAllClassesScan = Boolean.parseBoolean(s);
        }
        try {
            Class.forName("org.testng.Assert");
            this.allowAllClassesScan = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public AtmosphereFramework init(ServletConfig sc, boolean wrap) throws ServletException {
        if (this.isInit) {
            return this;
        }
        this.servletConfig(sc, wrap);
        this.readSystemProperties();
        this.populateBroadcasterType();
        this.populateObjectFactoryType();
        this.loadMetaService();
        this.onPreInit();
        try {
            String s;
            ServletContextFactory.getDefault().init(sc.getServletContext());
            this.preventOOM();
            this.doInitParams(this.servletConfig);
            this.doInitParamsForWebSocket(this.servletConfig);
            this.lookupDefaultObjectFactoryType();
            if (logger.isTraceEnabled()) {
                this.asyncSupportListener(this.newClassInstance(AsyncSupportListener.class, AsyncSupportListenerAdapter.class));
            }
            this.configureObjectFactory();
            this.configureAnnotationPackages();
            this.configureBroadcasterFactory();
            this.configureMetaBroadcaster();
            this.configureAtmosphereResourceFactory();
            if (this.isSessionSupportSpecified) {
                this.sessionFactory();
            }
            this.configureScanningPackage(this.servletConfig, "org.atmosphere.cpr.packages");
            this.configureScanningPackage(this.servletConfig, "jersey.config.server.provider.packages");
            this.configureScanningPackage(this.servletConfig, "com.sun.jersey.config.property.packages");
            this.defaultPackagesToScan();
            this.installAnnotationProcessor(this.servletConfig);
            this.autoConfigureService(this.servletConfig.getServletContext());
            this.configureBroadcasterFactory();
            this.patchContainer();
            this.configureBroadcaster();
            this.loadConfiguration(this.servletConfig);
            this.initWebSocket();
            this.initEndpointMapper();
            this.initDefaultSerializer();
            this.autoDetectContainer();
            this.configureWebDotXmlAtmosphereHandler(this.servletConfig);
            this.asyncSupport.init(this.servletConfig);
            this.initAtmosphereHandler(this.servletConfig);
            this.configureAtmosphereInterceptor(this.servletConfig);
            this.analytics();
            if (sc.getServletContext() != null) {
                sc.getServletContext().setAttribute(BroadcasterFactory.class.getName(), (Object)this.broadcasterFactory);
            }
            if ((s = this.config.getInitParameter("org.atmosphere.cpr.broadcaster.shareableThreadPool")) != null) {
                this.sharedThreadPools = Boolean.parseBoolean(s);
            }
            this.shutdownHook = new Thread(this::destroy);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            if (logger.isInfoEnabled()) {
                this.info();
            }
            if (this.initializationError != null) {
                logger.trace("ContainerInitalizer exception. May not be an issue if Atmosphere started properly ", (Throwable)this.initializationError);
            }
            this.universe();
        }
        catch (Throwable t) {
            logger.error("Failed to initialize Atmosphere Framework", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
        this.isInit = true;
        this.config.initComplete();
        this.onPostInit();
        return this;
    }

    protected void servletConfig(final ServletConfig sc, boolean wrap) {
        if (wrap) {
            String value = sc.getServletContext().getInitParameter("org.atmosphere.cpr.AtmosphereConfig.getInitParameter");
            final boolean useServletContextParameters = Boolean.parseBoolean(value);
            this.servletConfig = new ServletConfig(){
                final AtomicBoolean done = new AtomicBoolean();

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = AtmosphereFramework.this.initParams.get(name);
                    if (param == null && (param = sc.getInitParameter(name)) == null && useServletContextParameters) {
                        param = sc.getServletContext().getInitParameter(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    Enumeration en;
                    if (!this.done.getAndSet(true) && (en = sc.getInitParameterNames()) != null) {
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            if (AtmosphereFramework.this.initParams.containsKey(name)) continue;
                            AtmosphereFramework.this.initParams.put(name, sc.getInitParameter(name));
                        }
                    }
                    return Collections.enumeration(AtmosphereFramework.this.initParams.keySet());
                }
            };
        } else {
            this.servletConfig = sc;
        }
    }

    public void reconfigureInitParams(boolean reconfigureInitParams) {
        if (reconfigureInitParams) {
            this.doInitParams(this.servletConfig, reconfigureInitParams);
            this.doInitParamsForWebSocket(this.servletConfig);
        }
    }

    private void info() {
        if (logger.isTraceEnabled()) {
            Enumeration e = this.servletConfig.getInitParameterNames();
            logger.trace("Configured init-params");
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                logger.trace("\t{} = {}", (Object)n, (Object)this.servletConfig.getInitParameter(n));
            }
        }
        logger.info("Using EndpointMapper {}", this.endpointMapper.getClass());
        for (String i : this.broadcasterFilters) {
            logger.info("Using BroadcastFilter: {}", (Object)i);
        }
        if (this.broadcasterCacheClassName == null || DefaultBroadcasterCache.class.getName().equals(this.broadcasterCacheClassName)) {
            logger.warn("No BroadcasterCache configured. Broadcasted message between client reconnection will be LOST. It is recommended to configure the {}", (Object)UUIDBroadcasterCache.class.getName());
        } else {
            logger.info("Using BroadcasterCache: {}", (Object)this.broadcasterCacheClassName);
        }
        String s = this.config.getInitParameter("org.atmosphere.cpr.Broadcaster.threadWaitTime");
        logger.info("Default Broadcaster Class: {}", (Object)this.broadcasterClassName);
        logger.info("Broadcaster Shared List Resources: {}", (Object)this.config.getInitParameter("org.atmosphere.cpr.Broadcaster.sharedListenersList", false));
        logger.info("Broadcaster Polling Wait Time {}", s == null ? Integer.valueOf(100) : s);
        logger.info("Shared ExecutorService supported: {}", (Object)this.sharedThreadPools);
        ExecutorService executorService = ExecutorsFactory.getMessageDispatcher(this.config, "/*");
        if (executorService != null) {
            if (ThreadPoolExecutor.class.isAssignableFrom(executorService.getClass())) {
                long max = ((ThreadPoolExecutor)executorService).getMaximumPoolSize();
                logger.info("Messaging Thread Pool Size: {}", ((ThreadPoolExecutor)executorService).getMaximumPoolSize() == Integer.MAX_VALUE ? "Unlimited" : Long.valueOf(max));
            } else {
                logger.info("Messaging ExecutorService Pool Size unavailable - Not instance of ThreadPoolExecutor");
            }
        }
        if ((executorService = ExecutorsFactory.getAsyncOperationExecutor(this.config, "/*")) != null) {
            if (ThreadPoolExecutor.class.isAssignableFrom(executorService.getClass())) {
                logger.info("Async I/O Thread Pool Size: {}", (Object)((ThreadPoolExecutor)executorService).getMaximumPoolSize());
            } else {
                logger.info("Async I/O ExecutorService Pool Size unavailable - Not instance of ThreadPoolExecutor");
            }
        }
        logger.info("Using BroadcasterFactory: {}", (Object)this.broadcasterFactory.getClass().getName());
        logger.info("Using AtmosphereResurceFactory: {}", (Object)this.arFactory.getClass().getName());
        logger.info("Using WebSocketProcessor: {}", (Object)this.webSocketProcessorClassName);
        if (this.defaultSerializerClassName != null && !this.defaultSerializerClassName.isEmpty()) {
            logger.info("Using Serializer: {}", (Object)this.defaultSerializerClassName);
        }
        WebSocketProcessor wp = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this);
        boolean b = false;
        if (DefaultWebSocketProcessor.class.isAssignableFrom(wp.getClass())) {
            b = ((DefaultWebSocketProcessor)wp).invokeInterceptors();
        }
        logger.info("Invoke AtmosphereInterceptor on WebSocket message {}", (Object)b);
        logger.info("HttpSession supported: {}", (Object)this.config.isSupportSession());
        logger.info("Atmosphere is using {} for dependency injection and object creation", this.objectFactory);
        logger.info("Atmosphere is using async support: {} running under container: {}", (Object)this.getAsyncSupport().getClass().getName(), (Object)this.asyncSupport.getContainerName());
        logger.info("Atmosphere Framework {} started.", (Object)Version.getRawVersion());
        if (logger.isTraceEnabled()) {
            for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
                logger.trace("\nConfigured AtmosphereHandler {}\n", (Object)e.getKey());
                logger.trace("{}", (Object)e.getValue());
            }
        }
    }

    protected void universe() {
        Universe.broadcasterFactory(this.broadcasterFactory);
        Universe.resourceFactory(this.arFactory);
        Universe.sessionResourceFactory(this.sessionFactory);
        Universe.framework(this);
    }

    private void configureAnnotationPackages() {
        this.annotationPackages.add(Processor.class.getPackage().getName());
        String s = this.config.getInitParameter("org.atmosphere.annotation.packages");
        if (s != null) {
            String[] l;
            for (String p : l = s.split(",")) {
                this.annotationPackages.addLast(p);
            }
        }
    }

    protected void analytics() {
        if (!this.config.getInitParameter("org.atmosphere.cpr.AtmosphereFramework.analytics", true)) {
            return;
        }
        String container = this.getServletContext().getServerInfo();
        Thread t = new Thread(() -> {
            try {
                logger.debug("Retrieving Atmosphere's latest version from http://async-io.org/version.html");
                HttpURLConnection urlConnection = (HttpURLConnection)URI.create("http://async-io.org/version.html").toURL().openConnection();
                urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
                urlConnection.setRequestProperty("Connection", "keep-alive");
                urlConnection.setRequestProperty("Cache-Control", "max-age=0");
                urlConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                urlConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.8");
                urlConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
                urlConnection.setRequestProperty("If-Modified-Since", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
                urlConnection.setInstanceFollowRedirects(true);
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                String newVersion = Version.getRawVersion();
                String clientVersion = null;
                String nextMajorRelease = null;
                boolean nextAvailable = false;
                if (!newVersion.contains("SNAPSHOT")) {
                    try {
                        String inputLine;
                        while ((inputLine = in.readLine().trim()) != null) {
                            if (inputLine.startsWith("ATMO23_VERSION=")) {
                                newVersion = inputLine.substring("ATMO23_VERSION=".length());
                                continue;
                            }
                            if (inputLine.startsWith("CLIENT3_VERSION=")) {
                                clientVersion = inputLine.substring("CLIENT3_VERSION=".length());
                                break;
                            }
                            if (!inputLine.startsWith("ATMO_RELEASE_VERSION=") || (nextMajorRelease = inputLine.substring("ATMO_RELEASE_VERSION=".length())).compareTo(Version.getRawVersion()) <= 0 || nextMajorRelease.toLowerCase().contains("rc") || nextMajorRelease.toLowerCase().contains("beta")) continue;
                            nextAvailable = true;
                        }
                    }
                    finally {
                        if (clientVersion != null) {
                            logger.info("Latest version of Atmosphere's JavaScript Client {}", clientVersion);
                        }
                        if (newVersion.compareTo(Version.getRawVersion()) > 0) {
                            if (nextAvailable) {
                                logger.info("\n\n\tAtmosphere Framework Updates\n\tMinor available (bugs fixes): {}\n\tMajor available (new features): {}", (Object)newVersion, nextMajorRelease);
                            } else {
                                logger.info("\n\n\tAtmosphere Framework Updates:\n\tMinor Update available (bugs fixes): {}", (Object)newVersion);
                            }
                        } else if (nextAvailable) {
                            logger.info("\n\n\tAtmosphere Framework Updates:\n\tMajor Update available (new features): {}", nextMajorRelease);
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        urlConnection.disconnect();
                    }
                }
                JGoogleAnalyticsTracker tracker = new JGoogleAnalyticsTracker(ModuleDetection.detect(), Version.getRawVersion(), "UA-31990725-1");
                tracker.trackSynchronously(new FocusPoint(container, new FocusPoint("Atmosphere")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
    }

    protected void configureAtmosphereInterceptor(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor");
        if (s != null) {
            String[] list;
            for (String a : list = s.split(",")) {
                try {
                    AtmosphereInterceptor ai = this.newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.getClass(), a.trim()));
                    this.interceptor(ai);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        if (!Boolean.parseBoolean(s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults"))) {
            logger.info("Installing Default AtmosphereInterceptors");
            for (Class<? extends AtmosphereInterceptor> a : DEFAULT_ATMOSPHERE_INTERCEPTORS) {
                if (!this.excludedInterceptors.contains(a.getName())) {
                    this.interceptors.add(this.newAInterceptor(a));
                    continue;
                }
                logger.info("Dropping Interceptor {}", (Object)a.getName());
            }
            logger.info("Set {} to disable them.", (Object)"org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults");
        }
        this.addDefaultOrAppInterceptors();
    }

    protected AtmosphereInterceptor newAInterceptor(Class<? extends AtmosphereInterceptor> a) {
        AtmosphereInterceptor ai = null;
        try {
            ai = this.newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.getClass(), a.getName()));
            logger.info("\t{} : {}", (Object)a.getName(), (Object)ai);
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
        return ai;
    }

    protected void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler");
        if (s != null) {
            try {
                String mapping = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler.contextRoot");
                if (mapping == null) {
                    mapping = "/*";
                }
                this.addAtmosphereHandler(mapping, this.newClassInstance(AtmosphereHandler.class, IOUtils.loadClass(this.getClass(), s)));
            }
            catch (Exception ex) {
                logger.warn("Unable to load WebSocketHandle instance", (Throwable)ex);
            }
        }
    }

    protected void configureScanningPackage(ServletConfig sc, String value) {
        String packageName = sc.getInitParameter(value);
        if (packageName != null) {
            String[] list = packageName.split(",");
            Collections.addAll(this.packages, list);
        }
    }

    protected void defaultPackagesToScan() {
        this.packages.add("io.async.control");
        this.packages.add("io.async.satellite");
        this.packages.add("io.async.postman");
    }

    public void configureBroadcasterFactory() {
        try {
            Class<?> bc;
            if (!this.isBroadcasterSpecified) {
                this.broadcasterClassName = this.lookupDefaultBroadcasterType(this.broadcasterClassName);
            }
            if (this.broadcasterFactoryClassName != null && this.broadcasterFactory == null) {
                this.broadcasterFactory = this.newClassInstance(BroadcasterFactory.class, IOUtils.loadClass(this.getClass(), this.broadcasterFactoryClassName));
                bc = IOUtils.loadClass(this.getClass(), this.broadcasterClassName);
                this.broadcasterFactory.configure(bc, this.broadcasterLifeCyclePolicy, this.config);
            }
            if (this.broadcasterFactory == null) {
                bc = IOUtils.loadClass(this.getClass(), this.broadcasterClassName);
                this.broadcasterFactory = this.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class);
                this.broadcasterFactory.configure(bc, this.broadcasterLifeCyclePolicy, this.config);
            }
            for (BroadcasterListener b : this.broadcasterListeners) {
                this.broadcasterFactory.addBroadcasterListener(b);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    protected void configureBroadcaster() {
        try {
            for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
                AtmosphereHandlerWrapper w = e.getValue();
                if (w.broadcaster == null) {
                    w.broadcaster = this.broadcasterFactory.get(w.mapping);
                    continue;
                }
                if (this.broadcasterCacheClassName == null || !w.broadcaster.getBroadcasterConfig().getBroadcasterCache().getClass().getName().equals(DefaultBroadcasterCache.class.getName())) continue;
                BroadcasterCache cache = this.newClassInstance(BroadcasterCache.class, IOUtils.loadClass(this.getClass(), this.broadcasterCacheClassName));
                cache.configure(this.config);
                w.broadcaster.getBroadcasterConfig().setBroadcasterCache(cache);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    protected void installAnnotationProcessor(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AnnotationProcessor");
        if (s != null) {
            this.annotationProcessorClassName = s;
        }
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useWebSocket");
        if (s != null) {
            this.webSocketEnabled = Boolean.parseBoolean(s);
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter("org.atmosphere.websocket.WebSocketProtocol")) != null) {
            this.webSocketProtocolClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.websocket.WebSocketProcessor")) != null) {
            this.webSocketProcessorClassName = s;
        }
        if ((s = this.config.getInitParameter("org.atmosphere.useWebSocketAndServlet3")) != null) {
            this.useServlet30 = Boolean.parseBoolean(s);
        }
    }

    protected void doInitParams(ServletConfig sc) {
        this.doInitParams(sc, false);
    }

    protected void doInitParams(ServletConfig sc, boolean reconfigure) {
        String s = sc.getInitParameter("org.atmosphere.useNative");
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useBlocking")) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useStream")) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        s = sc.getInitParameter("org.atmosphere.cpr.asyncSupport");
        if (this.asyncSupport == null && s != null && !reconfigure) {
            this.asyncSupport = new DefaultAsyncSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterClass")) != null) {
            this.broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterCacheClass")) != null) {
            this.broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.sessionSupport")) == null) {
            s = sc.getServletContext().getInitParameter("org.atmosphere.cpr.sessionSupport");
        }
        if (s != null || SessionSupport.initializationHint) {
            boolean sessionSupport = Boolean.parseBoolean(s) || SessionSupport.initializationHint;
            this.config.setSupportSession(sessionSupport);
            if (!sessionSupport || sc.getServletContext().getMajorVersion() < 3 || !SessionSupport.initializationHint) {
                // empty if block
            }
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.removeSessionTimeout")) != null) {
            this.config.setSessionTimeoutRemovalAllowed(Boolean.parseBoolean(s));
        }
        if ((s = sc.getInitParameter("org.atmosphere.throwExceptionOnClonedRequest")) != null) {
            this.config.setThrowExceptionOnCloned(Boolean.parseBoolean(s));
            this.isThrowExceptionOnClonedRequestSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.disableOnStateEvent")) != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", s);
        } else {
            this.initParams.put("org.atmosphere.disableOnStateEvent", "false");
        }
        s = sc.getInitParameter("org.atmosphere.cpr.broadcastFilterClasses");
        if (s != null) {
            this.broadcasterFilters.addAll(Arrays.asList(s.split(",")));
            logger.info("Installing BroadcastFilter class(es) {}", (Object)s);
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterLifeCyclePolicy")) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.broadcasterFactory")) != null) {
            this.broadcasterFactoryClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.atmosphereHandlerPath")) != null) {
            this.handlersPath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.atmosphereDotXml")) != null) {
            this.atmosphereDotXmlPath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.metaServicePath")) != null) {
            this.metaServicePath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.mappingRegex")) != null) {
            this.mappingRegex = s;
        }
        if ((s = sc.getInitParameter("com.sun.jersey.config.property.packages")) != null) {
            this.packages.add(s);
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereResource.defaultSerializer")) != null) {
            this.defaultSerializerClassName = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disable")) != null) {
            this.excludedInterceptors.addAll(Arrays.asList(s.trim().replace(" ", "").split(",")));
        }
    }

    public void loadConfiguration(ServletConfig sc) throws ServletException {
        if (!this.autoDetectHandlers) {
            return;
        }
        try {
            URL url = sc.getServletContext().getResource(this.handlersPath);
            ClassLoader urlC = url == null ? this.getClass().getClassLoader() : new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream(this.atmosphereDotXmlPath), urlC);
            if (this.atmosphereHandlers.isEmpty()) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.isEmpty()) {
                    this.detectSupportedFramework(sc);
                }
            }
            this.autoDetectWebSocketHandler(sc.getServletContext(), urlC);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws Exception {
        Object b;
        boolean isJersey;
        String broadcasterClassNameTmp = null;
        try {
            IOUtils.loadClass(this.getClass(), "com.sun.jersey.spi.container.servlet.ServletContainer");
            isJersey = true;
            if (!this.isBroadcasterSpecified) {
                broadcasterClassNameTmp = this.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster");
                IOUtils.loadClass(this.getClass(), broadcasterClassNameTmp);
            }
            this.useStreamForFlushingComments = true;
            StringBuilder packagesInit = new StringBuilder();
            for (String s : this.packages) {
                packagesInit.append(s).append(",");
            }
            this.initParams.put("com.sun.jersey.config.property.packages", packagesInit.toString());
        }
        catch (Throwable t) {
            logger.trace("", t);
            return false;
        }
        logger.debug("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
        ReflectorServletProcessor rsp = this.newClassInstance(ReflectorServletProcessor.class, ReflectorServletProcessor.class);
        if (broadcasterClassNameTmp != null) {
            this.broadcasterClassName = broadcasterClassNameTmp;
        }
        this.configureDetectedFramework(rsp, isJersey);
        this.sessionSupport(false);
        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null && (mapping = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler.contextRoot")) == null) {
            mapping = "/*";
        }
        Class<?> bc = IOUtils.loadClass(this.getClass(), this.broadcasterClassName);
        this.broadcasterFactory.destroy();
        this.broadcasterFactory = this.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class);
        this.broadcasterFactory.configure(bc, this.broadcasterLifeCyclePolicy, this.config);
        for (BroadcasterListener b2 : this.broadcasterListeners) {
            this.broadcasterFactory.addBroadcasterListener(b2);
        }
        try {
            b = this.broadcasterFactory.get(bc, mapping);
        }
        catch (IllegalStateException ex) {
            logger.warn("Two Broadcaster's named {}. Renaming the second one to {}", (Object)mapping, (Object)(sc.getServletName() + mapping));
            b = this.broadcasterFactory.get(bc, sc.getServletName() + mapping);
        }
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp, (Broadcaster)b);
        return true;
    }

    protected void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
        rsp.setServletClassName("com.sun.jersey.spi.container.servlet.ServletContainer");
    }

    protected String lookupDefaultBroadcasterType(String defaultB) {
        if (this.autodetectBroadcaster()) {
            for (String b : this.broadcasterTypes) {
                try {
                    Class.forName(b);
                    logger.info("Detected a Broadcaster {} on the classpath. This broadcaster will be used by default and will override any annotated resources. Set {} to false to change the behavior", (Object)b, (Object)"org.atmosphere.cpr.Broadcaster.scanClassPath");
                    this.isBroadcasterSpecified = true;
                    return b;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return defaultB;
    }

    boolean autodetectBroadcaster() {
        if (this.servletConfig == null) {
            return true;
        }
        String autodetect = this.servletConfig.getInitParameter("org.atmosphere.cpr.Broadcaster.scanClassPath");
        return autodetect == null || Boolean.parseBoolean(autodetect);
    }

    protected AtmosphereObjectFactory<?> lookupDefaultObjectFactoryType() {
        if (this.objectFactory != null && !DefaultAtmosphereObjectFactory.class.getName().equals(this.objectFactory.getClass().getName())) {
            return this.objectFactory;
        }
        for (String b : this.objectFactoryType) {
            try {
                Class<?> c = Class.forName(b);
                this.objectFactory = (AtmosphereObjectFactory)c.newInstance();
                break;
            }
            catch (ClassNotFoundException e) {
                logger.trace(e.getMessage() + " not found");
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
        }
        if (this.objectFactory == null || DefaultAtmosphereObjectFactory.class.getName().equals(this.objectFactory.getClass().getName())) {
            try {
                IOUtils.loadClass(this.getClass(), "jakarta.inject.Inject");
                this.objectFactory = new InjectableObjectFactory();
            }
            catch (Exception e) {
                logger.trace("jakarta.inject.Inject nor installed. Using DefaultAtmosphereObjectFactory");
                this.objectFactory = new DefaultAtmosphereObjectFactory();
            }
        }
        this.objectFactory.configure(this.config);
        return this.objectFactory;
    }

    public void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.setSupportSession(sessionSupport);
        } else if (!this.config.isSupportSession()) {
            this.config.setSupportSession(sessionSupport);
        }
    }

    public void initAtmosphereHandler(ServletConfig sc) throws ServletException {
        this.initAtmosphereHandler();
    }

    public void initAtmosphereHandler() throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = h.getValue();
            AtmosphereHandler a = w.atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(this.config);
        }
        this.checkWebSocketSupportState();
    }

    public void checkWebSocketSupportState() {
        if (this.atmosphereHandlers.isEmpty() && !SimpleHttpProtocol.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
            logger.debug("Adding a void AtmosphereHandler mapped to /* to allow WebSocket application only");
            this.addAtmosphereHandler("/*", new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource r) throws IOException {
                    logger.debug("No AtmosphereHandler defined.");
                    if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                        WebSocket.notSupported(r.getRequest(), r.getResponse());
                    }
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    public void initWebSocket() {
        if (this.webSocketProtocolInitialized) {
            return;
        }
        if (this.webSocketProtocol == null) {
            try {
                this.webSocketProtocol = this.newClassInstance(WebSocketProtocol.class, IOUtils.loadClass(this.getClass(), this.webSocketProtocolClassName));
                logger.info("Installed WebSocketProtocol {} ", (Object)this.webSocketProtocolClassName);
            }
            catch (Exception ex) {
                logger.error("Cannot load the WebSocketProtocol {}", (Object)this.getWebSocketProtocolClassName(), (Object)ex);
                try {
                    this.webSocketProtocol = this.newClassInstance(WebSocketProtocol.class, SimpleHttpProtocol.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.webSocketProtocolInitialized = true;
        this.webSocketProtocol.configure(this.config);
    }

    public void initEndpointMapper() {
        String s = this.servletConfig.getInitParameter("org.atmosphere.cpr.EndpointMapper");
        if (s != null) {
            try {
                this.endpointMapper = this.newClassInstance(EndpointMapper.class, IOUtils.loadClass(this.getClass(), s));
                logger.info("Installed EndpointMapper {} ", (Object)s);
            }
            catch (Exception ex) {
                logger.error("Cannot load the EndpointMapper {}", (Object)s, (Object)ex);
            }
        }
        this.endpointMapper.configure(this.config);
    }

    protected void closeAtmosphereResource() {
        for (AtmosphereResource r : this.config.resourcesFactory().findAll()) {
            try {
                r.resume().close();
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public AtmosphereFramework destroy() {
        if (this.isDestroyed.getAndSet(true)) {
            return this;
        }
        this.onPreDestroy();
        this.closeAtmosphereResource();
        this.destroyInterceptors();
        this.config.destroy();
        BroadcasterFactory factory = this.broadcasterFactory;
        if (factory != null) {
            factory.destroy();
        }
        if (this.asyncSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.asyncSupport.getClass())) {
            ((AsynchronousProcessor)this.asyncSupport).shutdown();
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = entry.getValue();
            try {
                handlerWrapper.atmosphereHandler.destroy();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        if (this.metaBroadcaster != null) {
            this.metaBroadcaster.destroy();
        }
        if (this.arFactory != null) {
            this.arFactory.destroy();
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.destroy();
        }
        WebSocketProcessorFactory.getDefault().destroy();
        ExecutorsFactory.reset(this.config);
        this.resetStates();
        this.onPostDestroy();
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                this.shutdownHook = null;
            }
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
        }
        this.config.properties().clear();
        return this;
    }

    protected void destroyInterceptors() {
        for (AtmosphereHandlerWrapper w : this.atmosphereHandlers.values()) {
            for (AtmosphereInterceptor i : w.interceptors) {
                try {
                    i.destroy();
                }
                catch (Throwable ex) {
                    logger.warn("", ex);
                }
            }
        }
    }

    public AtmosphereFramework resetStates() {
        this.isInit = false;
        this.executeFirstSet = false;
        this.broadcasterFilters.clear();
        this.asyncSupportListeners.clear();
        this.possibleComponentsCandidate.clear();
        this.initParams.clear();
        this.atmosphereHandlers.clear();
        this.broadcasterTypes.clear();
        this.objectFactoryType.clear();
        this.inspectors.clear();
        this.broadcasterListeners.clear();
        this.packages.clear();
        this.annotationPackages.clear();
        this.excludedInterceptors.clear();
        this.broadcasterCacheListeners.clear();
        this.filterManipulators.clear();
        this.interceptors.clear();
        this.broadcasterFactory = null;
        this.arFactory = null;
        this.metaBroadcaster = null;
        this.sessionFactory = null;
        this.annotationFound = false;
        return this;
    }

    protected void loadMetaService() {
        try {
            Map<String, MetaServiceAction> config = (Map<String, MetaServiceAction>)this.servletConfig.getServletContext().getAttribute(MetaServiceAction.class.getName());
            if (config == null) {
                config = IOUtils.readServiceFile(this.metaServicePath + AtmosphereFramework.class.getName());
            }
            for (Map.Entry action : config.entrySet()) {
                try {
                    Class<?> c = IOUtils.loadClass(AtmosphereFramework.class, (String)action.getKey());
                    ((MetaServiceAction)((Object)action.getValue())).apply(this, c);
                }
                catch (ClassNotFoundException ex) {
                    if (((String)action.getKey()).startsWith(ASYNC_IO)) {
                        logger.trace("Unable to load class {}", (Object)ex.getMessage());
                        continue;
                    }
                    logger.warn("", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
    }

    protected void loadAtmosphereDotXml(InputStream stream, ClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        logger.info("Found Atmosphere Configuration under {}", (Object)this.atmosphereDotXmlPath);
        AtmosphereConfigReader.getInstance().parse(this.config, stream);
        AtmosphereHandler handler = null;
        for (AtmosphereHandlerConfig atmoHandler : this.config.getAtmosphereHandlerConfig()) {
            try {
                Object bc;
                if (!atmoHandler.getClassName().startsWith("@")) {
                    handler = !ReflectorServletProcessor.class.getName().equals(atmoHandler.getClassName()) ? this.newClassInstance(AtmosphereHandler.class, IOUtils.loadClass(this.getClass(), atmoHandler.getClassName())) : this.newClassInstance(AtmosphereHandler.class, ReflectorServletProcessor.class);
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)atmoHandler.getContextRoot());
                }
                for (ApplicationConfiguration applicationConfiguration : atmoHandler.getApplicationConfig()) {
                    this.initParams.put(applicationConfiguration.getParamName(), applicationConfiguration.getParamValue());
                }
                for (FrameworkConfiguration frameworkConfiguration : atmoHandler.getFrameworkConfig()) {
                    this.initParams.put(frameworkConfiguration.getParamName(), frameworkConfiguration.getParamValue());
                }
                for (AtmosphereHandlerProperty atmosphereHandlerProperty : atmoHandler.getProperties()) {
                    if (atmosphereHandlerProperty.getValue() != null && atmosphereHandlerProperty.getValue().contains("jersey")) {
                        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
                        this.useStreamForFlushingComments = true;
                        this.broadcasterClassName = this.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster");
                        this.broadcasterFactory.destroy();
                        this.broadcasterFactory = null;
                        this.configureBroadcasterFactory();
                        this.configureBroadcaster();
                    }
                    if (handler == null) continue;
                    IntrospectionUtils.setProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                    IntrospectionUtils.addProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                }
                this.sessionSupport(Boolean.parseBoolean(atmoHandler.getSupportSession()));
                if (handler == null) continue;
                String broadcasterClass = atmoHandler.getBroadcaster();
                if (broadcasterClass != null) {
                    this.broadcasterClassName = broadcasterClass;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    bc = cl.loadClass(this.broadcasterClassName);
                    this.broadcasterFactory = this.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class);
                    this.broadcasterFactory.configure((Class<? extends Broadcaster>)bc, this.broadcasterLifeCyclePolicy, this.config);
                }
                Object t = this.broadcasterFactory.lookup(atmoHandler.getContextRoot(), true);
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(handler, (Broadcaster)t, this.config);
                this.addMapping(atmoHandler.getContextRoot(), wrapper);
                bc = atmoHandler.getBroadcasterCache();
                if (bc != null) {
                    this.broadcasterCacheClassName = bc;
                }
                if (atmoHandler.getCometSupport() != null) {
                    this.asyncSupport = (AsyncSupport)c.loadClass(atmoHandler.getCometSupport()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (atmoHandler.getBroadcastFilterClasses() != null) {
                    this.broadcasterFilters.addAll(atmoHandler.getBroadcastFilterClasses());
                }
                LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
                if (atmoHandler.getAtmosphereInterceptorClasses() != null) {
                    for (String a : atmoHandler.getAtmosphereInterceptorClasses()) {
                        try {
                            AtmosphereInterceptor ai = this.newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.getClass(), a));
                            l.add(ai);
                        }
                        catch (Throwable e) {
                            logger.warn("", e);
                        }
                    }
                }
                this.addInterceptorToWrapper(wrapper, l);
                if (l.isEmpty()) continue;
                logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)atmoHandler.getClassName());
            }
            catch (Throwable t) {
                logger.warn("Unable to load AtmosphereHandler class: " + atmoHandler.getClassName(), t);
                throw new ServletException(t);
            }
        }
    }

    public AtmosphereFramework setAsyncSupport(AsyncSupport asyncSupport) {
        this.asyncSupport = asyncSupport;
        return this;
    }

    public AtmosphereFramework setCometSupport(AsyncSupport asyncSupport) {
        return this.setAsyncSupport(asyncSupport);
    }

    public AsyncSupport getAsyncSupport() {
        return this.asyncSupport;
    }

    public AsyncSupport getCometSupport() {
        return this.asyncSupport;
    }

    protected AsyncSupportResolver createAsyncSupportResolver() {
        return new DefaultAsyncSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getAsyncSupport() == null) {
            this.setAsyncSupport(this.createAsyncSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.useServlet30));
        }
    }

    public void autoDetectAtmosphereHandlers(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        if (!this.atmosphereHandlers.isEmpty()) {
            return;
        }
        logger.info("Auto detecting atmosphere handlers {}", (Object)this.handlersPath);
        String realPath = servletContext.getRealPath(this.handlersPath);
        if (realPath == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, realPath);
    }

    public void loadAtmosphereHandlersFromPath(ClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.exists() && file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = this.newClassInstance(AtmosphereHandler.class, clazz);
                    this.addMapping("/" + handler.getClass().getSimpleName(), new AtmosphereHandlerWrapper(this.broadcasterFactory, handler, "/" + handler.getClass().getSimpleName(), this.config));
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handler.getClass().getName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    protected void autoDetectWebSocketHandler(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        if (this.hasNewWebSocketProtocol) {
            return;
        }
        logger.info("Auto detecting WebSocketHandler in {}", (Object)this.handlersPath);
        this.loadWebSocketFromPath(classloader, IOUtils.realPath(servletContext, this.handlersPath));
    }

    protected void loadWebSocketFromPath(ClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.exists() && file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!WebSocketProtocol.class.isAssignableFrom(clazz)) continue;
                    this.webSocketProtocol = this.newClassInstance(WebSocketProtocol.class, clazz);
                    logger.info("Installed WebSocketProtocol {}", (Object)this.webSocketProtocol);
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an WebSocketProtocol: " + className, t);
                }
            }
        }
    }

    private void getFiles(File f) {
        if (this.scanDone) {
            return;
        }
        File[] files = f.listFiles();
        for (File test : Objects.requireNonNull(files)) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleComponentsCandidate.add(clazz);
        }
    }

    public AtmosphereFramework configureRequestResponse(AtmosphereRequest req, AtmosphereResponse res) throws UnsupportedEncodingException {
        String unique;
        req.setAttribute("org.atmosphere.useStream", this.useStreamForFlushingComments);
        req.setAttribute("org.atmosphere.cpr.broadcasterClass", this.broadcasterClassName);
        req.setAttribute(FrameworkConfig.ATMOSPHERE_CONFIG, this.config);
        req.setAttribute(FrameworkConfig.THROW_EXCEPTION_ON_CLONED_REQUEST, "" + this.config.isThrowExceptionOnCloned());
        boolean skip = true;
        String s = this.config.getInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet");
        if (s != null) {
            skip = Boolean.parseBoolean(s);
        }
        if (!skip || req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
            Map<String, String> headers = this.configureQueryStringAsRequest(req);
            String body = headers.remove("X-Atmosphere-Post-Body");
            if (body != null && body.isEmpty()) {
                body = null;
            }
            req.headers(headers).method(body != null && req.getMethod().equalsIgnoreCase("GET") ? "POST" : req.getMethod());
            if (body != null) {
                req.body(URLDecoder.decode(body, req.getCharacterEncoding() == null ? "UTF-8" : req.getCharacterEncoding()));
            }
        }
        if (((s = req.getHeader("X-Atmosphere-tracking-id")) == null || s.equals("0")) && Boolean.parseBoolean(unique = this.config.getInitParameter("org.atmosphere.cpr.AtmosphereResource.uniqueUUID"))) {
            s = (String)req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        }
        if (s == null || s.equals("0")) {
            s = this.config.uuidProvider().generateUuid();
            res.setHeader("X-Atmosphere-first-request", "true");
            res.setHeader("X-Atmosphere-tracking-id", s);
            String contentType = this.config.getInitParameter("org.atmosphere.cpr.contentTypeFirstResponse");
            if (contentType != null) {
                res.setHeader("Content-Type", contentType);
            }
        } else if (req.resource() == null) {
            res.setHeader("X-Atmosphere-tracking-id", s);
        } else if (req.getAttribute(WebSocket.WEBSOCKET_INITIATED) == null) {
            res.setHeader("X-Atmosphere-tracking-id", s);
        }
        if (req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid") == null) {
            req.setAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid", s);
        }
        return this;
    }

    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (this.isDestroyed.get()) {
            return Action.CANCELLED;
        }
        Action a = null;
        try {
            this.configureRequestResponse(req, res);
            a = this.asyncSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereFramework exception", (Throwable)ex);
            throw ex;
        }
        finally {
            if (a != null) {
                this.notify(a.type(), req, res);
            }
            if (!this.externalizeDestroy && req != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                req.destroy();
                res.destroy();
                this.notify(Action.TYPE.DESTROYED, req, res);
            }
        }
        return a;
    }

    public String getDefaultBroadcasterClassName() {
        return this.broadcasterClassName;
    }

    public AtmosphereFramework setDefaultBroadcasterClassName(String bccn) {
        if (this.isBroadcasterSpecified) {
            logger.trace("Broadcaster {} already set in web.xml", (Object)this.broadcasterClassName);
            return this;
        }
        this.isBroadcasterSpecified = true;
        this.broadcasterClassName = bccn;
        this.broadcasterFactory = null;
        this.configureBroadcasterFactory();
        for (AtmosphereHandlerWrapper w : this.atmosphereHandlers.values()) {
            if (w.broadcaster == null) continue;
            w.broadcaster = this.broadcasterFactory.lookup(w.broadcaster.getID(), true);
        }
        return this;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public boolean isUseServlet30() {
        return this.useServlet30;
    }

    public AtmosphereFramework setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
        return this;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        if (this.broadcasterFactory == null) {
            this.configureBroadcasterFactory();
        }
        return this.broadcasterFactory;
    }

    public AtmosphereFramework setBroadcasterFactory(BroadcasterFactory broadcasterFactory) {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster();
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return this.broadcasterCacheClassName;
    }

    public AtmosphereFramework setBroadcasterCacheClassName(String broadcasterCacheClassName) {
        this.broadcasterCacheClassName = broadcasterCacheClassName;
        return this;
    }

    public AtmosphereFramework addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterTypes.add(broadcasterTypeString);
        return this;
    }

    public ConcurrentLinkedQueue<String> broadcasterTypes() {
        return this.broadcasterTypes;
    }

    public String getWebSocketProtocolClassName() {
        return this.webSocketProtocolClassName;
    }

    public AtmosphereFramework setWebSocketProtocolClassName(String webSocketProtocolClassName) {
        this.hasNewWebSocketProtocol = true;
        this.webSocketProtocolClassName = webSocketProtocolClassName;
        return this;
    }

    public Map<String, AtmosphereHandlerWrapper> getAtmosphereHandlers() {
        return this.atmosphereHandlers;
    }

    protected Map<String, String> configureQueryStringAsRequest(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        StringBuilder q = new StringBuilder();
        try {
            String qs = request.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                String[] params;
                for (String p : params = qs.split("&")) {
                    String value;
                    String[] s = p.split("=", 2);
                    String header = s[0];
                    String string = value = s.length > 1 ? s[1] : "";
                    if (header.equalsIgnoreCase("Content-Type") && (request.getContentType() == null || !request.getContentType().equalsIgnoreCase(s.length > 1 ? value : ""))) {
                        request.contentType(s.length > 1 ? URLDecoder.decode(value, "UTF-8") : "");
                    }
                    if (!(header.isEmpty() || header.toLowerCase().startsWith("x-atmo") || header.equalsIgnoreCase("X-Heartbeat-Server") || header.equalsIgnoreCase("Content-Type") || header.equalsIgnoreCase("_"))) {
                        q.append(header).append("=").append(s.length > 1 ? value : "").append("&");
                    }
                    headers.put(header, s.length > 1 ? value : "");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Unable to parse query string", (Throwable)ex);
        }
        String disallowModifyQueryString = this.config.getInitParameter("org.atmosphere.cpr.disallowModifyQueryString");
        if (disallowModifyQueryString == null || disallowModifyQueryString.length() == 0 || "false".equalsIgnoreCase(disallowModifyQueryString)) {
            if (q.length() > 0) {
                q.deleteCharAt(q.length() - 1);
            }
            request.queryString(q.toString());
        }
        logger.trace("Query String translated to headers {}", headers);
        return headers;
    }

    public WebSocketProtocol getWebSocketProtocol() {
        this.initWebSocket();
        return this.webSocketProtocol;
    }

    public boolean isUseNativeImplementation() {
        return this.useNativeImplementation;
    }

    public AtmosphereFramework setUseNativeImplementation(boolean useNativeImplementation) {
        this.useNativeImplementation = useNativeImplementation;
        return this;
    }

    public boolean isUseBlockingImplementation() {
        return this.useBlockingImplementation;
    }

    public AtmosphereFramework setUseBlockingImplementation(boolean useBlockingImplementation) {
        this.useBlockingImplementation = useBlockingImplementation;
        return this;
    }

    public String getAtmosphereDotXmlPath() {
        return this.atmosphereDotXmlPath;
    }

    public AtmosphereFramework setAtmosphereDotXmlPath(String atmosphereDotXmlPath) {
        this.atmosphereDotXmlPath = atmosphereDotXmlPath;
        return this;
    }

    public String getHandlersPath() {
        return this.handlersPath;
    }

    public AtmosphereFramework setHandlersPath(String handlersPath) {
        this.handlersPath = handlersPath;
        return this;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public AtmosphereFramework setLibPath(String libPath) {
        this.libPath = libPath;
        return this;
    }

    public String getWebSocketProcessorClassName() {
        return this.webSocketProcessorClassName;
    }

    public AtmosphereFramework setWebsocketProcessorClassName(String webSocketProcessorClassName) {
        this.webSocketProcessorClassName = webSocketProcessorClassName;
        return this;
    }

    public AtmosphereFramework interceptor(AtmosphereInterceptor c) {
        if (!this.checkDuplicate(c)) {
            this.interceptors.add(c);
            if (this.isInit) {
                this.addInterceptorToAllWrappers(c);
            }
        }
        return this;
    }

    protected void addDefaultOrAppInterceptors() {
        for (AtmosphereInterceptor c : this.interceptors) {
            this.addInterceptorToAllWrappers(c);
        }
    }

    protected void addInterceptorToAllWrappers(AtmosphereInterceptor c) {
        c.configure(this.config);
        InvokationOrder.PRIORITY p = InvokationOrder.class.isAssignableFrom(c.getClass()) ? ((InvokationOrder)((Object)c)).priority() : InvokationOrder.AFTER_DEFAULT;
        logger.info("Installed AtmosphereInterceptor {} with priority {} ", (Object)c, (Object)p.name());
        for (AtmosphereHandlerWrapper wrapper : this.atmosphereHandlers.values()) {
            this.addInterceptorToWrapper(wrapper, c);
        }
    }

    protected void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, AtmosphereInterceptor c) {
        if (!this.checkDuplicate(wrapper.interceptors, c.getClass())) {
            wrapper.interceptors.add(c);
            wrapper.interceptors.sort(new InterceptorComparator());
        }
    }

    protected void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, List<AtmosphereInterceptor> interceptors) {
        for (AtmosphereInterceptor c : this.interceptors) {
            this.addInterceptorToWrapper(wrapper, c);
        }
        for (AtmosphereInterceptor c : interceptors) {
            this.addInterceptorToWrapper(wrapper, c);
            c.configure(this.config);
        }
    }

    private boolean checkDuplicate(AtmosphereInterceptor c) {
        return this.checkDuplicate(this.interceptors, c.getClass());
    }

    private boolean checkDuplicate(List<AtmosphereInterceptor> interceptorList, Class<? extends AtmosphereInterceptor> c) {
        for (AtmosphereInterceptor i : interceptorList) {
            if (!i.getClass().equals(c)) continue;
            return true;
        }
        return false;
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptors;
    }

    public <T extends AtmosphereInterceptor> T interceptor(Class<T> c) {
        for (AtmosphereInterceptor i : this.interceptors) {
            if (!c.isInstance(i)) continue;
            return (T)((AtmosphereInterceptor)c.cast(i));
        }
        return null;
    }

    public AtmosphereFramework annotationProcessorClassName(String annotationProcessorClassName) {
        this.annotationProcessorClassName = annotationProcessorClassName;
        return this;
    }

    public AtmosphereFramework asyncSupportListener(AsyncSupportListener asyncSupportListener) {
        this.asyncSupportListeners.add(asyncSupportListener);
        return this;
    }

    public List<AsyncSupportListener> asyncSupportListeners() {
        return this.asyncSupportListeners;
    }

    public AtmosphereFramework addBroadcasterListener(BroadcasterListener b) {
        this.broadcasterFactory.addBroadcasterListener(b);
        this.broadcasterListeners.add(b);
        return this;
    }

    public AtmosphereFramework addBroadcasterCacheListener(BroadcasterCacheListener b) {
        this.broadcasterCacheListeners.add(b);
        return this;
    }

    public List<BroadcasterCacheListener> broadcasterCacheListeners() {
        return this.broadcasterCacheListeners;
    }

    public AtmosphereFramework addBroadcasterCacheInjector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    public ConcurrentLinkedQueue<BroadcasterCacheInspector> inspectors() {
        return this.inspectors;
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public List<String> broadcasterFilters() {
        return this.broadcasterFilters;
    }

    public AtmosphereFramework broadcasterFilters(BroadcastFilter f) {
        this.broadcasterFilters.add(f.getClass().getName());
        for (Broadcaster b : this.config.getBroadcasterFactory().lookupAll()) {
            b.getBroadcasterConfig().addFilter(f);
        }
        return this;
    }

    public boolean isShareExecutorServices() {
        return this.sharedThreadPools;
    }

    public AtmosphereFramework shareExecutorServices(boolean sharedThreadPools) {
        this.sharedThreadPools = sharedThreadPools;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoConfigureService(ServletContext sc) throws IOException {
        String path = this.handlersPath != DEFAULT_HANDLER_PATH ? this.handlersPath : IOUtils.realPath(sc, this.handlersPath);
        try {
            this.annotationProcessor = this.newClassInstance(AnnotationProcessor.class, IOUtils.loadClass(this.getClass(), this.annotationProcessorClassName));
            logger.info("Atmosphere is using {} for processing annotation", (Object)this.annotationProcessorClassName);
            this.annotationProcessor.configure(this.config);
            if (!this.packages.isEmpty()) {
                for (String s : this.packages) {
                    this.annotationProcessor.scan(s);
                }
            }
            if (!this.annotationFound) {
                File libFolder;
                File[] jars;
                String pathLibs;
                if (path != null) {
                    this.annotationProcessor.scan(new File(path));
                }
                String string = pathLibs = !this.libPath.equals(DEFAULT_LIB_PATH) ? this.libPath : IOUtils.realPath(sc, DEFAULT_LIB_PATH);
                if (pathLibs != null && (jars = (libFolder = new File(pathLibs)).listFiles((arg0, arg1) -> arg1.endsWith(".jar"))) != null) {
                    for (File file : jars) {
                        this.annotationProcessor.scan(file);
                    }
                }
            }
            if (!this.annotationFound && this.allowAllClassesScan) {
                logger.debug("Scanning all classes on the classpath");
                this.annotationProcessor.scanAll();
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        finally {
            if (this.annotationProcessor != null) {
                this.annotationProcessor.destroy();
            }
        }
    }

    public EndpointMapper<AtmosphereHandlerWrapper> endPointMapper() {
        return this.endpointMapper;
    }

    public AtmosphereFramework endPointMapper(EndpointMapper endpointMapper) {
        this.endpointMapper = endpointMapper;
        return this;
    }

    public AtmosphereFramework addAnnotationPackage(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            logger.error("Class {} must have a package defined", clazz);
        } else {
            this.packages.add(clazz.getPackage().getName());
        }
        return this;
    }

    public AtmosphereFramework notify(Action.TYPE type, AtmosphereRequest request, AtmosphereResponse response) {
        for (AsyncSupportListener l : this.asyncSupportListeners()) {
            try {
                switch (type) {
                    case TIMEOUT: {
                        l.onTimeout(request, response);
                        break;
                    }
                    case CANCELLED: {
                        l.onClose(request, response);
                        break;
                    }
                    case SUSPEND: {
                        l.onSuspend(request, response);
                        break;
                    }
                    case RESUME: {
                        l.onResume(request, response);
                        break;
                    }
                    case DESTROYED: {
                        l.onDestroyed(request, response);
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return this;
    }

    public AtmosphereFramework notifyDestroyed(String uuid) {
        for (AtmosphereResourceListener l : this.atmosphereResourceListeners()) {
            l.onDisconnect(uuid);
        }
        return this;
    }

    public AtmosphereFramework notifySuspended(String uuid) {
        for (AtmosphereResourceListener l : this.atmosphereResourceListeners()) {
            l.onSuspended(uuid);
        }
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(WebSocketHandler handler) {
        this.addWebSocketHandler("/*", handler);
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler) {
        this.addWebSocketHandler(path, handler, REFLECTOR_ATMOSPHEREHANDLER, Collections.emptyList());
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h) {
        this.addWebSocketHandler(path, handler, REFLECTOR_ATMOSPHEREHANDLER, Collections.emptyList());
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this).registerWebSocketHandler(path, new WebSocketProcessor.WebSocketHandlerProxy(this.broadcasterFactory.lookup(path, true).getClass(), handler));
        this.addAtmosphereHandler(path, h, l);
        return this;
    }

    public AtmosphereFramework annotationScanned(boolean b) {
        this.annotationFound = b;
        return this;
    }

    public boolean initialized() {
        return this.isInit;
    }

    public List<String> packages() {
        return this.packages;
    }

    public List<String> customAnnotationPackages() {
        return this.annotationPackages;
    }

    public AtmosphereFramework addCustomAnnotationPackage(Class p) {
        this.annotationPackages.addLast(p.getPackage().getName());
        return this;
    }

    public <T, U extends T> T newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        return this.objectFactory.newClassInstance(classType, defaultType);
    }

    public void objectFactory(AtmosphereObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.objectFactory.configure(this.config);
    }

    public AtmosphereFramework externalizeDestroy(boolean externalizeDestroy) {
        this.externalizeDestroy = externalizeDestroy;
        return this;
    }

    public AnnotationProcessor annotationProcessor() {
        return this.annotationProcessor;
    }

    public boolean isBroadcasterSpecified() {
        return this.isBroadcasterSpecified;
    }

    protected void configureObjectFactory() {
        String s = this.config.getInitParameter("org.atmosphere.cpr.objectFactory");
        if (s != null) {
            try {
                AtmosphereObjectFactory aci = (AtmosphereObjectFactory)IOUtils.loadClass(this.getClass(), s).newInstance();
                logger.debug("Found ObjectFactory {}", (Object)aci.getClass().getName());
                this.objectFactory(aci);
            }
            catch (Exception ex) {
                logger.warn("Unable to load AtmosphereClassInstantiator instance", (Throwable)ex);
            }
        }
        if (!DefaultAtmosphereObjectFactory.class.isAssignableFrom(this.objectFactory.getClass())) {
            logger.trace("ObjectFactory already set to {}", this.objectFactory);
        }
    }

    public AtmosphereFramework excludeInterceptor(String interceptor) {
        this.excludedInterceptors.add(interceptor);
        return this;
    }

    public AtmosphereFramework filterManipulator(BroadcasterConfig.FilterManipulator m) {
        this.filterManipulators.add(m);
        return this;
    }

    public List<BroadcasterConfig.FilterManipulator> filterManipulators() {
        return this.filterManipulators;
    }

    public boolean isAServletFilter() {
        return this.isFilter;
    }

    public ConcurrentLinkedQueue<String> objectFactoryType() {
        return this.objectFactoryType;
    }

    public String mappingRegex() {
        return this.mappingRegex;
    }

    public AtmosphereFramework mappingRegex(String mappingRegex) {
        this.mappingRegex = mappingRegex;
        return this;
    }

    public void setUseServlet30(boolean useServlet30) {
        this.useServlet30 = useServlet30;
    }

    public boolean webSocketEnabled() {
        return this.webSocketEnabled;
    }

    public AtmosphereFramework webSocketEnabled(boolean webSocketEnabled) {
        this.webSocketEnabled = webSocketEnabled;
        return this;
    }

    public String broadcasterLifeCyclePolicy() {
        return this.broadcasterLifeCyclePolicy;
    }

    public AtmosphereFramework broadcasterLifeCyclePolicy(String broadcasterLifeCyclePolicy) {
        this.broadcasterLifeCyclePolicy = broadcasterLifeCyclePolicy;
        return this;
    }

    public List<BroadcasterListener> broadcasterListeners() {
        return this.broadcasterListeners;
    }

    public boolean sharedThreadPools() {
        return this.sharedThreadPools;
    }

    public AtmosphereFramework sharedThreadPools(boolean sharedThreadPools) {
        this.sharedThreadPools = sharedThreadPools;
        return this;
    }

    public boolean allowAllClassesScan() {
        return this.allowAllClassesScan;
    }

    public AtmosphereFramework allowAllClassesScan(boolean allowAllClassesScan) {
        this.allowAllClassesScan = allowAllClassesScan;
        return this;
    }

    public AtmosphereObjectFactory objectFactory() {
        return this.objectFactory;
    }

    public boolean externalizeDestroy() {
        return this.externalizeDestroy;
    }

    public List<String> excludedInterceptors() {
        return this.excludedInterceptors;
    }

    public Class<? extends AtmosphereInterceptor>[] defaultInterceptors() {
        return DEFAULT_ATMOSPHERE_INTERCEPTORS.toArray(new Class[DEFAULT_ATMOSPHERE_INTERCEPTORS.size()]);
    }

    public AtmosphereResourceFactory atmosphereFactory() {
        if (this.arFactory == null) {
            this.configureAtmosphereResourceFactory();
        }
        return this.arFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtmosphereFramework configureAtmosphereResourceFactory() {
        if (this.arFactory != null) {
            return this;
        }
        AtmosphereFramework atmosphereFramework = this;
        synchronized (atmosphereFramework) {
            try {
                this.arFactory = this.newClassInstance(AtmosphereResourceFactory.class, DefaultAtmosphereResourceFactory.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
            this.arFactory.configure(this.config);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtmosphereFramework configureWebSocketFactory() {
        if (this.webSocketFactory != null) {
            return this;
        }
        AtmosphereFramework atmosphereFramework = this;
        synchronized (atmosphereFramework) {
            try {
                this.webSocketFactory = this.newClassInstance(WebSocketFactory.class, DefaultWebSocketFactory.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
        }
        return this;
    }

    public MetaBroadcaster metaBroadcaster() {
        return this.metaBroadcaster;
    }

    private AtmosphereFramework configureMetaBroadcaster() {
        try {
            this.metaBroadcaster = this.newClassInstance(MetaBroadcaster.class, DefaultMetaBroadcaster.class);
            this.metaBroadcaster.configure(this.config);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
        }
        return this;
    }

    public String getDefaultSerializerClassName() {
        return this.defaultSerializerClassName;
    }

    public Class<Serializer> getDefaultSerializerClass() {
        return this.defaultSerializerClass;
    }

    public AtmosphereFramework setDefaultSerializerClassName(String defaultSerializerClassName) {
        this.defaultSerializerClassName = defaultSerializerClassName;
        this.initDefaultSerializer();
        return this;
    }

    private void initDefaultSerializer() {
        block5: {
            if (this.defaultSerializerClassName != null && !this.defaultSerializerClassName.isEmpty()) {
                try {
                    Class<?> clazz = IOUtils.loadClass(Serializer.class, this.defaultSerializerClassName);
                    if (Serializer.class.isAssignableFrom(clazz)) {
                        this.defaultSerializerClass = clazz;
                        break block5;
                    }
                    logger.error("Default Serializer class name does not implement Serializer interface");
                    this.defaultSerializerClassName = null;
                    this.defaultSerializerClass = null;
                }
                catch (Exception e) {
                    logger.error("Unable to set default Serializer", (Throwable)e);
                    this.defaultSerializerClassName = null;
                    this.defaultSerializerClass = null;
                }
            } else {
                this.defaultSerializerClassName = null;
                this.defaultSerializerClass = null;
            }
        }
    }

    public synchronized AtmosphereResourceSessionFactory sessionFactory() {
        if (this.sessionFactory == null) {
            try {
                this.sessionFactory = this.newClassInstance(AtmosphereResourceSessionFactory.class, DefaultAtmosphereResourceSessionFactory.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
        }
        return this.sessionFactory;
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public AtmosphereFramework frameworkListener(AtmosphereFrameworkListener l) {
        this.frameworkListeners.add(l);
        return this;
    }

    public List<AtmosphereFrameworkListener> frameworkListeners() {
        return this.frameworkListeners;
    }

    protected void onPreInit() {
        for (AtmosphereFrameworkListener l : this.frameworkListeners) {
            try {
                l.onPreInit(this);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    protected void onPostInit() {
        for (AtmosphereFrameworkListener l : this.frameworkListeners) {
            try {
                l.onPostInit(this);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    protected void onPreDestroy() {
        for (AtmosphereFrameworkListener l : this.frameworkListeners) {
            try {
                l.onPreDestroy(this);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    protected void onPostDestroy() {
        for (AtmosphereFrameworkListener l : this.frameworkListeners) {
            try {
                l.onPostDestroy(this);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public List<AtmosphereResourceListener> atmosphereResourceListeners() {
        return this.atmosphereResourceListeners;
    }

    public AtmosphereFramework atmosphereResourceListener(AtmosphereResourceListener atmosphereResourceListener) {
        this.atmosphereResourceListeners.add(atmosphereResourceListener);
        return this;
    }

    public AtmosphereFramework uuidProvider(UUIDProvider uuidProvider) {
        this.uuidProvider = uuidProvider;
        return this;
    }

    public UUIDProvider uuidProvider() {
        return this.uuidProvider;
    }

    public WebSocketFactory webSocketFactory() {
        if (this.webSocketFactory == null) {
            this.configureWebSocketFactory();
        }
        return this.webSocketFactory;
    }

    public AtmosphereFramework webSocketFactory(WebSocketFactory webSocketFactory) {
        this.webSocketFactory = webSocketFactory;
        return this;
    }

    public void initializationError(IllegalStateException initializationError) {
        this.initializationError = initializationError;
    }

    private static class InterceptorComparator
    implements Comparator<AtmosphereInterceptor> {
        private InterceptorComparator() {
        }

        @Override
        public int compare(AtmosphereInterceptor i1, AtmosphereInterceptor i2) {
            InvokationOrder.PRIORITY p1 = i1 instanceof InvokationOrder ? ((InvokationOrder)((Object)i1)).priority() : InvokationOrder.PRIORITY.AFTER_DEFAULT;
            InvokationOrder.PRIORITY p2 = i2 instanceof InvokationOrder ? ((InvokationOrder)((Object)i2)).priority() : InvokationOrder.PRIORITY.AFTER_DEFAULT;
            int orderResult = 0;
            switch (p1) {
                case AFTER_DEFAULT: {
                    switch (p2) {
                        case BEFORE_DEFAULT: 
                        case FIRST_BEFORE_DEFAULT: {
                            orderResult = 1;
                        }
                    }
                    break;
                }
                case BEFORE_DEFAULT: {
                    switch (p2) {
                        case AFTER_DEFAULT: {
                            orderResult = -1;
                            break;
                        }
                        case FIRST_BEFORE_DEFAULT: {
                            orderResult = 1;
                        }
                    }
                    break;
                }
                case FIRST_BEFORE_DEFAULT: {
                    switch (p2) {
                        case BEFORE_DEFAULT: 
                        case AFTER_DEFAULT: {
                            orderResult = -1;
                        }
                    }
                }
            }
            return orderResult;
        }
    }

    public static class DefaultAtmosphereObjectFactory
    implements AtmosphereObjectFactory<Object> {
        public String toString() {
            return "DefaultAtmosphereObjectFactory";
        }

        @Override
        public void configure(AtmosphereConfig config) {
        }

        @Override
        public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
            return defaultType.newInstance();
        }

        @Override
        public AtmosphereObjectFactory<Object> allowInjectionOf(Object o) {
            return this;
        }
    }

    public static enum MetaServiceAction {
        INSTALL(new InstallMetaServiceProcedure()),
        EXCLUDE(new ExcludeMetaServiceProcedure());

        private MetaServiceProcedure procedure;

        private MetaServiceAction(MetaServiceProcedure p) {
            this.procedure = p;
        }

        public void apply(AtmosphereFramework fwk, Class<?> clazz) throws Exception {
            this.procedure.apply(fwk, clazz);
        }

        private static class ExcludeMetaServiceProcedure
        implements MetaServiceProcedure {
            private ExcludeMetaServiceProcedure() {
            }

            @Override
            public void apply(AtmosphereFramework fwk, Class<?> c) {
                if (AtmosphereInterceptor.class.isAssignableFrom(c)) {
                    fwk.excludeInterceptor(c.getName());
                } else {
                    logger.warn("{} is not a framework service that could be excluded, pull request is welcome ;-)", (Object)c.getName());
                }
            }
        }

        private static class InstallMetaServiceProcedure
        implements MetaServiceProcedure {
            private InstallMetaServiceProcedure() {
            }

            public void apply(AtmosphereFramework fwk, Class c) throws Exception {
                if (AtmosphereInterceptor.class.isAssignableFrom(c)) {
                    fwk.interceptor(fwk.newClassInstance(AtmosphereInterceptor.class, c));
                } else if (Broadcaster.class.isAssignableFrom(c)) {
                    fwk.setDefaultBroadcasterClassName(c.getName());
                } else if (BroadcasterListener.class.isAssignableFrom(c)) {
                    fwk.addBroadcasterListener(fwk.newClassInstance(BroadcasterListener.class, c));
                } else if (BroadcasterCache.class.isAssignableFrom(c)) {
                    fwk.setBroadcasterCacheClassName(c.getName());
                } else if (BroadcastFilter.class.isAssignableFrom(c)) {
                    fwk.broadcasterFilters.add(c.getName());
                } else if (BroadcasterCacheInspector.class.isAssignableFrom(c)) {
                    fwk.inspectors.add(fwk.newClassInstance(BroadcasterCacheInspector.class, c));
                } else if (AsyncSupportListener.class.isAssignableFrom(c)) {
                    fwk.asyncSupportListeners.add(fwk.newClassInstance(AsyncSupportListener.class, c));
                } else if (AsyncSupport.class.isAssignableFrom(c)) {
                    fwk.setAsyncSupport(fwk.newClassInstance(AsyncSupport.class, c));
                } else if (BroadcasterCacheListener.class.isAssignableFrom(c)) {
                    fwk.broadcasterCacheListeners.add(fwk.newClassInstance(BroadcasterCacheListener.class, c));
                } else if (BroadcasterConfig.FilterManipulator.class.isAssignableFrom(c)) {
                    fwk.filterManipulators.add(fwk.newClassInstance(BroadcasterConfig.FilterManipulator.class, c));
                } else if (WebSocketProtocol.class.isAssignableFrom(c)) {
                    fwk.webSocketProtocolClassName = c.getName();
                } else if (WebSocketProcessor.class.isAssignableFrom(c)) {
                    fwk.webSocketProcessorClassName = c.getName();
                } else if (AtmosphereResourceFactory.class.isAssignableFrom(c)) {
                    fwk.setAndConfigureAtmosphereResourceFactory(fwk.newClassInstance(AtmosphereResourceFactory.class, c));
                } else if (AtmosphereFrameworkListener.class.isAssignableFrom(c)) {
                    fwk.frameworkListener(fwk.newClassInstance(AtmosphereFrameworkListener.class, c));
                } else if (WebSocketFactory.class.isAssignableFrom(c)) {
                    fwk.webSocketFactory(fwk.newClassInstance(WebSocketFactory.class, c));
                } else if (!AtmosphereFramework.class.isAssignableFrom(c)) {
                    if (EndpointMapper.class.isAssignableFrom(c)) {
                        fwk.endPointMapper(fwk.newClassInstance(EndpointMapper.class, c));
                    } else {
                        logger.warn("{} is not a framework service that could be installed", (Object)c.getName());
                    }
                }
            }
        }

        private static interface MetaServiceProcedure {
            public void apply(AtmosphereFramework var1, Class<?> var2) throws Exception;
        }
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;
        public String mapping;
        public final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
        public boolean create;
        private boolean needRequestScopedInjection;
        private final boolean wilcardMapping;

        public AtmosphereHandlerWrapper(BroadcasterFactory broadcasterFactory, AtmosphereHandler atmosphereHandler, String mapping, AtmosphereConfig config) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                if (broadcasterFactory != null) {
                    this.broadcaster = broadcasterFactory.lookup(mapping, true);
                } else {
                    this.mapping = mapping;
                }
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
            this.wilcardMapping = mapping.contains("{") && mapping.contains("}");
            this.hookInjection(config);
        }

        void hookInjection(AtmosphereConfig config) {
            config.startupHook(framework -> {
                this.needRequestScopedInjection = Utils.requestScopedInjection(config, this.atmosphereHandler);
            });
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster, AtmosphereConfig config) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
            this.hookInjection(config);
            this.wilcardMapping = false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.interceptors.size(); ++i) {
                b.append("\n\t").append(i).append(": ").append(this.interceptors.get(i).getClass().getName());
            }
            return "\n atmosphereHandler\n\t" + this.atmosphereHandler + "\n interceptors" + b.toString() + "\n broadcaster\t" + this.broadcaster;
        }

        public boolean needRequestScopedInjection() {
            return this.needRequestScopedInjection;
        }

        public boolean wildcardMapping() {
            return this.wilcardMapping;
        }
    }
}

