/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.CompletionAware;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.util.QueryStringDecoder;
import org.atmosphere.util.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereRequestImpl
extends HttpServletRequestWrapper
implements AtmosphereRequest {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereRequestImpl.class);
    private ServletInputStream bis;
    private BufferedReader br;
    private final Builder b;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private boolean queryComputed;
    private boolean cookieComputed;
    private volatile BufferedReader voidReader;
    private final ServletInputStream voidStream = new IS(new ByteArrayInputStream(new byte[0]));
    private AtomicBoolean streamSet = new AtomicBoolean();
    private AtomicBoolean readerSet = new AtomicBoolean();
    private String uuid;
    private boolean noopsAsyncContextStarted;

    private AtmosphereRequestImpl(Builder b) {
        super((HttpServletRequest)(b.request == null ? new NoOpsRequest() : b.request));
        if (b.request == null) {
            b.request(new NoOpsRequest());
        }
        this.b = b;
        this.uuid = this.resource() != null ? this.resource().uuid() : "0";
    }

    private BufferedReader getVoidReader() {
        if (this.voidReader == null) {
            this.voidReader = new BufferedReader(new StringReader(""), 5);
        }
        return this.voidReader;
    }

    private void configureStream() {
        if (this.bis == null && !this.streamSet.getAndSet(true)) {
            if (this.b.inputStream != null) {
                this.bis = new IS(this.b.inputStream);
            } else if (this.b.reader == null) {
                if (this.b.body.dataBytes != null) {
                    this.bis = new ByteInputStream(this.b.body.dataBytes, this.b.body.offset, this.b.body.length);
                } else if (this.b.body.data != null) {
                    byte[] bytes = this.b.body.data.getBytes(StandardCharsets.UTF_8);
                    this.bis = new ByteInputStream(bytes, 0, bytes.length);
                }
            } else {
                this.bis = new IS(new ReaderInputStream(this.b.reader));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureReader() {
        if (this.br != null || this.readerSet.getAndSet(false)) return;
        if (this.b.reader != null) {
            this.br = new BufferedReader(this.b.reader);
            return;
        } else if (this.b.inputStream == null) {
            try {
                if (this.b.body.dataBytes != null) {
                    this.br = new BufferedReader(new StringReader(new String(this.b.body.dataBytes, this.b.body.offset, this.b.body.length, this.b.encoding)));
                    return;
                }
                if (this.b.body.data == null) return;
                this.br = new BufferedReader(new StringReader(this.b.body.data));
                return;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.br = new BufferedReader(new InputStreamReader(this.b.inputStream));
        }
    }

    @Override
    public boolean destroyed() {
        return this.destroyed.get();
    }

    @Override
    public AtmosphereRequest destroyable(boolean destroyable) {
        this.b.destroyable = destroyable;
        return this;
    }

    @Override
    public String getPathInfo() {
        return !Objects.equals(this.b.pathInfo, "") ? this.b.pathInfo : (this.isNotNoOps() ? this.b.request.getPathInfo() : "");
    }

    @Override
    public String getPathTranslated() {
        return this.b.request.getPathTranslated();
    }

    @Override
    public String getQueryString() {
        return !Objects.equals(this.b.queryString, "") ? this.b.queryString : (this.isNotNoOps() ? this.b.request.getQueryString() : this.toQs());
    }

    private String toQs() {
        StringBuilder q = new StringBuilder();
        for (Map.Entry e : this.b.queryStrings.entrySet()) {
            for (String k : (String[])e.getValue()) {
                q.append((String)e.getKey()).append("=").append(k).append("&");
            }
        }
        if (q.length() > 0) {
            q.deleteCharAt(q.length() - 1);
        }
        return q.toString();
    }

    @Override
    public String getRemoteUser() {
        return this.b.principal != null ? this.b.principal.getName() : this.b.request.getRemoteUser();
    }

    @Override
    public String getRequestedSessionId() {
        return this.b.request.getRequestedSessionId();
    }

    @Override
    public String getMethod() {
        return this.b.methodType != null ? this.b.methodType : this.b.request.getMethod();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        return this.b.request.getPart(name);
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return this.b.request.getParts();
    }

    @Override
    public String getContentType() {
        return this.b.contentType != null || this.b.noContentType ? this.b.contentType : this.b.request.getContentType();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this.b.request.getDispatcherType();
    }

    @Override
    public String getServletPath() {
        return !Objects.equals(this.b.servletPath, "") ? this.b.servletPath : (this.isNotNoOps() ? this.b.request.getServletPath() : "");
    }

    @Override
    public String getRequestURI() {
        return this.b.requestURI != null ? this.b.requestURI : (this.isNotNoOps() ? this.b.request.getRequestURI() : "");
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.b.requestURL != null ? new StringBuffer(this.b.requestURL) : (this.isNotNoOps() ? this.b.request.getRequestURL() : new StringBuffer());
    }

    @Override
    public Enumeration getHeaders(String name) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!name.equalsIgnoreCase("content-type")) {
            Enumeration e = this.b.request.getHeaders(name);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
        }
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.getContentType();
            if (s != null) {
                list.add(s);
            }
        } else {
            if (this.b.headers.get(name) != null) {
                list.add(this.b.headers.get(name));
            }
            if (this.isNotNoOps() && list.isEmpty() && name.startsWith("X-Atmosphere") && AtmosphereRequestImpl.attributeWithoutException(this.b.request, name) != null) {
                list.add(AtmosphereRequestImpl.attributeWithoutException(this.b.request, name));
            }
        }
        return Collections.enumeration(list);
    }

    @Override
    public int getIntHeader(String name) {
        return this.b.request.getIntHeader(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        HashSet<Object> list = new HashSet<Object>();
        list.addAll(this.b.headers.keySet());
        list.addAll(Collections.list(this.b.request.getHeaderNames()));
        if (this.b.request != null) {
            Enumeration e = this.b.request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("X-Atmosphere")) continue;
                list.add(name);
            }
        }
        if (this.b.contentType != null) {
            list.add("Content-Type");
        }
        return Collections.enumeration(list);
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.b.request.authenticate(response);
    }

    @Override
    public String getAuthType() {
        return this.b.authType != null ? this.b.authType : this.b.request.getAuthType();
    }

    @Override
    public String getContextPath() {
        String c = "/";
        try {
            c = this.isNotNoOps() && this.b.request.getContextPath() != null ? this.b.request.getContextPath() : (this.b.contextPath != null ? this.b.contextPath : "");
        }
        catch (NullPointerException ex) {
            logger.warn("Unexpected getContextPath exception. Forcing `/`", (Throwable)ex);
        }
        return c;
    }

    @Override
    public Cookie[] getCookies() {
        if (!this.cookieComputed) {
            if (this.b.cookies == null) {
                return new Cookie[0];
            }
            this.cookieComputed = true;
            Cookie[] c = this.b.request.getCookies();
            if (c != null && c.length > 0) {
                this.b.cookies.addAll(Arrays.asList(c));
            }
        }
        return this.b.cookies.toArray(new Cookie[0]);
    }

    @Override
    public long getDateHeader(String name) {
        return this.b.request.getDateHeader(name);
    }

    @Override
    public String getHeader(String s) {
        return this.getHeader(s, true);
    }

    @Override
    public HttpServletRequest wrappedRequest() {
        return this.b.request;
    }

    @Override
    public String getHeader(String s, boolean checkCase) {
        String name;
        block11: {
            if ("content-type".equalsIgnoreCase(s)) {
                return this.getContentType();
            }
            name = this.b.request.getHeader(s);
            if (name == null) {
                if (this.b.headers.get(s) != null) {
                    return (String)this.b.headers.get(s);
                }
                if (s.startsWith("X-Atmosphere") && this.isNotNoOps()) {
                    Object o = AtmosphereRequestImpl.attributeWithoutException(this.b.request, s);
                    if (o == null || String.class.isAssignableFrom(o.getClass())) {
                        name = (String)o;
                    } else {
                        try {
                            if (!HttpServletRequestWrapper.class.isAssignableFrom(this.b.request.getClass())) break block11;
                            HttpServletRequest hsr = this.b.request;
                            while (hsr instanceof HttpServletRequestWrapper) {
                                o = AtmosphereRequestImpl.attributeWithoutException(hsr = (HttpServletRequest)((HttpServletRequestWrapper)hsr).getRequest(), s);
                                if (o != null && !String.class.isAssignableFrom(o.getClass())) continue;
                                name = (String)o;
                                break;
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("", (Throwable)ex);
                        }
                    }
                }
            }
        }
        if (name == null && checkCase) {
            return this.getHeader(s.toLowerCase(), false);
        }
        if (name == null && "connection".equalsIgnoreCase(s)) {
            return "keep-alive";
        }
        return name;
    }

    @Override
    public String getParameter(String s) {
        String name;
        String string = name = this.isNotNoOps() ? this.b.request.getParameter(s) : null;
        if (name == null && this.b.queryStrings.get(s) != null) {
            return ((String[])this.b.queryStrings.get(s))[0];
        }
        return name;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (!this.queryComputed) {
            this.queryComputed = true;
            Map m = this.isNotNoOps() ? this.b.request.getParameterMap() : Collections.emptyMap();
            for (String e : m.keySet()) {
                this.b.queryStrings.put(e, this.getParameterValues(e));
            }
        }
        return Collections.unmodifiableMap(this.b.queryStrings);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    @Override
    public String[] getParameterValues(String s) {
        Object[] list = this.b.request.getParameterValues(s);
        if (list != null && this.b.queryStrings.get(s) != null) {
            Object[] newList = (String[])this.b.queryStrings.get(s);
            if (!Arrays.deepEquals(list, newList)) {
                String[] s1 = new String[list.length + newList.length];
                System.arraycopy(list, 0, s1, 0, list.length);
                System.arraycopy(newList, 0, s1, list.length, newList.length);
                return s1;
            }
            return list;
        }
        return list == null ? (String[])this.b.queryStrings.get(s) : list;
    }

    @Override
    public String getProtocol() {
        return this.b.request.getProtocol();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.b.body.isEmpty()) {
            this.configureStream();
            return this.bis == null ? (this.isNotNoOps() ? this.b.request.getInputStream() : this.voidStream) : this.bis;
        }
        if (this.b.body.hasString()) {
            this.bis = new IS(new ByteArrayInputStream(this.b.body.asString().getBytes()));
        } else if (this.b.body.hasBytes()) {
            this.bis = new IS(new ByteArrayInputStream(this.b.body.asBytes(), this.b.body.offset, this.b.body.byteLength()));
        }
        return this.bis;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.b.body.isEmpty()) {
            this.configureReader();
            return this.br == null ? (this.isNotNoOps() ? this.b.request.getReader() : this.getVoidReader()) : this.br;
        }
        if (this.b.body.hasString()) {
            this.br = new BufferedReader(new StringReader(this.body().asString()));
        } else if (this.b.body.hasBytes()) {
            this.br = new BufferedReader(new StringReader(new String(this.body().asBytes(), this.body().byteOffset(), this.body().length)));
        }
        return this.br;
    }

    @Override
    public String getRealPath(String path) {
        return this.b.request.getRealPath(path);
    }

    @Override
    public AtmosphereRequest headers(Map<String, String> headers) {
        this.b.headers.putAll(headers);
        return this;
    }

    @Override
    public AtmosphereRequest header(String name, String value) {
        this.b.headers.put(name, value);
        return this;
    }

    @Override
    public AtmosphereRequest queryString(String qs) {
        if (qs == null) {
            return this;
        }
        if (!qs.isEmpty()) {
            QueryStringDecoder decoder = new QueryStringDecoder(this.getRequestURI() + "?" + qs);
            Map<String, List<String>> m = decoder.getParameters();
            HashMap<String, String[]> newM = new HashMap<String, String[]>();
            for (Map.Entry<String, List<String>> q : m.entrySet()) {
                newM.put(q.getKey(), q.getValue().toArray(new String[0]));
            }
            this.b.queryStrings(newM);
        }
        this.b.queryString = qs;
        return this;
    }

    @Override
    public Map<String, String> headersMap() {
        return this.b.headers;
    }

    @Override
    public Map<String, String[]> queryStringsMap() {
        return this.b.queryStrings;
    }

    @Override
    public AtmosphereRequest method(String m) {
        this.b.method(m);
        return this;
    }

    @Override
    public AtmosphereRequest contentType(String m) {
        this.b.contentType(m);
        return this;
    }

    @Override
    public AtmosphereRequest body(String body) {
        this.b.body = new Body(body, null, 0, 0);
        return this;
    }

    @Override
    public AtmosphereRequest body(byte[] bytes) {
        this.b.body = new Body(null, bytes, 0, bytes.length);
        return this;
    }

    @Override
    public AtmosphereRequest body(InputStream body) {
        this.bis = new IS(body);
        this.br = new BufferedReader(new InputStreamReader(body));
        return this;
    }

    @Override
    public AtmosphereRequest body(Reader body) {
        this.bis = new IS(new ReaderInputStream(body));
        this.br = new BufferedReader(body);
        return this;
    }

    @Override
    public Body body() {
        return this.b.body;
    }

    @Override
    public AtmosphereRequest servletPath(String servletPath) {
        this.b.servletPath = servletPath;
        return this;
    }

    @Override
    public AtmosphereRequest contextPath(String contextPath) {
        this.b.contextPath = contextPath;
        return this;
    }

    @Override
    public AtmosphereRequest requestURI(String requestURI) {
        this.b.requestURI = requestURI;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String s, Object o) {
        if (o == null) {
            this.removeAttribute(s);
            return;
        }
        this.b.localAttributes.put(s, o);
        if (this.isNotNoOps() && !this.destroyed.get()) {
            try {
                HttpServletRequest httpServletRequest = this.b.request;
                synchronized (httpServletRequest) {
                    this.b.request.setAttribute(s, o);
                }
            }
            catch (NullPointerException ex) {
                logger.trace("", (Throwable)ex);
            }
        }
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.b.request.setCharacterEncoding(env);
    }

    @Override
    public AsyncContext startAsync() {
        AsyncContext ac;
        if (AtmosphereResource.TRANSPORT.WEBSOCKET == this.resource().transport()) {
            this.noopsAsyncContextStarted = true;
            ac = new NoOpsAsyncContext(this.getRequest(), this.resource().getResponse().getResponse());
        } else {
            ac = this.b.request.startAsync();
        }
        return this.isCompletionAware() ? new CompletionAwareAsyncContext(ac, (CompletionAware)((Object)this.resource().getResponse())) : ac;
    }

    @Override
    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        AsyncContext ac;
        if (AtmosphereResource.TRANSPORT.WEBSOCKET == this.resource().transport()) {
            this.noopsAsyncContextStarted = true;
            ac = new NoOpsAsyncContext(request, response);
        } else {
            ac = this.b.request.startAsync(request, response);
        }
        return this.isCompletionAware() ? new CompletionAwareAsyncContext(ac, (CompletionAware)((Object)this.resource().getResponse())) : ac;
    }

    @Override
    public AsyncContext getAsyncContext() {
        AsyncContext ac;
        if (AtmosphereResource.TRANSPORT.WEBSOCKET == this.resource().transport()) {
            this.noopsAsyncContextStarted = true;
            ac = new NoOpsAsyncContext(this.getRequest(), this.resource().getResponse().getResponse());
        } else {
            ac = this.b.request.getAsyncContext();
        }
        return this.isCompletionAware() ? new CompletionAwareAsyncContext(ac, (CompletionAware)((Object)this.resource().getResponse())) : ac;
    }

    @Override
    public Object getAttribute(String s) {
        return this.b.localAttributes.get(s) != null ? this.b.localAttributes.get(s) : (this.isNotNoOps() ? AtmosphereRequestImpl.attributeWithoutException(this.b.request, s) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        this.b.localAttributes.remove(name);
        if (this.isNotNoOps() && !this.destroyed.get()) {
            HttpServletRequest httpServletRequest = this.b.request;
            synchronized (httpServletRequest) {
                this.b.request.removeAttribute(name);
            }
        }
    }

    @Override
    public AtmosphereRequest.LocalAttributes attributes() {
        return this.b.localAttributes;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.b.webSocketFakeSession != null) {
            return this.b.webSocketFakeSession;
        }
        if (this.resource() != null) {
            HttpSession session = ((AtmosphereResourceImpl)this.resource()).session;
            try {
                if (session != null) {
                    session.isNew();
                    return session;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            return this.b.request.getSession(create);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null && ex.getMessage().equals("No SessionManager")) {
                return null;
            }
            throw ex;
        }
        catch (NullPointerException ex) {
            try {
                return this.b.request.getSession(create);
            }
            catch (Exception e) {
                logger.trace("", (Throwable)ex);
                return null;
            }
        }
        catch (RuntimeException ex) {
            logger.trace("", (Throwable)ex);
            if (ex.getMessage() != null && ex.getMessage().contains("SESN0007E")) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public Principal getUserPrincipal() {
        return this.b.principal != null ? this.b.principal : this.b.request.getUserPrincipal();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.b.request.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.b.request.isRequestedSessionIdFromUrl();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.b.request.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.b.request.isRequestedSessionIdValid();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.b.request.isUserInRole(role);
    }

    @Override
    public void login(String username, String password) throws ServletException {
        this.b.request.login(username, password);
    }

    @Override
    public void logout() throws ServletException {
        this.b.request.logout();
    }

    @Override
    public String getRemoteAddr() {
        return this.isNotNoOps() ? this.b.request.getRemoteAddr() : (this.b.lazyRemote != null ? this.b.lazyRemote.getHostAddress() : this.b.remoteAddr);
    }

    @Override
    public String getRemoteHost() {
        return this.isNotNoOps() ? this.b.request.getRemoteHost() : (this.b.lazyRemote != null ? this.b.lazyRemote.getHostName() : this.b.remoteHost);
    }

    @Override
    public int getRemotePort() {
        return this.isNotNoOps() ? this.b.request.getRemotePort() : (this.b.lazyRemote != null ? this.b.lazyRemote.getPort() : this.b.remotePort);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.b.request.getRequestDispatcher(path);
    }

    @Override
    public String getScheme() {
        return this.b.request.getScheme();
    }

    @Override
    public String getServerName() {
        return !this.b.serverName.equals("") ? this.b.serverName : this.b.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.b.serverPort != 0 ? this.b.serverPort : this.b.request.getServerPort();
    }

    @Override
    public ServletContext getServletContext() {
        return this.b.request.getServletContext();
    }

    @Override
    public boolean isAsyncStarted() {
        if (AtmosphereResource.TRANSPORT.WEBSOCKET == this.resource().transport()) {
            return this.noopsAsyncContextStarted;
        }
        try {
            return this.b.request.isAsyncStarted();
        }
        catch (Throwable ex) {
            logger.trace("", ex);
            return false;
        }
    }

    @Override
    public boolean isAsyncSupported() {
        try {
            return this.b.request.isAsyncSupported();
        }
        catch (Throwable ex) {
            logger.trace("", ex);
            return false;
        }
    }

    @Override
    public boolean isSecure() {
        return this.isNotNoOps() ? this.b.request.isSecure() : this.b.isSecure;
    }

    @Override
    public String getLocalName() {
        return this.isNotNoOps() ? this.b.request.getLocalName() : (this.b.lazyLocal != null ? this.b.lazyLocal.getHostName() : this.b.localName);
    }

    @Override
    public int getLocalPort() {
        return this.isNotNoOps() ? this.b.request.getLocalPort() : (this.b.lazyLocal != null ? this.b.lazyLocal.getPort() : this.b.localPort);
    }

    @Override
    public String getLocalAddr() {
        return this.isNotNoOps() ? this.b.request.getLocalAddr() : (this.b.lazyLocal != null ? this.b.lazyLocal.getHostAddress() : this.b.localAddr);
    }

    private boolean isNotNoOps() {
        return !NoOpsRequest.class.isAssignableFrom(this.b.request.getClass());
    }

    @Override
    public Locale getLocale() {
        return this.isNotNoOps() ? this.b.request.getLocale() : (this.b.locales.iterator().hasNext() ? (Locale)this.b.locales.iterator().next() : Locale.getDefault());
    }

    @Override
    public AtmosphereResource resource() {
        try {
            Object o = this.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            if (!(o instanceof AtmosphereResource)) {
                return null;
            }
            return (AtmosphereResource)this.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return this.isNotNoOps() ? this.b.request.getLocales() : Collections.enumeration(this.b.locales);
    }

    @Override
    public boolean dispatchRequestAsynchronously() {
        return this.b.dispatchRequestAsynchronously;
    }

    @Override
    public boolean isDestroyable() {
        return this.b.destroyable;
    }

    @Override
    public AtmosphereRequest pathInfo(String pathInfo) {
        this.b.pathInfo = pathInfo;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> getAttributeNames() {
        HashSet<String> l = new HashSet<String>(this.b.localAttributes.unmodifiableMap().keySet());
        if (this.isNotNoOps()) {
            HttpServletRequest httpServletRequest = this.b.request;
            synchronized (httpServletRequest) {
                l.addAll(Collections.list(this.b.request.getAttributeNames()));
            }
        }
        return Collections.enumeration(l);
    }

    private static Object attributeWithoutException(HttpServletRequest request, String attribute) {
        try {
            return request.getAttribute(attribute);
        }
        catch (NullPointerException ex) {
            logger.trace("Unexpected NPE", (Throwable)ex);
            return "";
        }
    }

    @Override
    public AtmosphereRequest.LocalAttributes localAttributes() {
        return this.b.localAttributes;
    }

    @Override
    public String getCharacterEncoding() {
        return this.b.request.getCharacterEncoding() == null ? this.b.encoding : this.b.request.getCharacterEncoding();
    }

    @Override
    public int getContentLength() {
        if (this.b.contentLength == null) {
            return this.b.request.getContentLength();
        }
        return this.b.contentLength.intValue();
    }

    @Override
    public String uuid() {
        if (Objects.equals(this.uuid, "0")) {
            this.uuid = this.resource() != null ? this.resource().uuid() : "0";
        }
        return this.uuid;
    }

    @Override
    public void destroy() {
        this.destroy(this.b.destroyable);
    }

    @Override
    public void destroy(boolean force) {
        if (!force) {
            return;
        }
        this.destroyed.set(true);
        this.b.localAttributes.clear();
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.b.headers.clear();
        this.b.queryStrings.clear();
    }

    @Override
    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        if (HttpServletRequest.class.isAssignableFrom(request.getClass())) {
            this.b.request = (HttpServletRequest)request;
        }
    }

    public static AtmosphereRequest newInstance() {
        return new Builder().build();
    }

    public static AtmosphereRequest wrap(HttpServletRequest request) {
        if (AtmosphereRequestImpl.class.isAssignableFrom(request.getClass())) {
            return (AtmosphereRequestImpl)request;
        }
        Builder b = new Builder();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            b.localAttributes.put(s, AtmosphereRequestImpl.attributeWithoutException(request, s));
        }
        return b.request(request).build();
    }

    public static AtmosphereRequest cloneRequest(HttpServletRequest request, boolean loadInMemory, boolean copySession, boolean isDestroyable, boolean createSession) {
        Builder b;
        Cookie[] cs = request.getCookies();
        Set hs = Collections.synchronizedSet(new HashSet());
        if (cs != null) {
            Collections.addAll(hs, cs);
        }
        boolean isWrapped = false;
        if (AtmosphereRequestImpl.class.isAssignableFrom(request.getClass())) {
            b = ((AtmosphereRequestImpl)request).b;
            isWrapped = true;
        } else {
            b = new Builder();
            b.request(request);
        }
        HttpSession session = request.getSession(false);
        if (copySession) {
            session = request.getSession(createSession);
            session = session != null ? new FakeHttpSession(session) : new FakeHttpSession("", null, System.currentTimeMillis(), -1);
        }
        ((Builder)b.servletPath(request.getServletPath()).pathInfo(request.getPathInfo()).contextPath(request.getContextPath()).requestURI(request.getRequestURI()).requestURL(request.getRequestURL().toString()).method(request.getMethod()).serverName(request.getServerName()).serverPort(request.getServerPort()).remoteAddr(request.getRemoteAddr()).remoteHost(request.getRemoteHost()).remotePort(request.getRemotePort()).destroyable(isDestroyable).cookies(hs)).session(session).principal(request.getUserPrincipal()).authType(request.getAuthType()).isSSecure(request.isSecure());
        if (loadInMemory) {
            String s = (String)AtmosphereRequestImpl.attributeWithoutException(request, FrameworkConfig.THROW_EXCEPTION_ON_CLONED_REQUEST);
            boolean throwException = Boolean.parseBoolean(s);
            NoOpsRequest r = new NoOpsRequest(throwException);
            if (isWrapped) {
                AtmosphereRequestImpl.load(b.request, b);
            } else {
                AtmosphereRequestImpl.load(request, b);
            }
            b.request(r);
        }
        return isWrapped ? (AtmosphereRequestImpl)request : b.build();
    }

    private boolean isCompletionAware() {
        return Boolean.parseBoolean(this.resource().getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.ResponseCompletionAware"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(HttpServletRequest request, Builder b) {
        String s;
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.headers.put(s, request.getHeader(s));
        }
        HttpServletRequest httpServletRequest = b.request;
        synchronized (httpServletRequest) {
            e = request.getAttributeNames();
        }
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.localAttributes.put(s, AtmosphereRequestImpl.attributeWithoutException(request, s));
        }
        e = request.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.queryStrings.put(s, request.getParameterValues(s));
        }
        b.queryString = request.getQueryString();
        Enumeration l = request.getLocales();
        while (l.hasMoreElements()) {
            b.locale((Locale)l.nextElement());
        }
    }

    @Override
    public String toString() {
        try {
            return "AtmosphereRequest{ method=" + this.getMethod() + " contextPath=" + this.getContextPath() + " servletPath=" + this.getServletPath() + " pathInfo=" + this.getPathInfo() + " requestURI=" + this.getRequestURI() + " requestURL=" + this.getRequestURL() + " AtmosphereResource UUID=" + (this.resource() != null ? this.resource().uuid() : "") + " destroyable=" + this.b.destroyable + '}';
        }
        catch (Exception e) {
            return "AtmosphereRequest{ contextPath=" + this.getContextPath() + " servletPath=" + this.getServletPath() + " pathInfo=" + this.getPathInfo() + " requestURI=" + this.getRequestURI() + " destroyable=" + this.b.destroyable + '}';
        }
    }

    @Override
    public String requestURL() {
        return this.b.requestURL;
    }

    private class NoOpsAsyncContext
    implements AsyncContext {
        private final ServletRequest request;
        private final ServletResponse response;
        private long timeout;

        public NoOpsAsyncContext(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
            this.timeout = -1L;
        }

        public void addListener(AsyncListener listener) throws IllegalStateException {
        }

        public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) throws IllegalStateException {
        }

        public void complete() {
        }

        public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
            throw new ServletException("Not supported");
        }

        public void dispatch() throws IllegalStateException {
        }

        public void dispatch(ServletContext servletContext, String path) throws IllegalStateException {
        }

        public void dispatch(String path) throws IllegalStateException {
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public boolean hasOriginalRequestAndResponse() {
            return false;
        }

        public void setTimeout(long timeout) throws IllegalStateException {
            this.timeout = timeout;
        }

        public void start(Runnable run) {
            throw new RuntimeException("Not supported");
        }
    }

    private class CompletionAwareAsyncContext
    implements AsyncContext {
        private AsyncContext context;
        private CompletionAware callback;

        public CompletionAwareAsyncContext(AsyncContext context, CompletionAware callback) {
            this.context = context;
            this.callback = callback;
        }

        public void addListener(AsyncListener listener) throws IllegalStateException {
            this.context.addListener(listener);
        }

        public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) throws IllegalStateException {
            this.context.addListener(listener, request, response);
        }

        public void complete() {
            this.context.complete();
            this.callback.onComplete();
        }

        public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
            return (T)this.context.createListener(clazz);
        }

        public void dispatch() throws IllegalStateException {
            this.context.dispatch();
        }

        public void dispatch(ServletContext servletContext, String path) throws IllegalStateException {
            this.context.dispatch(servletContext, path);
        }

        public void dispatch(String path) throws IllegalStateException {
            this.context.dispatch(path);
        }

        public ServletRequest getRequest() {
            return this.context.getRequest();
        }

        public ServletResponse getResponse() {
            return this.context.getResponse();
        }

        public long getTimeout() {
            return this.context.getTimeout();
        }

        public boolean hasOriginalRequestAndResponse() {
            return this.context.hasOriginalRequestAndResponse();
        }

        public void setTimeout(long timeoutMilliseconds) throws IllegalStateException {
            this.context.setTimeout(timeoutMilliseconds);
        }

        public void start(Runnable run) {
            this.context.start(run);
        }
    }

    public static final class LazyComputation {
        private final Callable<InetSocketAddress> callable;
        private InetSocketAddress address;

        public LazyComputation(Callable<InetSocketAddress> callable) {
            this.callable = callable;
        }

        public InetSocketAddress address() {
            if (this.address == null) {
                try {
                    this.address = this.callable.call();
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
                if (this.address == null) {
                    this.address = new InetSocketAddress(8080);
                }
            }
            return this.address;
        }

        public int getPort() {
            return this.address().getPort();
        }

        public String getHostAddress() {
            return this.address().getAddress().getHostAddress();
        }

        public String getHostName() {
            return this.address().getHostName();
        }
    }

    public static final class NoOpsRequest
    implements HttpServletRequest {
        private final boolean throwExceptionOnCloned;
        public HttpSession fake;
        private static final Enumeration<String> EMPTY_ENUM_STRING = Collections.enumeration(Collections.emptyList());
        private static final Enumeration<Locale> EMPTY_ENUM_LOCALE = Collections.enumeration(Collections.emptyList());
        private static final List<Part> EMPTY_ENUM_PART = Collections.emptyList();
        private static final Map<String, String[]> EMPTY_MAP_STRING = Collections.emptyMap();
        private static final String[] EMPTY_ARRAY = new String[0];
        private final StringBuffer EMPTY_STRING_BUFFER = new StringBuffer();
        private static final Cookie[] EMPTY_COOKIE = new Cookie[0];
        private volatile BufferedReader voidReader;
        private final ServletInputStream voidStream = new IS(new ByteArrayInputStream(new byte[0]));

        public NoOpsRequest() {
            this.throwExceptionOnCloned = false;
        }

        public NoOpsRequest(boolean throwExceptionOnCloned) {
            this.throwExceptionOnCloned = throwExceptionOnCloned;
        }

        private BufferedReader getVoidReader() {
            if (this.voidReader == null) {
                this.voidReader = new BufferedReader(new StringReader(""));
            }
            return this.voidReader;
        }

        public boolean authenticate(HttpServletResponse response) {
            return false;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return "";
        }

        public Cookie[] getCookies() {
            return EMPTY_COOKIE;
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return EMPTY_ENUM_STRING;
        }

        public Enumeration<String> getHeaders(String name) {
            return EMPTY_ENUM_STRING;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return "GET";
        }

        public Part getPart(String name) throws IOException, ServletException {
            return null;
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return EMPTY_ENUM_PART;
        }

        public String getPathInfo() {
            return "";
        }

        public String getPathTranslated() {
            return "";
        }

        public String getQueryString() {
            return "";
        }

        public String getRemoteUser() {
            return "";
        }

        public String getRequestedSessionId() {
            return "";
        }

        public String getRequestURI() {
            return "/";
        }

        public StringBuffer getRequestURL() {
            return this.EMPTY_STRING_BUFFER;
        }

        public String getServletPath() {
            return "";
        }

        public HttpSession getSession() {
            return this.fake;
        }

        public String changeSessionId() {
            return this.getSession(false).getId();
        }

        public HttpSession getSession(boolean create) {
            if (create && this.fake == null) {
                this.fake = new FakeHttpSession("", null, System.currentTimeMillis(), -1){

                    @Override
                    public void invalidate() {
                        fake = null;
                        super.invalidate();
                    }
                };
            }
            return this.fake;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String role) {
            if (this.throwExceptionOnCloned) {
                throw new UnsupportedOperationException();
            }
            return false;
        }

        public void login(String username, String password) throws ServletException {
            if (this.throwExceptionOnCloned) {
                throw new ServletException();
            }
        }

        public void logout() throws ServletException {
            if (this.throwExceptionOnCloned) {
                throw new ServletException();
            }
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return EMPTY_ENUM_STRING;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public long getContentLengthLong() {
            return 0L;
        }

        public String getContentType() {
            return "text/plain";
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.REQUEST;
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.voidStream;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return EMPTY_ENUM_LOCALE;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public String getLocalAddr() {
            return "";
        }

        public String getParameter(String name) {
            return "";
        }

        public Map<String, String[]> getParameterMap() {
            return EMPTY_MAP_STRING;
        }

        public Enumeration<String> getParameterNames() {
            return EMPTY_ENUM_STRING;
        }

        public String[] getParameterValues(String name) {
            return EMPTY_ARRAY;
        }

        public String getProtocol() {
            return "HTTP/1.1";
        }

        public BufferedReader getReader() throws IOException {
            return this.getVoidReader();
        }

        public String getRealPath(String path) {
            return path;
        }

        public String getRemoteAddr() {
            return "";
        }

        public String getRemoteHost() {
            return "";
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public String getScheme() {
            return "ws";
        }

        public String getServerName() {
            return "";
        }

        public int getServerPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return true;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object o) {
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        }

        public AsyncContext startAsync() {
            return null;
        }

        public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
            return null;
        }
    }

    private static final class IS
    extends ServletInputStream {
        private final InputStream innerStream;

        public IS(InputStream innerStream) {
            this.innerStream = innerStream;
        }

        public int read() throws IOException {
            return this.innerStream.read();
        }

        public int read(byte[] bytes) throws IOException {
            return this.innerStream.read(bytes);
        }

        public int read(byte[] bytes, int i, int i1) throws IOException {
            return this.innerStream.read(bytes, i, i1);
        }

        public long skip(long l) throws IOException {
            return this.innerStream.skip(l);
        }

        public int available() throws IOException {
            return this.innerStream.available();
        }

        public void close() throws IOException {
            this.innerStream.close();
        }

        public synchronized void mark(int i) {
            this.innerStream.mark(i);
        }

        public synchronized void reset() throws IOException {
            this.innerStream.reset();
        }

        public boolean markSupported() {
            return this.innerStream.markSupported();
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }

    public static final class Body {
        private final String data;
        private final byte[] dataBytes;
        private final int offset;
        private final int length;
        private final boolean isEmpty;

        public Body(String data, byte[] dataBytes, int offset, int length) {
            this.data = data;
            this.dataBytes = dataBytes;
            this.offset = offset;
            this.length = length;
            this.isEmpty = data == null && dataBytes == null;
        }

        public boolean hasString() {
            return this.data != null;
        }

        public boolean hasBytes() {
            return this.dataBytes != null;
        }

        public String asString() {
            return this.data;
        }

        public byte[] asBytes() {
            return this.dataBytes;
        }

        public int byteOffset() {
            return this.offset;
        }

        public int byteLength() {
            return this.length;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static final class Builder
    implements AtmosphereRequest.Builder {
        private static final Body NULL_BODY = new Body(null, null, 0, 0);
        private HttpServletRequest request;
        private String pathInfo = "";
        private String encoding = "UTF-8";
        private String methodType;
        private String contentType;
        private boolean noContentType;
        private Long contentLength;
        private Map<String, String> headers = Collections.synchronizedMap(new HashMap());
        private Map<String, String[]> queryStrings = Collections.synchronizedMap(new HashMap());
        private String servletPath = "";
        private String requestURI;
        private String requestURL;
        private InputStream inputStream;
        private Reader reader;
        private String remoteAddr = "";
        private String remoteHost = "";
        private int remotePort;
        private String localAddr = "";
        private String localName = "";
        private int localPort;
        private boolean dispatchRequestAsynchronously;
        private boolean destroyable = true;
        private Set<Cookie> cookies = Collections.synchronizedSet(new HashSet());
        private final Set<Locale> locales = Collections.synchronizedSet(new HashSet());
        private Principal principal;
        private String authType;
        private String contextPath = "";
        private String serverName = "";
        private int serverPort;
        private HttpSession webSocketFakeSession;
        private String queryString = "";
        private boolean isSecure;
        private LazyComputation lazyRemote;
        private LazyComputation lazyLocal;
        public Body body;
        private AtmosphereRequest.LocalAttributes localAttributes = new AtmosphereRequest.LocalAttributes();

        @Override
        public Builder destroyable(boolean destroyable) {
            this.destroyable = destroyable;
            return this;
        }

        @Override
        public Builder headers(Map<String, String> headers) {
            this.headers = Collections.synchronizedMap(headers);
            return this;
        }

        @Override
        public Builder cookies(Set<Cookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        @Override
        public Builder dispatchRequestAsynchronously(boolean dispatchRequestAsynchronously) {
            this.dispatchRequestAsynchronously = dispatchRequestAsynchronously;
            return this;
        }

        @Override
        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        @Override
        public Builder remoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
            return this;
        }

        @Override
        public Builder remotePort(int remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        @Override
        public Builder localAddr(String localAddr) {
            this.localAddr = localAddr;
            return this;
        }

        @Override
        public Builder localName(String localName) {
            this.localName = localName;
            return this;
        }

        @Override
        public Builder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        @Override
        public Builder remoteInetSocketAddress(Callable remoteAddr) {
            this.lazyRemote = new LazyComputation(remoteAddr);
            return this;
        }

        @Override
        public Builder localInetSocketAddress(Callable localAddr) {
            this.lazyLocal = new LazyComputation(localAddr);
            return this;
        }

        @Override
        public Builder attributes(Map<String, Object> attributes) {
            this.localAttributes = new AtmosphereRequest.LocalAttributes(attributes);
            return this;
        }

        @Override
        public Builder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public Builder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        @Override
        public Builder requestURI(String requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        @Override
        public Builder requestURL(String requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        @Override
        public Builder pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        @Override
        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        @Override
        public Builder body(byte[] dataBytes) {
            return this.body(dataBytes, 0, dataBytes.length);
        }

        @Override
        public Builder body(byte[] dataBytes, int offset, int length) {
            this.body = new Body(null, dataBytes, offset, length);
            return this;
        }

        @Override
        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public Builder method(String methodType) {
            this.methodType = methodType;
            return this;
        }

        @Override
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            if (contentType == null) {
                this.noContentType = true;
            }
            return this;
        }

        @Override
        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public Builder body(String data) {
            this.body = new Body(data, null, 0, 0);
            return this;
        }

        @Override
        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Override
        public Builder reader(Reader reader) {
            this.reader = reader;
            return this;
        }

        @Override
        public AtmosphereRequest build() {
            if (this.body == null) {
                this.body = NULL_BODY;
            }
            return new AtmosphereRequestImpl(this);
        }

        @Override
        public Builder queryStrings(Map<String, String[]> queryStrings) {
            this.queryStrings = Collections.synchronizedMap(queryStrings);
            return this;
        }

        @Override
        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath == null ? "" : contextPath;
            return this;
        }

        @Override
        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        @Override
        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public Builder session(HttpSession session) {
            if (this.request == null) {
                this.request = new NoOpsRequest();
            }
            if (NoOpsRequest.class.isAssignableFrom(this.request.getClass())) {
                ((NoOpsRequest)this.request).fake = session;
            } else {
                this.webSocketFakeSession = session;
            }
            return this;
        }

        @Override
        public Builder principal(Principal principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public Builder isSSecure(boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            this.locales.add(locale);
            return this;
        }

        @Override
        public Builder userPrincipal(Principal userPrincipal) {
            this.principal = userPrincipal;
            return this;
        }
    }

    private static final class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

