/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.VoidServletConfig;

public class AtmosphereFrameworkInitializer {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFrameworkInitializer.class);
    protected AtmosphereFramework framework;
    protected boolean isFilter;
    protected boolean autoDetectHandlers;

    public AtmosphereFrameworkInitializer(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true, false, AtmosphereFramework.class);
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc, boolean init, boolean useNative, Class<? extends AtmosphereFramework> frameworkClass) throws ServletException {
        if (this.framework == null) {
            if (sc.getServletContext().getMajorVersion() > 2) {
                try {
                    this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(sc.getServletContext().getServletRegistration(sc.getServletName()).getName());
                }
                catch (Exception ex) {
                    if (UnsupportedOperationException.class.isAssignableFrom(ex.getClass())) {
                        logger.warn("WebLogic 12c unable to retrieve Servlet. Please make sure your servlet-name is 'AtmosphereServlet' or set org.atmosphere.servlet to the current value");
                        String name = sc.getInitParameter("org.atmosphere.servlet");
                        if (name == null) {
                            name = AtmosphereServlet.class.getSimpleName();
                        }
                        this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(name);
                    }
                    logger.trace("", (Throwable)ex);
                }
            }
            if (this.framework == null) {
                this.framework = AtmosphereFrameworkInitializer.newAtmosphereFramework(frameworkClass, this.isFilter, this.autoDetectHandlers);
            }
        }
        this.framework.setUseNativeImplementation(useNative);
        if (init) {
            this.framework.init(sc);
        }
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework(Class<? extends AtmosphereFramework> frameworkClass) {
        return AtmosphereFrameworkInitializer.newAtmosphereFramework(frameworkClass, this.isFilter, this.autoDetectHandlers);
    }

    protected static AtmosphereFramework newAtmosphereFramework(Class<? extends AtmosphereFramework> frameworkClass, boolean isFilter, boolean autoDetectHandlers, final ServletContext c) {
        AtmosphereFramework framework;
        try {
            framework = frameworkClass.getDeclaredConstructor(Boolean.TYPE, Boolean.TYPE).newInstance(isFilter, autoDetectHandlers);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            framework = new AtmosphereFramework(isFilter, autoDetectHandlers);
        }
        if (c != null) {
            framework.servletConfig(new VoidServletConfig(framework.initParams){

                @Override
                public ServletContext getServletContext() {
                    return c;
                }
            }, false);
        }
        return framework;
    }

    protected static AtmosphereFramework newAtmosphereFramework(Class<? extends AtmosphereFramework> frameworkClass, boolean isFilter, boolean autoDetectHandlers) {
        return AtmosphereFrameworkInitializer.newAtmosphereFramework(frameworkClass, isFilter, autoDetectHandlers, null);
    }

    public static AtmosphereFramework newAtmosphereFramework(ServletContext sc, boolean isFilter, boolean autoDetectHandlers) {
        String metaServicePath = sc.getInitParameter("org.atmosphere.cpr.metaServicePath") == null ? "META-INF/services/" : sc.getInitParameter("org.atmosphere.cpr.metaServicePath");
        try {
            Map<String, AtmosphereFramework.MetaServiceAction> config = IOUtils.readServiceFile(metaServicePath + AtmosphereFramework.class.getName());
            sc.setAttribute(AtmosphereFramework.MetaServiceAction.class.getName(), config);
            for (Map.Entry<String, AtmosphereFramework.MetaServiceAction> action : config.entrySet()) {
                Class<?> c = IOUtils.loadClass(AtmosphereFramework.class, action.getKey());
                if (!AtmosphereFramework.class.isAssignableFrom(c)) continue;
                logger.info("Found a definition of AtmosphereFramework {} under {}", c, (Object)metaServicePath);
                return AtmosphereFrameworkInitializer.newAtmosphereFramework(c, isFilter, autoDetectHandlers);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        return AtmosphereFrameworkInitializer.newAtmosphereFramework(AtmosphereFramework.class, isFilter, autoDetectHandlers, sc);
    }

    public AtmosphereFramework framework() {
        if (this.framework == null) {
            this.framework = AtmosphereFrameworkInitializer.newAtmosphereFramework(AtmosphereFramework.class, this.isFilter, this.autoDetectHandlers);
        }
        return this.framework;
    }

    public void destroy() {
        if (this.framework != null) {
            this.framework.destroy();
            this.framework = null;
        }
    }
}

