/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopilotServerClient {
    protected static final String SERVER_URL_ENV = "copilot.serverBaseUrl";
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpRequest buildRequest(URI uri, String json) {
        return HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofString(json)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(120L)).build();
    }

    protected String writeAsJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    protected <T> T readValue(String string, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(string, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid data", e);
        }
    }

    protected URI getQueryURI(String path) {
        try {
            return new URI(this.getServerBaseUrl() + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid server configuration, server uri is wrong", e);
        }
    }

    protected String getServerBaseUrl() {
        String serverBaseUrl = System.getenv(SERVER_URL_ENV);
        if (serverBaseUrl != null) {
            return serverBaseUrl;
        }
        if (CopilotServerClient.isDevelopment()) {
            try {
                String localhostUrl = "http://localhost:8081/v1/";
                String statusUrl = localhostUrl + "actuator/health";
                HttpRequest request = HttpRequest.newBuilder().uri(new URI(statusUrl)).timeout(Duration.ofSeconds(1L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    return localhostUrl;
                }
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return "https://copilot.stg.vaadin.com/v1/";
        }
        return "https://copilot.vaadin.com/v1/";
    }

    protected static boolean isDevelopment() {
        return System.getProperty("copilot.development") != null;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

