/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.Version;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.controls.ExtendedSchemaInfoRequestControl;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.MultiServerLDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CompareLDAPSchemas
extends MultiServerLDAPCommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final int FIRST_SERVER_INDEX = 0;
    private static final int SECOND_SERVER_INDEX = 1;
    @NotNull
    private static final String ARG_NAME_EXCLUDE_ELEMENTS_WITH_EXTENSION_VALUE = "excludeElementsWithExtensionValue";
    @NotNull
    private static final String ARG_NAME_EXCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX = "excludeElementsWithNameMatchingPrefix";
    @NotNull
    private static final String ARG_NAME_FIRST_SCHEMA_ENTRY_DN = "firstSchemaEntryDN";
    @NotNull
    private static final String ARG_NAME_GET_EXTENDED_SCHEMA_INFO = "getExtendedSchemaInfo";
    @NotNull
    private static final String ARG_NAME_IGNORE_DESCRIPTIONS = "ignoreDescriptions";
    @NotNull
    private static final String ARG_NAME_IGNORE_EXTENSIONS = "ignoreExtensions";
    @NotNull
    private static final String ARG_NAME_INCLUDE_ELEMENTS_WITH_EXTENSION_VALUE = "includeElementsWithExtensionValue";
    @NotNull
    private static final String ARG_NAME_INCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX = "includeElementsWithNameMatchingPrefix";
    @NotNull
    private static final String ARG_NAME_SCHEMA_ELEMENT_TYPE = "schemaElementType";
    @NotNull
    private static final String ARG_NAME_SECOND_SCHEMA_ENTRY_DN = "secondSchemaEntryDN";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES = "attribute-syntaxes";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES = "attribute-types";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES = "dit-content-rules";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES = "dit-structure-rules";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES = "matching-rule-uses";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_MATCHING_RULES = "matching-rules";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES = "object-classes";
    @NotNull
    private static final String SCHEMA_ELEMENT_TYPE_NAME_FORMS = "name-forms";
    @NotNull
    private final AtomicReference<ArgumentParser> parserRef = new AtomicReference();
    @NotNull
    private final AtomicReference<String> completionMessageRef = new AtomicReference();
    private boolean ignoreDescriptions = false;
    private boolean ignoreExtensions = false;
    private boolean includeOrExcludeBasedOnExtensions;
    private boolean includeOrExcludeBasedOnName;
    @NotNull
    private final List<String> excludeNamePrefixes;
    @NotNull
    private final List<String> includeNamePrefixes;
    @NotNull
    private final Map<String, List<String>> excludeExtensionValues;
    @NotNull
    private final Map<String, List<String>> includeExtensionValues;
    @NotNull
    private final Set<String> schemaElementTypes = new HashSet<String>(StaticUtils.setOf("attribute-syntaxes", "matching-rules", "attribute-types", "object-classes", "dit-content-rules", "dit-structure-rules", "name-forms", "matching-rule-uses"));

    public static void main(String ... args) {
        ResultCode resultCode = CompareLDAPSchemas.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        CompareLDAPSchemas tool = new CompareLDAPSchemas(out, err);
        return tool.runTool(args);
    }

    public CompareLDAPSchemas(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err, new String[]{"first", "second"}, null);
        this.includeNamePrefixes = new ArrayList<String>();
        this.excludeNamePrefixes = new ArrayList<String>();
        this.includeExtensionValues = new HashMap<String, List<String>>();
        this.excludeExtensionValues = new HashMap<String, List<String>>();
    }

    @Override
    @NotNull
    public String getToolName() {
        return "compare-ldap-schemas";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_COMPARE_SCHEMA_TOOL_DESC.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return Version.getNumericVersionString();
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parserRef.set(parser);
        DNArgument firstSchemaEntryDNArg = new DNArgument(null, ARG_NAME_FIRST_SCHEMA_ENTRY_DN, false, 1, null, ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_FIRST_SCHEMA_ENTRY_DN.get());
        firstSchemaEntryDNArg.addLongIdentifier("first-schema-entry-dn", true);
        firstSchemaEntryDNArg.addLongIdentifier("firstSchemaEntry", true);
        firstSchemaEntryDNArg.addLongIdentifier("first-schema-entry", true);
        firstSchemaEntryDNArg.addLongIdentifier("firstSchemaDN", true);
        firstSchemaEntryDNArg.addLongIdentifier("first-schema-dn", true);
        firstSchemaEntryDNArg.addLongIdentifier("firstSchema", true);
        firstSchemaEntryDNArg.addLongIdentifier("first-schema", true);
        parser.addArgument(firstSchemaEntryDNArg);
        DNArgument secondSchemaEntryDNArg = new DNArgument(null, ARG_NAME_SECOND_SCHEMA_ENTRY_DN, false, 1, null, ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_SECOND_SCHEMA_ENTRY_DN.get());
        secondSchemaEntryDNArg.addLongIdentifier("second-schema-entry-dn", true);
        secondSchemaEntryDNArg.addLongIdentifier("secondSchemaEntry", true);
        secondSchemaEntryDNArg.addLongIdentifier("second-schema-entry", true);
        secondSchemaEntryDNArg.addLongIdentifier("secondSchemaDN", true);
        secondSchemaEntryDNArg.addLongIdentifier("second-schema-dn", true);
        secondSchemaEntryDNArg.addLongIdentifier("secondSchema", true);
        secondSchemaEntryDNArg.addLongIdentifier("second-schema", true);
        parser.addArgument(secondSchemaEntryDNArg);
        StringArgument schemaElementTypesArg = new StringArgument(null, ARG_NAME_SCHEMA_ELEMENT_TYPE, false, 0, ToolMessages.INFO_COMPARE_SCHEMA_ARG_PLACEHOLDER_SCHEMA_ELEMENT_TYPE.get(), ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_SCHEMA_ELEMENT_TYPE.get(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES, SCHEMA_ELEMENT_TYPE_MATCHING_RULES, SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES, SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES, SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES, SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES, SCHEMA_ELEMENT_TYPE_NAME_FORMS, SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES));
        schemaElementTypesArg.addLongIdentifier("schema-element-types", true);
        parser.addArgument(schemaElementTypesArg);
        BooleanArgument getExtendedSchemaInfoArg = new BooleanArgument(null, ARG_NAME_GET_EXTENDED_SCHEMA_INFO, 1, ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_GET_EXTENDED_SCHEMA_INFO.get());
        getExtendedSchemaInfoArg.addLongIdentifier("get-extended-schema-info", true);
        parser.addArgument(getExtendedSchemaInfoArg);
        BooleanArgument ignoreDescriptionsArg = new BooleanArgument(null, ARG_NAME_IGNORE_DESCRIPTIONS, 1, ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_IGNORE_DESCRIPTIONS.get());
        ignoreDescriptionsArg.addLongIdentifier("ignore-descriptions", true);
        ignoreDescriptionsArg.addLongIdentifier("ignoreDescription", true);
        ignoreDescriptionsArg.addLongIdentifier("ignore-description", true);
        parser.addArgument(ignoreDescriptionsArg);
        BooleanArgument ignoreExtensionsArg = new BooleanArgument(null, ARG_NAME_IGNORE_EXTENSIONS, 1, ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_IGNORE_EXTENSIONS.get());
        ignoreExtensionsArg.addLongIdentifier("ignore-extensions", true);
        ignoreExtensionsArg.addLongIdentifier("ignoreExtension", true);
        ignoreExtensionsArg.addLongIdentifier("ignore-extension", true);
        parser.addArgument(ignoreExtensionsArg);
        StringArgument includeElementsWithNameMatchingPrefixArg = new StringArgument(null, ARG_NAME_INCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX, false, 0, ToolMessages.INFO_COMPARE_SCHEMA_ARG_PLACEHOLDER_PREFIX.get(), ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_INCLUDE_NAME_MATCHING_PREFIX.get());
        includeElementsWithNameMatchingPrefixArg.addLongIdentifier("include-elements-with-name-matching-prefix", true);
        parser.addArgument(includeElementsWithNameMatchingPrefixArg);
        StringArgument excludeElementsWithNameMatchingPrefixArg = new StringArgument(null, ARG_NAME_EXCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX, false, 0, ToolMessages.INFO_COMPARE_SCHEMA_ARG_PLACEHOLDER_PREFIX.get(), ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_EXCLUDE_NAME_MATCHING_PREFIX.get());
        excludeElementsWithNameMatchingPrefixArg.addLongIdentifier("exclude-elements-with-name-matching-prefix", true);
        parser.addArgument(excludeElementsWithNameMatchingPrefixArg);
        StringArgument includeElementsWithExtensionValueArg = new StringArgument(null, ARG_NAME_INCLUDE_ELEMENTS_WITH_EXTENSION_VALUE, false, 0, ToolMessages.INFO_COMPARE_SCHEMA_ARG_PLACEHOLDER_EXTENSION_VALUE.get(), ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_INCLUDE_EXTENSION_VALUE.get());
        includeElementsWithExtensionValueArg.addLongIdentifier("include-elements-with-extension-value", true);
        parser.addArgument(includeElementsWithExtensionValueArg);
        StringArgument excludeElementsWithExtensionValueArg = new StringArgument(null, ARG_NAME_EXCLUDE_ELEMENTS_WITH_EXTENSION_VALUE, false, 0, ToolMessages.INFO_COMPARE_SCHEMA_ARG_PLACEHOLDER_EXTENSION_VALUE.get(), ToolMessages.INFO_COMPARE_SCHEMA_ARG_DESC_EXCLUDE_EXTENSION_VALUE.get());
        excludeElementsWithExtensionValueArg.addLongIdentifier("exclude-elements-with-extension-value", true);
        parser.addArgument(excludeElementsWithExtensionValueArg);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        BooleanArgument ignoreDescriptionsArg;
        ArgumentParser parser = this.parserRef.get();
        StringArgument schemaElementTypesArg = parser.getStringArgument(ARG_NAME_SCHEMA_ELEMENT_TYPE);
        if (schemaElementTypesArg != null && schemaElementTypesArg.isPresent()) {
            this.schemaElementTypes.clear();
            for (String value : schemaElementTypesArg.getValues()) {
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_MATCHING_RULES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_MATCHING_RULES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_NAME_FORMS)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_NAME_FORMS);
                    continue;
                }
                if (value.equalsIgnoreCase(SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES)) {
                    this.schemaElementTypes.add(SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES);
                    continue;
                }
                throw new ArgumentException(ToolMessages.ERR_COMPARE_SCHEMA_INVALID_SCHEMA_ELEMENT_TYPE.get(value, ARG_NAME_SCHEMA_ELEMENT_TYPE, SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES, SCHEMA_ELEMENT_TYPE_MATCHING_RULES, SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES, SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES, SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES, SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES, SCHEMA_ELEMENT_TYPE_NAME_FORMS, SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES));
            }
        }
        this.ignoreDescriptions = (ignoreDescriptionsArg = parser.getBooleanArgument(ARG_NAME_IGNORE_DESCRIPTIONS)) != null && ignoreDescriptionsArg.isPresent();
        BooleanArgument ignoreExtensionsArg = parser.getBooleanArgument(ARG_NAME_IGNORE_EXTENSIONS);
        this.ignoreExtensions = ignoreExtensionsArg != null && ignoreExtensionsArg.isPresent();
        this.getNamePrefixes(ARG_NAME_INCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX, this.includeNamePrefixes);
        this.getNamePrefixes(ARG_NAME_EXCLUDE_ELEMENTS_WITH_NAME_MATCHING_PREFIX, this.excludeNamePrefixes);
        this.includeOrExcludeBasedOnName = !this.includeNamePrefixes.isEmpty() || !this.excludeNamePrefixes.isEmpty();
        this.getExtensionValues(ARG_NAME_INCLUDE_ELEMENTS_WITH_EXTENSION_VALUE, this.includeExtensionValues);
        this.getExtensionValues(ARG_NAME_EXCLUDE_ELEMENTS_WITH_EXTENSION_VALUE, this.excludeExtensionValues);
        this.includeOrExcludeBasedOnExtensions = !this.includeExtensionValues.isEmpty() || !this.excludeExtensionValues.isEmpty();
    }

    private void getNamePrefixes(@NotNull String argumentName, @NotNull List<String> prefixList) {
        prefixList.clear();
        StringArgument arg = this.parserRef.get().getStringArgument(argumentName);
        if (arg == null || !arg.isPresent()) {
            return;
        }
        for (String value : arg.getValues()) {
            prefixList.add(StaticUtils.toLowerCase(value));
        }
    }

    private void getExtensionValues(@NotNull String argumentName, @NotNull Map<String, List<String>> extensionMap) throws ArgumentException {
        extensionMap.clear();
        StringArgument arg = this.parserRef.get().getStringArgument(argumentName);
        if (arg == null || !arg.isPresent()) {
            return;
        }
        for (String value : arg.getValues()) {
            int equalPos = value.indexOf(61);
            if (equalPos < 0) {
                throw new ArgumentException(ToolMessages.ERR_COMPARE_SCHEMA_EXTENSION_VALUE_NO_EQUALS.get(argumentName, value));
            }
            String extensionName = StaticUtils.toLowerCase(value.substring(0, equalPos));
            if (extensionName.isEmpty()) {
                throw new ArgumentException(ToolMessages.ERR_COMPARE_SCHEMA_EXTENSION_VALUE_EMPTY_NAME.get(argumentName, value));
            }
            String extensionValue = StaticUtils.toLowerCase(value.substring(equalPos + 1));
            if (extensionValue.isEmpty()) {
                throw new ArgumentException(ToolMessages.ERR_COMPARE_SCHEMA_EXTENSION_VALUE_EMPTY_VALUE.get(argumentName, value));
            }
            List<String> valueList = extensionMap.get(extensionName);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                extensionMap.put(extensionName, valueList);
            }
            valueList.add(extensionValue);
        }
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    @Nullable
    protected String getToolCompletionMessage() {
        return this.completionMessageRef.get();
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        Schema secondServerSchema;
        Schema firstServerSchema;
        LinkedHashMap<String, LDAPException> firstUnparsableAttributeSyntaxes = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableMatchingRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableAttributeTypes = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableObjectClasses = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableDITContentRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableDITStructureRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableNameForms = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> firstUnparsableMatchingRuleUses = new LinkedHashMap<String, LDAPException>();
        try {
            firstServerSchema = this.getSchema(0, ARG_NAME_FIRST_SCHEMA_ENTRY_DN, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), firstUnparsableAttributeSyntaxes, firstUnparsableMatchingRules, firstUnparsableAttributeTypes, firstUnparsableObjectClasses, firstUnparsableDITContentRules, firstUnparsableDITStructureRules, firstUnparsableNameForms, firstUnparsableMatchingRuleUses);
        }
        catch (LDAPException e) {
            this.logCompletionError(e.getMessage());
            return e.getResultCode();
        }
        LinkedHashMap<String, LDAPException> secondUnparsableAttributeSyntaxes = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableMatchingRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableAttributeTypes = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableObjectClasses = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableDITContentRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableDITStructureRules = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableNameForms = new LinkedHashMap<String, LDAPException>();
        LinkedHashMap<String, LDAPException> secondUnparsableMatchingRuleUses = new LinkedHashMap<String, LDAPException>();
        try {
            secondServerSchema = this.getSchema(1, ARG_NAME_SECOND_SCHEMA_ENTRY_DN, ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), secondUnparsableAttributeSyntaxes, secondUnparsableMatchingRules, secondUnparsableAttributeTypes, secondUnparsableObjectClasses, secondUnparsableDITContentRules, secondUnparsableDITStructureRules, secondUnparsableNameForms, secondUnparsableMatchingRuleUses);
        }
        catch (LDAPException e) {
            this.logCompletionError(e.getMessage());
            return e.getResultCode();
        }
        AtomicReference<ResultCode> resultCodeRef = new AtomicReference<ResultCode>();
        boolean unparsableElementsEncountered = this.reportUnparsableSchemaElements(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), firstUnparsableAttributeSyntaxes, firstUnparsableMatchingRules, firstUnparsableAttributeTypes, firstUnparsableObjectClasses, firstUnparsableDITContentRules, firstUnparsableDITStructureRules, firstUnparsableNameForms, firstUnparsableMatchingRuleUses);
        if (unparsableElementsEncountered |= this.reportUnparsableSchemaElements(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), secondUnparsableAttributeSyntaxes, secondUnparsableMatchingRules, secondUnparsableAttributeTypes, secondUnparsableObjectClasses, secondUnparsableDITContentRules, secondUnparsableDITStructureRules, secondUnparsableNameForms, secondUnparsableMatchingRuleUses)) {
            resultCodeRef.set(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
        }
        AtomicInteger numDifferences = new AtomicInteger();
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES)) {
            this.compareAttributeSyntaxes(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_MATCHING_RULES)) {
            this.compareMatchingRules(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES)) {
            this.compareAttributeTypes(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES)) {
            this.compareObjectClasses(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES)) {
            this.compareDITContentRules(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES)) {
            this.compareDITStructureRules(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_NAME_FORMS)) {
            this.compareNameForms(firstServerSchema, secondServerSchema, numDifferences);
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES)) {
            this.compareMatchingRuleUses(firstServerSchema, secondServerSchema, numDifferences);
        }
        int differenceCount = numDifferences.get();
        if (unparsableElementsEncountered) {
            switch (differenceCount) {
                case 0: {
                    this.logCompletionError(ToolMessages.ERR_COMPARE_SCHEMA_SUMMARY_UNPARSABLE_NO_DIFFERENCES.get());
                    break;
                }
                case 1: {
                    this.logCompletionError(ToolMessages.ERR_COMPARE_SCHEMA_SUMMARY_UNPARSABLE_WITH_DIFFERENCE.get());
                    break;
                }
                default: {
                    this.logCompletionError(ToolMessages.ERR_COMPARE_SCHEMA_SUMMARY_UNPARSABLE_WITH_DIFFERENCES.get(differenceCount));
                    break;
                }
            }
        } else if (differenceCount > 0) {
            resultCodeRef.compareAndSet(null, ResultCode.COMPARE_FALSE);
            if (differenceCount == 1) {
                this.logCompletionError(ToolMessages.ERR_COMPARE_SCHEMA_SUMMARY_DIFFERENCE.get());
            } else {
                this.logCompletionError(ToolMessages.ERR_COMPARE_SCHEMA_SUMMARY_DIFFERENCES.get(differenceCount));
            }
        } else {
            resultCodeRef.compareAndSet(null, ResultCode.SUCCESS);
            String message = ToolMessages.INFO_COMPARE_SCHEMA_SUMMARY_NO_DIFFERENCES.get();
            this.completionMessageRef.compareAndSet(null, message);
            this.wrapOut(0, WRAP_COLUMN, message);
        }
        return (ResultCode)resultCodeRef.get();
    }

    @NotNull
    private Schema getSchema(int serverIndex, @NotNull String schemaDNArgName, @NotNull String serverLabel, @NotNull Map<String, LDAPException> unparsableAttributeSyntaxes, @NotNull Map<String, LDAPException> unparsableMatchingRules, @NotNull Map<String, LDAPException> unparsableAttributeTypes, @NotNull Map<String, LDAPException> unparsableObjectClasses, @NotNull Map<String, LDAPException> unparsableDITContentRules, @NotNull Map<String, LDAPException> unparsableDITStructureRules, @NotNull Map<String, LDAPException> unparsableNameForms, @NotNull Map<String, LDAPException> unparsableMatchingRuleUses) throws LDAPException {
        LDAPConnection conn;
        try {
            conn = this.getConnection(serverIndex);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), ToolMessages.ERR_COMPARE_SCHEMA_CANNOT_CONNECT.get(serverLabel, e.getMessage()), e);
        }
        ArgumentParser parser = this.parserRef.get();
        BooleanArgument getExtendedSchemaInfoArg = parser.getBooleanArgument(ARG_NAME_GET_EXTENDED_SCHEMA_INFO);
        boolean getExtendedSchemaInfo = getExtendedSchemaInfoArg != null && getExtendedSchemaInfoArg.isPresent();
        try {
            SearchResultEntry schemaEntry;
            String schemaEntryDN;
            DNArgument schemaEntryDNArg = parser.getDNArgument(schemaDNArgName);
            if (schemaEntryDNArg.isPresent()) {
                schemaEntryDN = schemaEntryDNArg.getStringValue();
            } else {
                RootDSE rootDSE = conn.getRootDSE();
                if (rootDSE == null) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_COMPARE_SCHEMA_CANNOT_GET_ROOT_DSE.get(serverLabel));
                }
                schemaEntryDN = rootDSE.getSubschemaSubentryDN();
                if (schemaEntryDN == null) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_COMPARE_SCHEMA_CANNOT_GET_ROOT_DSE_SCHEMA_DN.get(serverLabel, "subschemaSubentry"));
                }
            }
            SearchRequest searchRequest = new SearchRequest(schemaEntryDN, SearchScope.BASE, Schema.SUBSCHEMA_SUBENTRY_FILTER, Schema.SCHEMA_REQUEST_ATTRS);
            if (getExtendedSchemaInfo) {
                searchRequest.addControl(new ExtendedSchemaInfoRequestControl(false));
            }
            if ((schemaEntry = conn.searchForEntry(searchRequest)) == null) {
                throw new LDAPException(ResultCode.NO_SUCH_OBJECT, ToolMessages.ERR_COMPARE_SCHEMA_CANNOT_GET_SCHEMA_ENTRY.get(String.valueOf(schemaEntryDN), serverLabel));
            }
            Schema schema = new Schema(schemaEntry, unparsableAttributeSyntaxes, unparsableMatchingRules, unparsableAttributeTypes, unparsableObjectClasses, unparsableDITContentRules, unparsableDITStructureRules, unparsableNameForms, unparsableMatchingRuleUses);
            return schema;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(e.getResultCode(), ToolMessages.ERR_COMPARE_SCHEMA_CANNOT_GET_SCHEMA.get(serverLabel, e.getMessage()), e);
        }
        finally {
            conn.close();
        }
    }

    private boolean reportUnparsableSchemaElements(@NotNull String serverLabel, @NotNull Map<String, LDAPException> unparsableAttributeSyntaxes, @NotNull Map<String, LDAPException> unparsableMatchingRules, @NotNull Map<String, LDAPException> unparsableAttributeTypes, @NotNull Map<String, LDAPException> unparsableObjectClasses, @NotNull Map<String, LDAPException> unparsableDITContentRules, @NotNull Map<String, LDAPException> unparsableDITStructureRules, @NotNull Map<String, LDAPException> unparsableNameForms, @NotNull Map<String, LDAPException> unparsableMatchingRuleUses) {
        boolean unparsableFound = false;
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAXES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableAttributeSyntaxes, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAX.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_MATCHING_RULES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableMatchingRules, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableAttributeTypes, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_OBJECT_CLASSES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableObjectClasses, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableDITContentRules, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableDITStructureRules, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_NAME_FORMS)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableNameForms, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get());
        }
        if (this.schemaElementTypes.contains(SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USES)) {
            unparsableFound |= this.reportUnparsableSchemaElements(serverLabel, unparsableMatchingRuleUses, ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get());
        }
        return unparsableFound;
    }

    private boolean reportUnparsableSchemaElements(@NotNull String serverLabel, @NotNull Map<String, LDAPException> unparsableElements, @NotNull String elementTypeName) {
        for (Map.Entry<String, LDAPException> e : unparsableElements.entrySet()) {
            this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_COMPARE_SCHEMA_UNPARSABLE_ELEMENT.get(elementTypeName, serverLabel, e.getValue().getMessage()));
            this.err(e.getKey());
            this.err(new Object[0]);
        }
        return !unparsableElements.isEmpty();
    }

    private void compareAttributeSyntaxes(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, AttributeSyntaxDefinition> e;
        Map<OID, AttributeSyntaxDefinition> syntaxes1 = this.getAttributeSyntaxMap(firstServerSchema);
        Map<OID, AttributeSyntaxDefinition> syntaxes2 = this.getAttributeSyntaxMap(secondServerSchema);
        Iterator<Map.Entry<OID, AttributeSyntaxDefinition>> iterator = syntaxes1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (syntaxes2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_SYNTAX.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = syntaxes2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (syntaxes1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_SYNTAX.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : syntaxes1.keySet()) {
            AttributeSyntaxDefinition d1 = syntaxes1.get(oid2);
            AttributeSyntaxDefinition d2 = syntaxes2.get(oid2);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAX.get(), oid2.toString(), ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAX.get(), oid2.toString(), d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, AttributeSyntaxDefinition> getAttributeSyntaxMap(@NotNull Schema schema) {
        TreeMap<OID, AttributeSyntaxDefinition> syntaxes = new TreeMap<OID, AttributeSyntaxDefinition>();
        for (AttributeSyntaxDefinition d : schema.getAttributeSyntaxes()) {
            if (!this.includeBasedOnNameAndExtensions(StaticUtils.NO_STRINGS, d.getExtensions())) continue;
            syntaxes.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return syntaxes;
    }

    private void compareMatchingRules(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, MatchingRuleDefinition> e;
        Map<OID, MatchingRuleDefinition> matchingRules1 = this.getMatchingRuleMap(firstServerSchema);
        Map<OID, MatchingRuleDefinition> matchingRules2 = this.getMatchingRuleMap(secondServerSchema);
        Iterator<Map.Entry<OID, MatchingRuleDefinition>> iterator = matchingRules1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (matchingRules2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_MATCHING_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = matchingRules2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (matchingRules1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_MATCHING_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : matchingRules1.keySet()) {
            MatchingRuleDefinition d1 = matchingRules1.get(oid2);
            MatchingRuleDefinition d2 = matchingRules2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SYNTAX_OID.get(), d1.getSyntaxOID(), d2.getSyntaxOID(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAX.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, MatchingRuleDefinition> getMatchingRuleMap(@NotNull Schema schema) {
        TreeMap<OID, MatchingRuleDefinition> matchingRules = new TreeMap<OID, MatchingRuleDefinition>();
        for (MatchingRuleDefinition d : schema.getMatchingRules()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            matchingRules.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return matchingRules;
    }

    private void compareAttributeTypes(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, AttributeTypeDefinition> e;
        Map<OID, AttributeTypeDefinition> attributeTypes1 = this.getAttributeTypeMap(firstServerSchema);
        Map<OID, AttributeTypeDefinition> attributeTypes2 = this.getAttributeTypeMap(secondServerSchema);
        Iterator<Map.Entry<OID, AttributeTypeDefinition>> iterator = attributeTypes1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (attributeTypes2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_ATTRIBUTE_TYPE.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = attributeTypes2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (attributeTypes1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_ATTRIBUTE_TYPE.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : attributeTypes1.keySet()) {
            AttributeTypeDefinition d1 = attributeTypes1.get(oid2);
            AttributeTypeDefinition d2 = attributeTypes2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SUPERIOR_TYPE.get(), d1.getSuperiorType(), d2.getSuperiorType(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SYNTAX_OID.get(), d1.getSyntaxOID(), d2.getSyntaxOID(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_EQUALITY_MR.get(), d1.getEqualityMatchingRule(), d2.getEqualityMatchingRule(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_ORDERING_MR.get(), d1.getOrderingMatchingRule(), d2.getOrderingMatchingRule(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SUBSTRING_MR.get(), d1.getSubstringMatchingRule(), d2.getSubstringMatchingRule(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_SINGLE_VALUE.get(), d1.isSingleValued(), d2.isSingleValued(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_USAGE.get(), d1.getUsage().getName(), d2.getUsage().getName(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_NO_USER_MOD.get(), d1.isNoUserModification(), d2.isNoUserModification(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_COLLECTIVE.get(), d1.isCollective(), d2.isCollective(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_TYPE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_ATTRIBUTE_SYNTAX.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, AttributeTypeDefinition> getAttributeTypeMap(@NotNull Schema schema) {
        TreeMap<OID, AttributeTypeDefinition> attributeTypes = new TreeMap<OID, AttributeTypeDefinition>();
        for (AttributeTypeDefinition d : schema.getAttributeTypes()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            attributeTypes.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return attributeTypes;
    }

    private void compareObjectClasses(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, ObjectClassDefinition> e;
        Map<OID, ObjectClassDefinition> objectClasses1 = this.getObjectClassMap(firstServerSchema);
        Map<OID, ObjectClassDefinition> objectClasses2 = this.getObjectClassMap(secondServerSchema);
        Iterator<Map.Entry<OID, ObjectClassDefinition>> iterator = objectClasses1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (objectClasses2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_OBJECT_CLASS.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = objectClasses2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (objectClasses1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_OBJECT_CLASS.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : objectClasses1.keySet()) {
            ObjectClassDefinition d1 = objectClasses1.get(oid2);
            ObjectClassDefinition d2 = objectClasses2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SUPERIOR_TYPE.get(), d1.getSuperiorClasses(), d2.getSuperiorClasses(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_REQUIRED_ATTRIBUTE.get(), d1.getRequiredAttributes(), d2.getRequiredAttributes(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_OPTIONAL_ATTRIBUTE.get(), d1.getOptionalAttributes(), d2.getOptionalAttributes(), numDifferences);
            String oc1Type = d1.getObjectClassType() == null ? null : d1.getObjectClassType().getName();
            String oc2Type = d2.getObjectClassType() == null ? null : d2.getObjectClassType().getName();
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_OBJECT_CLASS_TYPE.get(), oc1Type, oc2Type, numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_OBJECT_CLASS.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, ObjectClassDefinition> getObjectClassMap(@NotNull Schema schema) {
        TreeMap<OID, ObjectClassDefinition> objectClasses = new TreeMap<OID, ObjectClassDefinition>();
        for (ObjectClassDefinition d : schema.getObjectClasses()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            objectClasses.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return objectClasses;
    }

    private void compareDITContentRules(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, DITContentRuleDefinition> e;
        Map<OID, DITContentRuleDefinition> ditContentRules1 = this.getDITContentRuleMap(firstServerSchema);
        Map<OID, DITContentRuleDefinition> ditContentRules2 = this.getDITContentRuleMap(secondServerSchema);
        Iterator<Map.Entry<OID, DITContentRuleDefinition>> iterator = ditContentRules1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (ditContentRules2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_DIT_CONTENT_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = ditContentRules2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (ditContentRules1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_DIT_CONTENT_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : ditContentRules1.keySet()) {
            DITContentRuleDefinition d1 = ditContentRules1.get(oid2);
            DITContentRuleDefinition d2 = ditContentRules2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_REQUIRED_ATTRIBUTE.get(), d1.getRequiredAttributes(), d2.getRequiredAttributes(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_OPTIONAL_ATTRIBUTE.get(), d1.getOptionalAttributes(), d2.getOptionalAttributes(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_PROHIBITED_ATTRIBUTE.get(), d1.getProhibitedAttributes(), d2.getProhibitedAttributes(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_AUXILIARY_CLASS.get(), d1.getAuxiliaryClasses(), d2.getAuxiliaryClasses(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_CONTENT_RULE.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, DITContentRuleDefinition> getDITContentRuleMap(@NotNull Schema schema) {
        TreeMap<OID, DITContentRuleDefinition> ditContentRules = new TreeMap<OID, DITContentRuleDefinition>();
        for (DITContentRuleDefinition d : schema.getDITContentRules()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            ditContentRules.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return ditContentRules;
    }

    private void compareDITStructureRules(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        Map.Entry<Integer, DITStructureRuleDefinition> e;
        Map<Integer, DITStructureRuleDefinition> ditStructureRules1 = this.getDITStructureRuleMap(firstServerSchema);
        Map<Integer, DITStructureRuleDefinition> ditStructureRules2 = this.getDITStructureRuleMap(secondServerSchema);
        Iterator<Map.Entry<Integer, DITStructureRuleDefinition>> iterator = ditStructureRules1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            Integer id = e.getKey();
            if (ditStructureRules2.containsKey(id)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_DIT_STRUCTURE_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = ditStructureRules2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            Integer oid = e.getKey();
            if (ditStructureRules1.containsKey(oid)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_DIT_STRUCTURE_RULE.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (Integer id : ditStructureRules1.keySet()) {
            DITStructureRuleDefinition d1 = ditStructureRules1.get(id);
            DITStructureRuleDefinition d2 = ditStructureRules2.get(id);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), id.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_NAME_FORM.get(), d1.getNameFormID(), d2.getNameFormID(), numDifferences);
            String[] superiorRuleIDs1 = CompareLDAPSchemas.intArrayToStringArray(d1.getSuperiorRuleIDs());
            String[] superiorRuleIDs2 = CompareLDAPSchemas.intArrayToStringArray(d2.getSuperiorRuleIDs());
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_SUPERIOR_RULE_ID.get(), superiorRuleIDs1, superiorRuleIDs2, numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_DIT_STRUCTURE_RULE.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<Integer, DITStructureRuleDefinition> getDITStructureRuleMap(@NotNull Schema schema) {
        TreeMap<Integer, DITStructureRuleDefinition> ditStructureRules = new TreeMap<Integer, DITStructureRuleDefinition>();
        for (DITStructureRuleDefinition d : schema.getDITStructureRules()) {
            if (!this.includeBasedOnNameAndExtensions(StaticUtils.NO_STRINGS, d.getExtensions())) continue;
            ditStructureRules.put(d.getRuleID(), d);
        }
        return ditStructureRules;
    }

    @NotNull
    private static String[] intArrayToStringArray(@NotNull int[] intArray) {
        String[] stringArray = new String[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            stringArray[i] = String.valueOf(intArray[i]);
        }
        return stringArray;
    }

    private void compareNameForms(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, NameFormDefinition> e;
        Map<OID, NameFormDefinition> nameForms1 = this.getNameFormMap(firstServerSchema);
        Map<OID, NameFormDefinition> nameForms2 = this.getNameFormMap(secondServerSchema);
        Iterator<Map.Entry<OID, NameFormDefinition>> iterator = nameForms1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (nameForms2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_NAME_FORM.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = nameForms2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (nameForms1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_NAME_FORM.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : nameForms1.keySet()) {
            NameFormDefinition d1 = nameForms1.get(oid2);
            NameFormDefinition d2 = nameForms2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_STRUCTURAL_CLASS.get(), d1.getStructuralClass(), d2.getStructuralClass(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_REQUIRED_ATTRIBUTE.get(), d1.getRequiredAttributes(), d2.getRequiredAttributes(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_OPTIONAL_ATTRIBUTE.get(), d1.getOptionalAttributes(), d2.getOptionalAttributes(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_NAME_FORM.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, NameFormDefinition> getNameFormMap(@NotNull Schema schema) {
        TreeMap<OID, NameFormDefinition> nameForms = new TreeMap<OID, NameFormDefinition>();
        for (NameFormDefinition d : schema.getNameForms()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            nameForms.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return nameForms;
    }

    private void compareMatchingRuleUses(@NotNull Schema firstServerSchema, @NotNull Schema secondServerSchema, @NotNull AtomicInteger numDifferences) {
        OID oid2;
        Map.Entry<OID, MatchingRuleUseDefinition> e;
        Map<OID, MatchingRuleUseDefinition> matchingRuleUses1 = this.getMatchingRuleUseMap(firstServerSchema);
        Map<OID, MatchingRuleUseDefinition> matchingRuleUses2 = this.getMatchingRuleUseMap(secondServerSchema);
        Iterator<Map.Entry<OID, MatchingRuleUseDefinition>> iterator = matchingRuleUses1.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (matchingRuleUses2.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_MATCHING_RULE_USE.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        iterator = matchingRuleUses2.entrySet().iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            oid2 = e.getKey();
            if (matchingRuleUses1.containsKey(oid2)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_MATCHING_RULE_USE.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, e.getValue().toString());
            iterator.remove();
        }
        for (OID oid2 : matchingRuleUses1.keySet()) {
            MatchingRuleUseDefinition d1 = matchingRuleUses1.get(oid2);
            MatchingRuleUseDefinition d2 = matchingRuleUses2.get(oid2);
            String identifier = this.compareNames(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get(), oid2.toString(), d1.getNames(), d2.getNames(), numDifferences);
            this.compareStringArrayValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_APPLICABLE_ATTRIBUTE.get(), d1.getApplicableAttributeTypes(), d2.getApplicableAttributeTypes(), numDifferences);
            this.compareBooleanValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_BOOLEAN_FIELD_NAME_OBSOLETE.get(), d1.isObsolete(), d2.isObsolete(), numDifferences);
            if (!this.ignoreDescriptions) {
                this.compareStringValues(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get(), identifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_DESCRIPTION.get(), d1.getDescription(), d2.getDescription(), numDifferences);
            }
            this.compareExtensions(ToolMessages.INFO_COMPARE_SCHEMA_ELEMENT_TYPE_MATCHING_RULE_USE.get(), identifier, d1.getExtensions(), d2.getExtensions(), numDifferences);
        }
    }

    @NotNull
    private Map<OID, MatchingRuleUseDefinition> getMatchingRuleUseMap(@NotNull Schema schema) {
        TreeMap<OID, MatchingRuleUseDefinition> matchingRuleUses = new TreeMap<OID, MatchingRuleUseDefinition>();
        for (MatchingRuleUseDefinition d : schema.getMatchingRuleUses()) {
            if (!this.includeBasedOnNameAndExtensions(d.getNames(), d.getExtensions())) continue;
            matchingRuleUses.put(new OID(StaticUtils.toLowerCase(d.getOID())), d);
        }
        return matchingRuleUses;
    }

    private boolean includeBasedOnNameAndExtensions(@NotNull String[] names, @NotNull Map<String, String[]> extensions) {
        boolean includeFound;
        if (this.includeOrExcludeBasedOnName && names.length > 0) {
            includeFound = false;
            block0: for (String name : names) {
                String lowerName = StaticUtils.toLowerCase(name);
                for (String string : this.excludeNamePrefixes) {
                    if (!lowerName.startsWith(string)) continue;
                    return false;
                }
                if (this.includeNamePrefixes.isEmpty()) continue;
                for (String string : this.includeNamePrefixes) {
                    if (!lowerName.startsWith(string)) continue;
                    includeFound = true;
                    continue block0;
                }
            }
            if (!this.includeNamePrefixes.isEmpty() && !includeFound) {
                return false;
            }
        }
        if (this.includeOrExcludeBasedOnExtensions && !extensions.isEmpty()) {
            includeFound = false;
            block3: for (Map.Entry entry : extensions.entrySet()) {
                List<String> list;
                String lowerName = StaticUtils.toLowerCase((String)entry.getKey());
                String[] values = (String[])entry.getValue();
                String[] lowerValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    lowerValues[i] = StaticUtils.toLowerCase(values[i]);
                }
                List<String> excludeValues = this.excludeExtensionValues.get(lowerName);
                if (excludeValues != null) {
                    for (String lowerValue : lowerValues) {
                        if (!excludeValues.contains(lowerValue)) continue;
                        return false;
                    }
                }
                if ((list = this.includeExtensionValues.get(lowerName)) == null) continue;
                for (String lowerValue : lowerValues) {
                    if (!list.contains(lowerValue)) continue;
                    includeFound = true;
                    continue block3;
                }
            }
            if (!this.includeExtensionValues.isEmpty() && !includeFound) {
                return false;
            }
        }
        return true;
    }

    private void reportDifference(@NotNull String message, @NotNull AtomicInteger numDifferences, String ... additionalStrings) {
        this.wrapErr(0, WRAP_COLUMN, message);
        for (String additionalString : additionalStrings) {
            this.err(additionalString);
        }
        this.err(new Object[0]);
        numDifferences.incrementAndGet();
    }

    private void compareStringValues(@NotNull String elementTypeName, @NotNull String elementIdentifier, @NotNull String stringDescriptor, @Nullable String string1, @Nullable String string2, @NotNull AtomicInteger numDifferences) {
        if (string1 == null) {
            if (string2 != null) {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_MISSING_FROM_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, string2, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
            }
        } else if (string2 == null) {
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_MISSING_FROM_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, string1, ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
        } else if (!string1.equalsIgnoreCase(string2)) {
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_DIFFERENT_BETWEEN_SERVERS.get(elementTypeName, elementIdentifier, stringDescriptor, string1, string2), numDifferences, new String[0]);
        }
    }

    private void compareStringArrayValues(@NotNull String elementTypeName, @NotNull String elementIdentifier, @NotNull String stringDescriptor, @NotNull String[] array1, @NotNull String[] array2, @NotNull AtomicInteger numDifferences) {
        if (array1.length == 0) {
            switch (array2.length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_SINGLE_IN_ONLY_ONE_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, array2[0], ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
                    break;
                }
                default: {
                    this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_MULTIPLE_IN_ONLY_ONE_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, Arrays.toString(array2), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
                    break;
                }
            }
        } else if (array2.length == 0) {
            if (array1.length == 1) {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_SINGLE_IN_ONLY_ONE_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, array1[0], ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
            } else {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_MULTIPLE_IN_ONLY_ONE_SERVER.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), elementTypeName, elementIdentifier, stringDescriptor, Arrays.toString(array1), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
            }
        } else {
            Map<String, String> n1 = CompareLDAPSchemas.getNameMap(array1);
            Map<String, String> n2 = CompareLDAPSchemas.getNameMap(array2);
            for (Map.Entry<String, String> e : n1.entrySet()) {
                String lowerName = e.getKey();
                if (n2.remove(lowerName) != null) continue;
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_VALUE_MISSING_FROM_SERVER.get(elementTypeName, elementIdentifier, stringDescriptor, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), e.getValue(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
            }
            for (String nameOnlyInServer2 : n2.values()) {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_STRING_ARRAY_VALUE_MISSING_FROM_SERVER.get(elementTypeName, elementIdentifier, stringDescriptor, ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), nameOnlyInServer2, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
            }
        }
    }

    @NotNull
    private String compareNames(@NotNull String elementTypeName, @NotNull String elementIdentifier, @NotNull String[] names1, @NotNull String[] names2, @NotNull AtomicInteger numDifferences) {
        this.compareStringArrayValues(elementTypeName, elementIdentifier, ToolMessages.INFO_COMPARE_SCHEMA_STRING_DESCRIPTOR_NAME.get(), names1, names2, numDifferences);
        if (names1.length > 0 && names2.length > 0 && names1[0].equalsIgnoreCase(names2[0])) {
            return names1[0];
        }
        return elementIdentifier;
    }

    private void compareBooleanValues(@NotNull String elementTypeName, @NotNull String elementIdentifier, @NotNull String booleanFieldName, boolean value1, boolean value2, @NotNull AtomicInteger numDifferences) {
        if (value1 != value2) {
            if (value1) {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_BOOLEAN_DIFFERENCE.get(elementTypeName, elementIdentifier, booleanFieldName, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
            } else {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_BOOLEAN_DIFFERENCE.get(elementTypeName, elementIdentifier, booleanFieldName, ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
            }
        }
    }

    private void compareExtensions(@NotNull String elementTypeName, @NotNull String elementIdentifier, @NotNull Map<String, String[]> extensions1, @NotNull Map<String, String[]> extensions2, @NotNull AtomicInteger numDifferences) {
        if (this.ignoreExtensions) {
            return;
        }
        Map<String, Set<String>> e1 = CompareLDAPSchemas.convertToUpdatableExtensionsMap(extensions1);
        Map<String, Set<String>> e2 = CompareLDAPSchemas.convertToUpdatableExtensionsMap(extensions2);
        for (Map.Entry<String, Set<String>> e : e1.entrySet()) {
            String extensionName = e.getKey();
            Set<String> extension1Values = e.getValue();
            Set<String> extension2Values = e2.remove(extensionName);
            if (extension2Values == null) {
                this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_EXTENSION.get(ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get(), elementTypeName, elementIdentifier, extensionName, ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get()), numDifferences, new String[0]);
                continue;
            }
            if (extension1Values.equals(extension2Values)) continue;
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_EXTENSION_DIFFERENCE.get(elementTypeName, elementIdentifier, extensionName), numDifferences, new String[0]);
        }
        for (String extensionName : e2.keySet()) {
            this.reportDifference(ToolMessages.WARN_COMPARE_SCHEMA_MISSING_EXTENSION.get(ToolMessages.INFO_COMPARE_SCHEMA_SECOND_SERVER_LABEL.get(), elementTypeName, elementIdentifier, extensionName, ToolMessages.INFO_COMPARE_SCHEMA_FIRST_SERVER_LABEL.get()), numDifferences, new String[0]);
        }
    }

    @NotNull
    private static Map<String, Set<String>> convertToUpdatableExtensionsMap(@NotNull Map<String, String[]> extensionsMap) {
        TreeMap<String, Set<String>> convertedExtensionsMap = new TreeMap<String, Set<String>>();
        for (Map.Entry<String, String[]> e : extensionsMap.entrySet()) {
            String lowerExtensionName = StaticUtils.toLowerCase(e.getKey());
            TreeSet<String> lowerExtensionValues = new TreeSet<String>();
            for (String extensionValue : e.getValue()) {
                lowerExtensionValues.add(StaticUtils.toLowerCase(extensionValue));
            }
            convertedExtensionsMap.put(lowerExtensionName, lowerExtensionValues);
        }
        return convertedExtensionsMap;
    }

    @NotNull
    private static Map<String, String> getNameMap(@NotNull String[] names) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (String name : names) {
            m.put(StaticUtils.toLowerCase(name), name);
        }
        return m;
    }

    private void logCompletionError(@NotNull String message) {
        this.completionMessageRef.compareAndSet(null, message);
        this.wrapErr(0, WRAP_COLUMN, message);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--firstHostname", "ds1.example.com", "--firstPort", "636", "--firstUseSSL", "--firstBindDN", "cn=Directory Manager", "--firstBindPasswordFile", "/path/to/password.txt", "--secondHostname", "ds2.example.com", "--secondPort", "636", "--secondUseSSL", "--secondBindDN", "cn=Directory Manager", "--secondBindPasswordFile", "/path/to/password.txt"}, ToolMessages.INFO_COMPARE_LDAP_SCHEMAS_EXAMPLE.get());
        return examples;
    }
}

