/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.RemoveAttributeTypeTask;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class RemoveAttributeTypeTaskProperties
implements Serializable {
    private static final long serialVersionUID = 8648887754165247809L;
    @Nullable
    private Boolean alertOnError;
    @Nullable
    private Boolean alertOnStart;
    @Nullable
    private Boolean alertOnSuccess;
    @Nullable
    private Date scheduledStartTime;
    @Nullable
    private FailedDependencyAction failedDependencyAction;
    @NotNull
    private final List<String> dependencyIDs;
    @NotNull
    private final List<String> notifyOnCompletion;
    @NotNull
    private final List<String> notifyOnError;
    @NotNull
    private final List<String> notifyOnStart;
    @NotNull
    private final List<String> notifyOnSuccess;
    @NotNull
    private String attributeType;
    @Nullable
    private String taskID;

    public RemoveAttributeTypeTaskProperties(@NotNull String attributeType) {
        this.attributeType = attributeType;
        this.alertOnError = null;
        this.alertOnStart = null;
        this.alertOnSuccess = null;
        this.scheduledStartTime = null;
        this.failedDependencyAction = null;
        this.dependencyIDs = new ArrayList<String>(5);
        this.notifyOnCompletion = new ArrayList<String>(5);
        this.notifyOnError = new ArrayList<String>(5);
        this.notifyOnStart = new ArrayList<String>(5);
        this.notifyOnSuccess = new ArrayList<String>(5);
        this.taskID = null;
    }

    public RemoveAttributeTypeTaskProperties(@NotNull RemoveAttributeTypeTaskProperties properties) {
        this.attributeType = properties.getAttributeType();
        this.alertOnError = properties.getAlertOnError();
        this.alertOnStart = properties.getAlertOnStart();
        this.alertOnSuccess = properties.getAlertOnSuccess();
        this.scheduledStartTime = properties.getScheduledStartTime();
        this.failedDependencyAction = properties.getFailedDependencyAction();
        this.dependencyIDs = new ArrayList<String>(properties.getDependencyIDs());
        this.notifyOnCompletion = new ArrayList<String>(properties.getNotifyOnCompletion());
        this.notifyOnError = new ArrayList<String>(properties.getNotifyOnError());
        this.notifyOnStart = new ArrayList<String>(properties.getNotifyOnStart());
        this.notifyOnSuccess = new ArrayList<String>(properties.getNotifyOnSuccess());
        this.taskID = properties.getTaskID();
    }

    public RemoveAttributeTypeTaskProperties(@NotNull RemoveAttributeTypeTask task) {
        this.attributeType = task.getAttributeType();
        this.alertOnError = task.getAlertOnError();
        this.alertOnStart = task.getAlertOnStart();
        this.alertOnSuccess = task.getAlertOnSuccess();
        this.scheduledStartTime = task.getScheduledStartTime();
        this.failedDependencyAction = task.getFailedDependencyAction();
        this.dependencyIDs = new ArrayList<String>(task.getDependencyIDs());
        this.notifyOnCompletion = new ArrayList<String>(task.getNotifyOnCompletionAddresses());
        this.notifyOnError = new ArrayList<String>(task.getNotifyOnErrorAddresses());
        this.notifyOnStart = new ArrayList<String>(task.getNotifyOnStartAddresses());
        this.notifyOnSuccess = new ArrayList<String>(task.getNotifyOnSuccessAddresses());
        this.taskID = task.getTaskID();
    }

    @NotNull
    public String getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(@NotNull String attributeType) {
        this.attributeType = attributeType;
    }

    @Nullable
    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(@Nullable String taskID) {
        this.taskID = taskID;
    }

    @Nullable
    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(@Nullable Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @NotNull
    public List<String> getDependencyIDs() {
        return new ArrayList<String>(this.dependencyIDs);
    }

    public void setDependencyIDs(@Nullable List<String> dependencyIDs) {
        this.dependencyIDs.clear();
        if (dependencyIDs != null) {
            this.dependencyIDs.addAll(dependencyIDs);
        }
    }

    @Nullable
    public FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public void setFailedDependencyAction(@Nullable FailedDependencyAction failedDependencyAction) {
        this.failedDependencyAction = failedDependencyAction;
    }

    @NotNull
    public List<String> getNotifyOnStart() {
        return new ArrayList<String>(this.notifyOnStart);
    }

    public void setNotifyOnStart(@Nullable List<String> notifyOnStart) {
        this.notifyOnStart.clear();
        if (notifyOnStart != null) {
            this.notifyOnStart.addAll(notifyOnStart);
        }
    }

    @NotNull
    public List<String> getNotifyOnCompletion() {
        return new ArrayList<String>(this.notifyOnCompletion);
    }

    public void setNotifyOnCompletion(@Nullable List<String> notifyOnCompletion) {
        this.notifyOnCompletion.clear();
        if (notifyOnCompletion != null) {
            this.notifyOnCompletion.addAll(notifyOnCompletion);
        }
    }

    @NotNull
    public List<String> getNotifyOnSuccess() {
        return new ArrayList<String>(this.notifyOnSuccess);
    }

    public void setNotifyOnSuccess(@Nullable List<String> notifyOnSuccess) {
        this.notifyOnSuccess.clear();
        if (notifyOnSuccess != null) {
            this.notifyOnSuccess.addAll(notifyOnSuccess);
        }
    }

    @NotNull
    public List<String> getNotifyOnError() {
        return new ArrayList<String>(this.notifyOnError);
    }

    public void setNotifyOnError(@Nullable List<String> notifyOnError) {
        this.notifyOnError.clear();
        if (notifyOnError != null) {
            this.notifyOnError.addAll(notifyOnError);
        }
    }

    @Nullable
    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(@Nullable Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    @Nullable
    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(@Nullable Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    @Nullable
    public Boolean getAlertOnError() {
        return this.alertOnError;
    }

    public void setAlertOnError(@Nullable Boolean alertOnError) {
        this.alertOnError = alertOnError;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RemoveAttributeTypeProperties(");
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "taskID", this.taskID);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "attributeType", this.attributeType);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "scheduledStartTime", this.scheduledStartTime);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "dependencyIDs", this.dependencyIDs);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "failedDependencyAction", (Object)this.failedDependencyAction);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "notifyOnStart", this.notifyOnStart);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "notifyOnCompletion", this.notifyOnCompletion);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "notifyOnSuccess", this.notifyOnSuccess);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "notifyOnError", this.notifyOnError);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "alertOnStart", this.alertOnStart);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "alertOnSuccess", this.alertOnSuccess);
        RemoveAttributeTypeTaskProperties.appendNameValuePair(buffer, "alertOnError", this.alertOnError);
        buffer.append(')');
    }

    private static void appendNameValuePair(@NotNull StringBuilder buffer, @NotNull String name, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("='");
        buffer.append(value);
        buffer.append('\'');
    }

    private static void appendNameValuePair(@NotNull StringBuilder buffer, @NotNull String name, @Nullable List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("={ ");
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
    }
}

