/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.TopologyRegistryTrustManager;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PasswordFileReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.JVMDefaultTrustManager;
import com.unboundid.util.ssl.PromptTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InternalSDKHelper {
    private InternalSDKHelper() {
    }

    public static int getSoTimeout(@NotNull LDAPConnection connection) throws LDAPException {
        try {
            return connection.getConnectionInternals(true).getSocket().getSoTimeout();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_INTERNAL_SDK_HELPER_CANNOT_GET_SO_TIMEOUT.get(String.valueOf(connection), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @InternalUseOnly
    public static void setSoTimeout(@NotNull LDAPConnection connection, int soTimeout) throws LDAPException {
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.CONNECT, "Setting the SO_TIMEOUT value for connection " + connection + " to " + soTimeout + "ms.");
        }
        try {
            LDAPConnectionInternals internals;
            if (connection != null && (internals = connection.getConnectionInternals(false)) != null) {
                internals.getSocket().setSoTimeout(soTimeout);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_INTERNAL_SDK_HELPER_CANNOT_SET_SO_TIMEOUT.get(String.valueOf(connection), soTimeout, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @InternalUseOnly
    public static void convertToTLS(@NotNull LDAPConnection connection, @NotNull SSLSocketFactory sslSocketFactory) throws LDAPException {
        connection.convertToTLS(sslSocketFactory);
    }

    @InternalUseOnly
    @NotNull
    public static AsyncRequestID createAsyncRequestID(int targetMessageID, @NotNull LDAPConnection connection) {
        return new AsyncRequestID(targetMessageID, connection);
    }

    @InternalUseOnly
    public static void cancel(@NotNull LDAPConnection connection, int targetMessageID, Control ... controls) throws LDAPException {
        int messageID = connection.nextMessageID();
        CancelExtendedRequest cancelRequest = new CancelExtendedRequest(targetMessageID);
        Debug.debugLDAPRequest(Level.INFO, cancelRequest, messageID, connection);
        LDAPConnectionLogger logger = connection.getConnectionOptions().getConnectionLogger();
        if (logger != null) {
            logger.logExtendedRequest(connection, messageID, cancelRequest);
        }
        connection.sendMessage(new LDAPMessage(messageID, (ProtocolOp)new ExtendedRequest(cancelRequest), controls), connection.getConnectionOptions().getExtendedOperationResponseTimeoutMillis("1.3.6.1.1.8"));
    }

    @InternalUseOnly
    @NotNull
    public static LDAPResult readLDAPResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return LDAPResult.readLDAPResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static BindResult readBindResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return BindResult.readBindResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static CompareResult readCompareResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return CompareResult.readCompareResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static ExtendedResult readExtendedResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return ExtendedResult.readExtendedResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static SearchResultEntry readSearchResultEntryFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader, @Nullable Schema schema) throws LDAPException {
        return SearchResultEntry.readSearchEntryFrom(messageID, messageSequence, reader, schema);
    }

    @InternalUseOnly
    @NotNull
    public static SearchResultReference readSearchResultReferenceFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return SearchResultReference.readSearchReferenceFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static SearchResult readSearchResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return SearchResult.readSearchResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @NotNull
    public static IntermediateResponse readIntermediateResponseFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        return IntermediateResponse.readFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    @Nullable
    public static Boolean followReferralsInternal(@NotNull LDAPRequest request) {
        return request.followReferralsInternal();
    }

    @InternalUseOnly
    @Nullable
    public static ReferralConnector getReferralConnectorInternal(@NotNull LDAPRequest request) {
        return request.getReferralConnectorInternal();
    }

    @InternalUseOnly
    public static int nextMessageID(@NotNull LDAPConnection connection) {
        return connection.nextMessageID();
    }

    @InternalUseOnly
    @Nullable
    public static BindRequest getLastBindRequest(@NotNull LDAPConnection connection) {
        return connection.getLastBindRequest();
    }

    @InternalUseOnly
    @Nullable
    public static Schema getEntrySchema(@NotNull Entry entry) {
        return entry.getSchema();
    }

    @InternalUseOnly
    @Nullable
    public static File getPingIdentityServerRoot() {
        String environmentVariableValue;
        String propertyValue = StaticUtils.getSystemProperty("com.unboundid.directory.server.ServerRoot");
        if (propertyValue != null) {
            try {
                File f = new File(propertyValue);
                if (f.exists() && f.isDirectory()) {
                    return f;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if ((environmentVariableValue = StaticUtils.getEnvironmentVariable("INSTANCE_ROOT")) != null) {
            try {
                File f = new File(environmentVariableValue);
                if (f.exists() && f.isDirectory()) {
                    return f;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return null;
    }

    @InternalUseOnly
    @NotNull
    public static AggregateTrustManager getPreferredNonInteractiveTrustManagerChain(X509TrustManager ... additionalTrustManagers) {
        ArrayList<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>(4);
        if (additionalTrustManagers != null) {
            trustManagers.addAll(Arrays.asList(additionalTrustManagers));
        }
        InternalSDKHelper.selectDefaultNonInteractiveTrustManagers(trustManagers);
        return new AggregateTrustManager(false, trustManagers);
    }

    @InternalUseOnly
    @NotNull
    public static AggregateTrustManager getPreferredPromptTrustManagerChain(@Nullable Collection<String> expectedAddresses) {
        ArrayList<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>(4);
        trustManagers.add(JVMDefaultTrustManager.getInstance());
        File pingIdentityServerRoot = InternalSDKHelper.getPingIdentityServerRoot();
        if (pingIdentityServerRoot != null) {
            File serverConfigFile;
            File serverTrustStore = StaticUtils.constructPath(pingIdentityServerRoot, "config", "truststore");
            if (serverTrustStore.exists()) {
                trustManagers.add(new TrustStoreTrustManager(serverTrustStore));
            }
            if ((serverConfigFile = StaticUtils.constructPath(pingIdentityServerRoot, "config", "config.ldif")).exists()) {
                trustManagers.add(new TopologyRegistryTrustManager(serverConfigFile, TimeUnit.MINUTES.toMillis(5L)));
            }
        }
        trustManagers.add(new PromptTrustManager(null, true, expectedAddresses, null, null));
        return new AggregateTrustManager(false, trustManagers);
    }

    private static void selectDefaultNonInteractiveTrustManagers(@NotNull List<X509TrustManager> trustManagers) {
        trustManagers.add(JVMDefaultTrustManager.getInstance());
        File pingIdentityServerRoot = InternalSDKHelper.getPingIdentityServerRoot();
        if (pingIdentityServerRoot != null) {
            File defaultJKSServerTrustStore = StaticUtils.constructPath(pingIdentityServerRoot, "config", "truststore");
            if (defaultJKSServerTrustStore.exists()) {
                trustManagers.add(new TrustStoreTrustManager(defaultJKSServerTrustStore, null, "JKS", true));
            } else {
                File trustStorePINFile = StaticUtils.constructPath(pingIdentityServerRoot, "config", "truststore.pin");
                File defaultPKCS12TrustStore = StaticUtils.constructPath(pingIdentityServerRoot, "config", "truststore.p12");
                File defaultBCFKSTrustStore = StaticUtils.constructPath(pingIdentityServerRoot, "config", "truststore.bcfks");
                if (trustStorePINFile.exists() && (defaultPKCS12TrustStore.exists() || defaultBCFKSTrustStore.exists())) {
                    try {
                        char[] trustStorePIN = new PasswordFileReader(false).readPassword(trustStorePINFile);
                        if (defaultPKCS12TrustStore.exists()) {
                            trustManagers.add(new TrustStoreTrustManager(defaultPKCS12TrustStore, trustStorePIN, "PKCS12", true));
                        } else if (defaultBCFKSTrustStore.exists()) {
                            trustManagers.add(new TrustStoreTrustManager(defaultPKCS12TrustStore, trustStorePIN, "BCFKS", true));
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            File serverConfigFile = StaticUtils.constructPath(pingIdentityServerRoot, "config", "config.ldif");
            if (serverConfigFile.exists()) {
                trustManagers.add(new TopologyRegistryTrustManager(serverConfigFile, TimeUnit.MINUTES.toMillis(5L)));
            }
        }
    }
}

