/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordFileReader {
    private final boolean allowPromptingForPassphrase;
    @NotNull
    private final CopyOnWriteArrayList<char[]> encryptionPasswordCache;
    @NotNull
    private final PrintStream standardError;
    @NotNull
    private final PrintStream standardOutput;

    public PasswordFileReader() {
        this(true);
    }

    public PasswordFileReader(boolean allowPromptingForPassphrase) {
        this(System.out, System.err, allowPromptingForPassphrase);
    }

    public PasswordFileReader(@NotNull PrintStream standardOutput, @NotNull PrintStream standardError) {
        this(standardOutput, standardError, true);
    }

    private PasswordFileReader(@NotNull PrintStream standardOutput, @NotNull PrintStream standardError, boolean allowPromptingForPassphrase) {
        Validator.ensureNotNullWithMessage(standardOutput, "PasswordFileReader.standardOutput must not be null.");
        Validator.ensureNotNullWithMessage(standardError, "PasswordFileReader.standardError must not be null.");
        this.standardOutput = standardOutput;
        this.standardError = standardError;
        this.allowPromptingForPassphrase = allowPromptingForPassphrase;
        this.encryptionPasswordCache = new CopyOnWriteArrayList();
    }

    @NotNull
    public char[] readPassword(@NotNull String path) throws IOException, LDAPException {
        return this.readPassword(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public char[] readPassword(@NotNull File file) throws IOException, LDAPException {
        if (!file.exists()) {
            throw new IOException(UtilityMessages.ERR_PW_FILE_READER_FILE_MISSING.get(file.getAbsolutePath()));
        }
        if (!file.isFile()) {
            throw new IOException(UtilityMessages.ERR_PW_FILE_READER_FILE_NOT_FILE.get(file.getAbsolutePath()));
        }
        InputStream inputStream = new FileInputStream(file);
        try {
            block33: {
                try {
                    if (this.allowPromptingForPassphrase) {
                        ObjectPair<InputStream, char[]> encryptedFileData = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, this.encryptionPasswordCache, true, (CharSequence)UtilityMessages.INFO_PW_FILE_READER_ENTER_PW_PROMPT.get(file.getAbsolutePath()), (CharSequence)UtilityMessages.ERR_PW_FILE_READER_WRONG_PW.get(file.getAbsolutePath()), this.standardOutput, this.standardError);
                        inputStream = encryptedFileData.getFirst();
                        char[] encryptionPassword = encryptedFileData.getSecond();
                        if (encryptionPassword == null) break block33;
                        CopyOnWriteArrayList<char[]> copyOnWriteArrayList = this.encryptionPasswordCache;
                        synchronized (copyOnWriteArrayList) {
                            boolean passwordIsAlreadyCached = false;
                            for (char[] cachedPassword : this.encryptionPasswordCache) {
                                if (!Arrays.equals(encryptionPassword, cachedPassword)) continue;
                                passwordIsAlreadyCached = true;
                                break;
                            }
                            if (!passwordIsAlreadyCached) {
                                this.encryptionPasswordCache.add(encryptionPassword);
                            }
                            break block33;
                        }
                    }
                    inputStream = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream);
                }
                catch (GeneralSecurityException e) {
                    Debug.debugException(e);
                    throw new IOException(e);
                }
            }
            inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String passwordLine = reader.readLine();
                if (passwordLine == null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_PW_FILE_READER_FILE_EMPTY.get(file.getAbsolutePath()));
                }
                String secondLine = reader.readLine();
                if (secondLine != null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_PW_FILE_READER_FILE_HAS_MULTIPLE_LINES.get(file.getAbsolutePath()));
                }
                if (passwordLine.isEmpty()) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_PW_FILE_READER_FILE_HAS_EMPTY_LINE.get(file.getAbsolutePath()));
                }
                char[] cArray = passwordLine.toCharArray();
                return cArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<char[]> getCachedEncryptionPasswords() {
        ArrayList<char[]> cacheCopy;
        CopyOnWriteArrayList<char[]> copyOnWriteArrayList = this.encryptionPasswordCache;
        synchronized (copyOnWriteArrayList) {
            cacheCopy = new ArrayList<char[]>(this.encryptionPasswordCache.size());
            for (char[] cachedPassword : this.encryptionPasswordCache) {
                cacheCopy.add(Arrays.copyOf(cachedPassword, cachedPassword.length));
            }
        }
        return Collections.unmodifiableList(cacheCopy);
    }

    public void addToEncryptionPasswordCache(@NotNull String encryptionPassword) {
        this.addToEncryptionPasswordCache(encryptionPassword.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToEncryptionPasswordCache(@NotNull char[] encryptionPassword) {
        Validator.ensureNotNullWithMessage(encryptionPassword, "PasswordFileReader.addToEncryptionPasswordCache.encryptionPassword must not be null or empty.");
        Validator.ensureTrue(encryptionPassword.length > 0, "PasswordFileReader.addToEncryptionPasswordCache.encryptionPassword must not be null or empty.");
        CopyOnWriteArrayList<char[]> copyOnWriteArrayList = this.encryptionPasswordCache;
        synchronized (copyOnWriteArrayList) {
            for (char[] cachedPassword : this.encryptionPasswordCache) {
                if (!Arrays.equals(cachedPassword, encryptionPassword)) continue;
                return;
            }
            this.encryptionPasswordCache.add(encryptionPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEncryptionPasswordCache(boolean zeroArrays) {
        CopyOnWriteArrayList<char[]> copyOnWriteArrayList = this.encryptionPasswordCache;
        synchronized (copyOnWriteArrayList) {
            if (zeroArrays) {
                for (char[] cachedPassword : this.encryptionPasswordCache) {
                    Arrays.fill(cachedPassword, '\u0000');
                }
            }
            this.encryptionPasswordCache.clear();
        }
    }
}

