/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.Mutable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.GeneralNames;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class GeneralNamesBuilder
implements Serializable {
    private static final long serialVersionUID = -5005719526010439377L;
    private final List<ASN1Element> ediPartyNames = new ArrayList<ASN1Element>(5);
    private final List<ASN1Element> x400Addresses = new ArrayList<ASN1Element>(5);
    private final List<DN> directoryNames = new ArrayList<DN>(5);
    private final List<InetAddress> ipAddresses = new ArrayList<InetAddress>(5);
    private final List<ObjectPair<OID, ASN1Element>> otherNames = new ArrayList<ObjectPair<OID, ASN1Element>>(5);
    private final List<OID> registeredIDs = new ArrayList<OID>(5);
    private final List<String> dnsNames = new ArrayList<String>(5);
    private final List<String> rfc822Names = new ArrayList<String>(5);
    private final List<String> uniformResourceIdentifiers = new ArrayList<String>(5);

    GeneralNamesBuilder() {
    }

    List<ObjectPair<OID, ASN1Element>> getOtherNames() {
        return this.otherNames;
    }

    GeneralNamesBuilder addOtherName(OID oid, ASN1Element value) {
        this.otherNames.add(new ObjectPair<OID, ASN1Element>(oid, value));
        return this;
    }

    List<String> getRFC822Names() {
        return this.rfc822Names;
    }

    GeneralNamesBuilder addRFC822Name(String emailAddress) {
        this.rfc822Names.add(emailAddress);
        return this;
    }

    List<String> getDNSNames() {
        return this.dnsNames;
    }

    GeneralNamesBuilder addDNSName(String dnsName) {
        this.dnsNames.add(dnsName);
        return this;
    }

    List<ASN1Element> getX400Addresses() {
        return this.x400Addresses;
    }

    GeneralNamesBuilder addX400Address(ASN1Element x400Address) {
        this.x400Addresses.add(x400Address);
        return this;
    }

    List<DN> getDirectoryNames() {
        return this.directoryNames;
    }

    GeneralNamesBuilder addDirectoryName(DN dn) {
        this.directoryNames.add(dn);
        return this;
    }

    List<ASN1Element> getEDIPartyNames() {
        return this.ediPartyNames;
    }

    GeneralNamesBuilder addEDIPartyName(ASN1Element value) {
        this.ediPartyNames.add(value);
        return this;
    }

    List<String> getUniformResourceIdentifiers() {
        return this.uniformResourceIdentifiers;
    }

    GeneralNamesBuilder addUniformResourceIdentifier(String uri) {
        this.uniformResourceIdentifiers.add(uri);
        return this;
    }

    List<InetAddress> getIPAddresses() {
        return this.ipAddresses;
    }

    GeneralNamesBuilder addIPAddress(InetAddress ipAddress) {
        this.ipAddresses.add(ipAddress);
        return this;
    }

    List<OID> getRegisteredIDs() {
        return this.registeredIDs;
    }

    GeneralNamesBuilder addRegisteredID(OID id) {
        this.registeredIDs.add(id);
        return this;
    }

    GeneralNames build() {
        return new GeneralNames(Collections.unmodifiableList(new ArrayList<ObjectPair<OID, ASN1Element>>(this.otherNames)), Collections.unmodifiableList(new ArrayList<String>(this.rfc822Names)), Collections.unmodifiableList(new ArrayList<String>(this.dnsNames)), Collections.unmodifiableList(new ArrayList<ASN1Element>(this.x400Addresses)), Collections.unmodifiableList(new ArrayList<DN>(this.directoryNames)), Collections.unmodifiableList(new ArrayList<ASN1Element>(this.ediPartyNames)), Collections.unmodifiableList(new ArrayList<String>(this.uniformResourceIdentifiers)), Collections.unmodifiableList(new ArrayList<InetAddress>(this.ipAddresses)), Collections.unmodifiableList(new ArrayList<OID>(this.registeredIDs)));
    }
}

