/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssertionRequestControl
extends Control {
    public static final String ASSERTION_REQUEST_OID = "1.3.6.1.1.12";
    private static final long serialVersionUID = 6592634203410511095L;
    private final Filter filter;

    public AssertionRequestControl(String filter) throws LDAPException {
        this(Filter.create(filter), true);
    }

    public AssertionRequestControl(Filter filter) {
        this(filter, true);
    }

    public AssertionRequestControl(String filter, boolean isCritical) throws LDAPException {
        this(Filter.create(filter), isCritical);
    }

    public AssertionRequestControl(Filter filter, boolean isCritical) {
        super(ASSERTION_REQUEST_OID, isCritical, AssertionRequestControl.encodeValue(filter));
        this.filter = filter;
    }

    public AssertionRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            this.filter = Filter.decode(valueElement);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSERT_CANNOT_DECODE.get(e), e);
        }
    }

    public static AssertionRequestControl generate(Entry sourceEntry, String ... attributes) {
        ArrayList<Filter> andComponents;
        Validator.ensureNotNull(sourceEntry);
        if (attributes == null || attributes.length == 0) {
            Collection<Attribute> entryAttrs = sourceEntry.getAttributes();
            andComponents = new ArrayList(entryAttrs.size());
            for (Attribute a : entryAttrs) {
                for (ASN1OctetString v : a.getRawValues()) {
                    andComponents.add(Filter.createEqualityFilter(a.getName(), v.getValue()));
                }
            }
        } else {
            andComponents = new ArrayList<Filter>(attributes.length);
            for (String name : attributes) {
                Attribute a = sourceEntry.getAttribute(name);
                if (a == null) continue;
                for (ASN1OctetString v : a.getRawValues()) {
                    andComponents.add(Filter.createEqualityFilter(name, v.getValue()));
                }
            }
        }
        if (andComponents.size() == 1) {
            return new AssertionRequestControl(andComponents.get(0));
        }
        return new AssertionRequestControl(Filter.createANDFilter(andComponents));
    }

    private static ASN1OctetString encodeValue(Filter filter) {
        return new ASN1OctetString(filter.encode().encode());
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ASSERTION_REQUEST.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AssertionRequestControl(filter='");
        this.filter.toString(buffer);
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

