/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SetNotificationSubscriptionExtendedRequest
extends ExtendedRequest {
    public static final String SET_NOTIFICATION_SUBSCRIPTION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.38";
    private static final long serialVersionUID = -5822283773149091097L;
    private final List<ASN1OctetString> subscriptionDetails;
    private final String destinationID;
    private final String managerID;
    private final String subscriptionID;

    public SetNotificationSubscriptionExtendedRequest(String managerID, String destinationID, String subscriptionID, ASN1OctetString ... subscriptionDetails) {
        this(managerID, destinationID, subscriptionID, StaticUtils.toList(subscriptionDetails), new Control[0]);
    }

    public SetNotificationSubscriptionExtendedRequest(String managerID, String destinationID, String subscriptionID, Collection<ASN1OctetString> subscriptionDetails, Control ... controls) {
        super(SET_NOTIFICATION_SUBSCRIPTION_REQUEST_OID, SetNotificationSubscriptionExtendedRequest.encodeValue(managerID, destinationID, subscriptionID, subscriptionDetails), controls);
        this.managerID = managerID;
        this.destinationID = destinationID;
        this.subscriptionID = subscriptionID;
        this.subscriptionDetails = Collections.unmodifiableList(new ArrayList<ASN1OctetString>(subscriptionDetails));
    }

    public SetNotificationSubscriptionExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_NOTIFICATION_SUB_REQ_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.managerID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.destinationID = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            this.subscriptionID = ASN1OctetString.decodeAsOctetString(elements[2]).stringValue();
            ASN1Element[] detailElements = ASN1Sequence.decodeAsSequence(elements[3]).elements();
            ArrayList<ASN1OctetString> detailList = new ArrayList<ASN1OctetString>(detailElements.length);
            for (ASN1Element e : detailElements) {
                detailList.add(ASN1OctetString.decodeAsOctetString(e));
            }
            this.subscriptionDetails = Collections.unmodifiableList(detailList);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_NOTIFICATION_SUB_REQ_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(String managerID, String destinationID, String subscriptionID, Collection<ASN1OctetString> subscriptionDetails) {
        Validator.ensureNotNull(managerID);
        Validator.ensureNotNull(destinationID);
        Validator.ensureNotNull(subscriptionID);
        Validator.ensureNotNull(subscriptionDetails);
        Validator.ensureFalse(subscriptionDetails.isEmpty());
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(managerID), new ASN1OctetString(destinationID), new ASN1OctetString(subscriptionID), new ASN1Sequence(new ArrayList<ASN1OctetString>(subscriptionDetails)));
        return new ASN1OctetString(valueSequence.encode());
    }

    public String getManagerID() {
        return this.managerID;
    }

    public String getDestinationID() {
        return this.destinationID;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public List<ASN1OctetString> getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    @Override
    public SetNotificationSubscriptionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public SetNotificationSubscriptionExtendedRequest duplicate(Control[] controls) {
        SetNotificationSubscriptionExtendedRequest r = new SetNotificationSubscriptionExtendedRequest(this.managerID, this.destinationID, this.subscriptionID, this.subscriptionDetails, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_SET_NOTIFICATION_SUB.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SetNotificationSubscriptionExtendedRequest(managerID='");
        buffer.append(this.managerID);
        buffer.append("', destinationID='");
        buffer.append(this.destinationID);
        buffer.append("', subscriptionID='");
        buffer.append(this.subscriptionID);
        buffer.append("', subscriptionDetails=ASN1OctetString[");
        buffer.append(this.subscriptionDetails.size());
        buffer.append(']');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

